# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220926

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('email_data_plane.email_data_plane_root_group.command_name', 'email-data-plane'), cls=CommandGroupWithAlias, help=cli_util.override('email_data_plane.email_data_plane_root_group.help', """Use the Email Delivery API to send high-volume and application-generated emails.
For more information, see [Overview of the Email Delivery Service]."""), short_help=cli_util.override('email_data_plane.email_data_plane_root_group.short_help', """Email Delivery Submission API"""))
@cli_util.help_option_group
def email_data_plane_root_group():
    pass


@click.command(cli_util.override('email_data_plane.email_submitted_response_group.command_name', 'email-submitted-response'), cls=CommandGroupWithAlias, help="""Response object that is returned to sender upon successfully submitting the email request.""")
@cli_util.help_option_group
def email_submitted_response_group():
    pass


@click.command(cli_util.override('email_data_plane.email_raw_submitted_response_group.command_name', 'email-raw-submitted-response'), cls=CommandGroupWithAlias, help="""Response object that is returned to sender upon successfully submitting the email request.""")
@cli_util.help_option_group
def email_raw_submitted_response_group():
    pass


email_data_plane_root_group.add_command(email_submitted_response_group)
email_data_plane_root_group.add_command(email_raw_submitted_response_group)


@email_submitted_response_group.command(name=cli_util.override('email_data_plane.submit_email.command_name', 'submit-email'), help=u"""Submits a formatted email. \n[Command Reference](submitEmail)""")
@cli_util.option('--sender', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--recipients', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--subject', required=True, help=u"""A short summary of the content, which will appear in the recipient's inbox. UTF-8 supported [RFC 2047].""")
@cli_util.option('--message-id', help=u"""The unique ID for the email's Message-ID header used for service log correlation. The submission will return an error if the syntax is not a valid [RFC 5322] Message-ID. This will be generated if not provided. Example: sdiofu234qwermls24fd@mail.example.com""")
@cli_util.option('--body-html', help=u"""HTML body content in UTF-8. NOTE: Even though bodytext and bodyhtml are both optional, at least one of them must be provided.""")
@cli_util.option('--body-text', help=u"""Text body content. NOTE: Even though bodytext and bodyhtml are both optional, at least one of them must be provided.""")
@cli_util.option('--reply-to', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The email address for the recipient to reply to. If left blank, defaults to the sender address.

This option is a JSON list with items of type EmailAddress.  For documentation on EmailAddress please see our API reference: https://docs.cloud.oracle.com/api/#/en/emaildp/20220926/datatypes/EmailAddress.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--header-fields', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The header used by the customer for the email sent. Reserved headers are not allowed e.g \"subject\", \"from\", and \"to\" etc. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'sender': {'module': 'email_data_plane', 'class': 'Sender'}, 'recipients': {'module': 'email_data_plane', 'class': 'Recipients'}, 'reply-to': {'module': 'email_data_plane', 'class': 'list[EmailAddress]'}, 'header-fields': {'module': 'email_data_plane', 'class': 'dict(str, string)'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'sender': {'module': 'email_data_plane', 'class': 'Sender'}, 'recipients': {'module': 'email_data_plane', 'class': 'Recipients'}, 'reply-to': {'module': 'email_data_plane', 'class': 'list[EmailAddress]'}, 'header-fields': {'module': 'email_data_plane', 'class': 'dict(str, string)'}}, output_type={'module': 'email_data_plane', 'class': 'EmailSubmittedResponse'})
@cli_util.wrap_exceptions
def submit_email(ctx, from_json, sender, recipients, subject, message_id, body_html, body_text, reply_to, header_fields):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['sender'] = cli_util.parse_json_parameter("sender", sender)
    _details['recipients'] = cli_util.parse_json_parameter("recipients", recipients)
    _details['subject'] = subject

    if message_id is not None:
        _details['messageId'] = message_id

    if body_html is not None:
        _details['bodyHtml'] = body_html

    if body_text is not None:
        _details['bodyText'] = body_text

    if reply_to is not None:
        _details['replyTo'] = cli_util.parse_json_parameter("reply_to", reply_to)

    if header_fields is not None:
        _details['headerFields'] = cli_util.parse_json_parameter("header_fields", header_fields)

    client = cli_util.build_client('email_data_plane', 'email_dp', ctx)
    result = client.submit_email(
        submit_email_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@email_raw_submitted_response_group.command(name=cli_util.override('email_data_plane.submit_raw_email.command_name', 'submit-raw-email'), help=u"""Submits a raw email. \n[Command Reference](submitRawEmail)""")
@cli_util.option('--content-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["message/rfc822", "message/global"]), help=u"""The media type of the body.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment that contains the approved sender resource.""")
@cli_util.option('--sender', required=True, help=u"""The envelope and the header from email address, that is sending the email. Email address must be an approved sender.""")
@cli_util.option('--recipients', required=True, multiple=True, help=u"""The destination for the email, all recipients including to, cc and bcc addresses.""")
@cli_util.option('--raw-message', required=True, help=u"""This should be formatted in valid MIME format. Message can include attachments. MIME libraries should be used to convert the content into the appropriate format.""")
@cli_util.option('--content-length', type=click.INT, help=u"""The content length of the body.""")
@json_skeleton_utils.get_cli_json_input_option({'recipients': {'module': 'email_data_plane', 'class': ''}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'recipients': {'module': 'email_data_plane', 'class': ''}}, output_type={'module': 'email_data_plane', 'class': 'EmailRawSubmittedResponse'})
@cli_util.wrap_exceptions
def submit_raw_email(ctx, from_json, content_type, compartment_id, sender, recipients, raw_message, content_length):

    kwargs = {}
    if content_length is not None:
        kwargs['content_length'] = content_length
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('email_data_plane', 'email_dp', ctx)
    result = client.submit_raw_email(
        content_type=content_type,
        compartment_id=compartment_id,
        sender=sender,
        recipients=recipients,
        raw_message=raw_message,
        **kwargs
    )
    cli_util.render_response(result, ctx)
