# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('jms_java_downloads.jms_java_downloads_root_group.command_name', 'jms-java-downloads'), cls=CommandGroupWithAlias, help=cli_util.override('jms_java_downloads.jms_java_downloads_root_group.help', """The APIs for the [Java Download] feature of Java Management Service."""), short_help=cli_util.override('jms_java_downloads.jms_java_downloads_root_group.short_help', """Java Management Service Java Download API"""))
@cli_util.help_option_group
def jms_java_downloads_root_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_download_report_group.command_name', 'java-download-report'), cls=CommandGroupWithAlias, help="""Details about a Java download report in a tenancy. The report is a file in Object Storage. It contains the download records in a specific format.""")
@cli_util.help_option_group
def java_download_report_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_download_record_group.command_name', 'java-download-record'), cls=CommandGroupWithAlias, help="""A record of Java artifact download in a tenancy.""")
@cli_util.help_option_group
def java_download_record_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_download_token_group.command_name', 'java-download-token'), cls=CommandGroupWithAlias, help="""A JavaDownloadToken is a primary resource for the script friendly URLs. The value of this token serves as the authorization token for the download.""")
@cli_util.help_option_group
def java_download_token_group():
    pass


@click.command(cli_util.override('jms_java_downloads.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while executing a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('jms_java_downloads.download_url_group.command_name', 'download-url'), cls=CommandGroupWithAlias, help="""Download Url object for the Java artifact.""")
@cli_util.help_option_group
def download_url_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_license_group.command_name', 'java-license'), cls=CommandGroupWithAlias, help="""Details about a license type for Java.""")
@cli_util.help_option_group
def java_license_group():
    pass


@click.command(cli_util.override('jms_java_downloads.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from the execution of a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_license_acceptance_record_group.command_name', 'java-license-acceptance-record'), cls=CommandGroupWithAlias, help="""User acceptance record for a Java license.""")
@cli_util.help_option_group
def java_license_acceptance_record_group():
    pass


@click.command(cli_util.override('jms_java_downloads.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""A description of workrequest status.""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('jms_java_downloads.java_download_count_aggregation_group.command_name', 'java-download-count-aggregation'), cls=CommandGroupWithAlias, help="""Count of Java downloads aggregated by the specified type.""")
@cli_util.help_option_group
def java_download_count_aggregation_group():
    pass


jms_java_downloads_root_group.add_command(java_download_report_group)
jms_java_downloads_root_group.add_command(java_download_record_group)
jms_java_downloads_root_group.add_command(java_download_token_group)
jms_java_downloads_root_group.add_command(work_request_error_group)
jms_java_downloads_root_group.add_command(download_url_group)
jms_java_downloads_root_group.add_command(java_license_group)
jms_java_downloads_root_group.add_command(work_request_log_entry_group)
jms_java_downloads_root_group.add_command(java_license_acceptance_record_group)
jms_java_downloads_root_group.add_command(work_request_group)
jms_java_downloads_root_group.add_command(java_download_count_aggregation_group)


@work_request_group.command(name=cli_util.override('jms_java_downloads.cancel_work_request.command_name', 'cancel'), help=u"""Cancels the work request with the given ID. \n[Command Reference](cancelWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cancel_work_request(ctx, from_json, work_request_id, if_match):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.cancel_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_download_report_group.command(name=cli_util.override('jms_java_downloads.create_java_download_report.command_name', 'create'), help=u"""Create a new report in the specified format containing the download details for the tenancy. \n[Command Reference](createJavaDownloadReport)""")
@cli_util.option('--compartment-id', required=True, help=u"""The compartment [OCID] here should be the tenancy OCID.""")
@cli_util.option('--format', required=True, type=custom_types.CliCaseInsensitiveChoice(["CSV"]), help=u"""The format of the report that is generated.""")
@cli_util.option('--time-start', type=custom_types.CLI_DATETIME, help=u"""The start time from when download records have to be included (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-end', type=custom_types.CLI_DATETIME, help=u"""The end time until when the download records have to be included (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeDownloaded", "downloadSourceId", "downloadType"]), help=u"""The property to be used for sorting the records.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order for the records.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`. (See [Managing Tags and Tag Namespaces].)""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See [Understanding Free-form Tags]).""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def create_java_download_report(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, format, time_start, time_end, sort_by, sort_order, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['format'] = format

    if time_start is not None:
        _details['timeStart'] = time_start

    if time_end is not None:
        _details['timeEnd'] = time_end

    if sort_by is not None:
        _details['sortBy'] = sort_by

    if sort_order is not None:
        _details['sortOrder'] = sort_order

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.create_java_download_report(
        create_java_download_report_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_download_token_group.command(name=cli_util.override('jms_java_downloads.create_java_download_token.command_name', 'create'), help=u"""Creates a new JavaDownloadToken in the tenancy with specified attributes. Ensure that you review the license terms before token generation. Visit the <a href=\"https://www.oracle.com/java/technologies/downloads\"/>Oracle Java Downloads</a> page to understand the license terms of the Java version for which you are generating a token. By generating a token, you agree to the associated license terms. See <a href=\"https://www.oracle.com/cis/java/technologies/javase/jdk-faqs.html\">Oracle JDK Licensing - FAQs</a> for detailed information. \n[Command Reference](createJavaDownloadToken)""")
@cli_util.option('--display-name', required=True, help=u"""User provided display name of the JavaDownloadToken.""")
@cli_util.option('--description', required=True, help=u"""User provided description of the JavaDownloadToken.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy scoped to the JavaDownloadToken.""")
@cli_util.option('--time-expires', required=True, type=custom_types.CLI_DATETIME, help=u"""Expiry time of the token.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--java-version', required=True, help=u"""The Java version associated with the token.""")
@cli_util.option('--license-type', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The license type(s) associated with the JavaDownloadToken.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-default', type=click.BOOL, help=u"""The token default attribute.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`. (See [Managing Tags and Tag Namespaces].)""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See [Understanding Free-form Tags]).""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'license-type': {'module': 'jms_java_downloads', 'class': 'list[LicenseType]'}, 'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'license-type': {'module': 'jms_java_downloads', 'class': 'list[LicenseType]'}, 'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadToken'})
@cli_util.wrap_exceptions
def create_java_download_token(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, display_name, description, compartment_id, time_expires, java_version, license_type, is_default, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['displayName'] = display_name
    _details['description'] = description
    _details['compartmentId'] = compartment_id
    _details['timeExpires'] = time_expires
    _details['javaVersion'] = java_version
    _details['licenseType'] = cli_util.parse_json_parameter("license_type", license_type)

    if is_default is not None:
        _details['isDefault'] = is_default

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.create_java_download_token(
        create_java_download_token_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_license_acceptance_record_group.command(name=cli_util.override('jms_java_downloads.create_java_license_acceptance_record.command_name', 'create'), help=u"""Creates a Java license acceptance record for the specified license type in a tenancy. \n[Command Reference](createJavaLicenseAcceptanceRecord)""")
@cli_util.option('--compartment-id', required=True, help=u"""The tenancy [OCID] of the user accepting the license.""")
@cli_util.option('--license-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["OTN", "NFTC", "BCL", "RESTRICTED"]), help=u"""License type for the Java version.""")
@cli_util.option('--license-acceptance-status', required=True, type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "REVOKED"]), help=u"""Status of license acceptance.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`. (See [Managing Tags and Tag Namespaces].)""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See [Understanding Free-form Tags]).""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicenseAcceptanceRecord'})
@cli_util.wrap_exceptions
def create_java_license_acceptance_record(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, license_type, license_acceptance_status, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['licenseType'] = license_type
    _details['licenseAcceptanceStatus'] = license_acceptance_status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.create_java_license_acceptance_record(
        create_java_license_acceptance_record_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_java_license_acceptance_record') and callable(getattr(client, 'get_java_license_acceptance_record')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_java_license_acceptance_record(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_download_report_group.command(name=cli_util.override('jms_java_downloads.delete_java_download_report.command_name', 'delete'), help=u"""Deletes a JavaDownloadReport resource by identifier. \n[Command Reference](deleteJavaDownloadReport)""")
@cli_util.option('--java-download-report-id', required=True, help=u"""Unique Java download report identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_java_download_report(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, java_download_report_id, if_match):

    if isinstance(java_download_report_id, six.string_types) and len(java_download_report_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-report-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.delete_java_download_report(
        java_download_report_id=java_download_report_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_download_token_group.command(name=cli_util.override('jms_java_downloads.delete_java_download_token.command_name', 'delete'), help=u"""Deletes a JavaDownloadToken resource by identifier. \n[Command Reference](deleteJavaDownloadToken)""")
@cli_util.option('--java-download-token-id', required=True, help=u"""Unique JavaDownloadToken identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_java_download_token(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, java_download_token_id, if_match):

    if isinstance(java_download_token_id, six.string_types) and len(java_download_token_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-token-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.delete_java_download_token(
        java_download_token_id=java_download_token_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_license_acceptance_record_group.command(name=cli_util.override('jms_java_downloads.delete_java_license_acceptance_record.command_name', 'delete'), help=u"""Deletes a Java license acceptance record with the specified identifier. \n[Command Reference](deleteJavaLicenseAcceptanceRecord)""")
@cli_util.option('--java-license-acceptance-record-id', required=True, help=u"""Unique Java license acceptance record identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_java_license_acceptance_record(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, java_license_acceptance_record_id, if_match):

    if isinstance(java_license_acceptance_record_id, six.string_types) and len(java_license_acceptance_record_id.strip()) == 0:
        raise click.UsageError('Parameter --java-license-acceptance-record-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.delete_java_license_acceptance_record(
        java_license_acceptance_record_id=java_license_acceptance_record_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_java_license_acceptance_record') and callable(getattr(client, 'get_java_license_acceptance_record')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_java_license_acceptance_record(java_license_acceptance_record_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@download_url_group.command(name=cli_util.override('jms_java_downloads.generate_artifact_download_url.command_name', 'generate-artifact'), help=u"""Generates a download URL and returns it in the response payload. The URL in the response can then be used for downloading the specific Java runtime artifact.

Use the [GetJavaRelease] API to get information about available artifacts for a specific release. Each artifact is uniquely identified by an `artifactId`. Refer [JavaArtifact] for more details. \n[Command Reference](generateArtifactDownloadUrl)""")
@cli_util.option('--artifact-id', required=True, type=click.INT, help=u"""Unique identifier for the Java runtime artifact.""")
@cli_util.option('--compartment-id', help=u"""The tenancy [OCID] of the user initiating the download.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'DownloadUrl'})
@cli_util.wrap_exceptions
def generate_artifact_download_url(ctx, from_json, artifact_id, compartment_id):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['artifactId'] = artifact_id

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.generate_artifact_download_url(
        generate_artifact_download_url_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_download_report_group.command(name=cli_util.override('jms_java_downloads.get_java_download_report.command_name', 'get'), help=u"""Gets a JavaDownloadReport by the specified identifier. \n[Command Reference](getJavaDownloadReport)""")
@cli_util.option('--java-download-report-id', required=True, help=u"""Unique Java download report identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadReport'})
@cli_util.wrap_exceptions
def get_java_download_report(ctx, from_json, java_download_report_id):

    if isinstance(java_download_report_id, six.string_types) and len(java_download_report_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-report-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_java_download_report(
        java_download_report_id=java_download_report_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_download_report_group.command(name=cli_util.override('jms_java_downloads.get_java_download_report_content.command_name', 'get-java-download-report-content'), help=u"""Retrieve a Java download report with the specified identifier. \n[Command Reference](getJavaDownloadReportContent)""")
@cli_util.option('--java-download-report-id', required=True, help=u"""Unique Java download report identifier.""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_java_download_report_content(ctx, from_json, file, java_download_report_id):

    if isinstance(java_download_report_id, six.string_types) and len(java_download_report_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-report-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_java_download_report_content(
        java_download_report_id=java_download_report_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@java_download_token_group.command(name=cli_util.override('jms_java_downloads.get_java_download_token.command_name', 'get'), help=u"""Gets a JavaDownloadToken by identifier \n[Command Reference](getJavaDownloadToken)""")
@cli_util.option('--java-download-token-id', required=True, help=u"""Unique JavaDownloadToken identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadToken'})
@cli_util.wrap_exceptions
def get_java_download_token(ctx, from_json, java_download_token_id):

    if isinstance(java_download_token_id, six.string_types) and len(java_download_token_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-token-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_java_download_token(
        java_download_token_id=java_download_token_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_license_group.command(name=cli_util.override('jms_java_downloads.get_java_license.command_name', 'get'), help=u"""Return details of the specified Java license type. \n[Command Reference](getJavaLicense)""")
@cli_util.option('--license-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["OTN", "NFTC", "BCL", "RESTRICTED"]), help=u"""Unique Java license type.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicense'})
@cli_util.wrap_exceptions
def get_java_license(ctx, from_json, license_type):

    if isinstance(license_type, six.string_types) and len(license_type.strip()) == 0:
        raise click.UsageError('Parameter --license-type cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_java_license(
        license_type=license_type,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_license_acceptance_record_group.command(name=cli_util.override('jms_java_downloads.get_java_license_acceptance_record.command_name', 'get'), help=u"""Returns a specific Java license acceptance record in a tenancy. \n[Command Reference](getJavaLicenseAcceptanceRecord)""")
@cli_util.option('--java-license-acceptance-record-id', required=True, help=u"""Unique Java license acceptance record identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicenseAcceptanceRecord'})
@cli_util.wrap_exceptions
def get_java_license_acceptance_record(ctx, from_json, java_license_acceptance_record_id):

    if isinstance(java_license_acceptance_record_id, six.string_types) and len(java_license_acceptance_record_id.strip()) == 0:
        raise click.UsageError('Parameter --java-license-acceptance-record-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_java_license_acceptance_record(
        java_license_acceptance_record_id=java_license_acceptance_record_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('jms_java_downloads.get_work_request.command_name', 'get'), help=u"""Gets details of the work request with the given ID. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_download_record_group.command(name=cli_util.override('jms_java_downloads.list_java_download_records.command_name', 'list'), help=u"""Returns a list of Java download records in a tenancy based on specified parameters. See [JavaReleases API] for possible values of `javaFamilyVersion` and `javaReleaseVersion` parameters. \n[Command Reference](listJavaDownloadRecords)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy.""")
@cli_util.option('--family-version', help=u"""Unique Java family version identifier.""")
@cli_util.option('--release-version', help=u"""Unique Java release version identifier.""")
@cli_util.option('--os-family', help=u"""Target Operating System family of the artifact.""")
@cli_util.option('--architecture', help=u"""Target Operating System architecture of the artifact.""")
@cli_util.option('--package-type-detail', help=u"""Packaging type detail of the artifact.""")
@cli_util.option('--time-start', type=custom_types.CLI_DATETIME, help=u"""The start of the time period for which reports are searched (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-end', type=custom_types.CLI_DATETIME, help=u"""The end of the time period for which reports are searched (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeDownloaded", "downloadSourceId", "downloadType"]), help=u"""If no value is specified _timeDownloaded_ is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadRecordCollection'})
@cli_util.wrap_exceptions
def list_java_download_records(ctx, from_json, all_pages, page_size, compartment_id, family_version, release_version, os_family, architecture, package_type_detail, time_start, time_end, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if family_version is not None:
        kwargs['family_version'] = family_version
    if release_version is not None:
        kwargs['release_version'] = release_version
    if os_family is not None:
        kwargs['os_family'] = os_family
    if architecture is not None:
        kwargs['architecture'] = architecture
    if package_type_detail is not None:
        kwargs['package_type_detail'] = package_type_detail
    if time_start is not None:
        kwargs['time_start'] = time_start
    if time_end is not None:
        kwargs['time_end'] = time_end
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_download_records,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_download_records,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_java_download_records(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_download_report_group.command(name=cli_util.override('jms_java_downloads.list_java_download_reports.command_name', 'list'), help=u"""Returns a list of JavaDownloadReports. \n[Command Reference](listJavaDownloadReports)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the display name.""")
@cli_util.option('--java-download-report-id', help=u"""Unique Java download report identifier.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. If no value is specified, _timeCreated_ is the default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadReportCollection'})
@cli_util.wrap_exceptions
def list_java_download_reports(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, java_download_report_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if java_download_report_id is not None:
        kwargs['java_download_report_id'] = java_download_report_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_download_reports,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_download_reports,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_java_download_reports(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_download_token_group.command(name=cli_util.override('jms_java_downloads.list_java_download_tokens.command_name', 'list'), help=u"""Returns a list of JavaDownloadTokens. \n[Command Reference](listJavaDownloadTokens)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), help=u"""A filter to return only resources their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""Unique JavaDownloadToken identifier.""")
@cli_util.option('--value', help=u"""Unique JavaDownloadToken value.""")
@cli_util.option('--family-version', help=u"""Unique Java family version identifier.""")
@cli_util.option('--search-by-user', help=u"""A filter to return only resources that match the user principal detail. The search string can be any of the property values from the [Principal] object. This object is used as a response datatype for the `createdBy` and `lastUpdatedBy` fields in applicable resource.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "timeExpires", "state", "displayName", "javaVersion"]), help=u"""The field to sort by. If no value is specified, _timeCreated_ is the default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadTokenCollection'})
@cli_util.wrap_exceptions
def list_java_download_tokens(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, id, value, family_version, search_by_user, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if value is not None:
        kwargs['value'] = value
    if family_version is not None:
        kwargs['family_version'] = family_version
    if search_by_user is not None:
        kwargs['search_by_user'] = search_by_user
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_download_tokens,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_download_tokens,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_java_download_tokens(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_license_acceptance_record_group.command(name=cli_util.override('jms_java_downloads.list_java_license_acceptance_records.command_name', 'list'), help=u"""Returns a list of all the Java license acceptance records in a tenancy. \n[Command Reference](listJavaLicenseAcceptanceRecords)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy.""")
@cli_util.option('--search-by-user', help=u"""A filter to return only resources that match the user principal detail. The search string can be any of the property values from the [Principal] object. This object is used as a response datatype for the `createdBy` and `lastUpdatedBy` fields in applicable resource.""")
@cli_util.option('--id', help=u"""Unique Java license acceptance record identifier.""")
@cli_util.option('--license-type', type=custom_types.CliCaseInsensitiveChoice(["OTN", "NFTC", "BCL", "RESTRICTED"]), help=u"""Unique Java license type.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "REVOKED"]), help=u"""The status of license acceptance.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted", "timeLastUpdated", "licenseAcceptanceStatus"]), help=u"""The field to sort by. If no value is specified, _timeAccepted_ is the default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicenseAcceptanceRecordCollection'})
@cli_util.wrap_exceptions
def list_java_license_acceptance_records(ctx, from_json, all_pages, page_size, compartment_id, search_by_user, id, license_type, status, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if search_by_user is not None:
        kwargs['search_by_user'] = search_by_user
    if id is not None:
        kwargs['id'] = id
    if license_type is not None:
        kwargs['license_type'] = license_type
    if status is not None:
        kwargs['status'] = status
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_license_acceptance_records,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_license_acceptance_records,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_java_license_acceptance_records(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_license_group.command(name=cli_util.override('jms_java_downloads.list_java_licenses.command_name', 'list'), help=u"""Return a list with details of all Java licenses. \n[Command Reference](listJavaLicenses)""")
@cli_util.option('--license-type', type=custom_types.CliCaseInsensitiveChoice(["OTN", "NFTC", "BCL", "RESTRICTED"]), help=u"""Unique Java license type.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the display name.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["licenseType", "displayName"]), help=u"""The field to sort by. If no value is specified, _licenseType_ is the default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicenseCollection'})
@cli_util.wrap_exceptions
def list_java_licenses(ctx, from_json, all_pages, page_size, license_type, display_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if license_type is not None:
        kwargs['license_type'] = license_type
    if display_name is not None:
        kwargs['display_name'] = display_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_licenses,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_licenses,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_java_licenses(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('jms_java_downloads.list_work_request_errors.command_name', 'list'), help=u"""Returns a (paginated) list of errors for the work request with the given ID. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('jms_java_downloads.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Returns a (paginated) list of logs for the work request with the given ID. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('jms_java_downloads.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a tenancy. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the tenancy.""")
@cli_util.option('--id', help=u"""The ID of an asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), help=u"""A filter to return only resources their lifecycleState matches the given OperationStatus.""")
@cli_util.option('--resource-id', help=u"""The ID of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if id is not None:
        kwargs['id'] = id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_download_count_aggregation_group.command(name=cli_util.override('jms_java_downloads.request_summarized_java_download_counts.command_name', 'request-summarized-java-download-counts'), help=u"""Returns list of download counts grouped by the specified property. \n[Command Reference](requestSummarizedJavaDownloadCounts)""")
@cli_util.option('--compartment-id', required=True, help=u"""The compartment [OCID] here should be the tenancy OCID.""")
@cli_util.option('--group-as', required=True, type=custom_types.CliCaseInsensitiveChoice(["JAVA_FAMILY", "JAVA_RELEASE", "PLATFORM"]), help=u"""The property that specifies the aggregation type for the download counts.""")
@cli_util.option('--family-version', help=u"""Unique Java family version identifier.""")
@cli_util.option('--release-version', help=u"""Unique Java release version identifier.""")
@cli_util.option('--time-start', type=custom_types.CLI_DATETIME, help=u"""The start time from when download data has to be included (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-end', type=custom_types.CLI_DATETIME, help=u"""The end time until when the download data has to be included (formatted according to [RFC3339]).""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["FAMILY_VERSION", "DOWNLOAD_COUNT"]), help=u"""The property to be used for sorting the aggregated report.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order for the aggregated report.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous call.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_java_downloads', 'class': 'JavaDownloadCountAggregationCollection'})
@cli_util.wrap_exceptions
def request_summarized_java_download_counts(ctx, from_json, compartment_id, group_as, family_version, release_version, time_start, time_end, sort_by, sort_order, limit, page):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['groupAs'] = group_as

    if family_version is not None:
        _details['familyVersion'] = family_version

    if release_version is not None:
        _details['releaseVersion'] = release_version

    if time_start is not None:
        _details['timeStart'] = time_start

    if time_end is not None:
        _details['timeEnd'] = time_end

    if sort_by is not None:
        _details['sortBy'] = sort_by

    if sort_order is not None:
        _details['sortOrder'] = sort_order

    if limit is not None:
        _details['limit'] = limit

    if page is not None:
        _details['page'] = page

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.request_summarized_java_download_counts(
        request_summarized_java_download_counts_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_download_token_group.command(name=cli_util.override('jms_java_downloads.update_java_download_token.command_name', 'update'), help=u"""Updates the JavaDownloadToken specified by the identifier. \n[Command Reference](updateJavaDownloadToken)""")
@cli_util.option('--java-download-token-id', required=True, help=u"""Unique JavaDownloadToken identifier.""")
@cli_util.option('--display-name', help=u"""User provided display name of the JavaDownloadToken.""")
@cli_util.option('--description', help=u"""User provided description of the JavaDownloadToken.""")
@cli_util.option('--is-default', type=click.BOOL, help=u"""Update the token default status.""")
@cli_util.option('--time-expires', type=custom_types.CLI_DATETIME, help=u"""Expiry time of the token.""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--license-type', type=custom_types.CLI_COMPLEX_TYPE, help=u"""The license type(s) associated with the JavaDownloadToken.

This option is a JSON list with items of type LicenseType.  For documentation on LicenseType please see our API reference: https://docs.cloud.oracle.com/api/#/en/javadownload/20230601/datatypes/LicenseType.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`. (See [Managing Tags and Tag Namespaces].)""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See [Understanding Free-form Tags]).""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'license-type': {'module': 'jms_java_downloads', 'class': 'list[LicenseType]'}, 'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'license-type': {'module': 'jms_java_downloads', 'class': 'list[LicenseType]'}, 'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_java_download_token(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, java_download_token_id, display_name, description, is_default, time_expires, license_type, freeform_tags, defined_tags, if_match):

    if isinstance(java_download_token_id, six.string_types) and len(java_download_token_id.strip()) == 0:
        raise click.UsageError('Parameter --java-download-token-id cannot be whitespace or empty string')
    if not force:
        if license_type or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to license-type and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if is_default is not None:
        _details['isDefault'] = is_default

    if time_expires is not None:
        _details['timeExpires'] = time_expires

    if license_type is not None:
        _details['licenseType'] = cli_util.parse_json_parameter("license_type", license_type)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.update_java_download_token(
        java_download_token_id=java_download_token_id,
        update_java_download_token_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@java_license_acceptance_record_group.command(name=cli_util.override('jms_java_downloads.update_java_license_acceptance_record.command_name', 'update'), help=u"""Updates a specific Java license acceptance record in a tenancy. \n[Command Reference](updateJavaLicenseAcceptanceRecord)""")
@cli_util.option('--java-license-acceptance-record-id', required=True, help=u"""Unique Java license acceptance record identifier.""")
@cli_util.option('--license-acceptance-status', required=True, type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "REVOKED"]), help=u"""Status of license acceptance.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`. (See [Managing Tags and Tag Namespaces].)""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See [Understanding Free-form Tags]).""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the ETag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the ETag you provide matches the resource's current ETag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_java_downloads', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'jms_java_downloads', 'class': 'JavaLicenseAcceptanceRecord'})
@cli_util.wrap_exceptions
def update_java_license_acceptance_record(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, java_license_acceptance_record_id, license_acceptance_status, freeform_tags, defined_tags, if_match):

    if isinstance(java_license_acceptance_record_id, six.string_types) and len(java_license_acceptance_record_id.strip()) == 0:
        raise click.UsageError('Parameter --java-license-acceptance-record-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['licenseAcceptanceStatus'] = license_acceptance_status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_java_downloads', 'java_download', ctx)
    result = client.update_java_license_acceptance_record(
        java_license_acceptance_record_id=java_license_acceptance_record_id,
        update_java_license_acceptance_record_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_java_license_acceptance_record') and callable(getattr(client, 'get_java_license_acceptance_record')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_java_license_acceptance_record(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
