# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('jms_utils.jms_utils_root_group.command_name', 'jms-utils'), cls=CommandGroupWithAlias, help=cli_util.override('jms_utils.jms_utils_root_group.help', """The APIs for Analyze Applications and other utilities of Java Management Service."""), short_help=cli_util.override('jms_utils.jms_utils_root_group.short_help', """Java Management Service Utilities API"""))
@cli_util.help_option_group
def jms_utils_root_group():
    pass


@click.command(cli_util.override('jms_utils.performance_tuning_analysis_group.command_name', 'performance-tuning-analysis'), cls=CommandGroupWithAlias, help="""To use any of the API operations, you must be authorized by an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def performance_tuning_analysis_group():
    pass


@click.command(cli_util.override('jms_utils.analyze_applications_configuration_group.command_name', 'analyze-applications-configuration'), cls=CommandGroupWithAlias, help="""The configuration for analyzing applications.""")
@cli_util.help_option_group
def analyze_applications_configuration_group():
    pass


@click.command(cli_util.override('jms_utils.work_item_summary_group.command_name', 'work-item-summary'), cls=CommandGroupWithAlias, help="""Work item to complete a work request.""")
@cli_util.help_option_group
def work_item_summary_group():
    pass


@click.command(cli_util.override('jms_utils.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while performing an operation that is tracked by a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('jms_utils.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from performing an operation that is tracked by a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('jms_utils.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""An asynchronous work request. Work requests help you monitor long-running operations. When you start a long-running operation, the service creates a work request. A work request is an activity log that lets you track each step in the operation's progress. Each work request has an OCID that lets you interact with it programmatically and use it for automation.""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('jms_utils.java_migration_analysis_group.command_name', 'java-migration-analysis'), cls=CommandGroupWithAlias, help="""To use any of the API operations, you must be authorized by an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies].""")
@cli_util.help_option_group
def java_migration_analysis_group():
    pass


@click.command(cli_util.override('jms_utils.subscription_acknowledgment_configuration_group.command_name', 'subscription-acknowledgment-configuration'), cls=CommandGroupWithAlias, help="""The configuration for subscription acknowledgment.""")
@cli_util.help_option_group
def subscription_acknowledgment_configuration_group():
    pass


jms_utils_root_group.add_command(performance_tuning_analysis_group)
jms_utils_root_group.add_command(analyze_applications_configuration_group)
jms_utils_root_group.add_command(work_item_summary_group)
jms_utils_root_group.add_command(work_request_error_group)
jms_utils_root_group.add_command(work_request_log_entry_group)
jms_utils_root_group.add_command(work_request_group)
jms_utils_root_group.add_command(java_migration_analysis_group)
jms_utils_root_group.add_command(subscription_acknowledgment_configuration_group)


@work_request_group.command(name=cli_util.override('jms_utils.cancel_work_request.command_name', 'cancel'), help=u"""Cancels a work request. \n[Command Reference](cancelWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cancel_work_request(ctx, from_json, work_request_id, if_match):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.cancel_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_migration_analysis_group.command(name=cli_util.override('jms_utils.delete_java_migration_analysis.command_name', 'delete'), help=u"""Deletes a Java Migration Analysis. \n[Command Reference](deleteJavaMigrationAnalysis)""")
@cli_util.option('--java-migration-analysis-id', required=True, help=u"""The [OCID] of the Java Migration Analysis.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_java_migration_analysis(ctx, from_json, java_migration_analysis_id, if_match):

    if isinstance(java_migration_analysis_id, six.string_types) and len(java_migration_analysis_id.strip()) == 0:
        raise click.UsageError('Parameter --java-migration-analysis-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.delete_java_migration_analysis(
        java_migration_analysis_id=java_migration_analysis_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@performance_tuning_analysis_group.command(name=cli_util.override('jms_utils.delete_performance_tuning_analysis.command_name', 'delete'), help=u"""Deletes a Performance Tuning Analysis. \n[Command Reference](deletePerformanceTuningAnalysis)""")
@cli_util.option('--performance-tuning-analysis-id', required=True, help=u"""The [OCID] of the Performance Tuning Analysis.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_performance_tuning_analysis(ctx, from_json, performance_tuning_analysis_id, if_match):

    if isinstance(performance_tuning_analysis_id, six.string_types) and len(performance_tuning_analysis_id.strip()) == 0:
        raise click.UsageError('Parameter --performance-tuning-analysis-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.delete_performance_tuning_analysis(
        performance_tuning_analysis_id=performance_tuning_analysis_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@analyze_applications_configuration_group.command(name=cli_util.override('jms_utils.get_analyze_applications_configuration.command_name', 'get'), help=u"""Returns the configuration for analyzing applications. \n[Command Reference](getAnalyzeApplicationsConfiguration)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'AnalyzeApplicationsConfiguration'})
@cli_util.wrap_exceptions
def get_analyze_applications_configuration(ctx, from_json, compartment_id):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.get_analyze_applications_configuration(
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_migration_analysis_group.command(name=cli_util.override('jms_utils.get_java_migration_analysis.command_name', 'get'), help=u"""Gets information about a Java Migration Analysis. \n[Command Reference](getJavaMigrationAnalysis)""")
@cli_util.option('--java-migration-analysis-id', required=True, help=u"""The [OCID] of the Java Migration Analysis.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'JavaMigrationAnalysis'})
@cli_util.wrap_exceptions
def get_java_migration_analysis(ctx, from_json, java_migration_analysis_id):

    if isinstance(java_migration_analysis_id, six.string_types) and len(java_migration_analysis_id.strip()) == 0:
        raise click.UsageError('Parameter --java-migration-analysis-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.get_java_migration_analysis(
        java_migration_analysis_id=java_migration_analysis_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@performance_tuning_analysis_group.command(name=cli_util.override('jms_utils.get_performance_tuning_analysis.command_name', 'get'), help=u"""Gets information about a Performance Tuning Analysis. \n[Command Reference](getPerformanceTuningAnalysis)""")
@cli_util.option('--performance-tuning-analysis-id', required=True, help=u"""The [OCID] of the Performance Tuning Analysis.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'PerformanceTuningAnalysis'})
@cli_util.wrap_exceptions
def get_performance_tuning_analysis(ctx, from_json, performance_tuning_analysis_id):

    if isinstance(performance_tuning_analysis_id, six.string_types) and len(performance_tuning_analysis_id.strip()) == 0:
        raise click.UsageError('Parameter --performance-tuning-analysis-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.get_performance_tuning_analysis(
        performance_tuning_analysis_id=performance_tuning_analysis_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@subscription_acknowledgment_configuration_group.command(name=cli_util.override('jms_utils.get_subscription_acknowledgment_configuration.command_name', 'get'), help=u"""Returns the configuration for subscription acknowledgment. \n[Command Reference](getSubscriptionAcknowledgmentConfiguration)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'SubscriptionAcknowledgmentConfiguration'})
@cli_util.wrap_exceptions
def get_subscription_acknowledgment_configuration(ctx, from_json, compartment_id):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.get_subscription_acknowledgment_configuration(
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('jms_utils.get_work_request.command_name', 'get'), help=u"""Gets the details of a work request. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@java_migration_analysis_group.command(name=cli_util.override('jms_utils.list_java_migration_analysis.command_name', 'list'), help=u"""Gets a list of Java Migration Analysis. \n[Command Reference](listJavaMigrationAnalysis)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""The [OCID] of the Java Migration Analysis.""")
@cli_util.option('--analysis-project-name', help=u"""The project name of the Performance Tuning Analysis to query for.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIME_CREATED", "TIME_STARTED", "TIME_FINISHED"]), help=u"""The field to sort Java Migration Analysis. Only one sort order may be provided.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'JavaMigrationAnalysisCollection'})
@cli_util.wrap_exceptions
def list_java_migration_analysis(ctx, from_json, all_pages, page_size, compartment_id, id, analysis_project_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if id is not None:
        kwargs['id'] = id
    if analysis_project_name is not None:
        kwargs['analysis_project_name'] = analysis_project_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_java_migration_analysis,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_java_migration_analysis,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_java_migration_analysis(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@performance_tuning_analysis_group.command(name=cli_util.override('jms_utils.list_performance_tuning_analysis.command_name', 'list'), help=u"""Gets a list of Performance tuning Analysis. \n[Command Reference](listPerformanceTuningAnalysis)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--id', help=u"""The [OCID] of the Performance Tuning Analysis.""")
@cli_util.option('--analysis-project-name', help=u"""The project name of the Performance Tuning Analysis to query for.""")
@cli_util.option('--performance-tuning-analysis-result', type=custom_types.CliCaseInsensitiveChoice(["ACTION_RECOMMENDED", "NO_WARNINGS"]), help=u"""The result of the Performance Tuning Analysis to query for.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["TIME_CREATED", "TIME_STARTED", "TIME_FINISHED"]), help=u"""The field to sort Performance Tuning Analysis. Only one sort order may be provided.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'PerformanceTuningAnalysisCollection'})
@cli_util.wrap_exceptions
def list_performance_tuning_analysis(ctx, from_json, all_pages, page_size, compartment_id, id, analysis_project_name, performance_tuning_analysis_result, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if id is not None:
        kwargs['id'] = id
    if analysis_project_name is not None:
        kwargs['analysis_project_name'] = analysis_project_name
    if performance_tuning_analysis_result is not None:
        kwargs['performance_tuning_analysis_result'] = performance_tuning_analysis_result
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_performance_tuning_analysis,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_performance_tuning_analysis,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_performance_tuning_analysis(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_item_summary_group.command(name=cli_util.override('jms_utils.list_work_items.command_name', 'list-work-items'), help=u"""Retrieve a paginated list of work items for a specified work request. \n[Command Reference](listWorkItems)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'WorkItemCollection'})
@cli_util.wrap_exceptions
def list_work_items(ctx, from_json, all_pages, page_size, work_request_id, page, limit):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_items,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_items,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_items(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('jms_utils.list_work_request_errors.command_name', 'list'), help=u"""Lists the errors for a work request. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for `timeCreated` is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('jms_utils.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Lists the logs for a work request. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for `timeCreated` is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('jms_utils.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--work-request-id', help=u"""The [OCID] of the asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELLING", "CANCELLED"]), help=u"""A filter to return only the resources that match the given lifecycle state.""")
@cli_util.option('--resource-id', help=u"""The [OCID] of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. The token is usually retrieved from a previous list call.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either ascending (`ASC`) or descending (`DESC`).""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for `timeAccepted` is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, work_request_id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if work_request_id is not None:
        kwargs['work_request_id'] = work_request_id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@java_migration_analysis_group.command(name=cli_util.override('jms_utils.request_java_migration_analysis.command_name', 'request'), help=u"""Requests Java Migration Analysis. \n[Command Reference](requestJavaMigrationAnalysis)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment where the Java Migration Analysis will be created.""")
@cli_util.option('--targets', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The list of targets for the Java Migration Analysis.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELLING", "CANCELLED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'targets': {'module': 'jms_utils', 'class': 'list[JavaMigrationAnalysisTarget]'}, 'freeform-tags': {'module': 'jms_utils', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_utils', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'targets': {'module': 'jms_utils', 'class': 'list[JavaMigrationAnalysisTarget]'}, 'freeform-tags': {'module': 'jms_utils', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_utils', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def request_java_migration_analysis(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, targets, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['targets'] = cli_util.parse_json_parameter("targets", targets)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.request_java_migration_analysis(
        request_java_migration_analysis_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@performance_tuning_analysis_group.command(name=cli_util.override('jms_utils.request_performance_tuning_analysis.command_name', 'request'), help=u"""Requests Performance Tuning Analysis. \n[Command Reference](requestPerformanceTuningAnalysis)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment where the Performance Tuning Analysis will be created.""")
@cli_util.option('--targets', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The list of targets for the Performance Tuning Analysis.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELLING", "CANCELLED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'targets': {'module': 'jms_utils', 'class': 'list[PerformanceTuningAnalysisTarget]'}, 'freeform-tags': {'module': 'jms_utils', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_utils', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'targets': {'module': 'jms_utils', 'class': 'list[PerformanceTuningAnalysisTarget]'}, 'freeform-tags': {'module': 'jms_utils', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'jms_utils', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def request_performance_tuning_analysis(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, targets, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['targets'] = cli_util.parse_json_parameter("targets", targets)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.request_performance_tuning_analysis(
        request_performance_tuning_analysis_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@analyze_applications_configuration_group.command(name=cli_util.override('jms_utils.update_analyze_applications_configuration.command_name', 'update'), help=u"""Updates the configuration for analyze application. \n[Command Reference](updateAnalyzeApplicationsConfiguration)""")
@cli_util.option('--namespace-name', help=u"""The Object Storage namespace used for analyzing applications.""")
@cli_util.option('--bucket-name', help=u"""The name of the bucket used for analyzing applications.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'AnalyzeApplicationsConfiguration'})
@cli_util.wrap_exceptions
def update_analyze_applications_configuration(ctx, from_json, namespace_name, bucket_name, compartment_id, if_match):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if namespace_name is not None:
        _details['namespaceName'] = namespace_name

    if bucket_name is not None:
        _details['bucketName'] = bucket_name

    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.update_analyze_applications_configuration(
        update_analyze_applications_configuration_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@subscription_acknowledgment_configuration_group.command(name=cli_util.override('jms_utils.update_subscription_acknowledgment_configuration.command_name', 'update'), help=u"""Updates the configuration for subscription acknowledgment. \n[Command Reference](updateSubscriptionAcknowledgmentConfiguration)""")
@cli_util.option('--is-acknowledged', type=click.BOOL, help=u"""Flag to determine whether the subscription was acknowledged or not.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment in which to list resources.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'jms_utils', 'class': 'SubscriptionAcknowledgmentConfiguration'})
@cli_util.wrap_exceptions
def update_subscription_acknowledgment_configuration(ctx, from_json, is_acknowledged, compartment_id, if_match):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_acknowledged is not None:
        _details['isAcknowledged'] = is_acknowledged

    client = cli_util.build_client('jms_utils', 'jms_utils', ctx)
    result = client.update_subscription_acknowledgment_configuration(
        update_subscription_acknowledgment_configuration_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
