# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('marketplace_publisher.marketplace_publisher_root_group.command_name', 'marketplace-publisher'), cls=CommandGroupWithAlias, help=cli_util.override('marketplace_publisher.marketplace_publisher_root_group.help', """Use the Marketplace Publisher API to manage the publishing of applications in Oracle Cloud Infrastructure Marketplace."""), short_help=cli_util.override('marketplace_publisher.marketplace_publisher_root_group.short_help', """MarketplacePublisherService API"""))
@cli_util.help_option_group
def marketplace_publisher_root_group():
    pass


@click.command(cli_util.override('marketplace_publisher.market_collection_group.command_name', 'market-collection'), cls=CommandGroupWithAlias, help="""Results of a market search. Contains the market items.""")
@cli_util.help_option_group
def market_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_collection_group.command_name', 'listing-collection'), cls=CommandGroupWithAlias, help="""Results of listing search. Contains Listing items.""")
@cli_util.help_option_group
def listing_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""A description of workrequest status""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('marketplace_publisher.support_doc_collection_group.command_name', 'support-doc-collection'), cls=CommandGroupWithAlias, help="""Results of a supportDoc search. Contains the supportDoc items.""")
@cli_util.help_option_group
def support_doc_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.lead_collection_group.command_name', 'lead-collection'), cls=CommandGroupWithAlias, help="""The model for the collection of Marketplace Publisher Lead.""")
@cli_util.help_option_group
def lead_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.publisher_collection_group.command_name', 'publisher-collection'), cls=CommandGroupWithAlias, help="""Results of a publisher search. Contains Publisher items.""")
@cli_util.help_option_group
def publisher_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.artifact_group.command_name', 'artifact'), cls=CommandGroupWithAlias, help="""Base model object for the artifacts.""")
@cli_util.help_option_group
def artifact_group():
    pass


@click.command(cli_util.override('marketplace_publisher.term_version_group.command_name', 'term-version'), cls=CommandGroupWithAlias, help="""Model object for the term version details.""")
@cli_util.help_option_group
def term_version_group():
    pass


@click.command(cli_util.override('marketplace_publisher.disbursement_report_record_collection_group.command_name', 'disbursement-report-record-collection'), cls=CommandGroupWithAlias, help="""Disbursement report""")
@cli_util.help_option_group
def disbursement_report_record_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_attachment_collection_group.command_name', 'listing-revision-attachment-collection'), cls=CommandGroupWithAlias, help="""Results of the listing attachments search. Contains attachment items.""")
@cli_util.help_option_group
def listing_revision_attachment_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while executing a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('marketplace_publisher.supported_currency_collection_group.command_name', 'supported-currency-collection'), cls=CommandGroupWithAlias, help="""Result set consisting of list of currencies supported by the Marketplace Publisher Service.""")
@cli_util.help_option_group
def supported_currency_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.term_group.command_name', 'term'), cls=CommandGroupWithAlias, help="""Base model object for the term.""")
@cli_util.help_option_group
def term_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_group.command_name', 'listing'), cls=CommandGroupWithAlias, help="""The model for the Marketplace Publisher listing.""")
@cli_util.help_option_group
def listing_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_note_collection_group.command_name', 'listing-revision-note-collection'), cls=CommandGroupWithAlias, help="""Results of note search. Contains listing revision note items.""")
@cli_util.help_option_group
def listing_revision_note_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_note_group.command_name', 'listing-revision-note'), cls=CommandGroupWithAlias, help="""The model for the listing revision notes.""")
@cli_util.help_option_group
def listing_revision_note_group():
    pass


@click.command(cli_util.override('marketplace_publisher.supported_shape_collection_group.command_name', 'supported-shape-collection'), cls=CommandGroupWithAlias, help="""The list of shapes that can be used to create a database system.""")
@cli_util.help_option_group
def supported_shape_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.customer_instance_report_record_collection_group.command_name', 'customer-instance-report-record-collection'), cls=CommandGroupWithAlias, help="""Customer instance report""")
@cli_util.help_option_group
def customer_instance_report_record_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.product_group.command_name', 'product'), cls=CommandGroupWithAlias, help="""The model for the product details.""")
@cli_util.help_option_group
def product_group():
    pass


@click.command(cli_util.override('marketplace_publisher.support_doc_group.command_name', 'support-doc'), cls=CommandGroupWithAlias, help="""The model for the supportDoc details.""")
@cli_util.help_option_group
def support_doc_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_group.command_name', 'listing-revision'), cls=CommandGroupWithAlias, help="""The model for an Oracle Cloud Infrastructure Marketplace Publisher listing revision.""")
@cli_util.help_option_group
def listing_revision_group():
    pass


@click.command(cli_util.override('marketplace_publisher.product_collection_group.command_name', 'product-collection'), cls=CommandGroupWithAlias, help="""Results of a product search. Contains the product items.""")
@cli_util.help_option_group
def product_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from the execution of a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('marketplace_publisher.term_version_collection_group.command_name', 'term-version-collection'), cls=CommandGroupWithAlias, help="""Results of the term version search. Contains term version items.""")
@cli_util.help_option_group
def term_version_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.term_collection_group.command_name', 'term-collection'), cls=CommandGroupWithAlias, help="""Results of the term search. Contains term items.""")
@cli_util.help_option_group
def term_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.artifact_collection_group.command_name', 'artifact-collection'), cls=CommandGroupWithAlias, help="""Results of the artifact search. Contains the artifact items.""")
@cli_util.help_option_group
def artifact_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.lead_group.command_name', 'lead'), cls=CommandGroupWithAlias, help="""Details of Lead""")
@cli_util.help_option_group
def lead_group():
    pass


@click.command(cli_util.override('marketplace_publisher.market_group.command_name', 'market'), cls=CommandGroupWithAlias, help="""The model for the market details.""")
@cli_util.help_option_group
def market_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_package_collection_group.command_name', 'listing-revision-package-collection'), cls=CommandGroupWithAlias, help="""Results of package search. Contains Package items.""")
@cli_util.help_option_group
def listing_revision_package_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.available_service_collection_group.command_name', 'available-service-collection'), cls=CommandGroupWithAlias, help="""Results of available service provider search, returns available services""")
@cli_util.help_option_group
def available_service_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_collection_group.command_name', 'listing-revision-collection'), cls=CommandGroupWithAlias, help="""Results of listing revision search. Contains Listing revision items.""")
@cli_util.help_option_group
def listing_revision_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_attachment_group.command_name', 'listing-revision-attachment'), cls=CommandGroupWithAlias, help="""A attachment for the listing revision. User can provide an external URL/upload a file""")
@cli_util.help_option_group
def listing_revision_attachment_group():
    pass


@click.command(cli_util.override('marketplace_publisher.publisher_group.command_name', 'publisher'), cls=CommandGroupWithAlias, help="""The model for a publisher details.""")
@cli_util.help_option_group
def publisher_group():
    pass


@click.command(cli_util.override('marketplace_publisher.category_collection_group.command_name', 'category-collection'), cls=CommandGroupWithAlias, help="""Results of a category search. Contains the category items.""")
@cli_util.help_option_group
def category_collection_group():
    pass


@click.command(cli_util.override('marketplace_publisher.category_group.command_name', 'category'), cls=CommandGroupWithAlias, help="""The model for the category details.""")
@cli_util.help_option_group
def category_group():
    pass


@click.command(cli_util.override('marketplace_publisher.listing_revision_package_group.command_name', 'listing-revision-package'), cls=CommandGroupWithAlias, help="""A base object for all types of listing revision packages.""")
@cli_util.help_option_group
def listing_revision_package_group():
    pass


marketplace_publisher_root_group.add_command(market_collection_group)
marketplace_publisher_root_group.add_command(listing_collection_group)
marketplace_publisher_root_group.add_command(work_request_group)
marketplace_publisher_root_group.add_command(support_doc_collection_group)
marketplace_publisher_root_group.add_command(lead_collection_group)
marketplace_publisher_root_group.add_command(publisher_collection_group)
marketplace_publisher_root_group.add_command(artifact_group)
marketplace_publisher_root_group.add_command(term_version_group)
marketplace_publisher_root_group.add_command(disbursement_report_record_collection_group)
marketplace_publisher_root_group.add_command(listing_revision_attachment_collection_group)
marketplace_publisher_root_group.add_command(work_request_error_group)
marketplace_publisher_root_group.add_command(supported_currency_collection_group)
marketplace_publisher_root_group.add_command(term_group)
marketplace_publisher_root_group.add_command(listing_group)
marketplace_publisher_root_group.add_command(listing_revision_note_collection_group)
marketplace_publisher_root_group.add_command(listing_revision_note_group)
marketplace_publisher_root_group.add_command(supported_shape_collection_group)
marketplace_publisher_root_group.add_command(customer_instance_report_record_collection_group)
marketplace_publisher_root_group.add_command(product_group)
marketplace_publisher_root_group.add_command(support_doc_group)
marketplace_publisher_root_group.add_command(listing_revision_group)
marketplace_publisher_root_group.add_command(product_collection_group)
marketplace_publisher_root_group.add_command(work_request_log_entry_group)
marketplace_publisher_root_group.add_command(term_version_collection_group)
marketplace_publisher_root_group.add_command(term_collection_group)
marketplace_publisher_root_group.add_command(artifact_collection_group)
marketplace_publisher_root_group.add_command(lead_group)
marketplace_publisher_root_group.add_command(market_group)
marketplace_publisher_root_group.add_command(listing_revision_package_collection_group)
marketplace_publisher_root_group.add_command(available_service_collection_group)
marketplace_publisher_root_group.add_command(listing_revision_collection_group)
marketplace_publisher_root_group.add_command(listing_revision_attachment_group)
marketplace_publisher_root_group.add_command(publisher_group)
marketplace_publisher_root_group.add_command(category_collection_group)
marketplace_publisher_root_group.add_command(category_group)
marketplace_publisher_root_group.add_command(listing_revision_package_group)


@term_version_group.command(name=cli_util.override('marketplace_publisher.activate_term_version.command_name', 'activate'), help=u"""Mark the Term Version identified by the id as active \n[Command Reference](activateTermVersion)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersion'})
@cli_util.wrap_exceptions
def activate_term_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, term_version_id, if_match):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.activate_term_version(
        term_version_id=term_version_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term_version') and callable(getattr(client, 'get_term_version')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term_version(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('marketplace_publisher.cancel_work_request.command_name', 'cancel'), help=u"""Cancels the work request with the given ID. \n[Command Reference](cancelWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cancel_work_request(ctx, from_json, work_request_id, if_match):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.cancel_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.cascading_delete_listing.command_name', 'cascading-delete'), help=u"""Cascade delete the listing and its subresources. \n[Command Reference](cascadingDeleteListing)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cascading_delete_listing(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, if_match):

    if isinstance(listing_id, six.string_types) and len(listing_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.cascading_delete_listing(
        listing_id=listing_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.cascading_delete_listing_revision.command_name', 'cascading-delete'), help=u"""Cascade delete listing revision and its subresources. \n[Command Reference](cascadingDeleteListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cascading_delete_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.cascading_delete_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.change_artifact_compartment.command_name', 'change-compartment'), help=u"""Moves the specified artifact to the specified compartment within the same tenancy. \n[Command Reference](changeArtifactCompartment)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier of the compartment for the artifact.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_artifact_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.change_artifact_compartment(
        artifact_id=artifact_id,
        change_artifact_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.change_listing_compartment.command_name', 'change-compartment'), help=u"""Moves a listing from one compartment to another \n[Command Reference](changeListingCompartment)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@cli_util.option('--compartment-id', help=u"""The id of the compartment which the listing should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_listing_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, compartment_id, if_match):

    if isinstance(listing_id, six.string_types) and len(listing_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.change_listing_compartment(
        listing_id=listing_id,
        change_listing_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.change_listing_revision_to_new_status.command_name', 'change-listing-revision-to-new-status'), help=u"""Updates the Listing Revision to New status \n[Command Reference](changeListingRevisionToNewStatus)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def change_listing_revision_to_new_status(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.change_listing_revision_to_new_status(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_group.command(name=cli_util.override('marketplace_publisher.change_term_compartment.command_name', 'change-compartment'), help=u"""Moves a term from one compartment to another \n[Command Reference](changeTermCompartment)""")
@cli_util.option('--term-id', required=True, help=u"""term OCID""")
@cli_util.option('--compartment-id', help=u"""The id of the compartment which the term should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_term_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, term_id, compartment_id, if_match):

    if isinstance(term_id, six.string_types) and len(term_id.strip()) == 0:
        raise click.UsageError('Parameter --term-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.change_term_compartment(
        term_id=term_id,
        change_term_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.clone_listing_revision.command_name', 'clone'), help=u"""Clone the published/withdrawn Listing Revision identified by the identifier. \n[Command Reference](cloneListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def clone_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.clone_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.create_artifact.command_name', 'create'), help=u"""Creates a new artifact in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the artifact(although it can be an empty string). It does not have to be unique, and you can change it anytime with [Update]..

You must also specify a *artifactType* for the artifact. Allowed values are CONTAINER_IMAGE and HELM_CHART

You must also provide the container or helm chart registry details for the corresponding images. Oracle container registry details (Registry/Concepts/registryoverview.htm).

After you send your request, the new object's `status` will temporarily be IN_PROGRESS and `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE and the status has changed to \u2018AVAILABLE\u2019 for the new Artifact. \n[Command Reference](createArtifact)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--artifact-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK"]), help=u"""Artifact Type for the artifact.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def create_artifact(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, artifact_type, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['artifactType'] = artifact_type

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_artifact(
        create_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.create_artifact_create_kubernetes_image_artifact_details.command_name', 'create-artifact-create-kubernetes-image-artifact-details'), help=u"""Creates a new artifact in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the artifact(although it can be an empty string). It does not have to be unique, and you can change it anytime with [Update]..

You must also specify a *artifactType* for the artifact. Allowed values are CONTAINER_IMAGE and HELM_CHART

You must also provide the container or helm chart registry details for the corresponding images. Oracle container registry details (Registry/Concepts/registryoverview.htm).

After you send your request, the new object's `status` will temporarily be IN_PROGRESS and `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE and the status has changed to \u2018AVAILABLE\u2019 for the new Artifact. \n[Command Reference](createArtifact)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--helm-chart', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--container-image-artifact-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of container image artifact uniquie identifiers included in the helm chart.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'helm-chart': {'module': 'marketplace_publisher', 'class': 'CreateHelmChartImageDetails'}, 'container-image-artifact-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'helm-chart': {'module': 'marketplace_publisher', 'class': 'CreateHelmChartImageDetails'}, 'container-image-artifact-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def create_artifact_create_kubernetes_image_artifact_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, helm_chart, display_name, freeform_tags, defined_tags, container_image_artifact_ids):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['helmChart'] = cli_util.parse_json_parameter("helm_chart", helm_chart)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if container_image_artifact_ids is not None:
        _details['containerImageArtifactIds'] = cli_util.parse_json_parameter("container_image_artifact_ids", container_image_artifact_ids)

    _details['artifactType'] = 'HELM_CHART'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_artifact(
        create_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.create_artifact_create_stack_artifact_details.command_name', 'create-artifact-create-stack-artifact-details'), help=u"""Creates a new artifact in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the artifact(although it can be an empty string). It does not have to be unique, and you can change it anytime with [Update]..

You must also specify a *artifactType* for the artifact. Allowed values are CONTAINER_IMAGE and HELM_CHART

You must also provide the container or helm chart registry details for the corresponding images. Oracle container registry details (Registry/Concepts/registryoverview.htm).

After you send your request, the new object's `status` will temporarily be IN_PROGRESS and `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE and the status has changed to \u2018AVAILABLE\u2019 for the new Artifact. \n[Command Reference](createArtifact)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--stack', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'stack': {'module': 'marketplace_publisher', 'class': 'CreateStackDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'stack': {'module': 'marketplace_publisher', 'class': 'CreateStackDetails'}})
@cli_util.wrap_exceptions
def create_artifact_create_stack_artifact_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, stack, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['stack'] = cli_util.parse_json_parameter("stack", stack)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['artifactType'] = 'STACK'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_artifact(
        create_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.create_artifact_create_container_image_artifact_details.command_name', 'create-artifact-create-container-image-artifact-details'), help=u"""Creates a new artifact in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the artifact(although it can be an empty string). It does not have to be unique, and you can change it anytime with [Update]..

You must also specify a *artifactType* for the artifact. Allowed values are CONTAINER_IMAGE and HELM_CHART

You must also provide the container or helm chart registry details for the corresponding images. Oracle container registry details (Registry/Concepts/registryoverview.htm).

After you send your request, the new object's `status` will temporarily be IN_PROGRESS and `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE and the status has changed to \u2018AVAILABLE\u2019 for the new Artifact. \n[Command Reference](createArtifact)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--container-image', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'container-image': {'module': 'marketplace_publisher', 'class': 'CreateContainerImageDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'container-image': {'module': 'marketplace_publisher', 'class': 'CreateContainerImageDetails'}})
@cli_util.wrap_exceptions
def create_artifact_create_container_image_artifact_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, container_image, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['containerImage'] = cli_util.parse_json_parameter("container_image", container_image)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['artifactType'] = 'CONTAINER_IMAGE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_artifact(
        create_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.create_artifact_create_machine_image_artifact_details.command_name', 'create-artifact-create-machine-image-artifact-details'), help=u"""Creates a new artifact in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the artifact(although it can be an empty string). It does not have to be unique, and you can change it anytime with [Update]..

You must also specify a *artifactType* for the artifact. Allowed values are CONTAINER_IMAGE and HELM_CHART

You must also provide the container or helm chart registry details for the corresponding images. Oracle container registry details (Registry/Concepts/registryoverview.htm).

After you send your request, the new object's `status` will temporarily be IN_PROGRESS and `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE and the status has changed to \u2018AVAILABLE\u2019 for the new Artifact. \n[Command Reference](createArtifact)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--machine-image', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'machine-image': {'module': 'marketplace_publisher', 'class': 'CreateMachineImageDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'machine-image': {'module': 'marketplace_publisher', 'class': 'CreateMachineImageDetails'}})
@cli_util.wrap_exceptions
def create_artifact_create_machine_image_artifact_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, machine_image, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['machineImage'] = cli_util.parse_json_parameter("machine_image", machine_image)

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['artifactType'] = 'MACHINE_IMAGE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_artifact(
        create_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.create_listing.command_name', 'create'), help=u"""Creates a new listing in your compartment. You must specify your compartment ID in the request object.

You must also specify a *name* for the listing and cannot be updated later.

You must also specify a *packageType* for the listing. Allowed values are CONTAINER_IMAGE and HELM_CHART

After you send your request, the new object's `lifecycleState` will be CREATING. Before using the object, first make sure its `lifecycleState` has changed to ACTIVE. \n[Command Reference](createListing)""")
@cli_util.option('--compartment-id', required=True, help=u"""The unique identifier for the compartment.""")
@cli_util.option('--name', required=True, help=u"""The name for the listing.""")
@cli_util.option('--listing-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]), help=u"""The listing type for the listing.""")
@cli_util.option('--package-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"]), help=u"""The package type for the listing.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'Listing'})
@cli_util.wrap_exceptions
def create_listing(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, name, listing_type, package_type, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['name'] = name
    _details['listingType'] = listing_type
    _details['packageType'] = package_type

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing(
        create_listing_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing') and callable(getattr(client, 'get_listing')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision.command_name', 'create'), help=u"""Creates a new Listing Revision. \n[Command Reference](createListingRevision)""")
@cli_util.option('--listing-id', required=True, help=u"""The unique identifier for the listing this revision belongs to.""")
@cli_util.option('--listing-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]), help=u"""The listing's type. Populated from the listing.""")
@cli_util.option('--headline', required=True, help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated with the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the publisher for the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--status', help=u"""The current status of the Listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def create_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, listing_type, headline, display_name, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, status, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingId'] = listing_id
    _details['listingType'] = listing_type
    _details['headline'] = headline

    if display_name is not None:
        _details['displayName'] = display_name

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if status is not None:
        _details['status'] = status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision(
        create_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_create_oci_listing_revision_details.command_name', 'create-listing-revision-create-oci-listing-revision-details'), help=u"""Creates a new Listing Revision. \n[Command Reference](createListingRevision)""")
@cli_util.option('--listing-id', required=True, help=u"""The unique identifier for the listing this revision belongs to.""")
@cli_util.option('--headline', required=True, help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--pricing-type', required=True, help=u"""The pricing model for the listing revision.""")
@cli_util.option('--products', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Products subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated with the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the publisher for the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--status', help=u"""The current status of the Listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--version-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--system-requirements', help=u"""System requirements for the listing revision.""")
@cli_util.option('--pricing-plans', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Pricing Plans provider by publisher.

This option is a JSON list with items of type PricingPlan.  For documentation on PricingPlan please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/PricingPlan.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--recommended-service-provider-listing-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""OCIDs of service listings attached to lead gen listing""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--availability-and-pricing-policy', help=u"""Listing availability and Pricing Policy statement.""")
@cli_util.option('--is-rover-exportable', type=click.BOOL, help=u"""Is this listing rover exportable""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'pricing-plans': {'module': 'marketplace_publisher', 'class': 'list[PricingPlan]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'pricing-plans': {'module': 'marketplace_publisher', 'class': 'list[PricingPlan]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def create_listing_revision_create_oci_listing_revision_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, headline, pricing_type, products, display_name, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, status, freeform_tags, defined_tags, version_details, system_requirements, pricing_plans, vanity_url, recommended_service_provider_listing_ids, availability_and_pricing_policy, is_rover_exportable):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingId'] = listing_id
    _details['headline'] = headline
    _details['pricingType'] = pricing_type
    _details['products'] = cli_util.parse_json_parameter("products", products)

    if display_name is not None:
        _details['displayName'] = display_name

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if status is not None:
        _details['status'] = status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if version_details is not None:
        _details['versionDetails'] = cli_util.parse_json_parameter("version_details", version_details)

    if system_requirements is not None:
        _details['systemRequirements'] = system_requirements

    if pricing_plans is not None:
        _details['pricingPlans'] = cli_util.parse_json_parameter("pricing_plans", pricing_plans)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if recommended_service_provider_listing_ids is not None:
        _details['recommendedServiceProviderListingIds'] = cli_util.parse_json_parameter("recommended_service_provider_listing_ids", recommended_service_provider_listing_ids)

    if availability_and_pricing_policy is not None:
        _details['availabilityAndPricingPolicy'] = availability_and_pricing_policy

    if is_rover_exportable is not None:
        _details['isRoverExportable'] = is_rover_exportable

    _details['listingType'] = 'OCI_APPLICATION'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision(
        create_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_create_service_listing_revision_details.command_name', 'create-listing-revision-create-service-listing-revision-details'), help=u"""Creates a new Listing Revision. \n[Command Reference](createListingRevision)""")
@cli_util.option('--listing-id', required=True, help=u"""The unique identifier for the listing this revision belongs to.""")
@cli_util.option('--headline', required=True, help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--product-codes', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of product codes subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--industries', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of industries subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated with the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the publisher for the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--status', help=u"""The current status of the Listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--contact-us', help=u"""Custom text by partner regarding contact information""")
@cli_util.option('--trained-professionals', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Number of trained professional per product

This option is a JSON list with items of type TrainedProfessionals.  For documentation on TrainedProfessionals please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/TrainedProfessionals.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--geo-locations', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Support details based on geographic location

This option is a JSON list with items of type GeoLocation.  For documentation on GeoLocation please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/GeoLocation.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'industries': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'trained-professionals': {'module': 'marketplace_publisher', 'class': 'list[TrainedProfessionals]'}, 'geo-locations': {'module': 'marketplace_publisher', 'class': 'list[GeoLocation]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'industries': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'trained-professionals': {'module': 'marketplace_publisher', 'class': 'list[TrainedProfessionals]'}, 'geo-locations': {'module': 'marketplace_publisher', 'class': 'list[GeoLocation]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def create_listing_revision_create_service_listing_revision_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, headline, product_codes, industries, display_name, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, status, freeform_tags, defined_tags, contact_us, trained_professionals, vanity_url, geo_locations):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingId'] = listing_id
    _details['headline'] = headline
    _details['productCodes'] = cli_util.parse_json_parameter("product_codes", product_codes)
    _details['industries'] = cli_util.parse_json_parameter("industries", industries)

    if display_name is not None:
        _details['displayName'] = display_name

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if status is not None:
        _details['status'] = status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if contact_us is not None:
        _details['contactUs'] = contact_us

    if trained_professionals is not None:
        _details['trainedProfessionals'] = cli_util.parse_json_parameter("trained_professionals", trained_professionals)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if geo_locations is not None:
        _details['geoLocations'] = cli_util.parse_json_parameter("geo_locations", geo_locations)

    _details['listingType'] = 'SERVICE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision(
        create_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_create_lead_gen_listing_revision_details.command_name', 'create-listing-revision-create-lead-gen-listing-revision-details'), help=u"""Creates a new Listing Revision. \n[Command Reference](createListingRevision)""")
@cli_util.option('--listing-id', required=True, help=u"""The unique identifier for the listing this revision belongs to.""")
@cli_util.option('--headline', required=True, help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--pricing-type', required=True, help=u"""The pricing model for the listing revision.""")
@cli_util.option('--products', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Products subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated with the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the publisher for the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--status', help=u"""The current status of the Listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--version-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--system-requirements', help=u"""System requirements for the listing revision.""")
@cli_util.option('--demo-url', help=u"""Url to demo of the listing""")
@cli_util.option('--self-paced-training-url', help=u"""Url to training resources of the listing""")
@cli_util.option('--recommended-service-provider-listing-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""OCIDs of service listings attached to lead gen listing""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--download-info', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--pricing-plans', help=u"""Pricing details for lead gen listing""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'download-info': {'module': 'marketplace_publisher', 'class': 'DownloadInfo'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'download-info': {'module': 'marketplace_publisher', 'class': 'DownloadInfo'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def create_listing_revision_create_lead_gen_listing_revision_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, headline, pricing_type, products, display_name, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, status, freeform_tags, defined_tags, version_details, system_requirements, demo_url, self_paced_training_url, recommended_service_provider_listing_ids, vanity_url, download_info, pricing_plans):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingId'] = listing_id
    _details['headline'] = headline
    _details['pricingType'] = pricing_type
    _details['products'] = cli_util.parse_json_parameter("products", products)

    if display_name is not None:
        _details['displayName'] = display_name

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if status is not None:
        _details['status'] = status

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if version_details is not None:
        _details['versionDetails'] = cli_util.parse_json_parameter("version_details", version_details)

    if system_requirements is not None:
        _details['systemRequirements'] = system_requirements

    if demo_url is not None:
        _details['demoUrl'] = demo_url

    if self_paced_training_url is not None:
        _details['selfPacedTrainingUrl'] = self_paced_training_url

    if recommended_service_provider_listing_ids is not None:
        _details['recommendedServiceProviderListingIds'] = cli_util.parse_json_parameter("recommended_service_provider_listing_ids", recommended_service_provider_listing_ids)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if download_info is not None:
        _details['downloadInfo'] = cli_util.parse_json_parameter("download_info", download_info)

    if pricing_plans is not None:
        _details['pricingPlans'] = pricing_plans

    _details['listingType'] = 'LEAD_GENERATION'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision(
        create_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment.command_name', 'create'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--attachment-type', required=True, help=u"""The specified attachment type.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, attachment_type, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['attachmentType'] = attachment_type

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_supported_service_attachment.command_name', 'create-listing-revision-attachment-create-supported-service-attachment'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--service-name', required=True, help=u"""Name of the service""")
@cli_util.option('--type', required=True, help=u"""Type of the service""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--url', help=u"""Optional url to service information""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_supported_service_attachment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, service_name, type, display_name, description, freeform_tags, defined_tags, url):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['serviceName'] = service_name
    _details['type'] = type

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if url is not None:
        _details['url'] = url

    _details['attachmentType'] = 'SUPPORTED_SERVICES'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_screen_shot_attachment_details.command_name', 'create-listing-revision-attachment-create-screen-shot-attachment-details'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_screen_shot_attachment_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'SCREENSHOT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_customer_success_attachment.command_name', 'create-listing-revision-attachment-create-customer-success-attachment'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--customer-name', required=True, help=u"""Name of the customer""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--url', help=u"""Optional url to success story""")
@cli_util.option('--product-codes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of product codes for success story""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_customer_success_attachment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, customer_name, display_name, description, freeform_tags, defined_tags, url, product_codes):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['customerName'] = customer_name

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if url is not None:
        _details['url'] = url

    if product_codes is not None:
        _details['productCodes'] = cli_util.parse_json_parameter("product_codes", product_codes)

    _details['attachmentType'] = 'CUSTOMER_SUCCESS'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_review_support_document_attachment.command_name', 'create-listing-revision-attachment-create-review-support-document-attachment'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--document-name', required=True, help=u"""Name of the review support document""")
@cli_util.option('--template-code', required=True, help=u"""Type of review support document""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_review_support_document_attachment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, document_name, template_code, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['documentName'] = document_name
    _details['templateCode'] = template_code

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'REVIEW_SUPPORT_DOCUMENT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_video_attachment_details.command_name', 'create-listing-revision-attachment-create-video-attachment-details'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--video-attachment-details', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'video-attachment-details': {'module': 'marketplace_publisher', 'class': 'CreateVideoDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'video-attachment-details': {'module': 'marketplace_publisher', 'class': 'CreateVideoDetails'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_video_attachment_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, video_attachment_details, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['videoAttachmentDetails'] = cli_util.parse_json_parameter("video_attachment_details", video_attachment_details)

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'VIDEO'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_attachment_create_related_document_attachment_details.command_name', 'create-listing-revision-attachment-create-related-document-attachment-details'), help=u"""Creates a new listing revision attachment. \n[Command Reference](createListingRevisionAttachment)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--document-category', required=True, help=u"""The document category of the listing revision attachment.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""Description for this specified attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def create_listing_revision_attachment_create_related_document_attachment_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, document_category, display_name, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['documentCategory'] = document_category

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'RELATED_DOCUMENT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_attachment(
        create_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_note_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_note.command_name', 'create'), help=u"""Creates a new Listing Revision Note. \n[Command Reference](createListingRevisionNote)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The unique identifier of the listing revision that the specified note belongs to.""")
@cli_util.option('--note-details', required=True, help=u"""Notes provided for the listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionNote'})
@cli_util.wrap_exceptions
def create_listing_revision_note(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, note_details, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['noteDetails'] = note_details

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_note(
        create_listing_revision_note_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_note') and callable(getattr(client, 'get_listing_revision_note')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_note(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.create_listing_revision_package.command_name', 'create'), help=u"""Creates a new Listing Revision Package. \n[Command Reference](createListingRevisionPackage)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""The OCID for the listing revision in Marketplace Publisher.""")
@cli_util.option('--package-version', required=True, help=u"""The version for the package.""")
@cli_util.option('--artifact-id', required=True, help=u"""The unique identifier for the artifact.""")
@cli_util.option('--term-id', required=True, help=u"""The unique identifier for the term.""")
@cli_util.option('--are-security-upgrades-provided', required=True, type=click.BOOL, help=u"""Identifies whether security upgrades will be provided for this package.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision package.""")
@cli_util.option('--description', help=u"""Description for this package.""")
@cli_util.option('--is-default', type=click.BOOL, help=u"""Identifies that this will be default package for the listing revision.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionPackage'})
@cli_util.wrap_exceptions
def create_listing_revision_package(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, package_version, artifact_id, term_id, are_security_upgrades_provided, display_name, description, is_default, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingRevisionId'] = listing_revision_id
    _details['packageVersion'] = package_version
    _details['artifactId'] = artifact_id
    _details['termId'] = term_id
    _details['areSecurityUpgradesProvided'] = are_security_upgrades_provided

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if is_default is not None:
        _details['isDefault'] = is_default

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_listing_revision_package(
        create_listing_revision_package_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_package') and callable(getattr(client, 'get_listing_revision_package')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_package(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_group.command(name=cli_util.override('marketplace_publisher.create_term.command_name', 'create'), help=u"""Creates a new Term. \n[Command Reference](createTerm)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the publisher's compartment.""")
@cli_util.option('--name', required=True, help=u"""The name of the term.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'Term'})
@cli_util.wrap_exceptions
def create_term(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['name'] = name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_term(
        create_term_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term') and callable(getattr(client, 'get_term')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.create_term_version.command_name', 'create'), help=u"""Creates a new Term Version. \n[Command Reference](createTermVersion)""")
@cli_util.option('--create-term-version-content', required=True, help=u"""The term version file to upload.""")
@cli_util.option('--term-id', required=True, help=u"""Unique OCID identifier for the term.""")
@cli_util.option('--display-name', help=u"""The name of the resource.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersion'})
@cli_util.wrap_exceptions
def create_term_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, create_term_version_content, term_id, display_name):

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.create_term_version(
        create_term_version_content=create_term_version_content,
        term_id=term_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term_version') and callable(getattr(client, 'get_term_version')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term_version(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.delete_artifact.command_name', 'delete'), help=u"""Deletes the specified artifact. \n[Command Reference](deleteArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_artifact(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_artifact(
        artifact_id=artifact_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.delete_listing.command_name', 'delete'), help=u"""Deletes a listing by the identifier \n[Command Reference](deleteListing)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_listing(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, if_match):

    if isinstance(listing_id, six.string_types) and len(listing_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_listing(
        listing_id=listing_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing') and callable(getattr(client, 'get_listing')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_listing(listing_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.delete_listing_revision.command_name', 'delete'), help=u"""Deletes a listing by the identifier \n[Command Reference](deleteListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_listing_revision(listing_revision_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.delete_listing_revision_attachment.command_name', 'delete'), help=u"""Deletes a listing revision attachment by the identifier \n[Command Reference](deleteListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_listing_revision_attachment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_listing_revision_attachment(listing_revision_attachment_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_note_group.command(name=cli_util.override('marketplace_publisher.delete_listing_revision_note.command_name', 'delete'), help=u"""Deletes a listing revision note by the identifier. \n[Command Reference](deleteListingRevisionNote)""")
@cli_util.option('--listing-revision-note-id', required=True, help=u"""Unique listing revision note identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_listing_revision_note(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_note_id, if_match):

    if isinstance(listing_revision_note_id, six.string_types) and len(listing_revision_note_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-note-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_listing_revision_note(
        listing_revision_note_id=listing_revision_note_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_note') and callable(getattr(client, 'get_listing_revision_note')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_listing_revision_note(listing_revision_note_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.delete_listing_revision_package.command_name', 'delete'), help=u"""Deletes a listing revision package by the identifier \n[Command Reference](deleteListingRevisionPackage)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_listing_revision_package(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_package_id, if_match):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_listing_revision_package(
        listing_revision_package_id=listing_revision_package_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_package') and callable(getattr(client, 'get_listing_revision_package')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_listing_revision_package(listing_revision_package_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_group.command(name=cli_util.override('marketplace_publisher.delete_term.command_name', 'delete'), help=u"""Deletes a Term by the identifier \n[Command Reference](deleteTerm)""")
@cli_util.option('--term-id', required=True, help=u"""term OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_term(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, term_id, if_match):

    if isinstance(term_id, six.string_types) and len(term_id.strip()) == 0:
        raise click.UsageError('Parameter --term-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_term(
        term_id=term_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term') and callable(getattr(client, 'get_term')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_term(term_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.delete_term_version.command_name', 'delete'), help=u"""Deletes a Term by the identifier \n[Command Reference](deleteTermVersion)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_term_version(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, term_version_id, if_match):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.delete_term_version(
        term_version_id=term_version_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term_version') and callable(getattr(client, 'get_term_version')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_term_version(term_version_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.get_artifact.command_name', 'get'), help=u"""Gets the specified artifact's information. \n[Command Reference](getArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Artifact'})
@cli_util.wrap_exceptions
def get_artifact(ctx, from_json, artifact_id):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_artifact(
        artifact_id=artifact_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@category_group.command(name=cli_util.override('marketplace_publisher.get_category.command_name', 'get'), help=u"""Gets the specified category's information. \n[Command Reference](getCategory)""")
@cli_util.option('--category-code', required=True, help=u"""Category Code""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Category'})
@cli_util.wrap_exceptions
def get_category(ctx, from_json, category_code, compartment_id):

    if isinstance(category_code, six.string_types) and len(category_code.strip()) == 0:
        raise click.UsageError('Parameter --category-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_category(
        category_code=category_code,
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@lead_group.command(name=cli_util.override('marketplace_publisher.get_lead.command_name', 'get'), help=u"""Gets the details for a lead. \n[Command Reference](getLead)""")
@cli_util.option('--lead-id', required=True, help=u"""Lead ID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Lead'})
@cli_util.wrap_exceptions
def get_lead(ctx, from_json, lead_id):

    if isinstance(lead_id, six.string_types) and len(lead_id.strip()) == 0:
        raise click.UsageError('Parameter --lead-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_lead(
        lead_id=lead_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.get_listing.command_name', 'get'), help=u"""Gets the details for a listing. \n[Command Reference](getListing)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Listing'})
@cli_util.wrap_exceptions
def get_listing(ctx, from_json, listing_id):

    if isinstance(listing_id, six.string_types) and len(listing_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing(
        listing_id=listing_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision.command_name', 'get'), help=u"""Gets the details for a listing revision. \n[Command Reference](getListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def get_listing_revision(ctx, from_json, listing_revision_id):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision_attachment.command_name', 'get'), help=u"""Get the details of the specified listing revision attachment. \n[Command Reference](getListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def get_listing_revision_attachment(ctx, from_json, listing_revision_attachment_id):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision_attachment_content.command_name', 'get-listing-revision-attachment-content'), help=u"""Get the attachment content by identifier. \n[Command Reference](getListingRevisionAttachmentContent)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_listing_revision_attachment_content(ctx, from_json, file, listing_revision_attachment_id):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision_attachment_content(
        listing_revision_attachment_id=listing_revision_attachment_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision_icon_content.command_name', 'get-listing-revision-icon-content'), help=u"""Gets the content for a listing revision icon. \n[Command Reference](getListingRevisionIconContent)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_listing_revision_icon_content(ctx, from_json, file, listing_revision_id):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision_icon_content(
        listing_revision_id=listing_revision_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@listing_revision_note_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision_note.command_name', 'get'), help=u"""Get note details by the identifier \n[Command Reference](getListingRevisionNote)""")
@cli_util.option('--listing-revision-note-id', required=True, help=u"""Unique listing revision note identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionNote'})
@cli_util.wrap_exceptions
def get_listing_revision_note(ctx, from_json, listing_revision_note_id):

    if isinstance(listing_revision_note_id, six.string_types) and len(listing_revision_note_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-note-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision_note(
        listing_revision_note_id=listing_revision_note_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.get_listing_revision_package.command_name', 'get'), help=u"""Get the details of the specified version of a package. \n[Command Reference](getListingRevisionPackage)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionPackage'})
@cli_util.wrap_exceptions
def get_listing_revision_package(ctx, from_json, listing_revision_package_id):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_listing_revision_package(
        listing_revision_package_id=listing_revision_package_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@market_group.command(name=cli_util.override('marketplace_publisher.get_market.command_name', 'get'), help=u"""Gets the specified market's information. \n[Command Reference](getMarket)""")
@cli_util.option('--market-code', required=True, help=u"""Market Code""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Market'})
@cli_util.wrap_exceptions
def get_market(ctx, from_json, market_code):

    if isinstance(market_code, six.string_types) and len(market_code.strip()) == 0:
        raise click.UsageError('Parameter --market-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_market(
        market_code=market_code,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@product_group.command(name=cli_util.override('marketplace_publisher.get_product.command_name', 'get'), help=u"""Gets a Product by code identifier \n[Command Reference](getProduct)""")
@cli_util.option('--product-code', required=True, help=u"""Product Code""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Product'})
@cli_util.wrap_exceptions
def get_product(ctx, from_json, product_code):

    if isinstance(product_code, six.string_types) and len(product_code.strip()) == 0:
        raise click.UsageError('Parameter --product-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_product(
        product_code=product_code,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@publisher_group.command(name=cli_util.override('marketplace_publisher.get_publisher.command_name', 'get'), help=u"""Gets a Publisher by identifier \n[Command Reference](getPublisher)""")
@cli_util.option('--publisher-id', required=True, help=u"""Publisher OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Publisher'})
@cli_util.wrap_exceptions
def get_publisher(ctx, from_json, publisher_id):

    if isinstance(publisher_id, six.string_types) and len(publisher_id.strip()) == 0:
        raise click.UsageError('Parameter --publisher-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_publisher(
        publisher_id=publisher_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@support_doc_group.command(name=cli_util.override('marketplace_publisher.get_support_doc.command_name', 'get'), help=u"""Gets a SupportDoc by code identifier \n[Command Reference](getSupportDoc)""")
@cli_util.option('--support-doc-code', required=True, help=u"""SupportDoc Code""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'SupportDoc'})
@cli_util.wrap_exceptions
def get_support_doc(ctx, from_json, support_doc_code):

    if isinstance(support_doc_code, six.string_types) and len(support_doc_code.strip()) == 0:
        raise click.UsageError('Parameter --support-doc-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_support_doc(
        support_doc_code=support_doc_code,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@support_doc_group.command(name=cli_util.override('marketplace_publisher.get_support_doc_content.command_name', 'get-support-doc-content'), help=u"""Gets a Support Doc content by supportDocCode \n[Command Reference](getSupportDocContent)""")
@cli_util.option('--support-doc-code', required=True, help=u"""SupportDoc Code""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_support_doc_content(ctx, from_json, file, support_doc_code):

    if isinstance(support_doc_code, six.string_types) and len(support_doc_code.strip()) == 0:
        raise click.UsageError('Parameter --support-doc-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_support_doc_content(
        support_doc_code=support_doc_code,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@term_group.command(name=cli_util.override('marketplace_publisher.get_term.command_name', 'get'), help=u"""Gets a Term by identifier \n[Command Reference](getTerm)""")
@cli_util.option('--term-id', required=True, help=u"""term OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'Term'})
@cli_util.wrap_exceptions
def get_term(ctx, from_json, term_id):

    if isinstance(term_id, six.string_types) and len(term_id.strip()) == 0:
        raise click.UsageError('Parameter --term-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_term(
        term_id=term_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.get_term_version.command_name', 'get'), help=u"""Gets a Term Version by the identifier \n[Command Reference](getTermVersion)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersion'})
@cli_util.wrap_exceptions
def get_term_version(ctx, from_json, term_version_id):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_term_version(
        term_version_id=term_version_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.get_term_version_content.command_name', 'get-term-version-content'), help=u"""Gets a Term Version content by the identifier. \n[Command Reference](getTermVersionContent)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def get_term_version_content(ctx, from_json, file, term_version_id):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_term_version_content(
        term_version_id=term_version_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@work_request_group.command(name=cli_util.override('marketplace_publisher.get_work_request.command_name', 'get'), help=u"""Gets details of the work request with the given ID. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@artifact_collection_group.command(name=cli_util.override('marketplace_publisher.list_artifacts.command_name', 'list-artifacts'), help=u"""Lists the artifacts in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listArtifacts)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only artifacts with their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["IN_PROGRESS", "AVAILABLE", "UNAVAILABLE"]), help=u"""A filter to return only artifacts with specific status.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ArtifactCollection'})
@cli_util.wrap_exceptions
def list_artifacts(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, display_name, status, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if display_name is not None:
        kwargs['display_name'] = display_name
    if status is not None:
        kwargs['status'] = status
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_artifacts,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_artifacts,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_artifacts(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@available_service_collection_group.command(name=cli_util.override('marketplace_publisher.list_available_services.command_name', 'list-available-services'), help=u"""List all published service listing revisions \n[Command Reference](listAvailableServices)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'AvailableServiceCollection'})
@cli_util.wrap_exceptions
def list_available_services(ctx, from_json, all_pages, page_size, compartment_id, name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if name is not None:
        kwargs['name'] = name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_available_services,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_available_services,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_available_services(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@category_collection_group.command(name=cli_util.override('marketplace_publisher.list_categories.command_name', 'list-categories'), help=u"""Lists the categories in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listCategories)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--product-code', help=u"""product code to filter""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'CategoryCollection'})
@cli_util.wrap_exceptions
def list_categories(ctx, from_json, all_pages, page_size, compartment_id, limit, page, product_code, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if product_code is not None:
        kwargs['product_code'] = product_code
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_categories,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_categories,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_categories(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@customer_instance_report_record_collection_group.command(name=cli_util.override('marketplace_publisher.list_customer_instance_report_records.command_name', 'list-customer-instance-report-records'), help=u"""List customer instance report records \n[Command Reference](listCustomerInstanceReportRecords)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--date-range', required=True, type=custom_types.CliCaseInsensitiveChoice(["THIS_WEEK", "LAST_WEEK", "THIS_MONTH", "LAST_MONTH", "LAST_THREE_MONTHS"]), help=u"""The date range of the report""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'CustomerInstanceReportRecordCollection'})
@cli_util.wrap_exceptions
def list_customer_instance_report_records(ctx, from_json, all_pages, page_size, compartment_id, date_range, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_customer_instance_report_records,
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_customer_instance_report_records,
            limit,
            page_size,
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    else:
        result = client.list_customer_instance_report_records(
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@disbursement_report_record_collection_group.command(name=cli_util.override('marketplace_publisher.list_disbursement_report_records.command_name', 'list-disbursement-report-records'), help=u"""List disbursement report records \n[Command Reference](listDisbursementReportRecords)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--date-range', required=True, type=custom_types.CliCaseInsensitiveChoice(["LAST_MONTH", "LAST_THREE_MONTHS"]), help=u"""The date range of the report""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'DisbursementReportRecordCollection'})
@cli_util.wrap_exceptions
def list_disbursement_report_records(ctx, from_json, all_pages, page_size, compartment_id, date_range, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_disbursement_report_records,
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_disbursement_report_records,
            limit,
            page_size,
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    else:
        result = client.list_disbursement_report_records(
            compartment_id=compartment_id,
            date_range=date_range,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@lead_collection_group.command(name=cli_util.override('marketplace_publisher.list_leads.command_name', 'list-leads'), help=u"""Lists the leads in your compartment that belong to a listing. You must specify your listing's OCID as the value for the listing ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listLeads)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list leads.""")
@cli_util.option('--listing-id', help=u"""Listing OCID to query resource against.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'LeadCollection'})
@cli_util.wrap_exceptions
def list_leads(ctx, from_json, all_pages, page_size, compartment_id, listing_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if listing_id is not None:
        kwargs['listing_id'] = listing_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_leads,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_leads,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_leads(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_revision_attachment_collection_group.command(name=cli_util.override('marketplace_publisher.list_listing_revision_attachments.command_name', 'list-listing-revision-attachments'), help=u"""Gets the list of attachments for a listing revision in a compartment \n[Command Reference](listListingRevisionAttachments)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""OCID of the listing revision.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), help=u"""A filter to return only attachments their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachmentCollection'})
@cli_util.wrap_exceptions
def list_listing_revision_attachments(ctx, from_json, all_pages, page_size, listing_revision_id, display_name, lifecycle_state, compartment_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_listing_revision_attachments,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_listing_revision_attachments,
            limit,
            page_size,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    else:
        result = client.list_listing_revision_attachments(
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_revision_note_collection_group.command(name=cli_util.override('marketplace_publisher.list_listing_revision_notes.command_name', 'list-listing-revision-notes'), help=u"""Gets the list of notes for a listing revision. \n[Command Reference](listListingRevisionNotes)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""OCID of the listing revision.""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionNoteCollection'})
@cli_util.wrap_exceptions
def list_listing_revision_notes(ctx, from_json, all_pages, page_size, listing_revision_id, compartment_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_listing_revision_notes,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_listing_revision_notes,
            limit,
            page_size,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    else:
        result = client.list_listing_revision_notes(
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_revision_package_collection_group.command(name=cli_util.override('marketplace_publisher.list_listing_revision_packages.command_name', 'list-listing-revision-packages'), help=u"""Gets the list of packages for a listing revision. \n[Command Reference](listListingRevisionPackages)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""OCID of the listing revision.""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only packages their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionPackageCollection'})
@cli_util.wrap_exceptions
def list_listing_revision_packages(ctx, from_json, all_pages, page_size, listing_revision_id, compartment_id, display_name, lifecycle_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_listing_revision_packages,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_listing_revision_packages,
            limit,
            page_size,
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    else:
        result = client.list_listing_revision_packages(
            listing_revision_id=listing_revision_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_revision_collection_group.command(name=cli_util.override('marketplace_publisher.list_listing_revisions.command_name', 'list-listing-revisions'), help=u"""Lists the list of listing revisions for a specific listing ID, compartment ID or listing revision status.

You can specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listListingRevisions)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only listing revisions their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--listing-revision-status', type=custom_types.CliCaseInsensitiveChoice(["NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED"]), help=u"""A filter to return only listing revisions their status matches the given listing revision status.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionCollection'})
@cli_util.wrap_exceptions
def list_listing_revisions(ctx, from_json, all_pages, page_size, listing_id, display_name, lifecycle_state, compartment_id, listing_revision_status, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if listing_revision_status is not None:
        kwargs['listing_revision_status'] = listing_revision_status
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_listing_revisions,
            listing_id=listing_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_listing_revisions,
            limit,
            page_size,
            listing_id=listing_id,
            **kwargs
        )
    else:
        result = client.list_listing_revisions(
            listing_id=listing_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_collection_group.command(name=cli_util.override('marketplace_publisher.list_listings.command_name', 'list-listings'), help=u"""Lists the listings in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listListings)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only listings their lifecycleState matches the given lifecycleState.""")
@cli_util.option('--listing-type', type=custom_types.CliCaseInsensitiveChoice(["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]), help=u"""A filter to return listings based on their type""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingCollection'})
@cli_util.wrap_exceptions
def list_listings(ctx, from_json, all_pages, page_size, compartment_id, lifecycle_state, listing_type, name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if listing_type is not None:
        kwargs['listing_type'] = listing_type
    if name is not None:
        kwargs['name'] = name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_listings,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_listings,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_listings(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@market_collection_group.command(name=cli_util.override('marketplace_publisher.list_markets.command_name', 'list-markets'), help=u"""Lists the markets in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listMarkets)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--listing-id', help=u"""Listing OCID to query resource against.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'MarketCollection'})
@cli_util.wrap_exceptions
def list_markets(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, name, listing_id):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    if listing_id is not None:
        kwargs['listing_id'] = listing_id
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_markets,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_markets,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_markets(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@product_collection_group.command(name=cli_util.override('marketplace_publisher.list_products.command_name', 'list-products'), help=u"""Lists the products in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listProducts)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--product-group', help=u"""Product Group""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ProductCollection'})
@cli_util.wrap_exceptions
def list_products(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, product_group, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if product_group is not None:
        kwargs['product_group'] = product_group
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_products,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_products,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_products(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@publisher_collection_group.command(name=cli_util.override('marketplace_publisher.list_publishers.command_name', 'list-publishers'), help=u"""Returns a list of publishers. \n[Command Reference](listPublishers)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'PublisherCollection'})
@cli_util.wrap_exceptions
def list_publishers(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_publishers,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_publishers,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_publishers(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@support_doc_collection_group.command(name=cli_util.override('marketplace_publisher.list_support_docs.command_name', 'list-support-docs'), help=u"""Lists the supportDocs in your compartment. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listSupportDocs)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--support-doc-group', help=u"""SupportDoc Group""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'SupportDocCollection'})
@cli_util.wrap_exceptions
def list_support_docs(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, support_doc_group, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if support_doc_group is not None:
        kwargs['support_doc_group'] = support_doc_group
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_support_docs,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_support_docs,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_support_docs(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@supported_currency_collection_group.command(name=cli_util.override('marketplace_publisher.list_supported_currencies.command_name', 'list-supported-currencies'), help=u"""Lists the currencies supported by the Marketplace Publisher Service. You must specify your compartment's OCID as the value for the compartment ID. For information about OCIDs, see Resource Identifiers (Content/General/Concepts/identifiers.htm). \n[Command Reference](listSupportedCurrencies)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'SupportedCurrencyCollection'})
@cli_util.wrap_exceptions
def list_supported_currencies(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_supported_currencies,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_supported_currencies,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_supported_currencies(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@supported_shape_collection_group.command(name=cli_util.override('marketplace_publisher.list_supported_shapes.command_name', 'list-supported-shapes'), help=u"""Lists the shapes available to select from. \n[Command Reference](listSupportedShapes)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'SupportedShapeCollection'})
@cli_util.wrap_exceptions
def list_supported_shapes(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_supported_shapes,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_supported_shapes,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_supported_shapes(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@term_version_collection_group.command(name=cli_util.override('marketplace_publisher.list_term_versions.command_name', 'list-term-versions'), help=u"""Returns a list of the publisher term versions. \n[Command Reference](listTermVersions)""")
@cli_util.option('--term-id', required=True, help=u"""term OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersionCollection'})
@cli_util.wrap_exceptions
def list_term_versions(ctx, from_json, all_pages, page_size, term_id, compartment_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_term_versions,
            term_id=term_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_term_versions,
            limit,
            page_size,
            term_id=term_id,
            **kwargs
        )
    else:
        result = client.list_term_versions(
            term_id=term_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@term_collection_group.command(name=cli_util.override('marketplace_publisher.list_terms.command_name', 'list-terms'), help=u"""Returns a list of the publisher terms. \n[Command Reference](listTerms)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--name', help=u"""A filter to return only resources that match the entire name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermCollection'})
@cli_util.wrap_exceptions
def list_terms(ctx, from_json, all_pages, page_size, compartment_id, limit, page, sort_order, sort_by, name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_terms,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_terms,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_terms(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('marketplace_publisher.list_work_request_errors.command_name', 'list'), help=u"""Returns a (paginated) list of errors for the work request with the given ID. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('marketplace_publisher.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Returns a (paginated) list of logs for the work request with the given ID. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timestamp"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timestamp is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('marketplace_publisher.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--work-request-id', help=u"""The ID of the asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), help=u"""A filter to return only resources their lifecycleState matches the given OperationStatus.""")
@cli_util.option('--resource-id', help=u"""The ID of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, work_request_id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if work_request_id is not None:
        kwargs['work_request_id'] = work_request_id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.mark_listing_revision_package_as_default.command_name', 'mark-listing-revision-package-as-default'), help=u"""Mark the Listing Revision Package identified by the id and package version as default \n[Command Reference](markListingRevisionPackageAsDefault)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def mark_listing_revision_package_as_default(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_package_id, if_match):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.mark_listing_revision_package_as_default(
        listing_revision_package_id=listing_revision_package_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.publish_listing_revision.command_name', 'publish'), help=u"""Publish the Listing revision identified by Identifier. \n[Command Reference](publishListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def publish_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.publish_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.publish_listing_revision_as_private.command_name', 'publish-listing-revision-as-private'), help=u"""Updates the Listing Revision to PublishAsPrivate \n[Command Reference](publishListingRevisionAsPrivate)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--allowed-tenancies', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Allowed tenancies provided when a listing is published as private.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'allowed-tenancies': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'allowed-tenancies': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def publish_listing_revision_as_private(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, allowed_tenancies, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if allowed_tenancies is not None:
        _details['allowedTenancies'] = cli_util.parse_json_parameter("allowed_tenancies", allowed_tenancies)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.publish_listing_revision_as_private(
        listing_revision_id=listing_revision_id,
        publish_listing_revision_as_private_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.publish_listing_revision_package.command_name', 'publish'), help=u"""Updates the Listing Revision Package to publish status \n[Command Reference](publishListingRevisionPackage)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def publish_listing_revision_package(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_package_id, if_match):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.publish_listing_revision_package(
        listing_revision_package_id=listing_revision_package_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.submit_listing_revision_for_review.command_name', 'submit-listing-revision-for-review'), help=u"""Update the Listing Revision identified by the id for review \n[Command Reference](submitListingRevisionForReview)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--note-details', help=u"""Notes provided for the listing revision.""")
@cli_util.option('--are-internal-tenancy-launch-allowed', type=click.BOOL, help=u"""Identifies whether publisher allows internal tenancy launches for the listing revision.""")
@cli_util.option('--should-auto-publish-on-approval', type=click.BOOL, help=u"""Identifies whether publisher intends to publish the listing automatically upon approval.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def submit_listing_revision_for_review(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, note_details, are_internal_tenancy_launch_allowed, should_auto_publish_on_approval, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if note_details is not None:
        _details['noteDetails'] = note_details

    if are_internal_tenancy_launch_allowed is not None:
        _details['areInternalTenancyLaunchAllowed'] = are_internal_tenancy_launch_allowed

    if should_auto_publish_on_approval is not None:
        _details['shouldAutoPublishOnApproval'] = should_auto_publish_on_approval

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.submit_listing_revision_for_review(
        listing_revision_id=listing_revision_id,
        submit_listing_revision_for_review_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.un_publish_listing_revision_package.command_name', 'un-publish'), help=u"""Updates the Listing Revision Package to Unpublish status \n[Command Reference](unPublishListingRevisionPackage)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def un_publish_listing_revision_package(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_package_id, if_match):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.un_publish_listing_revision_package(
        listing_revision_package_id=listing_revision_package_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.update_artifact.command_name', 'update'), help=u"""Updates the specified artifact identified by the id. \n[Command Reference](updateArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--artifact-type', type=custom_types.CliCaseInsensitiveChoice(["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK"]), help=u"""Artifact Type for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_artifact(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, display_name, artifact_type, freeform_tags, defined_tags, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if artifact_type is not None:
        _details['artifactType'] = artifact_type

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_artifact(
        artifact_id=artifact_id,
        update_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.update_artifact_update_kubernetes_image_artifact_details.command_name', 'update-artifact-update-kubernetes-image-artifact-details'), help=u"""Updates the specified artifact identified by the id. \n[Command Reference](updateArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--helm-chart', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--container-image-artifact-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of container image artifact unique identifiers included in the helm chart.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'helm-chart': {'module': 'marketplace_publisher', 'class': 'UpdateHelmChartImageDetails'}, 'container-image-artifact-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'helm-chart': {'module': 'marketplace_publisher', 'class': 'UpdateHelmChartImageDetails'}, 'container-image-artifact-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def update_artifact_update_kubernetes_image_artifact_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, display_name, freeform_tags, defined_tags, helm_chart, container_image_artifact_ids, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or helm_chart or container_image_artifact_ids:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and helm-chart and container-image-artifact-ids will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if helm_chart is not None:
        _details['helmChart'] = cli_util.parse_json_parameter("helm_chart", helm_chart)

    if container_image_artifact_ids is not None:
        _details['containerImageArtifactIds'] = cli_util.parse_json_parameter("container_image_artifact_ids", container_image_artifact_ids)

    _details['artifactType'] = 'HELM_CHART'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_artifact(
        artifact_id=artifact_id,
        update_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.update_artifact_update_stack_artifact_details.command_name', 'update-artifact-update-stack-artifact-details'), help=u"""Updates the specified artifact identified by the id. \n[Command Reference](updateArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--stack', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'stack': {'module': 'marketplace_publisher', 'class': 'UpdateStackDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'stack': {'module': 'marketplace_publisher', 'class': 'UpdateStackDetails'}})
@cli_util.wrap_exceptions
def update_artifact_update_stack_artifact_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, display_name, freeform_tags, defined_tags, stack, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or stack:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and stack will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if stack is not None:
        _details['stack'] = cli_util.parse_json_parameter("stack", stack)

    _details['artifactType'] = 'STACK'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_artifact(
        artifact_id=artifact_id,
        update_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.update_artifact_update_container_image_artifact_details.command_name', 'update-artifact-update-container-image-artifact-details'), help=u"""Updates the specified artifact identified by the id. \n[Command Reference](updateArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--container-image', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'container-image': {'module': 'marketplace_publisher', 'class': 'UpdateContainerImageDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'container-image': {'module': 'marketplace_publisher', 'class': 'UpdateContainerImageDetails'}})
@cli_util.wrap_exceptions
def update_artifact_update_container_image_artifact_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, display_name, freeform_tags, defined_tags, container_image, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or container_image:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and container-image will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if container_image is not None:
        _details['containerImage'] = cli_util.parse_json_parameter("container_image", container_image)

    _details['artifactType'] = 'CONTAINER_IMAGE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_artifact(
        artifact_id=artifact_id,
        update_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.update_artifact_update_machine_image_artifact_details.command_name', 'update-artifact-update-machine-image-artifact-details'), help=u"""Updates the specified artifact identified by the id. \n[Command Reference](updateArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--compartment-id', help=u"""The unique identifier for the compartment.""")
@cli_util.option('--display-name', help=u"""The display name for the artifact.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--machine-image', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'machine-image': {'module': 'marketplace_publisher', 'class': 'UpdateMachineImageDetails'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'machine-image': {'module': 'marketplace_publisher', 'class': 'UpdateMachineImageDetails'}})
@cli_util.wrap_exceptions
def update_artifact_update_machine_image_artifact_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, compartment_id, display_name, freeform_tags, defined_tags, machine_image, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or machine_image:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and machine-image will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if machine_image is not None:
        _details['machineImage'] = cli_util.parse_json_parameter("machine_image", machine_image)

    _details['artifactType'] = 'MACHINE_IMAGE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_artifact(
        artifact_id=artifact_id,
        update_artifact_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_group.command(name=cli_util.override('marketplace_publisher.update_listing.command_name', 'update'), help=u"""Updates the specified Listing identified by the id. \n[Command Reference](updateListing)""")
@cli_util.option('--listing-id', required=True, help=u"""listing OCID""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'Listing'})
@cli_util.wrap_exceptions
def update_listing(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_id, freeform_tags, defined_tags, if_match):

    if isinstance(listing_id, six.string_types) and len(listing_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing(
        listing_id=listing_id,
        update_listing_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing') and callable(getattr(client, 'get_listing')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision.command_name', 'update'), help=u"""Updates the Listing Revision \n[Command Reference](updateListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--listing-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]), help=u"""The listing's type. Populated from the listing.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--headline', help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated for the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def update_listing_revision(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, listing_type, display_name, headline, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')
    if not force:
        if content_language or supportedlanguages or support_contacts or support_links or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to content-language and supportedlanguages and support-contacts and support-links and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['listingType'] = listing_type

    if display_name is not None:
        _details['displayName'] = display_name

    if headline is not None:
        _details['headline'] = headline

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision(
        listing_revision_id=listing_revision_id,
        update_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_update_service_listing_revision_details.command_name', 'update-listing-revision-update-service-listing-revision-details'), help=u"""Updates the Listing Revision \n[Command Reference](updateListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--headline', help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated for the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--contact-us', help=u"""Custom text by partner regarding contact information""")
@cli_util.option('--product-codes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of product codes subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--industries', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of industries subscribed by listing.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--trained-professionals', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Number of trained professional per product

This option is a JSON list with items of type TrainedProfessionals.  For documentation on TrainedProfessionals please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/TrainedProfessionals.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--geo-locations', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Support details based on geographic location

This option is a JSON list with items of type GeoLocation.  For documentation on GeoLocation please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/GeoLocation.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'industries': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'trained-professionals': {'module': 'marketplace_publisher', 'class': 'list[TrainedProfessionals]'}, 'geo-locations': {'module': 'marketplace_publisher', 'class': 'list[GeoLocation]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'industries': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'trained-professionals': {'module': 'marketplace_publisher', 'class': 'list[TrainedProfessionals]'}, 'geo-locations': {'module': 'marketplace_publisher', 'class': 'list[GeoLocation]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def update_listing_revision_update_service_listing_revision_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, display_name, headline, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, freeform_tags, defined_tags, contact_us, product_codes, industries, trained_professionals, vanity_url, geo_locations, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')
    if not force:
        if content_language or supportedlanguages or support_contacts or support_links or freeform_tags or defined_tags or product_codes or industries or trained_professionals or geo_locations:
            if not click.confirm("WARNING: Updates to content-language and supportedlanguages and support-contacts and support-links and freeform-tags and defined-tags and product-codes and industries and trained-professionals and geo-locations will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if headline is not None:
        _details['headline'] = headline

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if contact_us is not None:
        _details['contactUs'] = contact_us

    if product_codes is not None:
        _details['productCodes'] = cli_util.parse_json_parameter("product_codes", product_codes)

    if industries is not None:
        _details['industries'] = cli_util.parse_json_parameter("industries", industries)

    if trained_professionals is not None:
        _details['trainedProfessionals'] = cli_util.parse_json_parameter("trained_professionals", trained_professionals)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if geo_locations is not None:
        _details['geoLocations'] = cli_util.parse_json_parameter("geo_locations", geo_locations)

    _details['listingType'] = 'SERVICE'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision(
        listing_revision_id=listing_revision_id,
        update_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_update_oci_listing_revision_details.command_name', 'update-listing-revision-update-oci-listing-revision-details'), help=u"""Updates the Listing Revision \n[Command Reference](updateListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--headline', help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated for the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--version-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--system-requirements', help=u"""System requirements for the listing revision.""")
@cli_util.option('--pricing-type', help=u"""The pricing model for the listing revision.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Products subscribed by listing.

This option is a JSON list with items of type ListingProduct.  For documentation on ListingProduct please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/ListingProduct.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--recommended-service-provider-listing-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""OCIDs of service listings attached to lead gen listing""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--availability-and-pricing-policy', help=u"""Listing availability and Pricing Policy statement.""")
@cli_util.option('--pricing-plans', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Pricing Plans provider by publisher.

This option is a JSON list with items of type PricingPlan.  For documentation on PricingPlan please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/PricingPlan.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-rover-exportable', type=click.BOOL, help=u"""Is this listing rover exportable""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'pricing-plans': {'module': 'marketplace_publisher', 'class': 'list[PricingPlan]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'pricing-plans': {'module': 'marketplace_publisher', 'class': 'list[PricingPlan]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def update_listing_revision_update_oci_listing_revision_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, display_name, headline, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, freeform_tags, defined_tags, version_details, system_requirements, pricing_type, products, vanity_url, recommended_service_provider_listing_ids, availability_and_pricing_policy, pricing_plans, is_rover_exportable, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')
    if not force:
        if content_language or supportedlanguages or support_contacts or support_links or freeform_tags or defined_tags or version_details or products or recommended_service_provider_listing_ids or pricing_plans:
            if not click.confirm("WARNING: Updates to content-language and supportedlanguages and support-contacts and support-links and freeform-tags and defined-tags and version-details and products and recommended-service-provider-listing-ids and pricing-plans will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if headline is not None:
        _details['headline'] = headline

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if version_details is not None:
        _details['versionDetails'] = cli_util.parse_json_parameter("version_details", version_details)

    if system_requirements is not None:
        _details['systemRequirements'] = system_requirements

    if pricing_type is not None:
        _details['pricingType'] = pricing_type

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if recommended_service_provider_listing_ids is not None:
        _details['recommendedServiceProviderListingIds'] = cli_util.parse_json_parameter("recommended_service_provider_listing_ids", recommended_service_provider_listing_ids)

    if availability_and_pricing_policy is not None:
        _details['availabilityAndPricingPolicy'] = availability_and_pricing_policy

    if pricing_plans is not None:
        _details['pricingPlans'] = cli_util.parse_json_parameter("pricing_plans", pricing_plans)

    if is_rover_exportable is not None:
        _details['isRoverExportable'] = is_rover_exportable

    _details['listingType'] = 'OCI_APPLICATION'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision(
        listing_revision_id=listing_revision_id,
        update_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_update_lead_gen_listing_revision_details.command_name', 'update-listing-revision-update-lead-gen-listing-revision-details'), help=u"""Updates the Listing Revision \n[Command Reference](updateListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--display-name', help=u"""The name for the listing revision.""")
@cli_util.option('--headline', help=u"""Single line introduction for the listing revision.""")
@cli_util.option('--tagline', help=u"""The tagline for the listing revision.""")
@cli_util.option('--keywords', help=u"""Keywords associated for the listing revision.""")
@cli_util.option('--short-description', help=u"""A short description for the listing revision.""")
@cli_util.option('--usage-information', help=u"""Usage information for the listing revision.""")
@cli_util.option('--long-description', help=u"""A long description for the listing revision.""")
@cli_util.option('--content-language', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--supportedlanguages', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Languages supported by the listing revision.

This option is a JSON list with items of type LanguageItem.  For documentation on LanguageItem please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/LanguageItem.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-contacts', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Contact information to use to get support from the publisher for the listing revision.

This option is a JSON list with items of type SupportContact.  For documentation on SupportContact please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/SupportContact.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--support-links', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Links to support resources for the listing revision.

This option is a JSON list with items of type NamedLink.  For documentation on NamedLink please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/NamedLink.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--version-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--system-requirements', help=u"""System requirements for the listing revision.""")
@cli_util.option('--pricing-type', help=u"""The pricing model for the listing revision.""")
@cli_util.option('--products', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of Products subscribed by listing.

This option is a JSON list with items of type ListingProduct.  For documentation on ListingProduct please see our API reference: https://docs.cloud.oracle.com/api/#/en/marketplacepublisher/20241201/datatypes/ListingProduct.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--demo-url', help=u"""Url to demo of the listing""")
@cli_util.option('--self-paced-training-url', help=u"""Url to training resources of the listing""")
@cli_util.option('--recommended-service-provider-listing-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""OCIDs of service listings attached to lead gen listing""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vanity-url', help=u"""Custom link to the listing""")
@cli_util.option('--download-info', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--pricing-plans', help=u"""Pricing details for lead gen listing""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'download-info': {'module': 'marketplace_publisher', 'class': 'DownloadInfo'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'content-language': {'module': 'marketplace_publisher', 'class': 'LanguageItem'}, 'supportedlanguages': {'module': 'marketplace_publisher', 'class': 'list[LanguageItem]'}, 'support-contacts': {'module': 'marketplace_publisher', 'class': 'list[SupportContact]'}, 'support-links': {'module': 'marketplace_publisher', 'class': 'list[NamedLink]'}, 'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'version-details': {'module': 'marketplace_publisher', 'class': 'VersionDetails'}, 'products': {'module': 'marketplace_publisher', 'class': 'list[ListingProduct]'}, 'recommended-service-provider-listing-ids': {'module': 'marketplace_publisher', 'class': 'list[string]'}, 'download-info': {'module': 'marketplace_publisher', 'class': 'DownloadInfo'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def update_listing_revision_update_lead_gen_listing_revision_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, display_name, headline, tagline, keywords, short_description, usage_information, long_description, content_language, supportedlanguages, support_contacts, support_links, freeform_tags, defined_tags, version_details, system_requirements, pricing_type, products, demo_url, self_paced_training_url, recommended_service_provider_listing_ids, vanity_url, download_info, pricing_plans, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')
    if not force:
        if content_language or supportedlanguages or support_contacts or support_links or freeform_tags or defined_tags or version_details or products or recommended_service_provider_listing_ids or download_info:
            if not click.confirm("WARNING: Updates to content-language and supportedlanguages and support-contacts and support-links and freeform-tags and defined-tags and version-details and products and recommended-service-provider-listing-ids and download-info will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if headline is not None:
        _details['headline'] = headline

    if tagline is not None:
        _details['tagline'] = tagline

    if keywords is not None:
        _details['keywords'] = keywords

    if short_description is not None:
        _details['shortDescription'] = short_description

    if usage_information is not None:
        _details['usageInformation'] = usage_information

    if long_description is not None:
        _details['longDescription'] = long_description

    if content_language is not None:
        _details['contentLanguage'] = cli_util.parse_json_parameter("content_language", content_language)

    if supportedlanguages is not None:
        _details['supportedlanguages'] = cli_util.parse_json_parameter("supportedlanguages", supportedlanguages)

    if support_contacts is not None:
        _details['supportContacts'] = cli_util.parse_json_parameter("support_contacts", support_contacts)

    if support_links is not None:
        _details['supportLinks'] = cli_util.parse_json_parameter("support_links", support_links)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if version_details is not None:
        _details['versionDetails'] = cli_util.parse_json_parameter("version_details", version_details)

    if system_requirements is not None:
        _details['systemRequirements'] = system_requirements

    if pricing_type is not None:
        _details['pricingType'] = pricing_type

    if products is not None:
        _details['products'] = cli_util.parse_json_parameter("products", products)

    if demo_url is not None:
        _details['demoUrl'] = demo_url

    if self_paced_training_url is not None:
        _details['selfPacedTrainingUrl'] = self_paced_training_url

    if recommended_service_provider_listing_ids is not None:
        _details['recommendedServiceProviderListingIds'] = cli_util.parse_json_parameter("recommended_service_provider_listing_ids", recommended_service_provider_listing_ids)

    if vanity_url is not None:
        _details['vanityUrl'] = vanity_url

    if download_info is not None:
        _details['downloadInfo'] = cli_util.parse_json_parameter("download_info", download_info)

    if pricing_plans is not None:
        _details['pricingPlans'] = pricing_plans

    _details['listingType'] = 'LEAD_GENERATION'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision(
        listing_revision_id=listing_revision_id,
        update_listing_revision_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment.command_name', 'update'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--attachment-type', help=u"""The specified attachment type for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, display_name, description, attachment_type, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if attachment_type is not None:
        _details['attachmentType'] = attachment_type

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_screen_shot_attachment_details.command_name', 'update-listing-revision-attachment-update-screen-shot-attachment-details'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_screen_shot_attachment_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, display_name, description, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'SCREENSHOT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_customer_success_attachment.command_name', 'update-listing-revision-attachment-update-customer-success-attachment'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--customer-name', required=True, help=u"""Name of the customer""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--url', help=u"""Optional url to success story""")
@cli_util.option('--product-codes', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of product codes for success story""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}, 'product-codes': {'module': 'marketplace_publisher', 'class': 'list[string]'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_customer_success_attachment(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, customer_name, display_name, description, freeform_tags, defined_tags, url, product_codes, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or product_codes:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and product-codes will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['customerName'] = customer_name

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if url is not None:
        _details['url'] = url

    if product_codes is not None:
        _details['productCodes'] = cli_util.parse_json_parameter("product_codes", product_codes)

    _details['attachmentType'] = 'CUSTOMER_SUCCESS'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_review_support_document_attachment.command_name', 'update-listing-revision-attachment-update-review-support-document-attachment'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--document-name', required=True, help=u"""Name of the review support document""")
@cli_util.option('--template-code', required=True, help=u"""Type of review support document""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_review_support_document_attachment(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, document_name, template_code, display_name, description, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['documentName'] = document_name
    _details['templateCode'] = template_code

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'REVIEW_SUPPORT_DOCUMENT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_related_document_attachment_details.command_name', 'update-listing-revision-attachment-update-related-document-attachment-details'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--document-category', help=u"""The document category of the listing revision attachment.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_related_document_attachment_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, display_name, description, freeform_tags, defined_tags, document_category, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if document_category is not None:
        _details['documentCategory'] = document_category

    _details['attachmentType'] = 'RELATED_DOCUMENT'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_supported_service_attachment.command_name', 'update-listing-revision-attachment-update-supported-service-attachment'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--service-name', required=True, help=u"""Name of the service""")
@cli_util.option('--type', required=True, help=u"""Type of service""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--url', help=u"""Optional url to service information""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_supported_service_attachment(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, service_name, type, display_name, description, freeform_tags, defined_tags, url, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['serviceName'] = service_name
    _details['type'] = type

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if url is not None:
        _details['url'] = url

    _details['attachmentType'] = 'SUPPORTED_SERVICES'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_update_video_attachment_details.command_name', 'update-listing-revision-attachment-update-video-attachment-details'), help=u"""Updates the Listing Revision Attachment \n[Command Reference](updateListingRevisionAttachment)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--display-name', help=u"""The name for the listing revision attachment.""")
@cli_util.option('--description', help=u"""The description for the listing revision attachment.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_update_video_attachment_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, display_name, description, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['attachmentType'] = 'VIDEO'

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_attachment_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_attachment_content.command_name', 'update-listing-revision-attachment-content'), help=u"""Update a file to listing revision attachment \n[Command Reference](updateListingRevisionAttachmentContent)""")
@cli_util.option('--listing-revision-attachment-id', required=True, help=u"""attachment OCID""")
@cli_util.option('--update-listing-revision-attachment-content', required=True, help=u"""The attachment to upload.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionAttachment'})
@cli_util.wrap_exceptions
def update_listing_revision_attachment_content(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_attachment_id, update_listing_revision_attachment_content, if_match):

    if isinstance(listing_revision_attachment_id, six.string_types) and len(listing_revision_attachment_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-attachment-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_attachment_content(
        listing_revision_attachment_id=listing_revision_attachment_id,
        update_listing_revision_attachment_content=update_listing_revision_attachment_content,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_attachment') and callable(getattr(client, 'get_listing_revision_attachment')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_attachment(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_icon_content.command_name', 'update-listing-revision-icon-content'), help=u"""Updates the Listing Revision \n[Command Reference](updateListingRevisionIconContent)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--update-listing-revision-icon-content', required=True, help=u"""The listing revision icon to be updated.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevision'})
@cli_util.wrap_exceptions
def update_listing_revision_icon_content(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, update_listing_revision_icon_content, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_icon_content(
        listing_revision_id=listing_revision_id,
        update_listing_revision_icon_content=update_listing_revision_icon_content,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision') and callable(getattr(client, 'get_listing_revision')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_note_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_note.command_name', 'update'), help=u"""Updates the Listing Revision Note tag data \n[Command Reference](updateListingRevisionNote)""")
@cli_util.option('--listing-revision-note-id', required=True, help=u"""Unique listing revision note identifier.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "DELETED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionNote'})
@cli_util.wrap_exceptions
def update_listing_revision_note(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_note_id, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_note_id, six.string_types) and len(listing_revision_note_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-note-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_note(
        listing_revision_note_id=listing_revision_note_id,
        update_listing_revision_note_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_note') and callable(getattr(client, 'get_listing_revision_note')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_note(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_package_group.command(name=cli_util.override('marketplace_publisher.update_listing_revision_package.command_name', 'update'), help=u"""Updates the Listing Revision Package. \n[Command Reference](updateListingRevisionPackage)""")
@cli_util.option('--listing-revision-package-id', required=True, help=u"""Unique listing revision package identifier.""")
@cli_util.option('--package-version', help=u"""The version for the package.""")
@cli_util.option('--display-name', help=u"""The name for the listing revision package.""")
@cli_util.option('--description', help=u"""The description for this package.""")
@cli_util.option('--artifact-id', help=u"""The unique identifier for the artifact.""")
@cli_util.option('--term-id', help=u"""The unique term identifier.""")
@cli_util.option('--is-default', type=click.BOOL, help=u"""Identifies that this will be default package for the listing revision.""")
@cli_util.option('--are-security-upgrades-provided', type=click.BOOL, help=u"""Identifies whether security upgrades will be provided for this package.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'ListingRevisionPackage'})
@cli_util.wrap_exceptions
def update_listing_revision_package(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_package_id, package_version, display_name, description, artifact_id, term_id, is_default, are_security_upgrades_provided, freeform_tags, defined_tags, if_match):

    if isinstance(listing_revision_package_id, six.string_types) and len(listing_revision_package_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-package-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if package_version is not None:
        _details['packageVersion'] = package_version

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if artifact_id is not None:
        _details['artifactId'] = artifact_id

    if term_id is not None:
        _details['termId'] = term_id

    if is_default is not None:
        _details['isDefault'] = is_default

    if are_security_upgrades_provided is not None:
        _details['areSecurityUpgradesProvided'] = are_security_upgrades_provided

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_listing_revision_package(
        listing_revision_package_id=listing_revision_package_id,
        update_listing_revision_package_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_listing_revision_package') and callable(getattr(client, 'get_listing_revision_package')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_listing_revision_package(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_group.command(name=cli_util.override('marketplace_publisher.update_term.command_name', 'update'), help=u"""Updates the Term \n[Command Reference](updateTerm)""")
@cli_util.option('--term-id', required=True, help=u"""term OCID""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'Term'})
@cli_util.wrap_exceptions
def update_term(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, term_id, freeform_tags, defined_tags, if_match):

    if isinstance(term_id, six.string_types) and len(term_id.strip()) == 0:
        raise click.UsageError('Parameter --term-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_term(
        term_id=term_id,
        update_term_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term') and callable(getattr(client, 'get_term')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.update_term_version.command_name', 'update'), help=u"""Updates the Term Version \n[Command Reference](updateTermVersion)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@cli_util.option('--display-name', help=u"""The name for the term version.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{\"bar-key\": \"value\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'marketplace_publisher', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersion'})
@cli_util.wrap_exceptions
def update_term_version(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, term_version_id, display_name, freeform_tags, defined_tags, if_match):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_term_version(
        term_version_id=term_version_id,
        update_term_version_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term_version') and callable(getattr(client, 'get_term_version')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term_version(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@term_version_group.command(name=cli_util.override('marketplace_publisher.update_term_version_content.command_name', 'update-term-version-content'), help=u"""Updates the Term Version attachment \n[Command Reference](updateTermVersionContent)""")
@cli_util.option('--term-version-id', required=True, help=u"""term version OCID""")
@cli_util.option('--update-term-version-content', required=True, help=u"""The term attachment to upload.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--display-name', help=u"""The name of the resource.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACTIVE", "INACTIVE"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'marketplace_publisher', 'class': 'TermVersion'})
@cli_util.wrap_exceptions
def update_term_version_content(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, term_version_id, update_term_version_content, if_match, display_name):

    if isinstance(term_version_id, six.string_types) and len(term_version_id.strip()) == 0:
        raise click.UsageError('Parameter --term-version-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.update_term_version_content(
        term_version_id=term_version_id,
        update_term_version_content=update_term_version_content,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_term_version') and callable(getattr(client, 'get_term_version')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_term_version(result.data.id), 'lifecycle_state', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@artifact_group.command(name=cli_util.override('marketplace_publisher.validate_and_publish_artifact.command_name', 'validate-and-publish'), help=u"""Validate and publish artifact. \n[Command Reference](validateAndPublishArtifact)""")
@cli_util.option('--artifact-id', required=True, help=u"""artifact OCID""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def validate_and_publish_artifact(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, artifact_id, if_match):

    if isinstance(artifact_id, six.string_types) and len(artifact_id.strip()) == 0:
        raise click.UsageError('Parameter --artifact-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.validate_and_publish_artifact(
        artifact_id=artifact_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@listing_revision_group.command(name=cli_util.override('marketplace_publisher.withdraw_listing_revision.command_name', 'withdraw'), help=u"""Update the Listing Revision identified by the id as Withdraw/UnPublished. \n[Command Reference](withdrawListingRevision)""")
@cli_util.option('--listing-revision-id', required=True, help=u"""listing revision""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def withdraw_listing_revision(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, listing_revision_id, if_match):

    if isinstance(listing_revision_id, six.string_types) and len(listing_revision_id.strip()) == 0:
        raise click.UsageError('Parameter --listing-revision-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('marketplace_publisher', 'marketplace_publisher', ctx)
    result = client.withdraw_listing_revision(
        listing_revision_id=listing_revision_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
