function GetOciTopLevelCommand_iot() {
    return 'iot'
}

function GetOciSubcommands_iot() {
    $ociSubcommands = @{
        'iot' = 'digital-twin-adapter digital-twin-instance digital-twin-model digital-twin-relationship domain domain-group work-request'
        'iot digital-twin-adapter' = 'create delete get list update'
        'iot digital-twin-instance' = 'create delete get get-content invoke-raw-binary-command invoke-raw-json-command invoke-raw-text-command list update'
        'iot digital-twin-model' = 'create delete get get-spec list update'
        'iot digital-twin-relationship' = 'create delete get list update'
        'iot domain' = 'change-compartment change-data-retention-period configure-apex-data-access configure-direct-data-access configure-ords-data-access create delete get list update'
        'iot domain-group' = 'change-compartment configure-data-access create delete get list update'
        'iot work-request' = 'get list list-errors list-logs'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_iot() {
    $ociCommandsToLongParams = @{
        'iot digital-twin-adapter create' = 'defined-tags description digital-twin-model-id digital-twin-model-spec-uri display-name freeform-tags from-json help inbound-envelope inbound-routes iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-adapter delete' = 'digital-twin-adapter-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-adapter get' = 'digital-twin-adapter-id from-json help'
        'iot digital-twin-adapter list' = 'all digital-twin-model-id digital-twin-model-spec-uri display-name from-json help id iot-domain-id lifecycle-state limit page page-size sort-by sort-order'
        'iot digital-twin-adapter update' = 'defined-tags description digital-twin-adapter-id display-name force freeform-tags from-json help if-match inbound-envelope inbound-routes max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-instance create' = 'auth-id defined-tags description digital-twin-adapter-id digital-twin-model-id digital-twin-model-spec-uri display-name external-key freeform-tags from-json help iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-instance delete' = 'digital-twin-instance-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-instance get' = 'digital-twin-instance-id from-json help'
        'iot digital-twin-instance get-content' = 'digital-twin-instance-id from-json help should-include-metadata'
        'iot digital-twin-instance invoke-raw-binary-command' = 'digital-twin-instance-id from-json help request-data request-data-content-type request-duration request-endpoint response-duration response-endpoint'
        'iot digital-twin-instance invoke-raw-json-command' = 'digital-twin-instance-id from-json help request-data request-data-content-type request-duration request-endpoint response-duration response-endpoint'
        'iot digital-twin-instance invoke-raw-text-command' = 'digital-twin-instance-id from-json help request-data request-data-content-type request-duration request-endpoint response-duration response-endpoint'
        'iot digital-twin-instance list' = 'all digital-twin-model-id digital-twin-model-spec-uri display-name from-json help id iot-domain-id lifecycle-state limit page page-size sort-by sort-order'
        'iot digital-twin-instance update' = 'auth-id defined-tags description digital-twin-adapter-id digital-twin-instance-id display-name external-key force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-model create' = 'defined-tags description display-name freeform-tags from-json help iot-domain-id max-wait-seconds spec wait-for-state wait-interval-seconds'
        'iot digital-twin-model delete' = 'digital-twin-model-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-model get' = 'digital-twin-model-id from-json help'
        'iot digital-twin-model get-spec' = 'digital-twin-model-id from-json help'
        'iot digital-twin-model list' = 'all display-name from-json help id iot-domain-id lifecycle-state limit page page-size sort-by sort-order spec-uri-starts-with'
        'iot digital-twin-model update' = 'defined-tags description digital-twin-model-id display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-relationship create' = 'content content-path defined-tags description display-name freeform-tags from-json help iot-domain-id max-wait-seconds source-digital-twin-instance-id target-digital-twin-instance-id wait-for-state wait-interval-seconds'
        'iot digital-twin-relationship delete' = 'digital-twin-relationship-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot digital-twin-relationship get' = 'digital-twin-relationship-id from-json help'
        'iot digital-twin-relationship list' = 'all content-path display-name from-json help id iot-domain-id lifecycle-state limit page page-size sort-by sort-order source-digital-twin-instance-id target-digital-twin-instance-id'
        'iot digital-twin-relationship update' = 'content defined-tags description digital-twin-relationship-id display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain change-compartment' = 'compartment-id from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain change-data-retention-period' = 'data-retention-period-in-days from-json help if-match iot-domain-id max-wait-seconds type wait-for-state wait-interval-seconds'
        'iot domain configure-apex-data-access' = 'db-workspace-admin-initial-password from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain configure-direct-data-access' = 'db-allow-listed-identity-group-names from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain configure-ords-data-access' = 'db-allowed-identity-domain-host from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain create' = 'compartment-id defined-tags description display-name freeform-tags from-json help iot-domain-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain delete' = 'force from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain get' = 'from-json help iot-domain-id'
        'iot domain list' = 'all compartment-id display-name from-json help id iot-domain-group-id lifecycle-state limit page page-size sort-by sort-order'
        'iot domain update' = 'defined-tags description display-name force freeform-tags from-json help if-match iot-domain-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain-group change-compartment' = 'compartment-id from-json help if-match iot-domain-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain-group configure-data-access' = 'db-allow-listed-vcn-ids from-json help if-match iot-domain-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain-group create' = 'compartment-id defined-tags description display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain-group delete' = 'force from-json help if-match iot-domain-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot domain-group get' = 'from-json help iot-domain-group-id'
        'iot domain-group list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'iot domain-group update' = 'defined-tags description display-name force freeform-tags from-json help if-match iot-domain-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'iot work-request get' = 'from-json help work-request-id'
        'iot work-request list' = 'all compartment-id from-json help id limit page page-size resource-id sort-by sort-order status'
        'iot work-request list-errors' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'iot work-request list-logs' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_iot() {
    $ociCommandsToShortParams = @{
        'iot digital-twin-adapter create' = '? h'
        'iot digital-twin-adapter delete' = '? h'
        'iot digital-twin-adapter get' = '? h'
        'iot digital-twin-adapter list' = '? h'
        'iot digital-twin-adapter update' = '? h'
        'iot digital-twin-instance create' = '? h'
        'iot digital-twin-instance delete' = '? h'
        'iot digital-twin-instance get' = '? h'
        'iot digital-twin-instance get-content' = '? h'
        'iot digital-twin-instance invoke-raw-binary-command' = '? h'
        'iot digital-twin-instance invoke-raw-json-command' = '? h'
        'iot digital-twin-instance invoke-raw-text-command' = '? h'
        'iot digital-twin-instance list' = '? h'
        'iot digital-twin-instance update' = '? h'
        'iot digital-twin-model create' = '? h'
        'iot digital-twin-model delete' = '? h'
        'iot digital-twin-model get' = '? h'
        'iot digital-twin-model get-spec' = '? h'
        'iot digital-twin-model list' = '? h'
        'iot digital-twin-model update' = '? h'
        'iot digital-twin-relationship create' = '? h'
        'iot digital-twin-relationship delete' = '? h'
        'iot digital-twin-relationship get' = '? h'
        'iot digital-twin-relationship list' = '? h'
        'iot digital-twin-relationship update' = '? h'
        'iot domain change-compartment' = '? c h'
        'iot domain change-data-retention-period' = '? h'
        'iot domain configure-apex-data-access' = '? h'
        'iot domain configure-direct-data-access' = '? h'
        'iot domain configure-ords-data-access' = '? h'
        'iot domain create' = '? c h'
        'iot domain delete' = '? h'
        'iot domain get' = '? h'
        'iot domain list' = '? c h'
        'iot domain update' = '? h'
        'iot domain-group change-compartment' = '? c h'
        'iot domain-group configure-data-access' = '? h'
        'iot domain-group create' = '? c h'
        'iot domain-group delete' = '? h'
        'iot domain-group get' = '? h'
        'iot domain-group list' = '? c h'
        'iot domain-group update' = '? h'
        'iot work-request get' = '? h'
        'iot work-request list' = '? c h'
        'iot work-request list-errors' = '? h'
        'iot work-request list-logs' = '? h'
    }
    return $ociCommandsToShortParams
}