"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientInstanceAttachment = exports.ClientInstanceAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const eais_generated_1 = require("./eais.generated");
Object.defineProperty(exports, "ClientInstanceAttachmentProperty", { enumerable: true, get: function () { return eais_generated_1.RosClientInstanceAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::EAIS::ClientInstanceAttachment`, which is used to attach an Elastic Accelerated Computing Instances (EAIS) instance to an Elastic Compute Service (ECS) instance or elastic container instance of a user.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosClientInstanceAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-eais-clientinstanceattachment
 */
class ClientInstanceAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosClientInstanceAttachment = new eais_generated_1.RosClientInstanceAttachment(this, id, {
            instanceId: props.instanceId,
            clientInstanceId: props.clientInstanceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosClientInstanceAttachment;
        this.attrClientInstanceId = rosClientInstanceAttachment.attrClientInstanceId;
        this.attrInstanceId = rosClientInstanceAttachment.attrInstanceId;
        this.attrVSwitchId = rosClientInstanceAttachment.attrVSwitchId;
    }
}
exports.ClientInstanceAttachment = ClientInstanceAttachment;
//# sourceMappingURL=data:application/json;base64,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