"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientInstanceAttachment = exports.ClientInstanceAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const eais_generated_1 = require("./eais.generated");
Object.defineProperty(exports, "ClientInstanceAttachmentProperty", { enumerable: true, get: function () { return eais_generated_1.RosClientInstanceAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::EAIS::ClientInstanceAttachment`, which is used to query the information about an Elastic Accelerated Computing Instances (EAIS) instance attached to an Elastic Compute Service (ECS) instance or elastic container instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosClientInstanceAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-eais-clientinstanceattachment
 */
class ClientInstanceAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosClientInstanceAttachment = new eais_generated_1.RosClientInstanceAttachment(this, id, {
            clientInstanceAttachmentId: props.clientInstanceAttachmentId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosClientInstanceAttachment;
        this.attrClientInstanceId = rosClientInstanceAttachment.attrClientInstanceId;
        this.attrInstanceId = rosClientInstanceAttachment.attrInstanceId;
        this.attrSecurityGroupId = rosClientInstanceAttachment.attrSecurityGroupId;
        this.attrVSwitchId = rosClientInstanceAttachment.attrVSwitchId;
    }
}
exports.ClientInstanceAttachment = ClientInstanceAttachment;
//# sourceMappingURL=data:application/json;base64,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