"""Finger metadata for QuantumTouch HRM helpers."""

from __future__ import annotations

from dataclasses import dataclass
from typing import Dict, Tuple


@dataclass(frozen=True)
class FingerMeta:
    hand: str  # "L" or "R"
    name: str  # "Pinky", "Ring", ...
    layer: str
    tap_key: str
    tapping_term_ms: int
    quick_tap_ms: int
    require_prior_idle_ms: int
    hold_trigger_positions: Tuple[int, ...]


FINGERS: Tuple[FingerMeta, ...] = (
    FingerMeta(
        hand="L",
        name="Pinky",
        layer="LeftPinky",
        tap_key="A",
        tapping_term_ms=280,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            57,
            56,
            55,
            72,
            73,
            74,
            5,
            6,
            7,
            8,
            16,
            17,
            18,
            19,
            20,
            28,
            29,
            30,
            31,
            32,
            40,
            41,
            42,
            43,
            44,
            58,
            59,
            60,
            61,
            62,
            75,
            76,
            77,
            78,
            9,
            21,
            33,
            45,
            63,
            79,
            52,
            53,
            54,
            70,
            71,
            69,
        ),
    ),
    FingerMeta(
        hand="L",
        name="Ring",
        layer="LeftRing",
        tap_key="S",
        tapping_term_ms=240,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            57,
            56,
            55,
            72,
            73,
            74,
            5,
            6,
            7,
            8,
            16,
            17,
            18,
            19,
            20,
            28,
            29,
            30,
            31,
            32,
            40,
            41,
            42,
            43,
            44,
            58,
            59,
            60,
            61,
            62,
            75,
            76,
            77,
            78,
            9,
            21,
            33,
            45,
            63,
            79,
            52,
            53,
            54,
            70,
            71,
            69,
        ),
    ),
    FingerMeta(
        hand="L",
        name="Middle",
        layer="LeftMiddle",
        tap_key="D",
        tapping_term_ms=210,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            57,
            56,
            55,
            72,
            73,
            74,
            5,
            6,
            7,
            8,
            16,
            17,
            18,
            19,
            20,
            28,
            29,
            30,
            31,
            32,
            40,
            41,
            42,
            43,
            44,
            58,
            59,
            60,
            61,
            62,
            75,
            76,
            77,
            78,
            9,
            21,
            33,
            45,
            63,
            79,
            52,
            53,
            54,
            70,
            71,
            69,
        ),
    ),
    FingerMeta(
        hand="L",
        name="Index",
        layer="LeftIndex",
        tap_key="F",
        tapping_term_ms=190,
        quick_tap_ms=300,
        require_prior_idle_ms=100,
        hold_trigger_positions=(
            57,
            56,
            55,
            72,
            73,
            74,
            5,
            6,
            7,
            8,
            16,
            17,
            18,
            19,
            20,
            28,
            29,
            30,
            31,
            32,
            40,
            41,
            42,
            43,
            44,
            58,
            59,
            60,
            61,
            62,
            75,
            76,
            77,
            78,
            9,
            21,
            33,
            45,
            63,
            79,
            52,
            53,
            54,
            70,
            71,
            69,
        ),
    ),
    FingerMeta(
        hand="R",
        name="Index",
        layer="RightIndex",
        tap_key="J",
        tapping_term_ms=190,
        quick_tap_ms=300,
        require_prior_idle_ms=100,
        hold_trigger_positions=(
            0,
            10,
            22,
            34,
            46,
            64,
            65,
            47,
            35,
            23,
            1,
            2,
            12,
            11,
            24,
            36,
            48,
            66,
            67,
            49,
            37,
            25,
            13,
            3,
            4,
            14,
            15,
            27,
            26,
            38,
            39,
            51,
            50,
            68,
            52,
            53,
            54,
            71,
            70,
            69,
            55,
            56,
            57,
            74,
            73,
            72,
        ),
    ),
    FingerMeta(
        hand="R",
        name="Middle",
        layer="RightMiddle",
        tap_key="K",
        tapping_term_ms=210,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            0,
            10,
            22,
            34,
            46,
            64,
            65,
            47,
            35,
            23,
            1,
            2,
            12,
            11,
            24,
            36,
            48,
            66,
            67,
            49,
            37,
            25,
            13,
            3,
            4,
            14,
            15,
            27,
            26,
            38,
            39,
            51,
            50,
            68,
            52,
            53,
            54,
            71,
            70,
            69,
            55,
            56,
            57,
            74,
            73,
            72,
        ),
    ),
    FingerMeta(
        hand="R",
        name="Ring",
        layer="RightRing",
        tap_key="L",
        tapping_term_ms=240,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            0,
            10,
            22,
            34,
            46,
            64,
            65,
            47,
            35,
            23,
            1,
            2,
            12,
            11,
            24,
            36,
            48,
            66,
            67,
            49,
            37,
            25,
            13,
            3,
            4,
            14,
            15,
            27,
            26,
            38,
            39,
            51,
            50,
            68,
            52,
            53,
            54,
            71,
            70,
            69,
            55,
            56,
            57,
            74,
            73,
            72,
        ),
    ),
    FingerMeta(
        hand="R",
        name="Pinky",
        layer="RightPinky",
        tap_key="SEMI",
        tapping_term_ms=280,
        quick_tap_ms=300,
        require_prior_idle_ms=150,
        hold_trigger_positions=(
            0,
            10,
            22,
            34,
            46,
            64,
            65,
            47,
            35,
            23,
            1,
            2,
            12,
            11,
            24,
            36,
            48,
            66,
            67,
            49,
            37,
            25,
            13,
            3,
            4,
            14,
            15,
            27,
            26,
            38,
            39,
            51,
            50,
            68,
            52,
            53,
            54,
            71,
            70,
            69,
            55,
            56,
            57,
            74,
            73,
            72,
        ),
    ),
)


FINGER_BY_LABEL: Dict[str, FingerMeta] = {
    ("Left" if meta.hand == "L" else "Right") + meta.name: meta for meta in FINGERS
}


__all__ = ["FingerMeta", "FINGERS", "FINGER_BY_LABEL"]
