# wds-client
This page lists current APIs.

All v0.2 APIs are subject to change without notice.

Changelog at [https://github.com/DataBiosphere/terra-workspace-data-service/releases](https://github.com/DataBiosphere/terra-workspace-data-service/releases)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.2
- Package version: 0.38.19
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import wds_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wds_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import wds_client
from wds_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = wds_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with wds_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = wds_client.CapabilitiesApi(api_client)

    try:
        # Describes the capabilities of this WDS version.
        api_response = api_instance.capabilities()
        print("The response of CapabilitiesApi->capabilities:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CapabilitiesApi->capabilities: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CapabilitiesApi* | [**capabilities**](docs/CapabilitiesApi.md#capabilities) | **GET** /capabilities/v1 | Describes the capabilities of this WDS version.
*CollectionApi* | [**create_collection_v1**](docs/CollectionApi.md#create_collection_v1) | **POST** /collections/v1/{workspaceId} | Create a collection in this workspace.
*CollectionApi* | [**delete_collection_v1**](docs/CollectionApi.md#delete_collection_v1) | **DELETE** /collections/v1/{workspaceId}/{collectionId} | Delete the specified collection.
*CollectionApi* | [**get_collection_v1**](docs/CollectionApi.md#get_collection_v1) | **GET** /collections/v1/{workspaceId}/{collectionId} | Retrieve a single collection.
*CollectionApi* | [**list_collections_v1**](docs/CollectionApi.md#list_collections_v1) | **GET** /collections/v1/{workspaceId} | List all collections in this workspace.
*CollectionApi* | [**update_collection_v1**](docs/CollectionApi.md#update_collection_v1) | **PUT** /collections/v1/{workspaceId}/{collectionId} | Update the specified collection.
*GeneralWDSInformationApi* | [**status_get**](docs/GeneralWDSInformationApi.md#status_get) | **GET** /status | Gets health status for WDS -- generated via Spring Boot Actuator (see https://docs.spring.io/spring-boot/docs/current/actuator-api/htmlsingle/#health for details)
*GeneralWDSInformationApi* | [**version_get**](docs/GeneralWDSInformationApi.md#version_get) | **GET** /version | Gets related git and build version info for WDS -- generated via Spring Boot Actuator (see https://docs.spring.io/spring-boot/docs/current/actuator-api/htmlsingle/#info for details)
*ImportApi* | [**import_v1**](docs/ImportApi.md#import_v1) | **POST** /{instanceUuid}/import/v1 | Import from a file
*JobApi* | [**job_status_v1**](docs/JobApi.md#job_status_v1) | **GET** /job/v1/{jobId} | Get status of a long-running job.
*JobApi* | [**jobs_in_instance_v1**](docs/JobApi.md#jobs_in_instance_v1) | **GET** /job/v1/instance/{instanceUuid} | Get all jobs with a certain status under a particular instance.
*RecordApi* | [**delete_records**](docs/RecordApi.md#delete_records) | **POST** /records/v1/{collectionId}/{recordType}/delete | Bulk delete records
*RecordsApi* | [**batch_write_records**](docs/RecordsApi.md#batch_write_records) | **POST** /{instanceid}/batch/{v}/{type} | Batch write records
*RecordsApi* | [**create_or_replace_record**](docs/RecordsApi.md#create_or_replace_record) | **PUT** /{instanceid}/records/{v}/{type}/{id} | Create or replace record
*RecordsApi* | [**delete_record**](docs/RecordsApi.md#delete_record) | **DELETE** /{instanceid}/records/{v}/{type}/{id} | Delete record
*RecordsApi* | [**get_record**](docs/RecordsApi.md#get_record) | **GET** /{instanceid}/records/{v}/{type}/{id} | Get record
*RecordsApi* | [**get_records_as_tsv**](docs/RecordsApi.md#get_records_as_tsv) | **GET** /{instanceid}/tsv/{v}/{type} | Retrieve all records in record type as tsv.
*RecordsApi* | [**query_records**](docs/RecordsApi.md#query_records) | **POST** /{instanceid}/search/{v}/{type} | Query records
*RecordsApi* | [**update_record**](docs/RecordsApi.md#update_record) | **PATCH** /{instanceid}/records/{v}/{type}/{id} | Update record
*RecordsApi* | [**upload_tsv**](docs/RecordsApi.md#upload_tsv) | **POST** /{instanceid}/tsv/{v}/{type} | Import records to a record type from a tsv file
*SchemaApi* | [**delete_attribute**](docs/SchemaApi.md#delete_attribute) | **DELETE** /{instanceid}/types/{v}/{type}/{attribute} | Delete attribute from record type
*SchemaApi* | [**delete_record_type**](docs/SchemaApi.md#delete_record_type) | **DELETE** /{instanceid}/types/{v}/{type} | Delete record type
*SchemaApi* | [**describe_all_record_types**](docs/SchemaApi.md#describe_all_record_types) | **GET** /{instanceid}/types/{v} | Describe all record types
*SchemaApi* | [**describe_record_type**](docs/SchemaApi.md#describe_record_type) | **GET** /{instanceid}/types/{v}/{type} | Describe record type
*SchemaApi* | [**update_attribute**](docs/SchemaApi.md#update_attribute) | **PATCH** /{instanceid}/types/{v}/{type}/{attribute} | Update an attribute
*WorkspaceApi* | [**init_workspace_v1**](docs/WorkspaceApi.md#init_workspace_v1) | **POST** /workspaces/v1/{workspaceId} | Initialize WDS for a given workspace.


## Documentation For Models

 - [App](docs/App.md)
 - [AttributeDataType](docs/AttributeDataType.md)
 - [AttributeSchema](docs/AttributeSchema.md)
 - [AttributeSchemaUpdate](docs/AttributeSchemaUpdate.md)
 - [BatchOperation](docs/BatchOperation.md)
 - [BatchRecordRequest](docs/BatchRecordRequest.md)
 - [BatchResponse](docs/BatchResponse.md)
 - [Build](docs/Build.md)
 - [Capabilities](docs/Capabilities.md)
 - [Collection](docs/Collection.md)
 - [CollectionRequest](docs/CollectionRequest.md)
 - [Commit](docs/Commit.md)
 - [DeleteRecordsRequest](docs/DeleteRecordsRequest.md)
 - [DeleteRecordsResponse](docs/DeleteRecordsResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [GenericJob](docs/GenericJob.md)
 - [Git](docs/Git.md)
 - [ImportRequest](docs/ImportRequest.md)
 - [JobV1](docs/JobV1.md)
 - [RecordQueryResponse](docs/RecordQueryResponse.md)
 - [RecordRequest](docs/RecordRequest.md)
 - [RecordResponse](docs/RecordResponse.md)
 - [RecordTypeSchema](docs/RecordTypeSchema.md)
 - [SearchFilter](docs/SearchFilter.md)
 - [SearchRequest](docs/SearchRequest.md)
 - [SearchSortDirection](docs/SearchSortDirection.md)
 - [StatusResponse](docs/StatusResponse.md)
 - [TsvUploadResponse](docs/TsvUploadResponse.md)
 - [VersionResponse](docs/VersionResponse.md)
 - [WorkspaceInit](docs/WorkspaceInit.md)
 - [WorkspaceInitClone](docs/WorkspaceInitClone.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication


## Author




