# CLI Pets

[![PyPI version](https://badge.fury.io/py/cli-pets.svg)](https://badge.fury.io/py/cli-pets)
[![Python 3.12+](https://img.shields.io/badge/python-3.12+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

Interactive CLI pets with animated emoji characters for your terminal. Watch cute pets walk, race, and greet you right in your command line!

![CLI Pets Demo](https://raw.githubusercontent.com/ran-codes/cli-pets/main/assets/demo_race.gif)

## Features

- **Walking Animations**: Watch your favorite emoji pets walk across the terminal
- **Pet Racing**: Race multiple pets against each other with live updates
- **Random Greetings**: Get friendly greetings from random pets
- **Rich Terminal Output**: Colorful and smooth animations using Rich library
- **Customizable**: Choose your pet, adjust speed, and control animation parameters

## Installation

Install from PyPI using pip:

```bash
pip install cli-pets
```

Or using uv:

```bash
uv pip install cli-pets
```

## Quick Start

### Walk a Pet

```python
from cli_pets import walk

# Walk a cat across the terminal
walk(steps=30, speed=0.1)

# Walk with more steps
walk(steps=50, speed=0.05)
```

### Race Pets

```python
from cli_pets import race

# Race 3 random pets
race(distance=50, racers=3)

# Race with custom settings
race(distance=40, racers=2, speed=0.1)
```

### Greet

```python
from cli_pets import greet

# Get a friendly greeting from a random pet
greet()
```

## Available Pets

The package includes 10 adorable animal emoji pets that are randomly selected for racing and greetings.

## API Reference

### `walk(pet, steps, speed)`

Animate a pet walking across the terminal.

**Parameters:**
- `pet` (str): Emoji character to display (default: cat emoji)
- `steps` (int): Number of steps to take (default: 30)
- `speed` (float): Seconds between steps (default: 0.1)

### `race(distance, racers, pets, speed, show_winner)`

Race multiple pets across the terminal.

**Parameters:**
- `distance` (int): Length of the race track (default: 50)
- `racers` (int): Number of racing pets (default: 3)
- `pets` (list[str] | None): Specific pets to race; if None, random pets are chosen (default: None)
- `speed` (float): Seconds between updates (default: 0.1)
- `show_winner` (bool): Whether to announce the winner (default: True)

### `greet()`

Print a friendly greeting with a random pet.

**Returns:** None (prints directly to console)

## Examples

### Custom Walking Animation

```python
from cli_pets import walk

# Slow walking
walk(steps=20, speed=0.2)

# Fast walking
walk(steps=60, speed=0.03)
```

### Epic Pet Race

```python
from cli_pets import race

# Long distance race with 5 pets
race(distance=100, racers=5, speed=0.05)

# Quick sprint
race(distance=20, racers=2, speed=0.05)
```

## Requirements

- Python 3.12+
- rich >= 14.2.0

## Development

Clone the repository:

```bash
git clone https://github.com/ran-codes/cli-pets.git
cd cli-pets
```

Install dependencies with uv:

```bash
uv sync
```

Run examples:

```bash
uv run python -c "from cli_pets import walk; walk(steps=20, speed=0.05)"
```

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Contributing

Contributions are welcome! Feel free to open issues or submit pull requests on [GitHub](https://github.com/ran-codes/cli-pets).

## Author

Created by [rl627](https://github.com/ran-codes)

## Changelog

### v0.0.1 (2025-10-15)

Initial release of CLI Pets!

**Features:**
- Walk animation for pets across the terminal
- Racing functionality with multiple pets
- Random pet greetings
- Rich terminal output with smooth animations
- Support for 10 different animal emoji pets
- Customizable speed and distance parameters

---

Made with love and code
