from netdot import client as Client
from netdot.actions import ActionTypes, NetdotAction
from netdot.csv_util import CSVReport
from netdot.dataclasses import (  # ClosetPicture,DataCache,FloorPicture,SitePicture,
    ASN,
    OUI,
    RR,
    RRADDR,
    RRCNAME,
    RRDS,
    RRHINFO,
    RRLOC,
    RRMX,
    RRNAPTR,
    RRNS,
    RRPTR,
    RRSRV,
    RRTXT,
    VLAN,
    AccessRight,
    Asset,
    Audit,
    Availability,
    BackboneCable,
    BGPPeering,
    CableStrand,
    CableType,
    Circuit,
    CircuitStatus,
    CircuitType,
    Closet,
    Contact,
    ContactList,
    ContactType,
    Device,
    DeviceAttr,
    DeviceAttrName,
    DeviceContacts,
    DeviceModule,
    DHCPAttr,
    DHCPAttrName,
    DHCPScope,
    DHCPScopeType,
    DHCPScopeUse,
    Entity,
    EntityRole,
    EntitySite,
    EntityType,
    FiberType,
    Floor,
    FWTable,
    FWTableEntry,
    GroupRight,
    HorizontalCable,
    Host,
    HostAudit,
    Interface,
    InterfaceVLAN,
    IPBlock,
    IPBlockAttr,
    IPBlockAttrName,
    IPBlockStatus,
    IPService,
    MaintContract,
    MonitorStatus,
    NetdotAPIDataclass,
    Person,
    PhysAddr,
    PhysAddrAttr,
    PhysAddrAttrName,
    Product,
    ProductType,
    Room,
    SavedQueries,
    SchemaInfo,
    Service,
    Site,
    SiteLink,
    SiteSubnet,
    Splice,
    STPInstance,
    StrandStatus,
    SubnetZone,
    UserRight,
    UserType,
    VLANGroup,
    Zone,
    ZoneAlias,
    initialize,
)
from netdot.repository import Repository
from netdot.unitofwork import UnitOfWork
from netdot.version import __version__

# Enable `netdot.connect()` to interactively set up a NetdotRepository
connect = Repository.connect
# Enable `netdot.load()` to load proposed changes from a file
load = UnitOfWork.load
# initialize()  # TODO is it really best to initialize on `import netdot` automatically?

__version__ = __version__
__all__ = [
    'Client',
    'connect',
    'load',
    'Repository',
    'UnitOfWork',
    'CSVReport',
    'ActionTypes',
    'NetdotAction',
    '__version__',
    #
    #
    # netdot dataclasses
    #
    # ! Oct 2023: Copied from netdot/dataclasses/__init__.py
    #
    "initialize",
    "NetdotAPIDataclass",
    "AccessRight",
    "ASN",
    "Asset",
    "Audit",
    "Availability",
    "BackboneCable",
    "BGPPeering",
    "CableStrand",
    "CableType",
    "Circuit",
    "CircuitStatus",
    "CircuitType",
    "Closet",
    # "ClosetPicture",
    "Contact",
    "ContactList",
    "ContactType",
    # "DataCache",
    "Device",
    "DeviceAttr",
    "DeviceAttrName",
    "DeviceContacts",
    "DeviceModule",
    "DHCPAttr",
    "DHCPAttrName",
    "DHCPScope",
    "DHCPScopeType",
    "DHCPScopeUse",
    "Entity",
    "EntityRole",
    "EntitySite",
    "EntityType",
    "FiberType",
    "Floor",
    # "FloorPicture",
    "FWTable",
    "FWTableEntry",
    "GroupRight",
    "HorizontalCable",
    "Host",
    "HostAudit",
    "Interface",
    "InterfaceVLAN",
    "IPBlock",
    "IPBlockAttr",
    "IPBlockAttrName",
    "IPBlockStatus",
    "IPService",
    "MaintContract",
    "MonitorStatus",
    "OUI",
    "Person",
    "PhysAddr",
    "PhysAddrAttr",
    "PhysAddrAttrName",
    "Product",
    "ProductType",
    "Room",
    "RR",
    "RRADDR",
    "RRCNAME",
    "RRCNAME",
    "RRDS",
    "RRHINFO",
    "RRLOC",
    "RRMX",
    "RRNAPTR",
    "RRNS",
    "RRPTR",
    "RRSRV",
    "RRTXT",
    "SavedQueries",
    "SchemaInfo",
    "Service",
    "Site",
    "SiteLink",
    # "SitePicture",
    "SiteSubnet",
    "Splice",
    "STPInstance",
    "StrandStatus",
    "SubnetZone",
    "UserRight",
    "UserType",
    "VLAN",
    "VLANGroup",
    "Zone",
    "ZoneAlias",
]
