import pytest
from assertpy import assert_that
from netdot import utils


@pytest.mark.parametrize("input,pluralized", 
                         [
    # ! Haven't tried to handle these cases:
    # ! ("goose", "geese"),
    # ! ("mouse", "mice"),
    # ! ("scarf", "scarves"),
    # ! ("glasses", "glasses"),
    # Here are some cases that are handled:
    ("Alias", "Aliases"),
    ("bag", "bags"),
    ("belt", "belts"),
    ("bird", "birds"),
    ("book", "books"),
    ("box", "boxes"),
    ("bracelet", "bracelets"),
    ("brush", "brushes"),
    ("bus", "buses"),
    ("camera", "cameras"),
    ("car", "cars"),
    ("cat", "cats"),
    ("ceiling", "ceilings"),
    ("chair", "chairs"),
    ("class", "classes"),
    ("cloud", "clouds"),
    ("coat", "coats"),
    ("computer", "computers"),
    ("Contacts", "Contacts"),
    ("desk", "desks"),
    ("dish", "dishes"),
    ("dog", "dogs"),
    ("door", "doors"),
    ("dress", "dresses"),
    ("earring", "earrings"),
    ("fax", "faxes"),
    ("floor", "floors"),
    ("flower", "flowers"),
    ("fox", "foxes"),
    ("galaxy", "galaxies"),
    ("glass", "glasses"),
    ("glove", "gloves"),
    ("grass", "grasses"),
    ("hat", "hats"),
    ("house", "houses"),
    ("Info", "Info"),
    ("jacket", "jackets"),
    ("key", "keys"),
    ("kiss", "kisses"),
    ("match", "matches"),
    ("moon", "moons"),
    ("mountain", "mountains"),
    ("necklace", "necklaces"),
    ("ocean", "oceans"),
    ("pants", "pants"),
    ("pen", "pens"),
    ("phone", "phones"),
    ("planet", "planets"),
    ("Queries", "Queries"),
    ("ring", "rings"),
    ("river", "rivers"),
    ("roof", "roofs"),
    ("RR", "RR"),
    ("RRADDR", "RRADDR"),
    ("RRCNAME", "RRCNAME"),
    ("RRDS", "RRDS"),
    ("RRHINFO", "RRHINFO"),
    ("RRLOC", "RRLOC"),
    ("RRMX", "RRMX"),
    ("RRNAPTR", "RRNAPTR"),
    ("RRNS", "RRNS"),
    ("RRPTR", "RRPTR"),
    ("RRSRV", "RRSRV"),
    ("RRTXT", "RRTXT"),
    ("shirt", "shirts"),
    ("shoe", "shoes"),
    ("sky", "skies"),
    ("sock", "socks"),
    ("star", "stars"),
    ("Status", "Statuses"),
    ("sun", "suns"),
    ("table", "tables"),
    ("tax", "taxes"),
    ("tie", "ties"),
    ("tree", "trees"),
    ("umbrella", "umbrellas"),
    ("universe", "universes"),
    ("wall", "walls"),
    ("wallet", "wallets"),
    ("watch", "watches"),
    ("window", "windows"),
    ("wish", "wishes"),
])
def test_pluralize(input, pluralized):
    assert_that(utils.pluralize(input)).is_equal_to(pluralized)
    