# -*- coding: utf-8 -*-
# Generated by Django 1.9.11 on 2016-12-01 03:54
from __future__ import unicode_literals

from django.contrib.contenttypes.models import ContentType
from django.db import migrations

from guardian.models import GroupObjectPermission, UserObjectPermission
from guardian.shortcuts import assign_perm


def migrate_sample(apps, schema_editor):
    """Migrate `Sample` objects and their permissions to `Entity`."""
    Sample = apps.get_model("resolwe_bio", "Sample")  # pylint: disable=invalid-name
    Entity = apps.get_model("flow", "Entity")  # pylint: disable=invalid-name

    Entity.objects.all().delete()

    sample_ctype = None

    for sample in Sample.objects.all():
        entity = Entity()

        entity.id = sample.id
        entity.slug = sample.slug
        entity.name = sample.name
        entity.version = sample.version
        entity.description = sample.description
        entity.settings = sample.settings
        entity.contributor = sample.contributor
        entity.descriptor_schema = sample.descriptor_schema
        entity.descriptor = sample.descriptor

        if not sample.presample:
            entity.descriptor_completed = True

        entity.save()

        for collection_id in sample.collections.all():
            entity.collections.add(collection_id)

        for data_id in sample.data.all():
            entity.data.add(data_id)

        sample_ctype = ContentType.objects.get_for_model(sample)
        for perm in UserObjectPermission.objects.filter(content_type=sample_ctype):
            new_codename = perm.permission.codename.replace('sample', 'entity')
            assign_perm(new_codename, perm.user, entity)
        for perm in GroupObjectPermission.objects.filter(content_type=sample_ctype):
            new_codename = perm.permission.codename.replace('sample', 'entity')
            assign_perm(new_codename, perm.group, entity)

    if sample_ctype:
        UserObjectPermission.objects.filter(content_type=sample_ctype).delete()
        GroupObjectPermission.objects.filter(content_type=sample_ctype).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('resolwe_bio', '0007_sample_descriptor_dirty'),
    ]

    operations = [
        migrations.RunPython(migrate_sample),
    ]
