# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CopyFileArgs', 'CopyFile']

@pulumi.input_type
class CopyFileArgs:
    def __init__(__self__, *,
                 connection: pulumi.Input['ConnectionArgs'],
                 local_path: pulumi.Input[_builtins.str],
                 remote_path: pulumi.Input[_builtins.str],
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None):
        """
        The set of arguments for constructing a CopyFile resource.
        :param pulumi.Input['ConnectionArgs'] connection: The parameters with which to connect to the remote host.
        :param pulumi.Input[_builtins.str] local_path: The path of the file to be copied.
        :param pulumi.Input[_builtins.str] remote_path: The destination path in the remote host.
        :param pulumi.Input[Sequence[Any]] triggers: Trigger replacements on changes to this input.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "local_path", local_path)
        pulumi.set(__self__, "remote_path", remote_path)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['ConnectionArgs']:
        """
        The parameters with which to connect to the remote host.
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of the file to be copied.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_path", value)

    @_builtins.property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Input[_builtins.str]:
        """
        The destination path in the remote host.
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_path", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        Trigger replacements on changes to this input.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)


warnings.warn("""This resource is deprecated and will be removed in a future release. Please use the `CopyToRemote` resource instead.""", DeprecationWarning)


@pulumi.type_token("command:remote:CopyFile")
class CopyFile(pulumi.CustomResource):
    warnings.warn("""This resource is deprecated and will be removed in a future release. Please use the `CopyToRemote` resource instead.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_path: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        """
        Copy a local file to a remote host.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']] connection: The parameters with which to connect to the remote host.
        :param pulumi.Input[_builtins.str] local_path: The path of the file to be copied.
        :param pulumi.Input[_builtins.str] remote_path: The destination path in the remote host.
        :param pulumi.Input[Sequence[Any]] triggers: Trigger replacements on changes to this input.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CopyFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Copy a local file to a remote host.

        :param str resource_name: The name of the resource.
        :param CopyFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CopyFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['ConnectionArgs', 'ConnectionArgsDict']]] = None,
                 local_path: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_path: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        pulumi.log.warn("""CopyFile is deprecated: This resource is deprecated and will be removed in a future release. Please use the `CopyToRemote` resource instead.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CopyFileArgs.__new__(CopyFileArgs)

            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = None if connection is None else pulumi.Output.secret(connection)
            if local_path is None and not opts.urn:
                raise TypeError("Missing required property 'local_path'")
            __props__.__dict__["local_path"] = local_path
            if remote_path is None and not opts.urn:
                raise TypeError("Missing required property 'remote_path'")
            __props__.__dict__["remote_path"] = remote_path
            __props__.__dict__["triggers"] = triggers
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connection"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CopyFile, __self__).__init__(
            'command:remote:CopyFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CopyFile':
        """
        Get an existing CopyFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CopyFileArgs.__new__(CopyFileArgs)

        __props__.__dict__["connection"] = None
        __props__.__dict__["local_path"] = None
        __props__.__dict__["remote_path"] = None
        __props__.__dict__["triggers"] = None
        return CopyFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['outputs.Connection']:
        """
        The parameters with which to connect to the remote host.
        """
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter(name="localPath")
    def local_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the file to be copied.
        """
        return pulumi.get(self, "local_path")

    @_builtins.property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> pulumi.Output[_builtins.str]:
        """
        The destination path in the remote host.
        """
        return pulumi.get(self, "remote_path")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        """
        Trigger replacements on changes to this input.
        """
        return pulumi.get(self, "triggers")

