"""Lookup table for drs attributes."""

cmor_lookup = {
    "cmip6": {
        "CF3hr": {
            "ci": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clic": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clis": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clivi": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cls": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clt": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cltc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clwc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clws": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clwvi": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "demc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "dems": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "dtauc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "dtaus": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "evspsbl": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "grpllsprof": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "h2o": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hfls": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hfss": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hurs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pfull": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "phalf": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pr": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prcprof": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prlsns": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prlsprof": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prsn": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prsnc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prw": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ps": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "psl": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclic": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclis": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclwc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclws": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffgrpls": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffrainc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffrains": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffsnowc": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffsnows": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlds": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rldscs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlus": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlut": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlutcs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsds": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdscs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdt": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsus": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsuscs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsut": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsutcs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rtmt": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sbl": {
                "time-frequency": "3hrPt",
                "realm": "landIce",
                "time-agg": "point",
            },
            "sci": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sfcWind": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tauu": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tauv": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ts": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zfull": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zhalf": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "Emon": {
            "c13Land": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c13Litter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c13Soil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c13Veg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c14Land": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c14Litter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c14Soil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c14Veg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLand": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterCwd": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterSubSurf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterSurf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cMisc": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cOther": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilAbove1m": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilLevels": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilPools": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cStem": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cTotFireLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cVegGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cVegShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cVegTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cWood": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cfadDbze94": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cfadLidarsr532": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clcalipsoice": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clcalipsoliq": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldicemxrat27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldnci": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldncl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldnvi": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldwatmxrat27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "climodis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clmisr": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cltmodis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwmodis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwvic": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co23D": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co2s": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "columnmassflux": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "conccmcn": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "conccn": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "concdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "concnmcn": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cropFracC3": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cropFracC4": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "depdust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "diabdrag": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "dissi14c": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ec550aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "evspsblpot": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "exparag": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expn": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expp": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expsi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fAnthDisturb": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fBNF": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fCLandToOcean": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fDeforestToAtmos": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fDeforestToProduct": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fFireAll": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fFireNat": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fHarvestToAtmos": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fHarvestToProduct": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLitterFire": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLuc": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLulccAtmLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLulccProductLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLulccResidueLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fN2O": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNAnthDisturb": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNLandToOcean": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNLitterSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNOx": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNProduct": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNVegLitter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNVegSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNdep": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNfert": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNgas": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNgasFire": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNgasNonFire": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNleach": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNloss": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNnetmin": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fNup": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fProductDecomp": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fProductDecompLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegFire": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegLitterMortality": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegLitterSenescence": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegSoilMortality": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegSoilSenescence": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fahLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fg14co2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "flandice": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "flashrate": {
                "time-frequency": "mon",
                "realm": "atmosChem",
                "time-agg": "mean",
            },
            "fracLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppc13": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gppc14": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "grassFracC3": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "grassFracC4": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "grplmxrat27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hflsLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "hfssLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "hursminCrop": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "hus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hussLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "intuadse": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "intuaw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "intvadse": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "intvaw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "irrLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "jpdftaureicemodis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "jpdftaureliqmodis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "laiLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "loaddust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadso4": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadss": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwsrfasdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwsrfcsdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwtoaasdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwtoacsaer": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwtoacsdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "md": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "mmrno3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mrlso": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrroLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsfl": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsll": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsoLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsol": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsosLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrtws": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLand": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLeaf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLitter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLitterCwd": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLitterSubSurf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nLitterSurf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nMineral": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nMineralNH4": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nMineralNO3": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nOther": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nProduct": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nRoot": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nStem": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nVeg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "necbLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nep": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "netAtmosLandC13Flux": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "netAtmosLandC14Flux": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "netAtmosLandCO2Flux": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppOther": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppStem": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nwdFracLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "ocontempdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontempmint": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppmdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppsmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemprmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemptend": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "od443dust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "od550aerso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "od550so4so": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "od865dust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "opottempdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottempmint": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppmdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppsmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemprmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemptend": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "orog": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "osaltdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpmdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpsmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltrmadvect": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osalttend": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "pabigthetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "parasolRefl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pastureFracC3": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "pastureFracC4": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "pathetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ppcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppdiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppdiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pppico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pr17O": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pr18O": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pr2h": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prCrop": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prbigthetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "prhmax": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn17O": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn18O": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn2h": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prthetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "prw17O": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prw18O": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "prw2H": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ps": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "raGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raLeaf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raOther": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raRoot": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raStem": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "raTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rac13": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rac14": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rainmxrat27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "reffclic": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "reffclis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "reffclwc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "reffclws": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rhGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhLitter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhc13": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rhc14": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rls": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlusLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rsdoabsorb": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "rsdscsdiff": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdsdiff": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rss": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsusLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "sconcdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sconcso4": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sconcss": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sedustCI": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "sfcWindmax": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "snowmxrat27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "somint": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sw17O": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sw18O": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sw2H": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sweLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "swsrfasdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "swsrfcsdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "swtoaasdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "swtoacsdust": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "t2": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "t20d": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tSoilPools": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "ta27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tasLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "tasmaxCrop": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "tasminCrop": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "tdps": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "thetaot": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetaot2000": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetaot300": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetaot700": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnhuspbl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusscp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntd": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntmp27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntpbl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntrl27": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrlcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntrs27": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrscs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntscp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "treeFracBdlDcd": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracBdlEvg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracNdlDcd": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracNdlEvg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "tslsiLut": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "twap": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "u2": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "ua": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "ua27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "uqint": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ut": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "utendnogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "uv": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "uwap": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "v2": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "va": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "va27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vegFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeight": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeightCrop": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeightGrass": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeightPasture": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeightShrub": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeightTree": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "vqint": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vt": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "vtendnogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vtendogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vwap": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wetlandCH4": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "wetlandCH4cons": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "wetlandCH4prod": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "wetlandFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "wtd": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "xgwdparam": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ygwdparam": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg27": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "E1hrClimMon": {
            "rlut": {
                "time-frequency": "1hrCM",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlutcs": {
                "time-frequency": "1hrCM",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdt": {
                "time-frequency": "1hrCM",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsut": {
                "time-frequency": "1hrCM",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsutcs": {
                "time-frequency": "1hrCM",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "Oday": {
            "chlos": {
                "time-frequency": "day",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "omldamax": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "maximum",
            },
            "phycos": {
                "time-frequency": "day",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "sos": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sossq": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tos": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tossq": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
        },
        "CFday": {
            "albisccp": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ccb": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cct": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cl": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "clcalipso": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clhcalipso": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cli": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clisccp": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clivi": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cllcalipso": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clmcalipso": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cltcalipso": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cltisccp": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clw": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwvi": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hur": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mc": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "pctisccp": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pfull": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "phalf": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ps": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "rldscs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlutcs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdscs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdt": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsuscs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsut": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsutcs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "ta700": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ua": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "va": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "wap": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap500": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
        },
        "Omon": {
            "agessc": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "arag": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "aragos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bacc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "baccos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bfeos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bigthetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "bigthetaoga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "bsi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bsios": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "calc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "calcos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "cfc11": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "cfc12": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "chl": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlcalcos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiatos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiazos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlmiscos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlpico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlpicoos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3abio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3abioos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3nat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3natos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3os": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3satarag": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3sataragos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3satcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3satcalcos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "detoc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "detocos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dfeos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissi13c": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissi13cos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissi14cabio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissi14cabioos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissic": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicabio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicabioos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicnat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicnatos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissoc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissocos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dmso": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dmsos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dpco2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dpco2abio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dpco2nat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dpo2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "eparag100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epc100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epcalc100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epfe100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epn100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epp100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "epsi100": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "evs": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "expc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtalk": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtdic": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtdife": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtdin": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtdip": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fbddtdisi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtalk": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtdic": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtdife": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtdin": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtdip": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fddtdisi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fg13co2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fg14co2abio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgcfc11": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "fgcfc12": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "fgco2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgco2abio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgco2nat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgdms": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgo2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgsf6": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ficeberg": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ficeberg2d": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "frfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fric": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "friver": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "frn": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "froc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fsfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fsitherm": {
                "time-frequency": "mon",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "fsn": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "graz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "hfbasin": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfbasinpadv": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfbasinpmadv": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfbasinpmdiff": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfbasinpsmadv": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfcorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfevapds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfgeou": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfibthermds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfibthermds2d": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hflso": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfrainds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfrunoffds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfrunoffds2d": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfsifrazil": {
                "time-frequency": "mon",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "hfsifrazil2d": {
                "time-frequency": "mon",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "hfsnthermds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfsnthermds2d": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfsso": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfx": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfy": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "htovgyre": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "htovovrt": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "icfriver": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intdic": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intdoc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intparag": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpbfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpbn": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpbp": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpbsi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpcalcite": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpn2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpoc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpp": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intppcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intppdiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intppdiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intppmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intppnitrate": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "intpppico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limfecalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limfediat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limfediaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limfemisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limfepico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limirrcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limirrdiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limirrdiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limirrmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limirrpico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limncalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limndiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limndiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limnmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "limnpico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "masscello": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "masso": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "mfo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "mlotst": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "mlotstmax": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "maximum",
            },
            "mlotstmin": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "minimum",
            },
            "mlotstsq": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftbarot": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmrho": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmrhompa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmz": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmzmpa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmzsmpa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyrho": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyrhompa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyz": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyzmpa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyzsmpa": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "nh4": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "nh4os": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "no3": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "no3os": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2min": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2os": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2sat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2satos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "obvfsq": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocfriver": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pbo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ph": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phabio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phabioos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phnat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phnatos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phycalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phycalcos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phycos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiatos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiaz": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiazos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyfe": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyfeos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phymisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phymiscos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyn": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phynos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyp": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phypico": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phypicoos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phypos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "physi": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "physios": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "po4": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "po4os": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pon": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ponos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pop": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "popos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pp": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "prra": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pso": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "rlntds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "rsdo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "rsntds": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sf6": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sfdsi": {
                "time-frequency": "mon",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "sfriver": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "si": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "sios": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "sltovgyre": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sltovovrt": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "so": {"time-frequency": "mon", "realm": "ocean", "time-agg": "mean"},
            "sob": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "soga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sos": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sosga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sossq": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "spco2": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "spco2abio": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "spco2nat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "talk": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "talknat": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "talknatos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "talkos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "tauucorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tauuo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tauvcorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tauvo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetao": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetaoga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thkcello": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tob": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tos": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tosga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tossq": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "umo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "uo": {"time-frequency": "mon", "realm": "ocean", "time-agg": "mean"},
            "vmo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vo": {"time-frequency": "mon", "realm": "ocean", "time-agg": "mean"},
            "volcello": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "volo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsf": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsfcorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsfevap": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsfpr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsfriver": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "vsfsit": {
                "time-frequency": "mon",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "wfcorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wfo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wfonocorr": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wmo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wo": {"time-frequency": "mon", "realm": "ocean", "time-agg": "mean"},
            "zfullo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zhalfo": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zmeso": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmesoos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmicro": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmicroos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmisc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmiscos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zo2min": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zooc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zoocos": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zos": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zossq": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zostoga": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zsatarag": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zsatcalc": {
                "time-frequency": "mon",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
        },
        "day": {
            "clt": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hur": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hurs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hursmax": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "hursmin": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "hus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "huss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mrro": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrso": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsos": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "pr": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "prc": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "psl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlds": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rls": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlut": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsds": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sfcWind": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sfcWindmax": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "snc": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snw": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "tas": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tasmax": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "tasmin": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "tslsi": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "ua": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "uas": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "va": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "vas": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
        },
        "6hrLev": {
            "bs550aer": {
                "time-frequency": "6hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "ec550aer": {
                "time-frequency": "6hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "hus": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pfull": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ps": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "ImonGre": {
            "acabf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "icem": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbffl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbfgr": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "licalvf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lifmassbf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotfl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotgr": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litemptop": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "mrroLi": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "orog": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "prra": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rlds": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rlus": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rsds": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rsus": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "sbl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snc": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snicefreez": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snicem": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snm": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tas": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "ts": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
        },
        "SIday": {
            "siconc": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siconca": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisnthick": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sispeed": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sitemptop": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sithick": {
                "time-frequency": "day",
                "realm": "seaIce ocean",
                "time-agg": "mean",
            },
            "sitimefrac": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siu": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siv": {
                "time-frequency": "day",
                "realm": "seaIce",
                "time-agg": "mean",
            },
        },
        "AERmonZ": {
            "bry": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ch4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "cly": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "h2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hcl": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hno3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ho2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "meanage": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "n2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "noy": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "o3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "oh": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ta": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ua": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "va": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "vt100": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
        },
        "ImonAnt": {
            "acabf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "icem": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbffl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbfgr": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "licalvf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lifmassbf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotfl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotgr": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litemptop": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "mrroLi": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "orog": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "prra": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rlds": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rlus": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rsds": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "rsus": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "sbl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snc": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snicefreez": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snicem": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snm": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tas": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "ts": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
        },
        "IyrAnt": {
            "acabf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "hfgeoubed": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "iareafl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "iareagr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbffl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbfgr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "licalvf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lifmassbf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lim": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "limnsw": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotfl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotgr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litemptop": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lithk": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "modelCellAreai": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "orog": {"time-frequency": "yr", "realm": "land", "time-agg": "mean"},
            "sftflf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sftgif": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftgrf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snc": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "strbasemag": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendacabf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendlibmassbf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendlicalvf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "topg": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelmean": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelmean": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "zvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "zvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
        },
        "CFsubhr": {
            "ccb": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cct": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ci": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cli": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clivi": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clw": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clwvi": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "edt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "evspsbl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "evu": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "fco2antt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "fco2fos": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "fco2nat": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hfls": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hfss": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hur": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hurs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "huss": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "latitude": {
                "time-frequency": "fx",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "longitude": {
                "time-frequency": "fx",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pfull": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "phalf": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pr": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prsn": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prw": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ps": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "psl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rld": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rldcs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlds": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rldscs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlu": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlucs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlut": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlutcs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsd": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdcs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsds": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdscs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsu": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsucs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsuscs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsut": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsutcs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rtmt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sbl": {
                "time-frequency": "subhrPt",
                "realm": "landIce",
                "time-agg": "point",
            },
            "sci": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sfcWind": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tas": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tauu": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tauv": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusa": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusd": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusmp": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusscpbl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnta": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntmp": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntr": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntscpbl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ts": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "uas": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "vas": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wap": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zg": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "IfxAnt": {
            "areacellg": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "hfgeoubed": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lithk": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "topg": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
        },
        "Lmon": {
            "baresoilFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "burntFractionAll": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c3PftFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "c4PftFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cCwd": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLeaf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterAbove": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitterBelow": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cProduct": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cRoot": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilFast": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilMedium": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cSoilSlow": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cVeg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "cropFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "evspsblsoi": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "evspsblveg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fFire": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fGrazing": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fHarvest": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fLitterSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegLitter": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "fVegSoil": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "gpp": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "grassFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "lai": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "landCoverFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrfso": {
                "time-frequency": "mon",
                "realm": "land landIce",
                "time-agg": "mean",
            },
            "mrro": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrros": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrso": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsos": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nbp": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "npp": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "nppLeaf": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppRoot": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "nppWood": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "pastureFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "prveg": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rGrowth": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rMaint": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "ra": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "residualFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "rh": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
            "shrubFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "tran": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFrac": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracPrimDec": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracPrimEver": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracSecDec": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFracSecEver": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "tsl": {"time-frequency": "mon", "realm": "land", "time-agg": "mean"},
        },
        "E1hr": {
            "pr": {"time-frequency": "1hr", "realm": "atmos", "time-agg": "mean"},
            "prc": {
                "time-frequency": "1hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "psl": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlut": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntr27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "utendnogw27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "vtendnogw27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wap": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wap27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zg27": {
                "time-frequency": "1hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "6hrPlevPt": {
            "cldicemxrat27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cldwatmxrat27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "dtauc": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "dtaus": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "grplmxrat27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "huss": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "lwsffluxaero": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "lwtoafluxaerocs": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "mrsol": {
                "time-frequency": "6hrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "mrsos": {
                "time-frequency": "6hrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "psl": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rainmxrat27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rv850": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sfcWind": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "snowmxrat27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "snw": {
                "time-frequency": "6hrPt",
                "realm": "landIce land",
                "time-agg": "point",
            },
            "swsffluxaero": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "swtoafluxaerocs": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tas": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ts": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tsl": {
                "time-frequency": "6hrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "ua": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "uas": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "vas": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "vortmean": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wbptemp7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zg27": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zg500": {
                "time-frequency": "6hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "zg7h": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "Ofx": {
            "areacello": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "basin": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "deptho": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfgeou": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "masscello": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sftof": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thkcello": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ugrido": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "volcello": {
                "time-frequency": "fx",
                "realm": "ocean",
                "time-agg": "mean",
            },
        },
        "fx": {
            "areacella": {
                "time-frequency": "fx",
                "realm": "atmos land",
                "time-agg": "mean",
            },
            "areacellr": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsofc": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "orog": {"time-frequency": "fx", "realm": "land", "time-agg": "mean"},
            "rootd": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftgif": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftlf": {
                "time-frequency": "fx",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zfull": {
                "time-frequency": "fx",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "CFmon": {
            "albisccp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clcalipso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clhcalipso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clic": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clis": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clisccp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cllcalipso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clmcalipso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cls": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cltcalipso": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cltisccp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clws": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "dmc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "edt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "evu": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hur": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mcd": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mcu": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pctisccp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ps": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "rld": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rld4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rldcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rldcs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlu": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlu4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlucs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlucs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlut4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlutcs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsd": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsd4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdcs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsu": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsu4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsucs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsucs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsut4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsutcs4co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "smc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "tnhus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusa": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusd": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusmp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnhusscpbl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tnta": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntmp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntr": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntscpbl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "SImon": {
            "sfdsi": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siage": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siareaacrossline": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siarean": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siareas": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sicompstren": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siconca": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidconcdyn": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidconcth": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidivvel": {
                "time-frequency": "monPt",
                "realm": "seaIce",
                "time-agg": "point",
            },
            "sidmassdyn": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassevapsubl": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassgrowthbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassgrowthwat": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmasslat": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassmeltbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassmelttop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmasssi": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmassth": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmasstranx": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidmasstrany": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidragbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sidragtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siextentn": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siextents": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sifb": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflcondbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflcondtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflfwbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflfwdrain": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sifllatstop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sifllwdtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sifllwutop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflsenstop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflsensupbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflswdbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflswdtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siflswutop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforcecoriolx": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforcecorioly": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforceintstrx": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforceintstry": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforcetiltx": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siforcetilty": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sihc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siitdconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siitdsnconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siitdsnthick": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siitdthick": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "simass": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "simassacrossline": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "simpconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "simpmass": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "simprefrozen": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sipr": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sirdgconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sirdgthick": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisali": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisaltmass": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sishevel": {
                "time-frequency": "monPt",
                "realm": "seaIce",
                "time-agg": "point",
            },
            "sisnconc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisnhc": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisnmass": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sisnthick": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sispeed": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sistremax": {
                "time-frequency": "monPt",
                "realm": "seaIce",
                "time-agg": "point",
            },
            "sistresave": {
                "time-frequency": "monPt",
                "realm": "seaIce",
                "time-agg": "point",
            },
            "sistrxdtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sistrxubot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sistrydtop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sistryubot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sitempbot": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sitempsnic": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sitemptop": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sithick": {
                "time-frequency": "mon",
                "realm": "seaIce ocean",
                "time-agg": "mean",
            },
            "sitimefrac": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siu": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "siv": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sivol": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sivoln": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sivols": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmassdyn": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmassmelt": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmasssi": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmasssnf": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmasssubl": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "sndmasswindrif": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
            "snmassacrossline": {
                "time-frequency": "mon",
                "realm": "seaIce",
                "time-agg": "mean",
            },
        },
        "Eyr": {
            "baresoilFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "cLitter": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cLitterLut": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cProduct": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cProductLut": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cSoil": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cSoilLut": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cVeg": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cVegLut": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "cropFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "fracInLut": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "sum",
            },
            "fracLut": {
                "time-frequency": "yrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "fracOutLut": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "sum",
            },
            "grassFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "residualFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "shrubFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "treeFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegFrac": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "zfullo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
        },
        "Oclim": {
            "difmxybo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difmxybo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difmxylo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difmxylo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrbbo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrbbo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrblo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrblo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrebo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrebo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrelo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrelo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrxybo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrxybo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrxylo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrxylo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvho": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvmbo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvmfdo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvmo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvmto": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvso": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvtrbo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvtrto": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "dispkevfo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "dispkexyfo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "dispkexyfo2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnkebto": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnkebto2d": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnpeo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnpeot": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnpeotb": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zfullo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zhalfo": {
                "time-frequency": "monC",
                "realm": "ocean",
                "time-agg": "mean",
            },
        },
        "LImon": {
            "acabfIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "agesno": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "hfdsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "hflsIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "hfssIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "icemIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litemptopIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lwsnl": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "mrroIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "orogIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "pflw": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "prraIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "prsnIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "rldsIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "rlusIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "rsdsIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "rsusIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sbl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sblIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sftflf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sftgif": {
                "time-frequency": "mon",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftgrf": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snc": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "sncIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snd": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snicefreezIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snicemIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snm": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snmIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snw": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "sootsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tasIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tpf": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tsIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tsn": {
                "time-frequency": "mon",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tsnIs": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
        },
        "E3hrPt": {
            "aerasymbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "aeroptbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "aerssabnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "albdiffbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "albdirbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cfadDbze94": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cfadLidarsr532": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ch4": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clcalipso": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clcalipso2": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clhcalipso": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clisccp": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cllcalipso": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clmcalipso": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "clmisr": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "cltcalipso": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "co2": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus7h": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "jpdftaureicemodis": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "jpdftaureliqmodis": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "n2o": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "o3": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "parasolRefl": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ps": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdcs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdcsaf": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsdcsafbnd": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsdcsbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdscsaf": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsdscsafbnd": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsdscsbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsucs": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsucsaf": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsucsafbnd": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsucsbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsuscsaf": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsuscsafbnd": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsuscsbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsutcsaf": {
                "time-frequency": "3hrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "rsutcsafbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsutcsbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "solbnd": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "sza": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta7h": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua7h": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va7h": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wap7h": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "E6hrZ": {
            "zmlwaero": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "zmswaero": {
                "time-frequency": "6hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "EdayZ": {
            "epfy": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "epfz": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "psitem": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "ua": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "utendepfd": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendnogw": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendogw": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendvtem": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendwtem": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "va": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "vtem": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wtem": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
        },
        "Amon": {
            "ccb": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cct": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cfc113global": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "cfc11global": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "cfc12global": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "ch4": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "ch4Clim": {
                "time-frequency": "monC",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "ch4global": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "ch4globalClim": {
                "time-frequency": "monC",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "ci": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "cl": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "cli": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clivi": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwvi": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co2Clim": {
                "time-frequency": "monC",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co2mass": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "co2massClim": {
                "time-frequency": "monC",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "evspsbl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "fco2antt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "fco2fos": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "fco2nat": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hcfc22global": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hur": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hurs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "huss": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "mc": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "n2o": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "n2oClim": {
                "time-frequency": "monC",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "n2oglobal": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "n2oglobalClim": {
                "time-frequency": "monC",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "o3": {
                "time-frequency": "mon",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "o3Clim": {
                "time-frequency": "monC",
                "realm": "atmos atmosChem",
                "time-agg": "mean",
            },
            "pfull": {
                "time-frequency": "monC",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "phalf": {
                "time-frequency": "monC",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pr": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "prc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ps": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "psl": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlds": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rldscs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlut": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlutcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsds": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdscs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsus": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsuscs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsut": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsutcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rtmt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sbl": {
                "time-frequency": "mon",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sci": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sfcWind": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "tas": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tasmax": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "tasmin": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "tauu": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tauv": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ts": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "ua": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "uas": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "va": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "vas": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
        },
        "Odec": {
            "agessc": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "bigthetao": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "bigthetaoga": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfbasin": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "hfds": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "masscello": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "masso": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmrho": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftmz": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyrho": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "msftyz": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sfdsi": {
                "time-frequency": "dec",
                "realm": "ocean seaIce",
                "time-agg": "mean",
            },
            "sfriver": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "so": {"time-frequency": "dec", "realm": "ocean", "time-agg": "mean"},
            "soga": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sos": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sosga": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tauuo": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tauvo": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetao": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thetaoga": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "thkcello": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tos": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tosga": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "uo": {"time-frequency": "dec", "realm": "ocean", "time-agg": "mean"},
            "vo": {"time-frequency": "dec", "realm": "ocean", "time-agg": "mean"},
            "volcello": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "volo": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wfo": {
                "time-frequency": "dec",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "wo": {"time-frequency": "dec", "realm": "ocean", "time-agg": "mean"},
        },
        "6hrPlev": {
            "bldep": {
                "time-frequency": "6hr",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hurs": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus4": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pr": {"time-frequency": "6hr", "realm": "atmos", "time-agg": "mean"},
            "prhmax": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "psl": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rv850": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sfcWind": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tas": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ua100m": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "uas": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "va100m": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vas": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wap4": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wsgmax100m": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "wsgmax10m": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "zg1000": {
                "time-frequency": "6hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "AERmon": {
            "abs550aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "airmass": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "aoanh": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "bldep": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "c2h2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "c2h6": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "c3h6": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "c3h8": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ccn": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "cdnc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ch3coch3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ch4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "cheaqpso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "chegpso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "chepasoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "chepsoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "cltc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "co": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "co2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "cod": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dms": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "drybc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "drydust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "drynh3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "drynh4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "drynoy": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dryo3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dryoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dryso2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dryso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "dryss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiaco": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emianox": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiaoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emibc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emibvoc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emico": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emidms": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emidust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiisop": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emilnox": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "eminh3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "eminox": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emioa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiso2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emiss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "emivoc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "h2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hcho": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hcl": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "hno3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "isop": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "jno2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "lossch4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "lossco": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "lossn2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "lwp": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmraerh2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrbc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrdust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrnh4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrno3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmroa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrpm1": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrpm10": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrpm2p5": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrsoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "mmrss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "n2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "nh50": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "no": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "no2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "o3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "o3loss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "o3prod": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "o3ste": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od440aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550aerh2o": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550bb": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550bc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550csaer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550dust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550lt1aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550no3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550oa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550so4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550soa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od550ss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "od870aer": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "oh": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "pan": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "pfull": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "phalf": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "photo1d": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "pod0": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "sum",
            },
            "ps": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "ptp": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "reffclwtop": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "rlutaf": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "rlutcsaf": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "rsutaf": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "rsutcsaf": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "so2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tatp": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrl": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrs": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "toz": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tropoz": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ttop": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ua": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "va": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetbc": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetdust": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetnh3": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetnh4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetnoy": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetoa": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetso2": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetso4": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "wetss": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "zg": {"time-frequency": "mon", "realm": "atmos", "time-agg": "mean"},
            "ztp": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
        },
        "Eday": {
            "agesno": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "albc": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "albsn": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "aod550volso4": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ares": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "ccldncl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldnci": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cldnvi": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clivic": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clt": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwvic": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "cnc": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "cw": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "dcw": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "dgw": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "dmlt": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "drivw": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "dslw": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "dsn": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "dsw": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "dtes": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "dtesn": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "ec": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "eow": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "es": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "esn": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "evspsbl": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "evspsblpot": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "hfdsl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfdsn": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "hfdsnb": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfmlt": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfrs": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfsbl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hursminCrop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "hus": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hus850": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "jpdftaureicemodis": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "jpdftaureliqmodis": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lai": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "loadbc": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loaddust": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadnh4": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadno3": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadoa": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadpoa": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadso4": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadsoa": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "loadss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "lwsnl": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "mlotst": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "mrfsofr": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrlqso": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrrob": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrros": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsfl": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsll": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsol": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsow": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrtws": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "nudgincsm": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "nudgincswe": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "parasolRefl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "pflw": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "prCrop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prhmax": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prra": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prrc": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prrsn": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsnc": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsnsn": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prveg": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "prw": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "qgwr": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "reffcclwtop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "reffsclwtop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rivi": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "rivo": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "rls": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdscsdiff": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdsdiff": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rss": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rzwc": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "sbl": {
                "time-frequency": "day",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sblnosn": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "scldncl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "snd": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snm": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "snmsl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "snrefr": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "snwc": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sootsn": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "sw": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "t20d": {
                "time-frequency": "day",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ta": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "ta500": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ta850": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tasmaxCrop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "maximum",
            },
            "tasminCrop": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "minimum",
            },
            "tau": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tauu": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tauupbl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tauv": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tauvpbl": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tcs": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "tdps": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tgs": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "tpf": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tr": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "tran": {
                "time-frequency": "day",
                "realm": "land",
                "time-agg": "mean",
            },
            "ts": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "tsl": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "tsland": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tsn": {
                "time-frequency": "day",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "tsns": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ua": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "va": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "wap": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wtd": {"time-frequency": "day", "realm": "land", "time-agg": "mean"},
            "zg": {"time-frequency": "day", "realm": "atmos", "time-agg": "mean"},
            "zmla": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "Efx": {
            "clayfrac": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "fldcapacity": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "ksat": {"time-frequency": "fx", "realm": "land", "time-agg": "mean"},
            "ps": {"time-frequency": "fx", "realm": "atmos", "time-agg": "mean"},
            "rld": {"time-frequency": "fx", "realm": "atmos", "time-agg": "mean"},
            "rlu": {"time-frequency": "fx", "realm": "atmos", "time-agg": "mean"},
            "rootdsl": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "rsd": {"time-frequency": "fx", "realm": "atmos", "time-agg": "mean"},
            "rsu": {"time-frequency": "fx", "realm": "atmos", "time-agg": "mean"},
            "sandfrac": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftflf": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sftgrf": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "siltfrac": {
                "time-frequency": "fx",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "slthick": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "vegHeight": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "wilt": {"time-frequency": "fx", "realm": "land", "time-agg": "mean"},
        },
        "3hr": {
            "clt": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfls": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "hfss": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "huss": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "mrro": {
                "time-frequency": "3hr",
                "realm": "land",
                "time-agg": "mean",
            },
            "mrsos": {
                "time-frequency": "3hrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "pr": {"time-frequency": "3hr", "realm": "atmos", "time-agg": "mean"},
            "prc": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsn": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ps": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlds": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rldscs": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlus": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsds": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdscs": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdsdiff": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsus": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsuscs": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tas": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tos": {
                "time-frequency": "3hrPt",
                "realm": "ocean",
                "time-agg": "point",
            },
            "tslsi": {
                "time-frequency": "3hrPt",
                "realm": "land",
                "time-agg": "point",
            },
            "uas": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "vas": {
                "time-frequency": "3hrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "AERhr": {
            "ps": {"time-frequency": "1hr", "realm": "atmos", "time-agg": "mean"},
            "sfno2": {
                "time-frequency": "1hr",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "sfo3": {
                "time-frequency": "1hr",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "sfpm25": {
                "time-frequency": "1hr",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tas": {
                "time-frequency": "1hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "EmonZ": {
            "epfy": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "epfz": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "jo2": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "jo3": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "oxloss": {
                "time-frequency": "mon",
                "realm": "atmosChem",
                "time-agg": "mean",
            },
            "oxprod": {
                "time-frequency": "mon",
                "realm": "atmosChem",
                "time-agg": "mean",
            },
            "sltbasin": {
                "time-frequency": "mon",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tntc": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntmp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntnogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntrl": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrlcs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntrs": {
                "time-frequency": "mon",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "tntrscs": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "tntscp": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendepfd": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "utendnogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vmrox": {
                "time-frequency": "mon",
                "realm": "atmosChem",
                "time-agg": "mean",
            },
            "vtem": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vtendnogw": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "wtem": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "xgwdparam": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ygwdparam": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zmtnt": {
                "time-frequency": "mon",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "Esubhr": {
            "bldep": {
                "time-frequency": "subhrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "hfls": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hfss": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "hus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "huss": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "mc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "pr": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "prw": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ps": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclic": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclis": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclwc": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "reffclws": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rlut": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsdt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "rsut": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ta": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tas": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhus": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhuspbl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnhusscp": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tnt": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntd": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntpbl": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntrl": {
                "time-frequency": "subhrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "tntrlcs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntrs": {
                "time-frequency": "subhrPt",
                "realm": "aerosol",
                "time-agg": "point",
            },
            "tntrscs": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "tntscp": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "ua": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "va": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
            "wap": {
                "time-frequency": "subhrPt",
                "realm": "atmos",
                "time-agg": "point",
            },
        },
        "Oyr": {
            "arag": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bacc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtalk": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtdic": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtdife": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtdin": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtdip": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bddtdisi": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bfe": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "bsi": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "calc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "cfc11": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "cfc12": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "chl": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chldiaz": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlmisc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "chlpico": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3abio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3nat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3satarag": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "co3satcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "darag": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "detoc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dfe": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "difmxybo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difmxylo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrblo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "diftrelo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvho": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "difvso": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "dispkexyfo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "dissi13c": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissi14cabio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissic": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicabio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissicnat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dissoc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "dmso": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "exparag": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expfe": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expn": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expp": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "expsi": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fediss": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fescav": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fg13co2": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fg14co2abio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgco2": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgco2abio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "fgco2nat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "graz": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "nh4": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "no3": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "o2sat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ocontempdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontempmint": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppmdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemppsmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemprmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "ocontemptend": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottempdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottempmint": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppmdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemppsmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemprmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "opottemptend": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpmdiff": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltpsmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osaltrmadvect": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "osalttend": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "parag": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pbfe": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pbsi": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ph": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phabio": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phnat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phycalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phydiaz": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyfe": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phymisc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyn": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phyp": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "phypico": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "physi": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pnitrate": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "po4": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pon": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pop": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pp": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppcalc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppdiat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppdiaz": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "ppmisc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "pppico": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "remoc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "rsdoabsorb": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "sf6": {"time-frequency": "yr", "realm": "ocean", "time-agg": "mean"},
            "si": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "somint": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "talk": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "talknat": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "tnkebto": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "tnpeo": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "volcello": {
                "time-frequency": "yr",
                "realm": "ocean",
                "time-agg": "mean",
            },
            "zmeso": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmicro": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zmisc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
            "zooc": {
                "time-frequency": "yr",
                "realm": "ocnBgchem",
                "time-agg": "mean",
            },
        },
        "IfxGre": {
            "areacellg": {
                "time-frequency": "fx",
                "realm": "land",
                "time-agg": "mean",
            },
            "hfgeoubed": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lithk": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "topg": {
                "time-frequency": "fx",
                "realm": "landIce",
                "time-agg": "mean",
            },
        },
        "E3hr": {
            "clivi": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "clwvi": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "gpp": {"time-frequency": "3hr", "realm": "land", "time-agg": "mean"},
            "prcsh": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prra": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prrc": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prsnc": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "prw": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "psl": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "ra": {"time-frequency": "3hr", "realm": "land", "time-agg": "mean"},
            "rh": {"time-frequency": "3hr", "realm": "land", "time-agg": "mean"},
            "rlut": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rlutcs": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsdt": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsut": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "rsutcs": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "sfcWind": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "uas": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "vas": {
                "time-frequency": "3hr",
                "realm": "atmos",
                "time-agg": "mean",
            },
        },
        "AERday": {
            "cod": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "maxpblz": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "maximum",
            },
            "minpblz": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "minimum",
            },
            "od550aer": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "sfo3max": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "maximum",
            },
            "toz": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "ua10": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "zg10": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "zg100": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
            "zg1000": {
                "time-frequency": "day",
                "realm": "atmos",
                "time-agg": "mean",
            },
            "zg500": {
                "time-frequency": "day",
                "realm": "aerosol",
                "time-agg": "mean",
            },
        },
        "IyrGre": {
            "acabf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "hfgeoubed": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "iareafl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "iareagr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbffl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "libmassbfgr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "licalvf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lifmassbf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lim": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "limnsw": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotfl": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litempbotgr": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "litemptop": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "lithk": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "modelCellAreai": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "orog": {"time-frequency": "yr", "realm": "land", "time-agg": "mean"},
            "sftflf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "sftgif": {
                "time-frequency": "yr",
                "realm": "land",
                "time-agg": "mean",
            },
            "sftgrf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "snc": {
                "time-frequency": "yr",
                "realm": "landIce land",
                "time-agg": "mean",
            },
            "strbasemag": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendacabf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendlibmassbf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "tendlicalvf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "topg": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelmean": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "xvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelmean": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "yvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "zvelbase": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
            "zvelsurf": {
                "time-frequency": "yr",
                "realm": "landIce",
                "time-agg": "mean",
            },
        },
    },
}
