# Generated by Django 5.2 on 2025-05-14 10:42

import django.core.validators
import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("extras", "0128_tableconfig"),
        ("netbox_security", "0004_alter_natrule_custom_interface"),
        ("tenancy", "0020_remove_contactgroupmembership"),
    ]

    operations = [
        migrations.CreateModel(
            name="Policer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "logical_interface_policer",
                    models.BooleanField(blank=True, null=True),
                ),
                (
                    "physical_interface_policer",
                    models.BooleanField(blank=True, null=True),
                ),
                (
                    "bandwidth_limit",
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(32000),
                            django.core.validators.MaxValueValidator(50000000000),
                        ],
                    ),
                ),
                (
                    "bandwidth_percent",
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "burst_size_limit",
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1500),
                            django.core.validators.MaxValueValidator(100000000000),
                        ],
                    ),
                ),
                ("discard", models.BooleanField(blank=True, null=True)),
                ("out_of_profile", models.BooleanField(blank=True, null=True)),
                ("loss_priority", models.CharField(blank=True, null=True)),
                ("forwarding_class", models.CharField(blank=True, null=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="%(class)s_related",
                        to="tenancy.tenant",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Policers",
                "ordering": ["name"],
            },
        ),
    ]
