# Generated by Django 5.2 on 2025-06-09 07:04

import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("extras", "0128_tableconfig"),
        (
            "netbox_security",
            "0006_alter_natpoolassignment_assigned_object_type_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="PolicerAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("assigned_object_id", models.PositiveBigIntegerField()),
                (
                    "assigned_object_type",
                    models.ForeignKey(
                        limit_choices_to=models.Q(
                            models.Q(("app_label", "dcim"), ("model", "device")),
                            models.Q(
                                ("app_label", "dcim"), ("model", "virtualdevicecontext")
                            ),
                        ),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "policer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="netbox_security.policer",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Policer assignment",
                "verbose_name_plural": "Policer assignments",
                "indexes": [
                    models.Index(
                        fields=["assigned_object_type", "assigned_object_id"],
                        name="netbox_secu_assigne_18849a_idx",
                    )
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=(
                            "assigned_object_type",
                            "assigned_object_id",
                            "policer",
                        ),
                        name="netbox_security_policerassignment_unique_policer",
                    )
                ],
            },
        ),
    ]
