# Generated by Django 5.2 on 2025-06-17 12:45

import django.db.models.deletion
import netbox_security.validators.fqdn
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("netbox_security", "0007_policerassignment"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="address",
            options={"ordering": ("name", "address", "dns_name")},
        ),
        migrations.RenameField(
            model_name="address",
            old_name="value",
            new_name="address",
        ),
        migrations.AlterUniqueTogether(
            name="address",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="address",
            name="dns_name",
            field=models.CharField(
                blank=True,
                max_length=255,
                null=True,
                validators=[netbox_security.validators.fqdn.validate_fqdn],
            ),
        ),
        migrations.AlterField(
            model_name="addressassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(
                            ("app_label", "netbox_security"), ("model", "securityzone")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="addresslist",
            name="assigned_object_type",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(
                            ("app_label", "netbox_security"), ("model", "address")
                        ),
                        models.Q(
                            ("app_label", "netbox_security"), ("model", "addressset")
                        ),
                        _connector="OR",
                    )
                ),
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="addresslistassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(
                            ("app_label", "netbox_security"), ("model", "securityzone")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="addresssetassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(
                            ("app_label", "netbox_security"), ("model", "securityzone")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="firewallfilterassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="natpoolassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(
                            ("app_label", "virtualization"), ("model", "virtualmachine")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="natrulesetassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(
                            ("app_label", "virtualization"), ("model", "virtualmachine")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="policerassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterField(
            model_name="securityzoneassignment",
            name="assigned_object_type",
            field=models.ForeignKey(
                limit_choices_to=models.Q(
                    models.Q(
                        models.Q(("app_label", "dcim"), ("model", "device")),
                        models.Q(
                            ("app_label", "dcim"), ("model", "virtualdevicecontext")
                        ),
                        models.Q(("app_label", "dcim"), ("model", "interface")),
                        _connector="OR",
                    )
                ),
                on_delete=django.db.models.deletion.CASCADE,
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="address",
            unique_together={("name", "address", "dns_name")},
        ),
    ]
