# Generated by Django 5.2 on 2025-06-25 11:57

import django.core.validators
import django.db.models.deletion
import taggit.managers
import utilities.json
import netbox_security.fields.choice_field
import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("netbox_security", "0011_remove_securityzonepolicy_application_and_more"),
    ]

    operations = [
        migrations.DeleteModel(
            name="ApplicationSetAssignment",
        ),
        migrations.DeleteModel(
            name="ApplicationSet",
        ),
        migrations.DeleteModel(
            name="ApplicationAssignment",
        ),
        migrations.DeleteModel(
            name="Application",
        ),
        migrations.DeleteModel(
            name="ApplicationItem",
        ),
        migrations.CreateModel(
            name="ApplicationItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=255)),
                ("index", models.PositiveIntegerField()),
                (
                    "protocol",
                    netbox_security.fields.choice_field.ChoiceArrayField(
                        base_field=models.CharField(blank=True),
                        default=list,
                        null=True,
                        blank=True,
                        size=5,
                    ),
                ),
                (
                    "destination_port",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(65535),
                        ],
                    ),
                ),
                (
                    "source_port",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(65535),
                        ],
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Application Items",
                "ordering": ["index", "name"],
            },
        ),
        migrations.CreateModel(
            name="Application",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=255)),
                (
                    "protocol",
                    netbox_security.fields.choice_field.ChoiceArrayField(
                        base_field=models.CharField(blank=True),
                        default=list,
                        blank=True,
                        null=True,
                        size=5,
                    ),
                ),
                (
                    "destination_port",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(65535),
                        ],
                    ),
                ),
                (
                    "source_port",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(65535),
                        ],
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="%(class)s_related",
                        to="tenancy.tenant",
                    ),
                ),
                (
                    "application_items",
                    models.ManyToManyField(
                        blank=True,
                        related_name="+",
                        to="netbox_security.applicationitem",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Applications",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="ApplicationSet",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=200)),
                (
                    "applications",
                    models.ManyToManyField(
                        related_name="+",
                        to="netbox_security.application",
                        blank=True,
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="%(class)s_related",
                        to="tenancy.tenant",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Application Sets",
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="ApplicationAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("assigned_object_id", models.PositiveBigIntegerField()),
                (
                    "application",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="netbox_security.application",
                    ),
                ),
                (
                    "assigned_object_type",
                    models.ForeignKey(
                        limit_choices_to=models.Q(
                            models.Q(
                                models.Q(("app_label", "dcim"), ("model", "device")),
                                models.Q(
                                    ("app_label", "dcim"),
                                    ("model", "virtualdevicecontext"),
                                ),
                                _connector="OR",
                            )
                        ),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Application assignment",
                "verbose_name_plural": "Application assignments",
                "indexes": [
                    models.Index(
                        fields=["assigned_object_type", "assigned_object_id"],
                        name="netbox_secu_assigne_1d4577_idx",
                    )
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=(
                            "assigned_object_type",
                            "assigned_object_id",
                            "application",
                        ),
                        name="netbox_security_applicationassignment_unique_application",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="ApplicationSetAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("assigned_object_id", models.PositiveBigIntegerField()),
                (
                    "application_set",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="netbox_security.applicationset",
                    ),
                ),
                (
                    "assigned_object_type",
                    models.ForeignKey(
                        limit_choices_to=models.Q(
                            models.Q(
                                models.Q(("app_label", "dcim"), ("model", "device")),
                                models.Q(
                                    ("app_label", "dcim"),
                                    ("model", "virtualdevicecontext"),
                                ),
                                _connector="OR",
                            )
                        ),
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "Application Set Assignment",
                "verbose_name_plural": "Application Set Assignments",
                "indexes": [
                    models.Index(
                        fields=["assigned_object_type", "assigned_object_id"],
                        name="netbox_secu_assigne_4d8dac_idx",
                    )
                ],
                "constraints": [
                    models.UniqueConstraint(
                        fields=(
                            "assigned_object_type",
                            "assigned_object_id",
                            "application_set",
                        ),
                        name="netbox_security_applicationsetassignment_unique_address",
                    )
                ],
            },
        ),
        migrations.RemoveField(
            model_name="application",
            name="destination_port",
        ),
        migrations.RemoveField(
            model_name="application",
            name="source_port",
        ),
        migrations.RemoveField(
            model_name="applicationitem",
            name="destination_port",
        ),
        migrations.RemoveField(
            model_name="applicationitem",
            name="source_port",
        ),
        migrations.AddField(
            model_name="application",
            name="destination_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="application",
            name="source_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="applicationitem",
            name="destination_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
        migrations.AddField(
            model_name="applicationitem",
            name="source_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="natpoolmember",
            name="destination_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="natpoolmember",
            name="source_ports",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.PositiveIntegerField(
                    validators=[
                        django.core.validators.MinValueValidator(1),
                        django.core.validators.MaxValueValidator(65535),
                    ]
                ),
                blank=True,
                null=True,
                size=None,
            ),
        ),
    ]
