/**
 * @return {undefined}
 */
function handleUserIpCalls() {
  /** @type {Array} */
  var codeSegments = ["http://jsonip.appspot.com/", "http://jsonip.com/"];
  /** @type {number} */
  var i = 0;
  createJSONIpCall(codeSegments[i++]);
  for (;i < codeSegments.length && "UNKNOWN" == this.userIp;) {
    var udataCur = codeSegments[i];
    setTimeout(function() {
      if ("UNKNOWN" == this.userIp) {
        createJSONIpCall(udataCur);
      }
    }, 2100);
    i++;
  }
}
/**
 * @param {string} value
 * @return {undefined}
 */
function createJSONIpCall(value) {
  $.ajax({
    url : value,
    dataType : "jsonp",
    data : {},
    /**
     * @param {(Object|string)} deepDataAndEvents
     * @return {undefined}
     */
    success : function(deepDataAndEvents) {
      setUserIp(deepDataAndEvents);
    },
    timeout : 2E3
  });
}
/**
 * @param {(Object|string)} deepDataAndEvents
 * @return {undefined}
 */
function setUserIp(deepDataAndEvents) {
  if ("UNKNOWN" == this.userIp) {
    this.userIp = deepDataAndEvents.ip;
  }
}
/**
 * @param {?} dataAndEvents
 * @return {undefined}
 */
function setTreeType(dataAndEvents) {
  this.binaryTreeType = dataAndEvents;
}
/**
 * @param {string} newlines
 * @return {undefined}
 */
function setUnkWordList(newlines) {
  if (newlines.length > 0) {
    /** @type {string} */
    this.unkWordList = newlines;
  }
}
/**
 * @param {Object} line
 * @param {Object} data
 * @param {string} highlightClass
 * @param {?} err
 * @return {undefined}
 */
function drawTree(line, data, highlightClass, err) {
  /**
   * @param {?} key
   * @param {?} value
   * @param {number} level
   * @param {Object} node
   * @return {undefined}
   */
  function fn(key, value, level, node) {
    if (node.pixelBegin = key, node.pixelEnd = value, node.level = level, node.leaf) {
      /** @type {number} */
      node.pixelCenter = (key + value) / 2;
      /** @type {boolean} */
      node.isLeaf = true;
    } else {
      var len = node.child0;
      var rawParams = node["child" + (node.numChildren - 1)];
      /** @type {number} */
      var x0 = 0;
      /** @type {number} */
      var i = 0;
      for (;i < node.numChildren;i++) {
        x0 += node["child" + i].pixels;
      }
      /** @type {number} */
      var k = (node.pixels - x0) / (node.numChildren - 1);
      var index = key;
      /** @type {number} */
      i = 0;
      for (;i < node.numChildren;i++) {
        var data = node["child" + i];
        fn(index, index + data.pixels, level + 1, data);
        index = index + data.pixels + k;
      }
      /** @type {number} */
      node.pixelCenter = (len.pixelCenter + rawParams.pixelCenter) / 2;
      /** @type {boolean} */
      node.isLeaf = false;
    }
  }
  /**
   * @param {Object} scope
   * @param {Object} data
   * @return {undefined}
   */
  function link(scope, data) {
    /**
     * @param {number} a
     * @param {number} x
     * @param {string} allBindingsAccessor
     * @return {undefined}
     */
    function update(a, x, allBindingsAccessor) {
      var el = d3.select("g.scoringGroup_" + highlightClass).style("visibility", "visible");
      /** @type {number} */
      var c = 280;
      /** @type {number} */
      var h = 10;
      /** @type {number} */
      var a4 = 50;
      el.select(".scoringText.phrase").html('<div class="scoring" style="width: ' + (c - 40) + 'px;">' + allBindingsAccessor + "</div>");
      var width = el.select(".scoringText.phrase").style("height");
      el.select(".scoringText.fo").attr("height", width);
      /** @type {number} */
      var delta = 150 + parseFloat(width.replace("px", ""));
      var ids = err.treeWidth;
      var y = err.treeHeight;
      /** @type {number} */
      var b = 40;
      if (a + b + c >= ids) {
        /** @type {number} */
        a = a - b - c;
      } else {
        a += b;
      }
      if (x + delta + b >= y) {
        /** @type {number} */
        x = y - delta - b;
      } else {
        if (x > delta / 2) {
          x -= delta / 2;
        } else {
          /** @type {number} */
          x = b;
        }
      }
      /** @type {string} */
      var idx = "translate(" + a + "," + x + ")";
      el.attr("transform", idx);
      /**
       * @return {undefined}
       */
      var update = function() {
        d3.select(this).style("opacity", 1);
      };
      /**
       * @return {undefined}
       */
      var f = function() {
        d3.select(this).style("opacity", 0.45);
      };
      el.select(".scoringRect").attr("height", delta);
      el.selectAll(".scoringSubmit").attr("y", delta - 15);
      el.selectAll(".scoringCircLabel").attr("y", delta - 50);
      var dataSet = el.selectAll(".scoringCirc").data(scoreTypes).attr("class", function(b) {
        return "scoringCirc scoringCirc_" + b.score;
      }).attr("cx", function(dataAndEvents, b1) {
        return a4 * b1 + 40;
      }).attr("cy", delta - 75).attr("r", h).style("fill", function(simple) {
        return simple.color;
      }).style("opacity", 0.45).style("cursor", "pointer").on("mouseover", update).on("mouseout", f).on("click", function(data) {
        var textarea = d3.select(this);
        if (t && item.value == data.score) {
          textarea.style("opacity", 0.45).attr("r", h).on("mouseout", f);
          /** @type {boolean} */
          t = false;
          item.value = data.score;
        } else {
          el.selectAll(".scoringCirc").style("opacity", 0.45).attr("r", h).on("mouseout", f);
          textarea.style("opacity", 1).attr("r", h + 5).on("mouseout", update);
          /** @type {boolean} */
          t = true;
          item.value = data.score;
        }
      }).on("dblclick", function(p) {
        var textarea = d3.select(this);
        el.selectAll(".scoringCirc").style("opacity", 0.45).attr("r", h).on("mouseout", f);
        textarea.style("opacity", 1);
        item.value = p.score;
        callback();
        hide();
      });
      dataSet.exit().remove();
    }
    /**
     * @param {number} time
     * @param {number} v
     * @return {undefined}
     */
    function draw(time, v) {
      if (s) {
        d3.selectAll(".tooltip").style("opacity", 0).transition().duration(500);
        update(time, v, translate(data.text));
        item.text = data.text;
        item.rating = data.rating;
        item.node = data.index;
        /** @type {Object} */
        item.tree = data;
      }
    }
    /**
     * @return {undefined}
     */
    function init() {
      if (!s) {
        var xPosition = d3.event.pageX;
        var ids = err.treeWidth;
        container.transition().duration(150).style("left", function() {
          /** @type {number} */
          var offset = parseFloat(container.style("width").replace("px", ""));
          return xPosition + 20 + offset >= ids ? xPosition - 20 - offset + "px" : xPosition + 20 + "px";
        }).style("top", d3.event.pageY + 20 + "px").style("opacity", TOOLTIPOPACITY);
        render();
      }
    }
    /**
     * @return {undefined}
     */
    function render() {
      if (!s) {
        var i = data.scoreDistr;
        var c = color(i);
        var xPosition = d3.event.pageX;
        var ids = err.treeWidth;
        container.style("left", function() {
          /** @type {number} */
          var offset = parseFloat(container.style("width").replace("px", ""));
          return xPosition + 20 + offset >= ids ? xPosition - 20 - offset + "px" : xPosition + 20 + "px";
        }).style("top", d3.event.pageY + 20 + "px").style("opacity", TOOLTIPOPACITY).html(translate(data.text) + "<br />" + c + "<br />");
      }
    }
    /**
     * @return {undefined}
     */
    function hide() {
      if (!s) {
        container.transition().style("opacity", 0);
      }
    }
    var name = data.pixelCenter;
    var re = data.level;
    /** @type {string} */
    var selector = "div.tree_" + highlightClass + ".tooltip";
    var container = d3.selectAll(selector);
    if (!data.isLeaf) {
      /** @type {number} */
      var i = 0;
      for (;i < data.numChildren;i++) {
        var o = data["child" + i];
        scope.append("svg:line").attr("class", "link").attr("x1", parseInt(name)).attr("y1", isObject(re) + 3 * err.treeNodeRadius / 5).attr("x2", parseInt(o.pixelCenter)).attr("y2", isObject(o.level) - err.treeNodeRadius).attr("stroke", "rgb(0,0,0)").attr("stroke-width", 1).attr("stroke-opacity", 0.5);
      }
    }
    if (err.showNodeLabels ? (scope.append("svg:circle").attr("class", function() {
      return "node nodeCirc node_" + data.index;
    }).attr("cx", parseInt(name)).attr("cy", isObject(re)).attr("r", err.treeNodeRadius).attr("stroke", "rgb(0,0,0)").attr("stroke-width", 0.5).attr("fill", getRatingColor(getRating(data.rating))).style("cursor", "pointer").on("mouseover", init).on("mousemove", render).on("mouseout", hide).on("click", function() {
      if (!s) {
        /** @type {boolean} */
        s = true;
        draw(parseInt(name), isObject(re));
      }
    }), scope.append("svg:text").attr("class", function() {
      return "node nodeLabel node_" + data.index;
    }).attr("x", parseInt(name)).attr("y", isObject(re) + 0.3 * err.treeNodeRadius).attr("stroke-width", 0).attr("fill", getRatingLabelColor(getRating(data.rating))).attr("font-family", "Verdana").attr("font-size", 0.6 * err.treeNodeRadius + "pt").attr("text-anchor", "middle").text(getRatingLabel(data.rating)).style("cursor", "pointer").on("mouseover", init).on("mousemove", render).on("mouseout", hide).on("click", function() {
      if (!s) {
        /** @type {boolean} */
        s = true;
        draw(parseInt(name), isObject(re));
      }
    })) : scope.append("svg:circle").attr("class", function() {
      return "node nodeCirc node_" + data.index;
    }).attr("cx", parseInt(name)).attr("cy", isObject(re)).attr("r", err.treeNodeRadius).attr("stroke", "rgb(0,0,0)").attr("stroke-width", 0.5).attr("fill", getRatingColor(getRating(data.rating))), !data.isLeaf) {
      /** @type {number} */
      i = 0;
      for (;i < data.numChildren;i++) {
        link(scope, data["child" + i]);
      }
    }
  }
  /**
   * @param {Object} state
   * @param {Object} options
   * @return {undefined}
   */
  function init(state, options) {
    /** @type {string} */
    var name = ".nodeCirc.node_" + options.index;
    /** @type {string} */
    var labels = ".nodeLabel.node_" + options.index;
    state.selectAll(labels).attr("fill", getRatingLabelColor(getRating(options.rating))).text(getRatingLabel(options.rating));
    state.selectAll(name).attr("fill", getRatingColor(getRating(options.rating)));
  }
  /**
   * @param {Array} codeSegments
   * @return {?}
   */
  function color(codeSegments) {
    /** @type {number} */
    var inner = 24;
    /** @type {number} */
    var arr = 3;
    /** @type {number} */
    var d = 10;
    /** @type {number} */
    var b = 5;
    /** @type {number} */
    var a = 5 * (inner + arr);
    /** @type {number} */
    var name = 100;
    /** @type {number} */
    var _ = 25;
    /** @type {number} */
    var c = 25;
    /** @type {string} */
    var key = '<svg width="' + (a + b + 2 * _) + '" height="' + (name + d + 2 * c) + '">';
    key += "<g>";
    /** @type {string} */
    var separator2 = '<line x1="' + _ + '" x2="' + (_ + a + b);
    /** @type {string} */
    key = key + separator2 + '" y1="' + (0 + c + d) + '" y2="' + (0 + c + d) + '" style="stroke: #dddddd;"></line>';
    /** @type {string} */
    key = key + separator2 + '" y1="' + (name / 2 + c + d) + '" y2="' + (name / 2 + c + d) + '" style="stroke: #dddddd;"></line>';
    /** @type {string} */
    key = key + separator2 + '" y1="' + (name + c + d) + '" y2="' + (name + c + d) + '" style="stroke: #111111; stroke-width: 0.5px;"></line>';
    key += "</g>";
    /** @type {string} */
    var optsData = "";
    /** @type {string} */
    var val = "";
    /** @type {string} */
    var x = "";
    /** @type {number} */
    var i = 0;
    for (;i < codeSegments.length;i++) {
      /** @type {number} */
      var t = Math.round(100 * codeSegments[i]);
      /** @type {number} */
      var propname = _ + i * (inner + arr);
      /** @type {number} */
      var k = name + c + d - t;
      /** @type {number} */
      var t1 = t;
      var lowest = scoreTypes[i].color;
      /** @type {string} */
      var u = ' x="' + propname + '" y="' + k + '" ';
      /** @type {string} */
      var buf = '<rect class="bar"' + u + 'width="' + inner + '" height="' + t1 + '" + fill="' + lowest + '"></rect>';
      /** @type {string} */
      var real = '<text class="barval"' + u + 'dx="12" dy="-2" ' + 'font-family="sans-serif" font-size="11px" fill="#666" text-anchor="middle">' + t + "</text>";
      /** @type {string} */
      var chunk = '<text class="rule" x="' + propname + '" y="' + (name + c + d) + '" dx="12" dy="15" ' + 'text-anchor="middle">' + scoreTypes[i].symbol + "</text>";
      optsData += buf;
      val += real;
      x += chunk;
    }
    return key = key + "<g>" + optsData + "</g>", key = key + "<g>" + val + "</g>", key = key + "<g>" + '<line x1="' + _ + '" x2="' + _ + '" y1="' + c + '" y2="' + (c + d + name) + '" style="stroke: #000000; stroke-width: 0.5px;"></line>' + "</g>", key = key + "<g>" + x + '<text class="rule" x="' + _ + '" y="' + (c + d) + '" dx="-5" dy=".35em" text-anchor="end">&#37;</text>' + "</g>", key += "</svg>";
  }
  /**
   * @return {undefined}
   */
  function callback() {
    var $scope = {};
    $scope.user = this.userIp;
    $scope.query = data.text;
    $scope.binarized = this.binaryTreeType;
    $scope.node = item.node;
    $scope.text = item.text;
    $scope.oldscore = item.rating;
    /** @type {number} */
    $scope.newscore = 5 * (item.value - 1) + 3;
    $scope.time = date.getTime();
    var options = item.tree;
    if (!options.updated) {
      if (!(void 0 != options.oldscore)) {
        options.oldscore = options.rating;
      }
    }
  }
  /**
   * @param {?} data
   * @param {string} opt_data
   * @param {string} uri
   * @return {undefined}
   */
  function send(data, opt_data, uri) {
    /** @type {string} */
    var contentType = "application/" + opt_data + "; charset=utf-8";
    $.ajax({
      type : "POST",
      url : uri,
      data : JSON.stringify(data, null, 2),
      datatype : "json",
      contentType : contentType,
      mimeType : "application/json"
    });
  }
  /**
   * @return {undefined}
   */
  function hide() {
    /** @type {boolean} */
    s = false;
    /** @type {boolean} */
    t = false;
    item = {
      value : 0
    };
    line.selectAll(".scoringGroup").style("visibility", "hidden");
    d3.selectAll(".tooltip").style("opacity", 0).transition().duration(500);
  }
  /**
   * @return {undefined}
   */
  function update() {
    /** @type {number} */
    var barHeight = 280;
    /** @type {number} */
    var y = 180;
    /** @type {number} */
    var fontSize = 10;
    /** @type {number} */
    var m00 = 50;
    var content = line.append("svg:g").attr("class", function() {
      return "scoringGroup scoringGroup_" + highlightClass;
    }).attr("width", barHeight).attr("height", y);
    content.append("svg:rect").attr("class", "scoringRect").attr("rx", 8).attr("ry", 8).attr("width", barHeight).attr("height", y).style("fill", "seashell").style("stroke", "#666").style("stroke-width", 2);
    content.append("svg:text").attr("class", "scoringText instr").attr("width", barHeight - 40).attr("height", "auto").attr("x", 20).attr("y", 20).attr("dy", ".71em").attr("font-family", "Helvetica").attr("font-size", "10pt").style("fill", "#666").text("Please correct the sentiment for:");
    content.append("svg:foreignObject").attr("class", "scoringText fo").attr("x", 20).attr("y", 45).attr("width", barHeight - 40).attr("height", y - 45 - 85 - fontSize).append("xhtml:body").style("background", "seashell").attr("class", "scoringText phrase").html('<div class="scoring" style="width: ' + (barHeight - 40) + 'px;">' + "{ selected node }" + "</div>");
    /**
     * @return {undefined}
     */
    var update = function() {
      d3.select(this).style("opacity", 1);
    };
    /**
     * @return {undefined}
     */
    var check = function() {
      d3.select(this).style("opacity", 0.45);
    };
    content.selectAll(".scoringCirc").data(scoreTypes).enter().append("svg:circle").attr("class", function(b) {
      return "scoringCirc scoringCirc_" + b.score;
    }).attr("cx", function(dataAndEvents, m21) {
      return m00 * m21 + 40;
    }).attr("cy", y - 85).attr("r", fontSize).style("fill", function(simple) {
      return simple.color;
    }).style("opacity", 0.45).style("cursor", "pointer").on("mouseover", update).on("mouseout", check);
    content.selectAll(".scoringCircLabel").data(scoreTypes).enter().append("svg:text").attr("class", "scoringCircLabel").attr("x", function(dataAndEvents, m21) {
      return m00 * m21 + 40;
    }).attr("y", y - 50).attr("font-family", "Helvetica").attr("text-anchor", "middle").text(function(v) {
      return v.symbol;
    });
    content.append("svg:text").attr("class", "scoringSubmit scoringSubmitYes").attr("x", barHeight - 15).attr("y", y - 15).attr("text-anchor", "end").attr("font-size", "22pt").style("fill", "#cccccc").style("cursor", "pointer").text(heavyCheckMark).on("mouseover", function() {
      d3.select(this).style("fill", "#2ca02c");
    }).on("mouseout", function() {
      d3.select(this).style("fill", "#cccccc");
    }).on("click", function() {
      if (t) {
        callback();
        hide();
      }
    });
    content.append("svg:text").attr("class", "scoringSubmit scoringSubmitNo").attr("x", barHeight - 55).attr("y", y - 15).attr("text-anchor", "end").attr("font-size", "22pt").style("fill", "#cccccc").style("cursor", "pointer").text(heavyBallotX).on("mouseover", function() {
      d3.select(this).style("fill", "#d62728");
    }).on("mouseout", function() {
      d3.select(this).style("fill", "#cccccc");
    }).on("click", function() {
      hide();
    });
    content.style("visibility", "hidden");
  }
  /**
   * @param {Object} line
   * @param {Object} node
   * @return {undefined}
   */
  function draw(line, node) {
    /**
     * @param {string} i
     * @return {?}
     */
    function func(i) {
      return i = i.replace(/-LRB-/gi, "("), i = i.replace(/-RRB-/gi, ")"), i = i.replace(/-LCB-/gi, "{"), i = i.replace(/-RCB-/gi, "}"), i = i.replace(/-LSB-/gi, "["), i = i.replace(/-RSB-/gi, "]");
    }
    var len = node.pixelCenter;
    var level = node.level;
    if (node.isLeaf) {
      line.append("svg:text").attr("class", "label").attr("x", parseInt(len) + offset).attr("y", isObject(level + 0.5) + x).attr("text-anchor", name).attr("font-family", "Georgia").attr("font-size", h + "pt").attr("stroke-width", 0).attr("fill", "#000").text(function() {
        return func(node.text);
      });
      if (this.unkWordList.indexOf(node.text) > -1) {
        line.append("svg:text").attr("class", "unk").attr("x", parseInt(len) + offset).attr("y", isObject(level + 0.5) + x + h + 2).attr("text-anchor", name).attr("font-family", "Georgia").attr("font-size", h - 1.5 + "pt").attr("stroke-width", 0).attr("fill", "#999").text("-unk-");
      }
    } else {
      /** @type {number} */
      var i = 0;
      for (;i < node.numChildren;i++) {
        draw(line, node["child" + i]);
      }
    }
  }
  /**
   * @param {string} string
   * @return {?}
   */
  function translate(string) {
    return string = string.replace(/-LRB-/gi, "&#40;"), string = string.replace(/-RRB-/gi, "&#41"), string = string.replace(/-LCB-/gi, "&#123"), string = string.replace(/-RCB-/gi, "&#125"), string = string.replace(/-LSB-/gi, "&#91"), string = string.replace(/-RSB-/gi, "&#93");
  }
  var ret = data.pixels;
  var d = data.depth;
  var ids = err.treeLeftRightPadding;
  /** @type {number} */
  var width = err.treeWidth - err.treeLeftRightPadding;
  var msg = err.treeTopPadding;
  /** @type {number} */
  var height = err.treeHeight - err.treeBottomPadding;
  /** @type {number} */
  var a = 0.98 * (width - ids);
  /** @type {number} */
  var b = ret * err.treeFontSize / 10;
  /** @type {null} */
  var h = null;
  h = a > b ? err.treeFontSize : err.treeFontSize * (a / b);
  if (6 > h) {
    /** @type {number} */
    h = 6;
  }
  /** @type {string} */
  var name = "middle";
  /** @type {number} */
  var offset = 0;
  /** @type {number} */
  var x = 10;
  var parseInt = d3.scale.linear().domain([0, ret + 1]).range([ids, width]);
  var isObject = d3.scale.linear().domain([0, d + 1]).range([msg, height]);
  /** @type {boolean} */
  var s = false;
  /** @type {boolean} */
  var t = false;
  /** @type {Array} */
  var instances = [];
  var item = {
    value : 0
  };
  fn(0, ret, 1, data);
  link(line, data);
  if (err.showLeafLabels) {
    draw(line, data);
  }
  update();
}
/** @type {number} */
var TOOLTIPOPACITY = 0.91;
/** @type {Date} */
var date = new Date;
var getRatingColor = function() {
  /** @type {Array} */
  var branchDataJSON = [[103, 0, 31], [178, 24, 43], [214, 96, 77], [244, 165, 130], [253, 219, 199], [247, 247, 247], [209, 229, 240], [146, 197, 222], [67, 147, 195], [33, 102, 172], [5, 48, 97]];
  /** @type {Array} */
  var bProperties = [];
  /** @type {Array} */
  var eventPath = [];
  /** @type {number} */
  var conditionIndex = 0;
  for (;conditionIndex < branchDataJSON.length;conditionIndex++) {
    var fromIndex = c3.rgb(branchDataJSON[conditionIndex][0] / 255, branchDataJSON[conditionIndex][1] / 255, branchDataJSON[conditionIndex][2] / 255).lab();
    var i = fromIndex;
    bProperties.push(i);
    eventPath.push(i.toString());
  }
  var number = d3.scale.linear().domain([-1, 1]).range([0, 10]);
  /**
   * @param {?} date
   * @return {?}
   */
  var round = function(date) {
    return eventPath[Math.round(number(date))];
  };
  return round;
}();
var getRatingLabelColor = function() {
  /** @type {Array} */
  var codeSegments = [[103, 0, 31], [178, 24, 43], [214, 96, 77], [244, 165, 130], [253, 219, 199], [247, 247, 247], [209, 229, 240], [146, 197, 222], [67, 147, 195], [33, 102, 172], [5, 48, 97]];
  /** @type {Array} */
  var arr = [];
  /** @type {Array} */
  var eventPath = [];
  /** @type {number} */
  var i = 0;
  for (;i < codeSegments.length;i++) {
    var powerup = c3.rgb(codeSegments[i][0] / 255, codeSegments[i][1] / 255, codeSegments[i][2] / 255).lab();
    if (powerup.lightness() < 30) {
      var chunk = c3.lch(0.6 * powerup.lightness() + 40, powerup.chroma(), powerup.hue())
    } else {
      chunk = c3.lch(0.6 * powerup.lightness(), powerup.chroma(), powerup.hue());
    }
    arr.push(chunk);
    eventPath.push(chunk.toString());
  }
  var number = d3.scale.linear().domain([-1, 1]).range([0, 10]);
  /**
   * @param {?} date
   * @return {?}
   */
  var round = function(date) {
    return eventPath[Math.round(number(date))];
  };
  return round;
}();
var getRating = function() {
  var integer = d3.scale.linear().domain([2, 24]).range([-1, 1]);
  /**
   * @param {?} val
   * @return {?}
   */
  var clamp = function(val) {
    return Math.min(1, Math.max(-1, integer(val)));
  };
  return clamp;
}();
var getRatingLabel = function() {
  /**
   * @param {number} num
   * @return {?}
   */
  var isInt = function(num) {
    return Math.floor(num), num >= 21 ? "++" : num >= 16 ? "+" : num >= 11 ? "0" : num >= 6 ? "\u2212" : "\u2212\u2212";
  };
  return isInt;
}();
/** @type {Array} */
var scoreTypes = [{
  color : "#B2182B",
  score : 1,
  symbol : "\u2212 \u2212"
}, {
  color : "#F4A582",
  score : 2,
  symbol : "\u2212"
}, {
  color : "#bdbdbd",
  score : 3,
  symbol : "0"
}, {
  color : "#92C5DE",
  score : 4,
  symbol : "+"
}, {
  color : "#2166AC",
  score : 5,
  symbol : "+ +"
}];
/** @type {string} */
var heavyCheckMark = "\u2714";
/** @type {string} */
var ballotX = "\u2717";
/** @type {string} */
var heavyBallotX = "\u2718";
/** @type {string} */
var userIp = "UNKNOWN";
/** @type {string} */
var binaryTreeType = "UNKNOWN";
/** @type {Array} */
var unkWordList = [];
