/**
 * @param {?} chart
 * @param {Array} data
 * @param {?} proto
 * @return {undefined}
 */
function drawTrees(chart, data, proto) {
  /**
   * @param {?} value
   * @param {string} rez
   * @return {?}
   */
  function url(value, rez) {
    /** @type {Array} */
    var dig = ["tree", "tree_" + rez];
    return dig.join(" ");
  }
  /**
   * @param {number} id
   * @return {?}
   */
  function resolve(id) {
    /**
     * @return {undefined}
     */
    var render = function() {
      var type = data[id];
      if ("overview" == type.state) {
        init(type, id);
        /** @type {string} */
        type.state = "detail";
      } else {
        if ("detail" == type.state) {
          render(type, id);
          /** @type {string} */
          type.state = "overview";
          d3.selectAll("div.tooltip").transition().duration(150).style("opacity", 1E-6);
        }
      }
    };
    return render;
  }
  /**
   * @param {?} type
   * @param {number} id
   * @return {undefined}
   */
  function render(type, id) {
    var chart = d3.select("div.tree_" + id);
    var el = chart.select("svg");
    el.selectAll("*").remove();
    chart.selectAll(".btn-small").remove();
    var f = resolve(id);
    el.on("dblclick", f);
    var $wrap = el.append("svg:g").style("width", margin.treeWidth + "px").style("height", margin.treeHeight + "px");
    drawTree($wrap, type, id, margin);
    el.transition().duration(640).style("width", margin.treeWidth + "px").style("height", margin.treeHeight + "px");
  }
  /**
   * @param {?} type
   * @param {number} id
   * @return {undefined}
   */
  function init(type, id) {
    var chart = d3.select("div.tree_" + id);
    var el = chart.select("svg");
    el.selectAll("*").remove();
    el.on("dblclick", null);
    var $wrap = el.append("svg:g").style("width", pos.treeWidth + "px").style("height", pos.treeHeight + "px");
    drawTree($wrap, type, id, pos);
    el.transition().duration(640).style("width", pos.treeWidth + "px").style("height", pos.treeHeight + "px");
    var f = resolve(id);
    /**
     * @return {undefined}
     */
    var update = function() {
      updateDisplayLiveDemoTree(type, true);
      chart.selectAll(".btn-save").remove();
      chart.append("rect").attr("class", "btn btn-small btn-thanks").style("text-decoration", "none").style("cursor", "default").text("Saved. Thank you!");
    };
    $wrap.append("svg:text").attr("class", "button").attr("x", pos.treeWidth).attr("y", 0).attr("dx", -25).attr("dy", 25).attr("text-anchor", "start").attr("font-family", "Helvetica").attr("font-size", "28pt").text("\u00d7").style("fill", "#cccccc").style("cursor", "pointer").on("click", f).on("mouseover", synchronizedMouseOver).on("mouseout", bubbleclick).transition().duration(640);
  }
  var margin = {
    treeLeftRightPadding : 10,
    treeTopPadding : 0,
    treeBottomPadding : 0,
    treeWidth : 240,
    treeHeight : 200,
    treeFontSize : 6,
    treeNodeRadius : 6,
    showLeafLabels : false,
    showNodeLabels : false
  };
  var pos = {
    treeLeftRightPadding : 25,
    treeTopPadding : 0,
    treeBottomPadding : 10,
    treeWidth : {treeWidth},
    treeHeight : {treeHeight},
    treeFontSize : 10,
    treeNodeRadius : {treeNodeRadius},
    showLeafLabels : true,
    showNodeLabels : true
  };
  /**
   * @return {undefined}
   */
  var synchronizedMouseOver = function() {
    d3.select(this).style("fill", "#d62728");
  };
  /**
   * @return {undefined}
   */
  var bubbleclick = function() {
    d3.select(this).style("fill", "#cccccc");
  };
  chart.selectAll("*").remove();
  chart.selectAll("div.tree").data(data).enter().append("div").attr("class", url);
  /** @type {number} */
  var version = parseFloat(d3.select(".trees").style("width").replace("px", ""));
  /** @type {number} */
  var floatVal = parseFloat(d3.select("div.trees").style("padding").replace("px", ""));
  if (isNaN(floatVal) || 0 == floatVal) {
    /** @type {number} */
    floatVal = 10;
  }
  /** @type {number} */
  pos.treeWidth = version - 2 * floatVal - 2;
  /** @type {number} */
  margin.treeWidth = version / 4 - 2 * floatVal - 2;
  /** @type {number} */
  var i = 0;
  for (;i < data.length;i++) {
    var content = d3.select("div.tree_" + i);
    resolve(i);
    var query = content.append("svg:svg").style("width", margin.treeWidth + "px").style("height", margin.treeHeight + "px");
    if (proto.filterByIndexList[i] >= 0) {
      var returnHeight = query.append("svg:g").style("width", margin.treeWidth + "px").style("height", margin.treeHeight + "px");
      var type = data[i];
      if (proto.filterByIndexList[i] >= 1) {
        /** @type {string} */
        type.state = "detail";
        drawTree(returnHeight, type, i, pos);
        init(type, i);
      } else {
        /** @type {string} */
        type.state = "overview";
        drawTree(returnHeight, type, i, margin);
        render(type, i);
      }
      content.style("display", null);
    } else {
      type = data[i];
      /** @type {string} */
      type.state = "hidden";
      content.style("display", "none");
    }
    divTooltip = content.append("div").attr("class", function() {
      return["tooltip", "tree_" + i].join(" ");
    }).style("opacity", 0);
  }
  init(data[0], 0);
  /** @type {string} */
  data[0].state = "detail";
}
/**
 * @param {?} object
 * @param {boolean} dataAndEvents
 * @return {undefined}
 */
function updateDisplayLiveDemoTree(object, dataAndEvents) {
  /**
   * @param {?} data
   * @param {string} isAsync
   * @param {string} url
   * @return {undefined}
   */
  function post(data, isAsync, url) {
    /** @type {string} */
    var contentType = "application/" + isAsync + "; charset=utf-8";
    $.ajax({
      type : "POST",
      url : url,
      data : JSON.stringify(data, null, 2),
      datatype : "json",
      contentType : contentType,
      mimeType : "application/json"
    });
  }
  /**
   * @param {Object} self
   * @return {?}
   */
  function callback(self) {
    var data = {};
    return data.pp = [], data.phrases = [], data.scores = [], data.oldscores = [], add(self, data), data.user = this.userIp, data.query = self.text, data.binarized = this.binaryTreeType, data.time = date.getTime(), data;
  }
  /**
   * @param {Object} data
   * @param {?} obj
   * @return {undefined}
   */
  function add(data, obj) {
    var name = data.index;
    if (!data.isLeaf && data.numChildren > 0) {
      /** @type {number} */
      var i = 0;
      for (;i < data.numChildren;i++) {
        var n = data["child" + i].index;
        obj.pp[n] = name;
        add(data["child" + i], obj);
      }
    }
    if (void 0 == obj.pp[name]) {
      /** @type {number} */
      obj.pp[name] = 0;
    }
    obj.phrases[name] = data.text;
    obj.scores[name] = data.rating;
    if (1 == data.updated) {
      obj.oldscores[name] = data.oldscore;
    } else {
      if (void 0 == obj.oldscores[name] || null == obj.oldscores[name]) {
        /** @type {null} */
        obj.oldscores[name] = null;
      }
    }
  }
  if (dataAndEvents) {
    var value = callback(object);
    post(value, "jdemotree", loggerURL);
  }
}
;
