import logging
import os

from src.common import interface
from src.common.factory import EngineClass, EngineFactory


from dotenv import load_dotenv

load_dotenv(override=True)


class ASRLiveEnvInit:
    @staticmethod
    def getEngine(tag, **kwargs) -> interface.IAsrLive | EngineClass:
        if "asr_streaming_sensevoice" == tag:
            from . import streaming_sensevoice

        engine = EngineFactory.get_engine_by_tag(EngineClass, tag, **kwargs)
        return engine

    @staticmethod
    def initEngine(tag: str | None = None, **kwargs) -> interface.IAsrLive | EngineClass:
        # punc
        tag = tag or os.getenv("ASR_LIVE_TAG", "asr_streaming_sensevoice")
        logging.info(f"{tag} args: {kwargs}")
        engine = ASRLiveEnvInit.getEngine(tag, **kwargs)
        logging.info(f"initEngine: {tag}, {engine}")
        return engine
