"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class UserTool(_ParentRestClient):
    """
    This class contains methods for the 'User Tools' webservices
    PATH: /{apiVersion}/tools
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(UserTool, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def update_acl(self, members, action, data=None, **options):
        """
        Update the set of user tool permissions granted for the member.
        PATH: /{apiVersion}/tools/acl/{members}/update

        :param dict data: JSON containing the parameters to update the
            permissions. (REQUIRED)
        :param str action: Action to be performed [ADD, SET, REMOVE or RESET].
            Allowed values: ['SET ADD REMOVE RESET'] (REQUIRED)
        :param str members: Comma separated list of user or group ids.
            (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        options['action'] = action
        return self._post(category='tools', resource='update', subcategory='acl', second_query_id=members, data=data, **options)

    def aggregation_stats(self, **options):
        """
        Fetch user tool stats.
        PATH: /{apiVersion}/tools/aggregationStats

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str id: Comma separated list of external tool IDs up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str name: Comma separated list of external tool names up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str uuid: Comma separated list of external tool UUIDs up to a
            maximum of 100.
        :param str tags: Comma separated list of tags.
        :param bool draft: Boolean field indicating whether the workflow is a
            draft or not.
        :param str internal.registration_user_id: UserId that created the
            workflow.
        :param str type: External tool type. Allowed types: [CUSTOM_TOOL,
            VARIANT_WALKER or WORKFLOW].
        :param str scope: External tool scope. Allowed types:
            [CLINICAL_INTERPRETATION, SECONDARY_ANALYSIS, RESEARCH or OTHER].
        :param str workflow_repository_name: Workflow repository name.
        :param str container_name: Container name.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str acl: Filter entries for which a user has the provided
            permissions. Format: acl={user}:{permissions}. Example:
            acl=john:WRITE,WRITE_ANNOTATIONS will return all entries for which
            user john has both WRITE and WRITE_ANNOTATIONS permissions. Only
            study owners or administrators can query by this field. .
        :param str release: Release when it was created.
        :param int snapshot: Snapshot value (Latest version of the entry in
            the specified release).
        :param bool deleted: Boolean to retrieve deleted entries.
        :param str field: Field to apply aggregation statistics to (or a list
            of fields separated by semicolons), e.g.:
            studies;type;numSamples[0..10]:1;format:sum(size).
        """

        return self._get(category='tools', resource='aggregationStats', **options)

    def run_custom_builder(self, data=None, **options):
        """
        Execute an analysis from a custom binary.
        PATH: /{apiVersion}/tools/custom/builder/run

        :param dict data: body. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='tools', resource='run', subcategory='custom/builder', data=data, **options)

    def create_custom(self, data=None, **options):
        """
        Register a new user tool of type CUSTOM_TOOL.
        PATH: /{apiVersion}/tools/custom/create

        :param dict data: JSON containing workflow information. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='tools', resource='create', subcategory='custom', data=data, **options)

    def run_custom_docker(self, data=None, **options):
        """
        Execute an analysis from a custom binary.
        PATH: /{apiVersion}/tools/custom/run

        :param dict data: Custom tool run parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='tools', resource='run', subcategory='custom', data=data, **options)

    def update_custom(self, tool_id, data=None, **options):
        """
        Update some custom user tool attributes.
        PATH: /{apiVersion}/tools/custom/{toolId}/update

        :param str tool_id: Comma separated list of external tool IDs up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        :param dict data: body.
        """

        return self._post(category='tools', resource='update', subcategory='custom', second_query_id=tool_id, data=data, **options)

    def distinct(self, field, **options):
        """
        User tool distinct method.
        PATH: /{apiVersion}/tools/distinct

        :param str field: Comma separated list of fields for which to obtain
            the distinct values. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str id: Comma separated list of external tool IDs up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str name: Comma separated list of external tool names up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str uuid: Comma separated list of external tool UUIDs up to a
            maximum of 100.
        :param str tags: Comma separated list of tags.
        :param bool draft: Boolean field indicating whether the workflow is a
            draft or not.
        :param str internal.registration_user_id: UserId that created the
            workflow.
        :param str type: External tool type. Allowed types: [CUSTOM_TOOL,
            VARIANT_WALKER or WORKFLOW].
        :param str scope: External tool scope. Allowed types:
            [CLINICAL_INTERPRETATION, SECONDARY_ANALYSIS, RESEARCH or OTHER].
        :param str workflow_repository_name: Workflow repository name.
        :param str container_name: Container name.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str acl: Filter entries for which a user has the provided
            permissions. Format: acl={user}:{permissions}. Example:
            acl=john:WRITE,WRITE_ANNOTATIONS will return all entries for which
            user john has both WRITE and WRITE_ANNOTATIONS permissions. Only
            study owners or administrators can query by this field. .
        :param str release: Release when it was created.
        :param int snapshot: Snapshot value (Latest version of the entry in
            the specified release).
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        options['field'] = field
        return self._get(category='tools', resource='distinct', **options)

    def search(self, **options):
        """
        User tool search method.
        PATH: /{apiVersion}/tools/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str id: Comma separated list of external tool IDs up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str name: Comma separated list of external tool names up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str uuid: Comma separated list of external tool UUIDs up to a
            maximum of 100.
        :param str tags: Comma separated list of tags.
        :param bool draft: Boolean field indicating whether the workflow is a
            draft or not.
        :param str internal.registration_user_id: UserId that created the
            workflow.
        :param str type: External tool type. Allowed types: [CUSTOM_TOOL,
            VARIANT_WALKER or WORKFLOW].
        :param str scope: External tool scope. Allowed types:
            [CLINICAL_INTERPRETATION, SECONDARY_ANALYSIS, RESEARCH or OTHER].
        :param str workflow_repository_name: Workflow repository name.
        :param str container_name: Container name.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str acl: Filter entries for which a user has the provided
            permissions. Format: acl={user}:{permissions}. Example:
            acl=john:WRITE,WRITE_ANNOTATIONS will return all entries for which
            user john has both WRITE and WRITE_ANNOTATIONS permissions. Only
            study owners or administrators can query by this field. .
        :param str release: Release when it was created.
        :param int snapshot: Snapshot value (Latest version of the entry in
            the specified release).
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='tools', resource='search', **options)

    def create_walker(self, data=None, **options):
        """
        Register a new user tool of type VARIANT_WALKER.
        PATH: /{apiVersion}/tools/walker/create

        :param dict data: JSON containing workflow information. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='tools', resource='create', subcategory='walker', data=data, **options)

    def run_walker(self, data=None, **options):
        """
        Execute an analysis from a custom binary.
        PATH: /{apiVersion}/tools/walker/run

        :param dict data: Variant walker params. (REQUIRED)
        :param str project: Project [organization@]project where project can
            be either the ID or the alias.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='tools', resource='run', subcategory='walker', data=data, **options)

    def create_workflow(self, data=None, **options):
        """
        Register a new user tool of type WORKFLOW.
        PATH: /{apiVersion}/tools/workflow/create

        :param dict data: JSON containing workflow information. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='tools', resource='create', subcategory='workflow', data=data, **options)

    def import_workflow(self, data=None, **options):
        """
        Import a user tool of type WORKFLOW.
        PATH: /{apiVersion}/tools/workflow/import

        :param dict data: Repository parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        return self._post(category='tools', resource='import', subcategory='workflow', data=data, **options)

    def run_workflow(self, data=None, **options):
        """
        Run a user tool of type WORKFLOW.
        PATH: /{apiVersion}/tools/workflow/run

        :param dict data: Workflow tool run parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='tools', resource='run', subcategory='workflow', data=data, **options)

    def update_workflow(self, tool_id, data=None, **options):
        """
        Update some user tool attributes.
        PATH: /{apiVersion}/tools/workflow/{toolId}/update

        :param str tool_id: Comma separated list of external tool IDs up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        :param dict data: body.
        """

        return self._post(category='tools', resource='update', subcategory='workflow', second_query_id=tool_id, data=data, **options)

    def acl(self, tools, **options):
        """
        Returns the acl of the user tools. If member is provided, it will only
            return the acl for the member.
        PATH: /{apiVersion}/tools/{tools}/acl

        :param str tools: Comma separated of external tool ids. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str member: User or group id.
        :param bool silent: Boolean to retrieve all possible entries that are
            queried for, false to raise an exception whenever one of the
            entries looked for cannot be shown for whichever reason.
        """

        return self._get(category='tools', resource='acl', query_id=tools, **options)

    def delete(self, tools, **options):
        """
        Delete user tools.
        PATH: /{apiVersion}/tools/{tools}/delete

        :param str tools: Comma separated of external tool ids. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        return self._delete(category='tools', resource='delete', query_id=tools, **options)

    def info(self, tools, **options):
        """
        Get user tool information.
        PATH: /{apiVersion}/tools/{tools}/info

        :param str tools: Comma separated of external tool ids. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str version: Comma separated list of external tool versions.
            'all' to get all the external tool versions. Not supported if
            multiple external tool ids are provided.
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='tools', resource='info', query_id=tools, **options)

