"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class Workflow(_ParentRestClient):
    """
    This class contains methods for the 'Workflows' webservices
    PATH: /{apiVersion}/workflows
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Workflow, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def update_acl(self, members, action, data=None, **options):
        """
        Update the set of workflow permissions granted for the member.
        PATH: /{apiVersion}/workflows/acl/{members}/update

        :param dict data: JSON containing the parameters to update the
            permissions. (REQUIRED)
        :param str action: Action to be performed [ADD, SET, REMOVE or RESET].
            Allowed values: ['SET ADD REMOVE RESET'] (REQUIRED)
        :param str members: Comma separated list of user or group ids.
            (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        options['action'] = action
        return self._post(category='workflows', resource='update', subcategory='acl', second_query_id=members, data=data, **options)

    def create(self, data=None, **options):
        """
        Create a workflow.
        PATH: /{apiVersion}/workflows/create

        :param dict data: JSON containing workflow information. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='workflows', resource='create', data=data, **options)

    def distinct(self, field, **options):
        """
        Workflow distinct method.
        PATH: /{apiVersion}/workflows/distinct

        :param str field: Comma separated list of fields for which to obtain
            the distinct values. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str id: Comma separated list of workflow IDs up to a maximum of
            100. Also admits basic regular expressions using the operator '~',
            i.e. '~{perl-regex}' e.g. '~value' for case sensitive, '~/value/i'
            for case insensitive search.
        :param str name: Comma separated list of workflow names up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str uuid: Comma separated list of workflow UUIDs up to a
            maximum of 100.
        :param str tags: Comma separated list of tags.
        :param bool draft: Boolean field indicating whether the workflow is a
            draft or not.
        :param str internal.registration_user_id: UserId that created the
            workflow.
        :param str manager.id: Id of the workflow system (Allowed values:
            NEXTFLOW).
        :param str type: Workflow type. Allowed types:
            [CLINICAL_INTERPRETATION, SECONDARY_ANALYSIS, RESEARCH or OTHER].
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str acl: Filter entries for which a user has the provided
            permissions. Format: acl={user}:{permissions}. Example:
            acl=john:WRITE,WRITE_ANNOTATIONS will return all entries for which
            user john has both WRITE and WRITE_ANNOTATIONS permissions. Only
            study owners or administrators can query by this field. .
        :param str release: Release when it was created.
        :param int snapshot: Snapshot value (Latest version of the entry in
            the specified release).
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        options['field'] = field
        return self._get(category='workflows', resource='distinct', **options)

    def import_workflow(self, data=None, **options):
        """
        Import a workflow.
        PATH: /{apiVersion}/workflows/import

        :param dict data: Repository parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        return self._post(category='workflows', resource='import', data=data, **options)

    def run(self, data=None, **options):
        """
        Execute a workflow analysis.
        PATH: /{apiVersion}/workflows/run

        :param dict data: Workflow tool run parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='workflows', resource='run', data=data, **options)

    def search(self, **options):
        """
        Workflow search method.
        PATH: /{apiVersion}/workflows/search

        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str id: Comma separated list of workflow IDs up to a maximum of
            100. Also admits basic regular expressions using the operator '~',
            i.e. '~{perl-regex}' e.g. '~value' for case sensitive, '~/value/i'
            for case insensitive search.
        :param str name: Comma separated list of workflow names up to a
            maximum of 100. Also admits basic regular expressions using the
            operator '~', i.e. '~{perl-regex}' e.g. '~value' for case
            sensitive, '~/value/i' for case insensitive search.
        :param str uuid: Comma separated list of workflow UUIDs up to a
            maximum of 100.
        :param str tags: Comma separated list of tags.
        :param bool draft: Boolean field indicating whether the workflow is a
            draft or not.
        :param str internal.registration_user_id: UserId that created the
            workflow.
        :param str manager.id: Id of the workflow system (Allowed values:
            NEXTFLOW).
        :param str type: Workflow type. Allowed types:
            [CLINICAL_INTERPRETATION, SECONDARY_ANALYSIS, RESEARCH or OTHER].
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str acl: Filter entries for which a user has the provided
            permissions. Format: acl={user}:{permissions}. Example:
            acl=john:WRITE,WRITE_ANNOTATIONS will return all entries for which
            user john has both WRITE and WRITE_ANNOTATIONS permissions. Only
            study owners or administrators can query by this field. .
        :param str release: Release when it was created.
        :param int snapshot: Snapshot value (Latest version of the entry in
            the specified release).
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='workflows', resource='search', **options)

    def update(self, workflow_id, data=None, **options):
        """
        Update some workflow attributes.
        PATH: /{apiVersion}/workflows/{workflowId}/update

        :param str workflow_id: Comma separated list workflow IDs or UUIDs up
            to a maximum of 100. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        :param dict data: body.
        """

        return self._post(category='workflows', resource='update', query_id=workflow_id, data=data, **options)

    def acl(self, workflows, **options):
        """
        Returns the acl of the workflows. If member is provided, it will only
            return the acl for the member.
        PATH: /{apiVersion}/workflows/{workflows}/acl

        :param str workflows: Comma separated list workflow IDs or UUIDs up to
            a maximum of 100. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str member: User or group id.
        :param bool silent: Boolean to retrieve all possible entries that are
            queried for, false to raise an exception whenever one of the
            entries looked for cannot be shown for whichever reason.
        """

        return self._get(category='workflows', resource='acl', query_id=workflows, **options)

    def delete(self, workflows, **options):
        """
        Delete workflows.
        PATH: /{apiVersion}/workflows/{workflows}/delete

        :param str workflows: Comma separated list workflow IDs or UUIDs up to
            a maximum of 100. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        return self._delete(category='workflows', resource='delete', query_id=workflows, **options)

    def info(self, workflows, **options):
        """
        Get workflow information.
        PATH: /{apiVersion}/workflows/{workflows}/info

        :param str workflows: Comma separated list sample IDs or UUIDs up to a
            maximum of 100. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str version: Comma separated list of workflow versions. 'all'
            to get all the workflow versions. Not supported if multiple
            workflow ids are provided.
        :param bool deleted: Boolean to retrieve deleted entries.
        """

        return self._get(category='workflows', resource='info', query_id=workflows, **options)

