# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetBranchResult',
    'AwaitableGetBranchResult',
    'get_branch',
    'get_branch_output',
]

@pulumi.output_type
class GetBranchResult:
    """
    A collection of values returned by getBranch.
    """
    def __init__(__self__, branch=None, etag=None, id=None, ref=None, repository=None, sha=None):
        if branch and not isinstance(branch, str):
            raise TypeError("Expected argument 'branch' to be a str")
        pulumi.set(__self__, "branch", branch)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ref and not isinstance(ref, str):
            raise TypeError("Expected argument 'ref' to be a str")
        pulumi.set(__self__, "ref", ref)
        if repository and not isinstance(repository, str):
            raise TypeError("Expected argument 'repository' to be a str")
        pulumi.set(__self__, "repository", repository)
        if sha and not isinstance(sha, str):
            raise TypeError("Expected argument 'sha' to be a str")
        pulumi.set(__self__, "sha", sha)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        An etag representing the Branch object.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> _builtins.str:
        """
        A string representing a branch reference, in the form of `refs/heads/<branch>`.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def sha(self) -> _builtins.str:
        """
        A string storing the reference's `HEAD` commit's SHA1.
        """
        return pulumi.get(self, "sha")


class AwaitableGetBranchResult(GetBranchResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBranchResult(
            branch=self.branch,
            etag=self.etag,
            id=self.id,
            ref=self.ref,
            repository=self.repository,
            sha=self.sha)


def get_branch(branch: Optional[_builtins.str] = None,
               repository: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBranchResult:
    """
    Use this data source to retrieve information about a repository branch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    development = github.get_branch(repository="example",
        branch="development")
    ```


    :param _builtins.str branch: The repository branch to retrieve.
    :param _builtins.str repository: The GitHub repository name.
    """
    __args__ = dict()
    __args__['branch'] = branch
    __args__['repository'] = repository
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getBranch:getBranch', __args__, opts=opts, typ=GetBranchResult).value

    return AwaitableGetBranchResult(
        branch=pulumi.get(__ret__, 'branch'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        ref=pulumi.get(__ret__, 'ref'),
        repository=pulumi.get(__ret__, 'repository'),
        sha=pulumi.get(__ret__, 'sha'))
def get_branch_output(branch: Optional[pulumi.Input[_builtins.str]] = None,
                      repository: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBranchResult]:
    """
    Use this data source to retrieve information about a repository branch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    development = github.get_branch(repository="example",
        branch="development")
    ```


    :param _builtins.str branch: The repository branch to retrieve.
    :param _builtins.str repository: The GitHub repository name.
    """
    __args__ = dict()
    __args__['branch'] = branch
    __args__['repository'] = repository
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getBranch:getBranch', __args__, opts=opts, typ=GetBranchResult)
    return __ret__.apply(lambda __response__: GetBranchResult(
        branch=pulumi.get(__response__, 'branch'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        ref=pulumi.get(__response__, 'ref'),
        repository=pulumi.get(__response__, 'repository'),
        sha=pulumi.get(__response__, 'sha')))
