# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IssueLabelsArgs', 'IssueLabels']

@pulumi.input_type
class IssueLabelsArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]] = None):
        """
        The set of arguments for constructing a IssueLabels resource.
        :param pulumi.Input[_builtins.str] repository: The GitHub repository
        :param pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]] labels: List of labels
        """
        pulumi.set(__self__, "repository", repository)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Input[_builtins.str]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]]:
        """
        List of labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class _IssueLabelsState:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IssueLabels resources.
        :param pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]] labels: List of labels
        :param pulumi.Input[_builtins.str] repository: The GitHub repository
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]]:
        """
        List of labels
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IssueLabelsLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)


@pulumi.type_token("github:index/issueLabels:IssueLabels")
class IssueLabels(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IssueLabelsLabelArgs', 'IssueLabelsLabelArgsDict']]]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides GitHub issue labels resource.

        This resource allows you to create and manage issue labels within your
        GitHub organization.

        > Note: IssueLabels cannot be used in conjunction with IssueLabel or they will fight over what your policy should be.

        This resource is authoritative. For adding a label to a repo in a non-authoritative manner, use IssueLabel instead.

        If you change the case of a label's name, its' color, or description, this resource will edit the existing label to match the new values. However, if you change the name of a label, this resource will create a new label with the new name and delete the old label. Beware that this will remove the label from any issues it was previously attached to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Create a new, red colored label
        test_repo = github.IssueLabels("test_repo",
            repository="test-repo",
            labels=[
                {
                    "name": "Urgent",
                    "color": "FF0000",
                },
                {
                    "name": "Critical",
                    "color": "FF0000",
                },
            ])
        ```

        ## Import

        GitHub Issue Labels can be imported using the repository `name`, e.g.

        ```sh
        $ pulumi import github:index/issueLabels:IssueLabels test_repo test_repo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IssueLabelsLabelArgs', 'IssueLabelsLabelArgsDict']]]] labels: List of labels
        :param pulumi.Input[_builtins.str] repository: The GitHub repository
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IssueLabelsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides GitHub issue labels resource.

        This resource allows you to create and manage issue labels within your
        GitHub organization.

        > Note: IssueLabels cannot be used in conjunction with IssueLabel or they will fight over what your policy should be.

        This resource is authoritative. For adding a label to a repo in a non-authoritative manner, use IssueLabel instead.

        If you change the case of a label's name, its' color, or description, this resource will edit the existing label to match the new values. However, if you change the name of a label, this resource will create a new label with the new name and delete the old label. Beware that this will remove the label from any issues it was previously attached to.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Create a new, red colored label
        test_repo = github.IssueLabels("test_repo",
            repository="test-repo",
            labels=[
                {
                    "name": "Urgent",
                    "color": "FF0000",
                },
                {
                    "name": "Critical",
                    "color": "FF0000",
                },
            ])
        ```

        ## Import

        GitHub Issue Labels can be imported using the repository `name`, e.g.

        ```sh
        $ pulumi import github:index/issueLabels:IssueLabels test_repo test_repo
        ```

        :param str resource_name: The name of the resource.
        :param IssueLabelsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IssueLabelsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IssueLabelsLabelArgs', 'IssueLabelsLabelArgsDict']]]]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IssueLabelsArgs.__new__(IssueLabelsArgs)

            __props__.__dict__["labels"] = labels
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
        super(IssueLabels, __self__).__init__(
            'github:index/issueLabels:IssueLabels',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IssueLabelsLabelArgs', 'IssueLabelsLabelArgsDict']]]]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None) -> 'IssueLabels':
        """
        Get an existing IssueLabels resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IssueLabelsLabelArgs', 'IssueLabelsLabelArgsDict']]]] labels: List of labels
        :param pulumi.Input[_builtins.str] repository: The GitHub repository
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IssueLabelsState.__new__(_IssueLabelsState)

        __props__.__dict__["labels"] = labels
        __props__.__dict__["repository"] = repository
        return IssueLabels(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.IssueLabelsLabel']]]:
        """
        List of labels
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        The GitHub repository
        """
        return pulumi.get(self, "repository")

