# Generated by Django 4.2.23 on 2025-08-13 15:10

from django.db import migrations, models
import django.db.models.deletion
import pulp_maven.app.models


class Migration(migrations.Migration):

    replaces = [
        ("maven", "0001_initial"),
        ("maven", "0002_maven_related_names"),
        ("maven", "0003_mavenrepository"),
        ("maven", "0004_swap_distribution_models"),
        ("maven", "0005_mavenmetadata"),
        ("maven", "0006_alter_mavenartifact_content_ptr_and_more"),
    ]

    initial = True

    dependencies = [
        ("core", "0106_alter_artifactdistribution_distribution_ptr_and_more"),
        ("core", "0098_pulp_labels"),
        ("core", "0091_systemid"),
    ]

    operations = [
        migrations.CreateModel(
            name="MavenArtifact",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("group_id", models.CharField(max_length=255)),
                ("artifact_id", models.CharField(max_length=255)),
                ("version", models.CharField(max_length=255)),
                ("filename", models.CharField(max_length=255)),
            ],
            options={
                "unique_together": {("group_id", "artifact_id", "version", "filename")},
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="MavenDistribution",
            fields=[
                (
                    "distribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.distribution",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.distribution",),
        ),
        migrations.CreateModel(
            name="MavenMetadata",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("group_id", models.CharField(max_length=255)),
                ("artifact_id", models.CharField(max_length=255)),
                ("version", models.CharField(max_length=255, null=True)),
                ("filename", models.CharField(max_length=255)),
                ("sha256", models.CharField(db_index=True, max_length=64, unique=True)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("group_id", "artifact_id", "version", "filename", "sha256")},
            },
            bases=(pulp_maven.app.models.MavenContentMixin, "core.content"),
        ),
        migrations.CreateModel(
            name="MavenRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.remote",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="MavenRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.repository",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.repository",),
        ),
    ]
