"""
Main interface for kinesisanalyticsv2 service type definitions.

Usage::

    from mypy_boto3.kinesisanalyticsv2.type_defs import ClientAddApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionTypeDef

    data: ClientAddApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionTypeDef = {...}
"""
from __future__ import annotations

from datetime import datetime
import sys
from typing import Dict, List

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "ClientAddApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionTypeDef",
    "ClientAddApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef",
    "ClientAddApplicationCloudWatchLoggingOptionResponseTypeDef",
    "ClientAddApplicationInputInputInputParallelismTypeDef",
    "ClientAddApplicationInputInputInputProcessingConfigurationInputLambdaProcessorTypeDef",
    "ClientAddApplicationInputInputInputProcessingConfigurationTypeDef",
    "ClientAddApplicationInputInputInputSchemaRecordColumnsTypeDef",
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientAddApplicationInputInputInputSchemaRecordFormatTypeDef",
    "ClientAddApplicationInputInputInputSchemaTypeDef",
    "ClientAddApplicationInputInputKinesisFirehoseInputTypeDef",
    "ClientAddApplicationInputInputKinesisStreamsInputTypeDef",
    "ClientAddApplicationInputInputTypeDef",
    "ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationInputLambdaProcessorTypeDef",
    "ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationTypeDef",
    "ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    "ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionTypeDef",
    "ClientAddApplicationInputProcessingConfigurationResponseTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputParallelismTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordColumnsTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsInputStartingPositionConfigurationTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    "ClientAddApplicationInputResponseInputDescriptionsTypeDef",
    "ClientAddApplicationInputResponseTypeDef",
    "ClientAddApplicationOutputOutputDestinationSchemaTypeDef",
    "ClientAddApplicationOutputOutputKinesisFirehoseOutputTypeDef",
    "ClientAddApplicationOutputOutputKinesisStreamsOutputTypeDef",
    "ClientAddApplicationOutputOutputLambdaOutputTypeDef",
    "ClientAddApplicationOutputOutputTypeDef",
    "ClientAddApplicationOutputResponseOutputDescriptionsDestinationSchemaTypeDef",
    "ClientAddApplicationOutputResponseOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    "ClientAddApplicationOutputResponseOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    "ClientAddApplicationOutputResponseOutputDescriptionsLambdaOutputDescriptionTypeDef",
    "ClientAddApplicationOutputResponseOutputDescriptionsTypeDef",
    "ClientAddApplicationOutputResponseTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordColumnsTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceS3ReferenceDataSourceTypeDef",
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsTypeDef",
    "ClientAddApplicationReferenceDataSourceResponseTypeDef",
    "ClientAddApplicationVpcConfigurationResponseVpcConfigurationDescriptionTypeDef",
    "ClientAddApplicationVpcConfigurationResponseTypeDef",
    "ClientAddApplicationVpcConfigurationVpcConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationTypeDef",
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentTypeDef",
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationApplicationSnapshotConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupsTypeDef",
    "ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesTypeDef",
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputParallelismTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationInputLambdaProcessorTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordColumnsTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisFirehoseInputTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisStreamsInputTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsDestinationSchemaTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisFirehoseOutputTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisStreamsOutputTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsLambdaOutputTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordColumnsTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesS3ReferenceDataSourceTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesTypeDef",
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationTypeDef",
    "ClientCreateApplicationApplicationConfigurationVpcConfigurationsTypeDef",
    "ClientCreateApplicationApplicationConfigurationTypeDef",
    "ClientCreateApplicationCloudWatchLoggingOptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    "ClientCreateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    "ClientCreateApplicationResponseApplicationDetailTypeDef",
    "ClientCreateApplicationResponseTypeDef",
    "ClientCreateApplicationTagsTypeDef",
    "ClientDeleteApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef",
    "ClientDeleteApplicationCloudWatchLoggingOptionResponseTypeDef",
    "ClientDeleteApplicationInputProcessingConfigurationResponseTypeDef",
    "ClientDeleteApplicationOutputResponseTypeDef",
    "ClientDeleteApplicationReferenceDataSourceResponseTypeDef",
    "ClientDeleteApplicationVpcConfigurationResponseTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    "ClientDescribeApplicationResponseApplicationDetailTypeDef",
    "ClientDescribeApplicationResponseTypeDef",
    "ClientDescribeApplicationSnapshotResponseSnapshotDetailsTypeDef",
    "ClientDescribeApplicationSnapshotResponseTypeDef",
    "ClientDiscoverInputSchemaInputProcessingConfigurationInputLambdaProcessorTypeDef",
    "ClientDiscoverInputSchemaInputProcessingConfigurationTypeDef",
    "ClientDiscoverInputSchemaInputStartingPositionConfigurationTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaRecordColumnsTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatTypeDef",
    "ClientDiscoverInputSchemaResponseInputSchemaTypeDef",
    "ClientDiscoverInputSchemaResponseTypeDef",
    "ClientDiscoverInputSchemaS3ConfigurationTypeDef",
    "ClientListApplicationSnapshotsResponseSnapshotSummariesTypeDef",
    "ClientListApplicationSnapshotsResponseTypeDef",
    "ClientListApplicationsResponseApplicationSummariesTypeDef",
    "ClientListApplicationsResponseTypeDef",
    "ClientListTagsForResourceResponseTagsTypeDef",
    "ClientListTagsForResourceResponseTypeDef",
    "ClientStartApplicationRunConfigurationApplicationRestoreConfigurationTypeDef",
    "ClientStartApplicationRunConfigurationFlinkRunConfigurationTypeDef",
    "ClientStartApplicationRunConfigurationSqlRunConfigurationsInputStartingPositionConfigurationTypeDef",
    "ClientStartApplicationRunConfigurationSqlRunConfigurationsTypeDef",
    "ClientStartApplicationRunConfigurationTypeDef",
    "ClientTagResourceTagsTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateS3ContentLocationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationSnapshotConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesPropertyGroupsTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateCheckpointConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateMonitoringConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateParallelismConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputParallelismUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateInputLambdaProcessorUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordColumnUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersCSVMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersJSONMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisFirehoseInputUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisStreamsInputUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesDestinationSchemaUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisFirehoseOutputUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisStreamsOutputUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesLambdaOutputUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordColumnsTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesS3ReferenceDataSourceUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateVpcConfigurationUpdatesTypeDef",
    "ClientUpdateApplicationApplicationConfigurationUpdateTypeDef",
    "ClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    "ClientUpdateApplicationResponseApplicationDetailTypeDef",
    "ClientUpdateApplicationResponseTypeDef",
    "ClientUpdateApplicationRunConfigurationUpdateApplicationRestoreConfigurationTypeDef",
    "ClientUpdateApplicationRunConfigurationUpdateFlinkRunConfigurationTypeDef",
    "ClientUpdateApplicationRunConfigurationUpdateTypeDef",
    "SnapshotDetailsTypeDef",
    "ListApplicationSnapshotsResponseTypeDef",
    "ApplicationSummaryTypeDef",
    "ListApplicationsResponseTypeDef",
    "PaginatorConfigTypeDef",
)

ClientAddApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionTypeDef = TypedDict(
    "ClientAddApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionTypeDef",
    {"LogStreamARN": str},
)

ClientAddApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef = TypedDict(
    "ClientAddApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef",
    {"CloudWatchLoggingOptionId": str, "LogStreamARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationCloudWatchLoggingOptionResponseTypeDef = TypedDict(
    "ClientAddApplicationCloudWatchLoggingOptionResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "CloudWatchLoggingOptionDescriptions": List[
            ClientAddApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientAddApplicationInputInputInputParallelismTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputParallelismTypeDef", {"Count": int}, total=False
)

ClientAddApplicationInputInputInputProcessingConfigurationInputLambdaProcessorTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputProcessingConfigurationInputLambdaProcessorTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientAddApplicationInputInputInputProcessingConfigurationTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputProcessingConfigurationTypeDef",
    {
        "InputLambdaProcessor": ClientAddApplicationInputInputInputProcessingConfigurationInputLambdaProcessorTypeDef
    },
    total=False,
)

ClientAddApplicationInputInputInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationInputInputInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientAddApplicationInputInputInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationInputInputInputSchemaTypeDef = TypedDict(
    "ClientAddApplicationInputInputInputSchemaTypeDef",
    {
        "RecordFormat": ClientAddApplicationInputInputInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[ClientAddApplicationInputInputInputSchemaRecordColumnsTypeDef],
    },
    total=False,
)

ClientAddApplicationInputInputKinesisFirehoseInputTypeDef = TypedDict(
    "ClientAddApplicationInputInputKinesisFirehoseInputTypeDef", {"ResourceARN": str}, total=False
)

ClientAddApplicationInputInputKinesisStreamsInputTypeDef = TypedDict(
    "ClientAddApplicationInputInputKinesisStreamsInputTypeDef", {"ResourceARN": str}, total=False
)

_RequiredClientAddApplicationInputInputTypeDef = TypedDict(
    "_RequiredClientAddApplicationInputInputTypeDef", {"NamePrefix": str}
)
_OptionalClientAddApplicationInputInputTypeDef = TypedDict(
    "_OptionalClientAddApplicationInputInputTypeDef",
    {
        "InputProcessingConfiguration": ClientAddApplicationInputInputInputProcessingConfigurationTypeDef,
        "KinesisStreamsInput": ClientAddApplicationInputInputKinesisStreamsInputTypeDef,
        "KinesisFirehoseInput": ClientAddApplicationInputInputKinesisFirehoseInputTypeDef,
        "InputParallelism": ClientAddApplicationInputInputInputParallelismTypeDef,
        "InputSchema": ClientAddApplicationInputInputInputSchemaTypeDef,
    },
    total=False,
)


class ClientAddApplicationInputInputTypeDef(
    _RequiredClientAddApplicationInputInputTypeDef, _OptionalClientAddApplicationInputInputTypeDef
):
    pass


ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationInputLambdaProcessorTypeDef = TypedDict(
    "ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationInputLambdaProcessorTypeDef",
    {"ResourceARN": str},
)

ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationTypeDef = TypedDict(
    "ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationTypeDef",
    {
        "InputLambdaProcessor": ClientAddApplicationInputProcessingConfigurationInputProcessingConfigurationInputLambdaProcessorTypeDef
    },
)

ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionTypeDef",
    {
        "InputLambdaProcessorDescription": ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef
    },
    total=False,
)

ClientAddApplicationInputProcessingConfigurationResponseTypeDef = TypedDict(
    "ClientAddApplicationInputProcessingConfigurationResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "InputId": str,
        "InputProcessingConfigurationDescription": ClientAddApplicationInputProcessingConfigurationResponseInputProcessingConfigurationDescriptionTypeDef,
    },
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputParallelismTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputParallelismTypeDef",
    {"Count": int},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    {
        "InputLambdaProcessorDescription": ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef
    },
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputSchemaTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputSchemaTypeDef",
    {
        "RecordFormat": ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientAddApplicationInputResponseInputDescriptionsInputSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsKinesisFirehoseInputDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsKinesisStreamsInputDescriptionTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationInputResponseInputDescriptionsTypeDef = TypedDict(
    "ClientAddApplicationInputResponseInputDescriptionsTypeDef",
    {
        "InputId": str,
        "NamePrefix": str,
        "InAppStreamNames": List[str],
        "InputProcessingConfigurationDescription": ClientAddApplicationInputResponseInputDescriptionsInputProcessingConfigurationDescriptionTypeDef,
        "KinesisStreamsInputDescription": ClientAddApplicationInputResponseInputDescriptionsKinesisStreamsInputDescriptionTypeDef,
        "KinesisFirehoseInputDescription": ClientAddApplicationInputResponseInputDescriptionsKinesisFirehoseInputDescriptionTypeDef,
        "InputSchema": ClientAddApplicationInputResponseInputDescriptionsInputSchemaTypeDef,
        "InputParallelism": ClientAddApplicationInputResponseInputDescriptionsInputParallelismTypeDef,
        "InputStartingPositionConfiguration": ClientAddApplicationInputResponseInputDescriptionsInputStartingPositionConfigurationTypeDef,
    },
    total=False,
)

ClientAddApplicationInputResponseTypeDef = TypedDict(
    "ClientAddApplicationInputResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "InputDescriptions": List[ClientAddApplicationInputResponseInputDescriptionsTypeDef],
    },
    total=False,
)

ClientAddApplicationOutputOutputDestinationSchemaTypeDef = TypedDict(
    "ClientAddApplicationOutputOutputDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientAddApplicationOutputOutputKinesisFirehoseOutputTypeDef = TypedDict(
    "ClientAddApplicationOutputOutputKinesisFirehoseOutputTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientAddApplicationOutputOutputKinesisStreamsOutputTypeDef = TypedDict(
    "ClientAddApplicationOutputOutputKinesisStreamsOutputTypeDef", {"ResourceARN": str}, total=False
)

ClientAddApplicationOutputOutputLambdaOutputTypeDef = TypedDict(
    "ClientAddApplicationOutputOutputLambdaOutputTypeDef", {"ResourceARN": str}, total=False
)

_RequiredClientAddApplicationOutputOutputTypeDef = TypedDict(
    "_RequiredClientAddApplicationOutputOutputTypeDef", {"Name": str}
)
_OptionalClientAddApplicationOutputOutputTypeDef = TypedDict(
    "_OptionalClientAddApplicationOutputOutputTypeDef",
    {
        "KinesisStreamsOutput": ClientAddApplicationOutputOutputKinesisStreamsOutputTypeDef,
        "KinesisFirehoseOutput": ClientAddApplicationOutputOutputKinesisFirehoseOutputTypeDef,
        "LambdaOutput": ClientAddApplicationOutputOutputLambdaOutputTypeDef,
        "DestinationSchema": ClientAddApplicationOutputOutputDestinationSchemaTypeDef,
    },
    total=False,
)


class ClientAddApplicationOutputOutputTypeDef(
    _RequiredClientAddApplicationOutputOutputTypeDef,
    _OptionalClientAddApplicationOutputOutputTypeDef,
):
    pass


ClientAddApplicationOutputResponseOutputDescriptionsDestinationSchemaTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseOutputDescriptionsDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientAddApplicationOutputResponseOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationOutputResponseOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationOutputResponseOutputDescriptionsLambdaOutputDescriptionTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseOutputDescriptionsLambdaOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientAddApplicationOutputResponseOutputDescriptionsTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseOutputDescriptionsTypeDef",
    {
        "OutputId": str,
        "Name": str,
        "KinesisStreamsOutputDescription": ClientAddApplicationOutputResponseOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef,
        "KinesisFirehoseOutputDescription": ClientAddApplicationOutputResponseOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef,
        "LambdaOutputDescription": ClientAddApplicationOutputResponseOutputDescriptionsLambdaOutputDescriptionTypeDef,
        "DestinationSchema": ClientAddApplicationOutputResponseOutputDescriptionsDestinationSchemaTypeDef,
    },
    total=False,
)

ClientAddApplicationOutputResponseTypeDef = TypedDict(
    "ClientAddApplicationOutputResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "OutputDescriptions": List[ClientAddApplicationOutputResponseOutputDescriptionsTypeDef],
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceReferenceDataSourceS3ReferenceDataSourceTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceReferenceDataSourceS3ReferenceDataSourceTypeDef",
    {"BucketARN": str, "FileKey": str},
    total=False,
)

_RequiredClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef = TypedDict(
    "_RequiredClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef", {"TableName": str}
)
_OptionalClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef = TypedDict(
    "_OptionalClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef",
    {
        "S3ReferenceDataSource": ClientAddApplicationReferenceDataSourceReferenceDataSourceS3ReferenceDataSourceTypeDef,
        "ReferenceSchema": ClientAddApplicationReferenceDataSourceReferenceDataSourceReferenceSchemaTypeDef,
    },
    total=False,
)


class ClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef(
    _RequiredClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef,
    _OptionalClientAddApplicationReferenceDataSourceReferenceDataSourceTypeDef,
):
    pass


ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ReferenceRoleARN": str},
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsTypeDef",
    {
        "ReferenceId": str,
        "TableName": str,
        "S3ReferenceDataSourceDescription": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef,
        "ReferenceSchema": ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsReferenceSchemaTypeDef,
    },
    total=False,
)

ClientAddApplicationReferenceDataSourceResponseTypeDef = TypedDict(
    "ClientAddApplicationReferenceDataSourceResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "ReferenceDataSourceDescriptions": List[
            ClientAddApplicationReferenceDataSourceResponseReferenceDataSourceDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientAddApplicationVpcConfigurationResponseVpcConfigurationDescriptionTypeDef = TypedDict(
    "ClientAddApplicationVpcConfigurationResponseVpcConfigurationDescriptionTypeDef",
    {
        "VpcConfigurationId": str,
        "VpcId": str,
        "SubnetIds": List[str],
        "SecurityGroupIds": List[str],
    },
    total=False,
)

ClientAddApplicationVpcConfigurationResponseTypeDef = TypedDict(
    "ClientAddApplicationVpcConfigurationResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "VpcConfigurationDescription": ClientAddApplicationVpcConfigurationResponseVpcConfigurationDescriptionTypeDef,
    },
    total=False,
)

_RequiredClientAddApplicationVpcConfigurationVpcConfigurationTypeDef = TypedDict(
    "_RequiredClientAddApplicationVpcConfigurationVpcConfigurationTypeDef", {"SubnetIds": List[str]}
)
_OptionalClientAddApplicationVpcConfigurationVpcConfigurationTypeDef = TypedDict(
    "_OptionalClientAddApplicationVpcConfigurationVpcConfigurationTypeDef",
    {"SecurityGroupIds": List[str]},
    total=False,
)


class ClientAddApplicationVpcConfigurationVpcConfigurationTypeDef(
    _RequiredClientAddApplicationVpcConfigurationVpcConfigurationTypeDef,
    _OptionalClientAddApplicationVpcConfigurationVpcConfigurationTypeDef,
):
    pass


ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationTypeDef",
    {"BucketARN": str, "FileKey": str, "ObjectVersion": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentTypeDef",
    {
        "TextContent": str,
        "ZipFileContent": bytes,
        "S3ContentLocation": ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentS3ContentLocationTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationTypeDef",
    {
        "CodeContent": ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentTypeDef,
        "CodeContentType": Literal["PLAINTEXT", "ZIPFILE"],
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationApplicationSnapshotConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationApplicationSnapshotConfigurationTypeDef",
    {"SnapshotsEnabled": bool},
    total=False,
)

ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupsTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupsTypeDef",
    {"PropertyGroupId": str, "PropertyMap": Dict[str, str]},
    total=False,
)

ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesTypeDef",
    {
        "PropertyGroups": List[
            ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupsTypeDef
        ]
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "CheckpointingEnabled": bool,
        "CheckpointInterval": int,
        "MinPauseBetweenCheckpoints": int,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "MetricsLevel": Literal["APPLICATION", "TASK", "OPERATOR", "PARALLELISM"],
        "LogLevel": Literal["INFO", "WARN", "ERROR", "DEBUG"],
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "Parallelism": int,
        "ParallelismPerKPU": int,
        "AutoScalingEnabled": bool,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationTypeDef",
    {
        "CheckpointConfiguration": ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationTypeDef,
        "MonitoringConfiguration": ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationTypeDef,
        "ParallelismConfiguration": ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputParallelismTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputParallelismTypeDef",
    {"Count": int},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationInputLambdaProcessorTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationInputLambdaProcessorTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationTypeDef",
    {
        "InputLambdaProcessor": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationInputLambdaProcessorTypeDef
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaTypeDef",
    {
        "RecordFormat": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisFirehoseInputTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisFirehoseInputTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisStreamsInputTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisStreamsInputTypeDef",
    {"ResourceARN": str},
    total=False,
)

_RequiredClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef = TypedDict(
    "_RequiredClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef",
    {"NamePrefix": str},
)
_OptionalClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef = TypedDict(
    "_OptionalClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef",
    {
        "InputProcessingConfiguration": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputProcessingConfigurationTypeDef,
        "KinesisStreamsInput": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisStreamsInputTypeDef,
        "KinesisFirehoseInput": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsKinesisFirehoseInputTypeDef,
        "InputParallelism": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputParallelismTypeDef,
        "InputSchema": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsInputSchemaTypeDef,
    },
    total=False,
)


class ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef(
    _RequiredClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef,
    _OptionalClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef,
):
    pass


ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsDestinationSchemaTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisFirehoseOutputTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisFirehoseOutputTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisStreamsOutputTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisStreamsOutputTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsLambdaOutputTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsLambdaOutputTypeDef",
    {"ResourceARN": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsTypeDef",
    {
        "Name": str,
        "KinesisStreamsOutput": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisStreamsOutputTypeDef,
        "KinesisFirehoseOutput": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsKinesisFirehoseOutputTypeDef,
        "LambdaOutput": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsLambdaOutputTypeDef,
        "DestinationSchema": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsDestinationSchemaTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesS3ReferenceDataSourceTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesS3ReferenceDataSourceTypeDef",
    {"BucketARN": str, "FileKey": str},
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesTypeDef",
    {
        "TableName": str,
        "S3ReferenceDataSource": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesS3ReferenceDataSourceTypeDef,
        "ReferenceSchema": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesReferenceSchemaTypeDef,
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationTypeDef",
    {
        "Inputs": List[
            ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationInputsTypeDef
        ],
        "Outputs": List[
            ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationOutputsTypeDef
        ],
        "ReferenceDataSources": List[
            ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourcesTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationApplicationConfigurationVpcConfigurationsTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationVpcConfigurationsTypeDef",
    {"SubnetIds": List[str], "SecurityGroupIds": List[str]},
    total=False,
)

ClientCreateApplicationApplicationConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationApplicationConfigurationTypeDef",
    {
        "SqlApplicationConfiguration": ClientCreateApplicationApplicationConfigurationSqlApplicationConfigurationTypeDef,
        "FlinkApplicationConfiguration": ClientCreateApplicationApplicationConfigurationFlinkApplicationConfigurationTypeDef,
        "EnvironmentProperties": ClientCreateApplicationApplicationConfigurationEnvironmentPropertiesTypeDef,
        "ApplicationCodeConfiguration": ClientCreateApplicationApplicationConfigurationApplicationCodeConfigurationTypeDef,
        "ApplicationSnapshotConfiguration": ClientCreateApplicationApplicationConfigurationApplicationSnapshotConfigurationTypeDef,
        "VpcConfigurations": List[
            ClientCreateApplicationApplicationConfigurationVpcConfigurationsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationCloudWatchLoggingOptionsTypeDef = TypedDict(
    "ClientCreateApplicationCloudWatchLoggingOptionsTypeDef", {"LogStreamARN": str}
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ObjectVersion": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    {
        "TextContent": str,
        "CodeMD5": str,
        "CodeSize": int,
        "S3ApplicationCodeLocationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    {
        "CodeContentType": Literal["PLAINTEXT", "ZIPFILE"],
        "CodeContentDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    {"SnapshotsEnabled": bool},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    {"PropertyGroupId": str, "PropertyMap": Dict[str, str]},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    {
        "PropertyGroupDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef
        ]
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "CheckpointingEnabled": bool,
        "CheckpointInterval": int,
        "MinPauseBetweenCheckpoints": int,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "MetricsLevel": Literal["APPLICATION", "TASK", "OPERATOR", "PARALLELISM"],
        "LogLevel": Literal["INFO", "WARN", "ERROR", "DEBUG"],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "Parallelism": int,
        "ParallelismPerKPU": int,
        "CurrentParallelism": int,
        "AutoScalingEnabled": bool,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    {
        "CheckpointConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef,
        "MonitoringConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef,
        "ParallelismConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef,
        "JobPlanDescription": str,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreType": Literal[
            "SKIP_RESTORE_FROM_SNAPSHOT",
            "RESTORE_FROM_LATEST_SNAPSHOT",
            "RESTORE_FROM_CUSTOM_SNAPSHOT",
        ],
        "SnapshotName": str,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    {"Count": int},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    {
        "InputLambdaProcessorDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    {
        "RecordFormat": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    {
        "InputId": str,
        "NamePrefix": str,
        "InAppStreamNames": List[str],
        "InputProcessingConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef,
        "KinesisStreamsInputDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef,
        "KinesisFirehoseInputDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef,
        "InputSchema": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef,
        "InputParallelism": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef,
        "InputStartingPositionConfiguration": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    {
        "OutputId": str,
        "Name": str,
        "KinesisStreamsOutputDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef,
        "KinesisFirehoseOutputDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef,
        "LambdaOutputDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef,
        "DestinationSchema": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ReferenceRoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    {
        "ReferenceId": str,
        "TableName": str,
        "S3ReferenceDataSourceDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef,
        "ReferenceSchema": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef,
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    {
        "InputDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef
        ],
        "OutputDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef
        ],
        "ReferenceDataSourceDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    {
        "VpcConfigurationId": str,
        "VpcId": str,
        "SubnetIds": List[str],
        "SecurityGroupIds": List[str],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    {
        "SqlApplicationConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef,
        "ApplicationCodeConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef,
        "RunConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef,
        "FlinkApplicationConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef,
        "EnvironmentPropertyDescriptions": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef,
        "ApplicationSnapshotConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef,
        "VpcConfigurationDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    {"CloudWatchLoggingOptionId": str, "LogStreamARN": str, "RoleARN": str},
    total=False,
)

ClientCreateApplicationResponseApplicationDetailTypeDef = TypedDict(
    "ClientCreateApplicationResponseApplicationDetailTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationDescription": str,
        "ApplicationName": str,
        "RuntimeEnvironment": Literal["SQL-1_0", "FLINK-1_6", "FLINK-1_8"],
        "ServiceExecutionRole": str,
        "ApplicationStatus": Literal[
            "DELETING", "STARTING", "STOPPING", "READY", "RUNNING", "UPDATING"
        ],
        "ApplicationVersionId": int,
        "CreateTimestamp": datetime,
        "LastUpdateTimestamp": datetime,
        "ApplicationConfigurationDescription": ClientCreateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef,
        "CloudWatchLoggingOptionDescriptions": List[
            ClientCreateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientCreateApplicationResponseTypeDef = TypedDict(
    "ClientCreateApplicationResponseTypeDef",
    {"ApplicationDetail": ClientCreateApplicationResponseApplicationDetailTypeDef},
    total=False,
)

_RequiredClientCreateApplicationTagsTypeDef = TypedDict(
    "_RequiredClientCreateApplicationTagsTypeDef", {"Key": str}
)
_OptionalClientCreateApplicationTagsTypeDef = TypedDict(
    "_OptionalClientCreateApplicationTagsTypeDef", {"Value": str}, total=False
)


class ClientCreateApplicationTagsTypeDef(
    _RequiredClientCreateApplicationTagsTypeDef, _OptionalClientCreateApplicationTagsTypeDef
):
    pass


ClientDeleteApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef = TypedDict(
    "ClientDeleteApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef",
    {"CloudWatchLoggingOptionId": str, "LogStreamARN": str, "RoleARN": str},
    total=False,
)

ClientDeleteApplicationCloudWatchLoggingOptionResponseTypeDef = TypedDict(
    "ClientDeleteApplicationCloudWatchLoggingOptionResponseTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationVersionId": int,
        "CloudWatchLoggingOptionDescriptions": List[
            ClientDeleteApplicationCloudWatchLoggingOptionResponseCloudWatchLoggingOptionDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientDeleteApplicationInputProcessingConfigurationResponseTypeDef = TypedDict(
    "ClientDeleteApplicationInputProcessingConfigurationResponseTypeDef",
    {"ApplicationARN": str, "ApplicationVersionId": int},
    total=False,
)

ClientDeleteApplicationOutputResponseTypeDef = TypedDict(
    "ClientDeleteApplicationOutputResponseTypeDef",
    {"ApplicationARN": str, "ApplicationVersionId": int},
    total=False,
)

ClientDeleteApplicationReferenceDataSourceResponseTypeDef = TypedDict(
    "ClientDeleteApplicationReferenceDataSourceResponseTypeDef",
    {"ApplicationARN": str, "ApplicationVersionId": int},
    total=False,
)

ClientDeleteApplicationVpcConfigurationResponseTypeDef = TypedDict(
    "ClientDeleteApplicationVpcConfigurationResponseTypeDef",
    {"ApplicationARN": str, "ApplicationVersionId": int},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ObjectVersion": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    {
        "TextContent": str,
        "CodeMD5": str,
        "CodeSize": int,
        "S3ApplicationCodeLocationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    {
        "CodeContentType": Literal["PLAINTEXT", "ZIPFILE"],
        "CodeContentDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    {"SnapshotsEnabled": bool},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    {"PropertyGroupId": str, "PropertyMap": Dict[str, str]},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    {
        "PropertyGroupDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef
        ]
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "CheckpointingEnabled": bool,
        "CheckpointInterval": int,
        "MinPauseBetweenCheckpoints": int,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "MetricsLevel": Literal["APPLICATION", "TASK", "OPERATOR", "PARALLELISM"],
        "LogLevel": Literal["INFO", "WARN", "ERROR", "DEBUG"],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "Parallelism": int,
        "ParallelismPerKPU": int,
        "CurrentParallelism": int,
        "AutoScalingEnabled": bool,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    {
        "CheckpointConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef,
        "MonitoringConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef,
        "ParallelismConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef,
        "JobPlanDescription": str,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreType": Literal[
            "SKIP_RESTORE_FROM_SNAPSHOT",
            "RESTORE_FROM_LATEST_SNAPSHOT",
            "RESTORE_FROM_CUSTOM_SNAPSHOT",
        ],
        "SnapshotName": str,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    {"Count": int},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    {
        "InputLambdaProcessorDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    {
        "RecordFormat": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    {
        "InputId": str,
        "NamePrefix": str,
        "InAppStreamNames": List[str],
        "InputProcessingConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef,
        "KinesisStreamsInputDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef,
        "KinesisFirehoseInputDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef,
        "InputSchema": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef,
        "InputParallelism": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef,
        "InputStartingPositionConfiguration": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    {
        "OutputId": str,
        "Name": str,
        "KinesisStreamsOutputDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef,
        "KinesisFirehoseOutputDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef,
        "LambdaOutputDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef,
        "DestinationSchema": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ReferenceRoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    {
        "ReferenceId": str,
        "TableName": str,
        "S3ReferenceDataSourceDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef,
        "ReferenceSchema": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef,
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    {
        "InputDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef
        ],
        "OutputDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef
        ],
        "ReferenceDataSourceDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    {
        "VpcConfigurationId": str,
        "VpcId": str,
        "SubnetIds": List[str],
        "SecurityGroupIds": List[str],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    {
        "SqlApplicationConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef,
        "ApplicationCodeConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef,
        "RunConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef,
        "FlinkApplicationConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef,
        "EnvironmentPropertyDescriptions": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef,
        "ApplicationSnapshotConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef,
        "VpcConfigurationDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    {"CloudWatchLoggingOptionId": str, "LogStreamARN": str, "RoleARN": str},
    total=False,
)

ClientDescribeApplicationResponseApplicationDetailTypeDef = TypedDict(
    "ClientDescribeApplicationResponseApplicationDetailTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationDescription": str,
        "ApplicationName": str,
        "RuntimeEnvironment": Literal["SQL-1_0", "FLINK-1_6", "FLINK-1_8"],
        "ServiceExecutionRole": str,
        "ApplicationStatus": Literal[
            "DELETING", "STARTING", "STOPPING", "READY", "RUNNING", "UPDATING"
        ],
        "ApplicationVersionId": int,
        "CreateTimestamp": datetime,
        "LastUpdateTimestamp": datetime,
        "ApplicationConfigurationDescription": ClientDescribeApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef,
        "CloudWatchLoggingOptionDescriptions": List[
            ClientDescribeApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientDescribeApplicationResponseTypeDef = TypedDict(
    "ClientDescribeApplicationResponseTypeDef",
    {"ApplicationDetail": ClientDescribeApplicationResponseApplicationDetailTypeDef},
    total=False,
)

ClientDescribeApplicationSnapshotResponseSnapshotDetailsTypeDef = TypedDict(
    "ClientDescribeApplicationSnapshotResponseSnapshotDetailsTypeDef",
    {
        "SnapshotName": str,
        "SnapshotStatus": Literal["CREATING", "READY", "DELETING", "FAILED"],
        "ApplicationVersionId": int,
        "SnapshotCreationTimestamp": datetime,
    },
    total=False,
)

ClientDescribeApplicationSnapshotResponseTypeDef = TypedDict(
    "ClientDescribeApplicationSnapshotResponseTypeDef",
    {"SnapshotDetails": ClientDescribeApplicationSnapshotResponseSnapshotDetailsTypeDef},
    total=False,
)

ClientDiscoverInputSchemaInputProcessingConfigurationInputLambdaProcessorTypeDef = TypedDict(
    "ClientDiscoverInputSchemaInputProcessingConfigurationInputLambdaProcessorTypeDef",
    {"ResourceARN": str},
)

ClientDiscoverInputSchemaInputProcessingConfigurationTypeDef = TypedDict(
    "ClientDiscoverInputSchemaInputProcessingConfigurationTypeDef",
    {
        "InputLambdaProcessor": ClientDiscoverInputSchemaInputProcessingConfigurationInputLambdaProcessorTypeDef
    },
)

ClientDiscoverInputSchemaInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientDiscoverInputSchemaInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientDiscoverInputSchemaResponseInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientDiscoverInputSchemaResponseInputSchemaTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseInputSchemaTypeDef",
    {
        "RecordFormat": ClientDiscoverInputSchemaResponseInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[ClientDiscoverInputSchemaResponseInputSchemaRecordColumnsTypeDef],
    },
    total=False,
)

ClientDiscoverInputSchemaResponseTypeDef = TypedDict(
    "ClientDiscoverInputSchemaResponseTypeDef",
    {
        "InputSchema": ClientDiscoverInputSchemaResponseInputSchemaTypeDef,
        "ParsedInputRecords": List[List[str]],
        "ProcessedInputRecords": List[str],
        "RawInputRecords": List[str],
    },
    total=False,
)

_RequiredClientDiscoverInputSchemaS3ConfigurationTypeDef = TypedDict(
    "_RequiredClientDiscoverInputSchemaS3ConfigurationTypeDef", {"BucketARN": str}
)
_OptionalClientDiscoverInputSchemaS3ConfigurationTypeDef = TypedDict(
    "_OptionalClientDiscoverInputSchemaS3ConfigurationTypeDef", {"FileKey": str}, total=False
)


class ClientDiscoverInputSchemaS3ConfigurationTypeDef(
    _RequiredClientDiscoverInputSchemaS3ConfigurationTypeDef,
    _OptionalClientDiscoverInputSchemaS3ConfigurationTypeDef,
):
    pass


ClientListApplicationSnapshotsResponseSnapshotSummariesTypeDef = TypedDict(
    "ClientListApplicationSnapshotsResponseSnapshotSummariesTypeDef",
    {
        "SnapshotName": str,
        "SnapshotStatus": Literal["CREATING", "READY", "DELETING", "FAILED"],
        "ApplicationVersionId": int,
        "SnapshotCreationTimestamp": datetime,
    },
    total=False,
)

ClientListApplicationSnapshotsResponseTypeDef = TypedDict(
    "ClientListApplicationSnapshotsResponseTypeDef",
    {
        "SnapshotSummaries": List[ClientListApplicationSnapshotsResponseSnapshotSummariesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientListApplicationsResponseApplicationSummariesTypeDef = TypedDict(
    "ClientListApplicationsResponseApplicationSummariesTypeDef",
    {
        "ApplicationName": str,
        "ApplicationARN": str,
        "ApplicationStatus": Literal[
            "DELETING", "STARTING", "STOPPING", "READY", "RUNNING", "UPDATING"
        ],
        "ApplicationVersionId": int,
        "RuntimeEnvironment": Literal["SQL-1_0", "FLINK-1_6", "FLINK-1_8"],
    },
    total=False,
)

ClientListApplicationsResponseTypeDef = TypedDict(
    "ClientListApplicationsResponseTypeDef",
    {
        "ApplicationSummaries": List[ClientListApplicationsResponseApplicationSummariesTypeDef],
        "NextToken": str,
    },
    total=False,
)

ClientListTagsForResourceResponseTagsTypeDef = TypedDict(
    "ClientListTagsForResourceResponseTagsTypeDef", {"Key": str, "Value": str}, total=False
)

ClientListTagsForResourceResponseTypeDef = TypedDict(
    "ClientListTagsForResourceResponseTypeDef",
    {"Tags": List[ClientListTagsForResourceResponseTagsTypeDef]},
    total=False,
)

ClientStartApplicationRunConfigurationApplicationRestoreConfigurationTypeDef = TypedDict(
    "ClientStartApplicationRunConfigurationApplicationRestoreConfigurationTypeDef",
    {
        "ApplicationRestoreType": Literal[
            "SKIP_RESTORE_FROM_SNAPSHOT",
            "RESTORE_FROM_LATEST_SNAPSHOT",
            "RESTORE_FROM_CUSTOM_SNAPSHOT",
        ],
        "SnapshotName": str,
    },
    total=False,
)

ClientStartApplicationRunConfigurationFlinkRunConfigurationTypeDef = TypedDict(
    "ClientStartApplicationRunConfigurationFlinkRunConfigurationTypeDef",
    {"AllowNonRestoredState": bool},
    total=False,
)

ClientStartApplicationRunConfigurationSqlRunConfigurationsInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientStartApplicationRunConfigurationSqlRunConfigurationsInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientStartApplicationRunConfigurationSqlRunConfigurationsTypeDef = TypedDict(
    "ClientStartApplicationRunConfigurationSqlRunConfigurationsTypeDef",
    {
        "InputId": str,
        "InputStartingPositionConfiguration": ClientStartApplicationRunConfigurationSqlRunConfigurationsInputStartingPositionConfigurationTypeDef,
    },
    total=False,
)

ClientStartApplicationRunConfigurationTypeDef = TypedDict(
    "ClientStartApplicationRunConfigurationTypeDef",
    {
        "FlinkRunConfiguration": ClientStartApplicationRunConfigurationFlinkRunConfigurationTypeDef,
        "SqlRunConfigurations": List[
            ClientStartApplicationRunConfigurationSqlRunConfigurationsTypeDef
        ],
        "ApplicationRestoreConfiguration": ClientStartApplicationRunConfigurationApplicationRestoreConfigurationTypeDef,
    },
    total=False,
)

_RequiredClientTagResourceTagsTypeDef = TypedDict(
    "_RequiredClientTagResourceTagsTypeDef", {"Key": str}
)
_OptionalClientTagResourceTagsTypeDef = TypedDict(
    "_OptionalClientTagResourceTagsTypeDef", {"Value": str}, total=False
)


class ClientTagResourceTagsTypeDef(
    _RequiredClientTagResourceTagsTypeDef, _OptionalClientTagResourceTagsTypeDef
):
    pass


ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateS3ContentLocationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateS3ContentLocationUpdateTypeDef",
    {"BucketARNUpdate": str, "FileKeyUpdate": str, "ObjectVersionUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateTypeDef",
    {
        "TextContentUpdate": str,
        "ZipFileContentUpdate": bytes,
        "S3ContentLocationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateS3ContentLocationUpdateTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateTypeDef",
    {
        "CodeContentTypeUpdate": Literal["PLAINTEXT", "ZIPFILE"],
        "CodeContentUpdate": ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateCodeContentUpdateTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateApplicationSnapshotConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateApplicationSnapshotConfigurationUpdateTypeDef",
    {"SnapshotsEnabledUpdate": bool},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesPropertyGroupsTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesPropertyGroupsTypeDef",
    {"PropertyGroupId": str, "PropertyMap": Dict[str, str]},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesTypeDef",
    {
        "PropertyGroups": List[
            ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesPropertyGroupsTypeDef
        ]
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateCheckpointConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateCheckpointConfigurationUpdateTypeDef",
    {
        "ConfigurationTypeUpdate": Literal["DEFAULT", "CUSTOM"],
        "CheckpointingEnabledUpdate": bool,
        "CheckpointIntervalUpdate": int,
        "MinPauseBetweenCheckpointsUpdate": int,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateMonitoringConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateMonitoringConfigurationUpdateTypeDef",
    {
        "ConfigurationTypeUpdate": Literal["DEFAULT", "CUSTOM"],
        "MetricsLevelUpdate": Literal["APPLICATION", "TASK", "OPERATOR", "PARALLELISM"],
        "LogLevelUpdate": Literal["INFO", "WARN", "ERROR", "DEBUG"],
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateParallelismConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateParallelismConfigurationUpdateTypeDef",
    {
        "ConfigurationTypeUpdate": Literal["DEFAULT", "CUSTOM"],
        "ParallelismUpdate": int,
        "ParallelismPerKPUUpdate": int,
        "AutoScalingEnabledUpdate": bool,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateTypeDef",
    {
        "CheckpointConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateCheckpointConfigurationUpdateTypeDef,
        "MonitoringConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateMonitoringConfigurationUpdateTypeDef,
        "ParallelismConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateParallelismConfigurationUpdateTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputParallelismUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputParallelismUpdateTypeDef",
    {"CountUpdate": int},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateInputLambdaProcessorUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateInputLambdaProcessorUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateTypeDef",
    {
        "InputLambdaProcessorUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateInputLambdaProcessorUpdateTypeDef
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordColumnUpdatesTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordColumnUpdatesTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateTypeDef",
    {
        "RecordFormatUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordFormatUpdateTypeDef,
        "RecordEncodingUpdate": str,
        "RecordColumnUpdates": List[
            ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateRecordColumnUpdatesTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisFirehoseInputUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisFirehoseInputUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisStreamsInputUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisStreamsInputUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

_RequiredClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef = TypedDict(
    "_RequiredClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef",
    {"InputId": str},
)
_OptionalClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef = TypedDict(
    "_OptionalClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef",
    {
        "NamePrefixUpdate": str,
        "InputProcessingConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputProcessingConfigurationUpdateTypeDef,
        "KinesisStreamsInputUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisStreamsInputUpdateTypeDef,
        "KinesisFirehoseInputUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesKinesisFirehoseInputUpdateTypeDef,
        "InputSchemaUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputSchemaUpdateTypeDef,
        "InputParallelismUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesInputParallelismUpdateTypeDef,
    },
    total=False,
)


class ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef(
    _RequiredClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef,
    _OptionalClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef,
):
    pass


ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesDestinationSchemaUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesDestinationSchemaUpdateTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisFirehoseOutputUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisFirehoseOutputUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisStreamsOutputUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisStreamsOutputUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesLambdaOutputUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesLambdaOutputUpdateTypeDef",
    {"ResourceARNUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesTypeDef",
    {
        "OutputId": str,
        "NameUpdate": str,
        "KinesisStreamsOutputUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisStreamsOutputUpdateTypeDef,
        "KinesisFirehoseOutputUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesKinesisFirehoseOutputUpdateTypeDef,
        "LambdaOutputUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesLambdaOutputUpdateTypeDef,
        "DestinationSchemaUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesDestinationSchemaUpdateTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordColumnsTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateTypeDef",
    {
        "RecordFormat": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesS3ReferenceDataSourceUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesS3ReferenceDataSourceUpdateTypeDef",
    {"BucketARNUpdate": str, "FileKeyUpdate": str},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesTypeDef",
    {
        "ReferenceId": str,
        "TableNameUpdate": str,
        "S3ReferenceDataSourceUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesS3ReferenceDataSourceUpdateTypeDef,
        "ReferenceSchemaUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesReferenceSchemaUpdateTypeDef,
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateTypeDef",
    {
        "InputUpdates": List[
            ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateInputUpdatesTypeDef
        ],
        "OutputUpdates": List[
            ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateOutputUpdatesTypeDef
        ],
        "ReferenceDataSourceUpdates": List[
            ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateReferenceDataSourceUpdatesTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateVpcConfigurationUpdatesTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateVpcConfigurationUpdatesTypeDef",
    {"VpcConfigurationId": str, "SubnetIdUpdates": List[str], "SecurityGroupIdUpdates": List[str]},
    total=False,
)

ClientUpdateApplicationApplicationConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationApplicationConfigurationUpdateTypeDef",
    {
        "SqlApplicationConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateSqlApplicationConfigurationUpdateTypeDef,
        "ApplicationCodeConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateApplicationCodeConfigurationUpdateTypeDef,
        "FlinkApplicationConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateFlinkApplicationConfigurationUpdateTypeDef,
        "EnvironmentPropertyUpdates": ClientUpdateApplicationApplicationConfigurationUpdateEnvironmentPropertyUpdatesTypeDef,
        "ApplicationSnapshotConfigurationUpdate": ClientUpdateApplicationApplicationConfigurationUpdateApplicationSnapshotConfigurationUpdateTypeDef,
        "VpcConfigurationUpdates": List[
            ClientUpdateApplicationApplicationConfigurationUpdateVpcConfigurationUpdatesTypeDef
        ],
    },
    total=False,
)

_RequiredClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef = TypedDict(
    "_RequiredClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef",
    {"CloudWatchLoggingOptionId": str},
)
_OptionalClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef = TypedDict(
    "_OptionalClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef",
    {"LogStreamARNUpdate": str},
    total=False,
)


class ClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef(
    _RequiredClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef,
    _OptionalClientUpdateApplicationCloudWatchLoggingOptionUpdatesTypeDef,
):
    pass


ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ObjectVersion": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef",
    {
        "TextContent": str,
        "CodeMD5": str,
        "CodeSize": int,
        "S3ApplicationCodeLocationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionS3ApplicationCodeLocationDescriptionTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef",
    {
        "CodeContentType": Literal["PLAINTEXT", "ZIPFILE"],
        "CodeContentDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionCodeContentDescriptionTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef",
    {"SnapshotsEnabled": bool},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef",
    {"PropertyGroupId": str, "PropertyMap": Dict[str, str]},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef",
    {
        "PropertyGroupDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsPropertyGroupDescriptionsTypeDef
        ]
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "CheckpointingEnabled": bool,
        "CheckpointInterval": int,
        "MinPauseBetweenCheckpoints": int,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "MetricsLevel": Literal["APPLICATION", "TASK", "OPERATOR", "PARALLELISM"],
        "LogLevel": Literal["INFO", "WARN", "ERROR", "DEBUG"],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef",
    {
        "ConfigurationType": Literal["DEFAULT", "CUSTOM"],
        "Parallelism": int,
        "ParallelismPerKPU": int,
        "CurrentParallelism": int,
        "AutoScalingEnabled": bool,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef",
    {
        "CheckpointConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionCheckpointConfigurationDescriptionTypeDef,
        "MonitoringConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionMonitoringConfigurationDescriptionTypeDef,
        "ParallelismConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionParallelismConfigurationDescriptionTypeDef,
        "JobPlanDescription": str,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreType": Literal[
            "SKIP_RESTORE_FROM_SNAPSHOT",
            "RESTORE_FROM_LATEST_SNAPSHOT",
            "RESTORE_FROM_CUSTOM_SNAPSHOT",
        ],
        "SnapshotName": str,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef",
    {
        "ApplicationRestoreConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionApplicationRestoreConfigurationDescriptionTypeDef
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef",
    {"Count": int},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef",
    {
        "InputLambdaProcessorDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionInputLambdaProcessorDescriptionTypeDef
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef",
    {
        "RecordFormat": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef",
    {"InputStartingPosition": Literal["NOW", "TRIM_HORIZON", "LAST_STOPPED_POINT"]},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef",
    {
        "InputId": str,
        "NamePrefix": str,
        "InAppStreamNames": List[str],
        "InputProcessingConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputProcessingConfigurationDescriptionTypeDef,
        "KinesisStreamsInputDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisStreamsInputDescriptionTypeDef,
        "KinesisFirehoseInputDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsKinesisFirehoseInputDescriptionTypeDef,
        "InputSchema": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputSchemaTypeDef,
        "InputParallelism": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputParallelismTypeDef,
        "InputStartingPositionConfiguration": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsInputStartingPositionConfigurationTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef",
    {"RecordFormatType": Literal["JSON", "CSV"]},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef",
    {"ResourceARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef",
    {
        "OutputId": str,
        "Name": str,
        "KinesisStreamsOutputDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisStreamsOutputDescriptionTypeDef,
        "KinesisFirehoseOutputDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsKinesisFirehoseOutputDescriptionTypeDef,
        "LambdaOutputDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsLambdaOutputDescriptionTypeDef,
        "DestinationSchema": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsDestinationSchemaTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef",
    {"Name": str, "Mapping": str, "SqlType": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef",
    {"RecordRowDelimiter": str, "RecordColumnDelimiter": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef",
    {"RecordRowPath": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef",
    {
        "JSONMappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersJSONMappingParametersTypeDef,
        "CSVMappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersCSVMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef",
    {
        "RecordFormatType": Literal["JSON", "CSV"],
        "MappingParameters": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatMappingParametersTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef",
    {
        "RecordFormat": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordFormatTypeDef,
        "RecordEncoding": str,
        "RecordColumns": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaRecordColumnsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef",
    {"BucketARN": str, "FileKey": str, "ReferenceRoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef",
    {
        "ReferenceId": str,
        "TableName": str,
        "S3ReferenceDataSourceDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsS3ReferenceDataSourceDescriptionTypeDef,
        "ReferenceSchema": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsReferenceSchemaTypeDef,
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef",
    {
        "InputDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionInputDescriptionsTypeDef
        ],
        "OutputDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionOutputDescriptionsTypeDef
        ],
        "ReferenceDataSourceDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionReferenceDataSourceDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef",
    {
        "VpcConfigurationId": str,
        "VpcId": str,
        "SubnetIds": List[str],
        "SecurityGroupIds": List[str],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef",
    {
        "SqlApplicationConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionSqlApplicationConfigurationDescriptionTypeDef,
        "ApplicationCodeConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationCodeConfigurationDescriptionTypeDef,
        "RunConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionRunConfigurationDescriptionTypeDef,
        "FlinkApplicationConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionFlinkApplicationConfigurationDescriptionTypeDef,
        "EnvironmentPropertyDescriptions": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionEnvironmentPropertyDescriptionsTypeDef,
        "ApplicationSnapshotConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionApplicationSnapshotConfigurationDescriptionTypeDef,
        "VpcConfigurationDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionVpcConfigurationDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef",
    {"CloudWatchLoggingOptionId": str, "LogStreamARN": str, "RoleARN": str},
    total=False,
)

ClientUpdateApplicationResponseApplicationDetailTypeDef = TypedDict(
    "ClientUpdateApplicationResponseApplicationDetailTypeDef",
    {
        "ApplicationARN": str,
        "ApplicationDescription": str,
        "ApplicationName": str,
        "RuntimeEnvironment": Literal["SQL-1_0", "FLINK-1_6", "FLINK-1_8"],
        "ServiceExecutionRole": str,
        "ApplicationStatus": Literal[
            "DELETING", "STARTING", "STOPPING", "READY", "RUNNING", "UPDATING"
        ],
        "ApplicationVersionId": int,
        "CreateTimestamp": datetime,
        "LastUpdateTimestamp": datetime,
        "ApplicationConfigurationDescription": ClientUpdateApplicationResponseApplicationDetailApplicationConfigurationDescriptionTypeDef,
        "CloudWatchLoggingOptionDescriptions": List[
            ClientUpdateApplicationResponseApplicationDetailCloudWatchLoggingOptionDescriptionsTypeDef
        ],
    },
    total=False,
)

ClientUpdateApplicationResponseTypeDef = TypedDict(
    "ClientUpdateApplicationResponseTypeDef",
    {"ApplicationDetail": ClientUpdateApplicationResponseApplicationDetailTypeDef},
    total=False,
)

ClientUpdateApplicationRunConfigurationUpdateApplicationRestoreConfigurationTypeDef = TypedDict(
    "ClientUpdateApplicationRunConfigurationUpdateApplicationRestoreConfigurationTypeDef",
    {
        "ApplicationRestoreType": Literal[
            "SKIP_RESTORE_FROM_SNAPSHOT",
            "RESTORE_FROM_LATEST_SNAPSHOT",
            "RESTORE_FROM_CUSTOM_SNAPSHOT",
        ],
        "SnapshotName": str,
    },
    total=False,
)

ClientUpdateApplicationRunConfigurationUpdateFlinkRunConfigurationTypeDef = TypedDict(
    "ClientUpdateApplicationRunConfigurationUpdateFlinkRunConfigurationTypeDef",
    {"AllowNonRestoredState": bool},
    total=False,
)

ClientUpdateApplicationRunConfigurationUpdateTypeDef = TypedDict(
    "ClientUpdateApplicationRunConfigurationUpdateTypeDef",
    {
        "FlinkRunConfiguration": ClientUpdateApplicationRunConfigurationUpdateFlinkRunConfigurationTypeDef,
        "ApplicationRestoreConfiguration": ClientUpdateApplicationRunConfigurationUpdateApplicationRestoreConfigurationTypeDef,
    },
    total=False,
)

_RequiredSnapshotDetailsTypeDef = TypedDict(
    "_RequiredSnapshotDetailsTypeDef",
    {
        "SnapshotName": str,
        "SnapshotStatus": Literal["CREATING", "READY", "DELETING", "FAILED"],
        "ApplicationVersionId": int,
    },
)
_OptionalSnapshotDetailsTypeDef = TypedDict(
    "_OptionalSnapshotDetailsTypeDef", {"SnapshotCreationTimestamp": datetime}, total=False
)


class SnapshotDetailsTypeDef(_RequiredSnapshotDetailsTypeDef, _OptionalSnapshotDetailsTypeDef):
    pass


ListApplicationSnapshotsResponseTypeDef = TypedDict(
    "ListApplicationSnapshotsResponseTypeDef",
    {"SnapshotSummaries": List[SnapshotDetailsTypeDef], "NextToken": str},
    total=False,
)

ApplicationSummaryTypeDef = TypedDict(
    "ApplicationSummaryTypeDef",
    {
        "ApplicationName": str,
        "ApplicationARN": str,
        "ApplicationStatus": Literal[
            "DELETING", "STARTING", "STOPPING", "READY", "RUNNING", "UPDATING"
        ],
        "ApplicationVersionId": int,
        "RuntimeEnvironment": Literal["SQL-1_0", "FLINK-1_6", "FLINK-1_8"],
    },
)

_RequiredListApplicationsResponseTypeDef = TypedDict(
    "_RequiredListApplicationsResponseTypeDef",
    {"ApplicationSummaries": List[ApplicationSummaryTypeDef]},
)
_OptionalListApplicationsResponseTypeDef = TypedDict(
    "_OptionalListApplicationsResponseTypeDef", {"NextToken": str}, total=False
)


class ListApplicationsResponseTypeDef(
    _RequiredListApplicationsResponseTypeDef, _OptionalListApplicationsResponseTypeDef
):
    pass


PaginatorConfigTypeDef = TypedDict(
    "PaginatorConfigTypeDef", {"MaxItems": int, "PageSize": int, "StartingToken": str}, total=False
)
