# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .auth_type import AuthType
from .fields import Fields


class AuthProvider(UniversalBaseModel):
    """
    Schema for auth provider response.
    """

    name: str = pydantic.Field()
    """
    Human-readable name of the auth provider (e.g., 'Google OAuth', 'GitHub')
    """

    short_name: str = pydantic.Field()
    """
    Technical identifier used internally to reference this auth provider. Must be unique.
    """

    class_name: str = pydantic.Field()
    """
    Python class name of the auth provider implementation
    """

    auth_config_class: str = pydantic.Field()
    """
    Python class name that defines the authentication configuration fields
    """

    config_class: str = pydantic.Field()
    """
    Python class name that defines the auth provider-specific configuration
    """

    auth_type: AuthType = pydantic.Field()
    """
    Type of authentication mechanism used by this provider
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Detailed description explaining what this auth provider offers
    """

    organization_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization identifier for custom auth providers. System providers have this set to null.
    """

    id: str
    created_at: dt.datetime
    modified_at: dt.datetime
    auth_fields: typing.Optional[Fields] = pydantic.Field(default=None)
    """
    Dynamically populated field definitions for authentication configuration. These describe what credentials are required to connect to this auth provider.
    """

    config_fields: typing.Optional[Fields] = pydantic.Field(default=None)
    """
    Dynamically populated field definitions for auth provider-specific configuration. These describe what additional configuration is required when using this auth provider to connect to a source (e.g., integration_id and account_id for Composio).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
