# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .geo_bounding_box import GeoBoundingBox
from .geo_polygon import GeoPolygon
from .geo_radius import GeoRadius
from .match import Match
from .range import Range
from .values_count import ValuesCount


class FieldCondition(UniversalBaseModel):
    """
    All possible payload filtering conditions
    """

    key: str = pydantic.Field()
    """
    Payload key
    """

    match: typing.Optional[Match] = pydantic.Field(default=None)
    """
    Check if point has field with a given value
    """

    range: typing.Optional[Range] = pydantic.Field(default=None)
    """
    Check if points value lies in a given range
    """

    geo_bounding_box: typing.Optional[GeoBoundingBox] = pydantic.Field(default=None)
    """
    Check if points geolocation lies in a given area
    """

    geo_radius: typing.Optional[GeoRadius] = pydantic.Field(default=None)
    """
    Check if geo point is within a given radius
    """

    geo_polygon: typing.Optional[GeoPolygon] = pydantic.Field(default=None)
    """
    Check if geo point is within a given polygon
    """

    values_count: typing.Optional[ValuesCount] = pydantic.Field(default=None)
    """
    Check number of values of the field
    """

    is_empty: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Check that the field is empty, alternative syntax for `is_empty: \&quot;field_name\&quot;`
    """

    is_null: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Check that the field is null, alternative syntax for `is_null: \&quot;field_name\&quot;`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
