# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .auth_type import AuthType
from .integration_type import IntegrationType


class IntegrationCredentialInDb(UniversalBaseModel):
    """
    Integration credential in DB without decrypted data.
    """

    name: str
    integration_short_name: str
    description: typing.Optional[str] = None
    integration_type: IntegrationType
    auth_type: AuthType
    auth_config_class: typing.Optional[str] = None
    id: str
    organization_id: str
    encrypted_credentials: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
