# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .auth_type import AuthType
from .integration_type import IntegrationType


class IntegrationCredentialRawCreate(UniversalBaseModel):
    """
    Create class for integration credentials with raw auth fields.

    This schema is used when auth fields need to be validated and encrypted
    before creating the credential.
    """

    name: str
    integration_short_name: str
    description: typing.Optional[str] = None
    integration_type: IntegrationType
    auth_type: AuthType
    auth_config_class: typing.Optional[str] = None
    auth_fields: typing.Dict[str, typing.Optional[typing.Any]]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
