# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WhiteLabel(UniversalBaseModel):
    """
    Complete white label integration representation returned by the API.
    """

    name: str = pydantic.Field()
    """
    Human-readable name for the white label integration. This helps you identify the integration in the UI and should clearly describe its purpose (e.g., 'Customer Portal Slack Integration', 'Enterprise Google Drive Access').
    """

    source_short_name: str = pydantic.Field()
    """
    Technical identifier of the source type that this integration supports (e.g., 'slack', 'google_drive', 'github'). This determines which service provider the OAuth integration connects to.
    """

    redirect_url: str = pydantic.Field()
    """
    OAuth2 callback URL where users are redirected after completing authentication. This must be a valid HTTPS URL that your application can handle to receive the authorization code.
    """

    client_id: str = pydantic.Field()
    """
    OAuth2 client identifier provided by the service provider. This identifies your application during the OAuth consent flow and must match the client ID configured in the service provider's developer console.
    """

    client_secret: str = pydantic.Field()
    """
    OAuth2 client secret from your registered application. This is used to securely authenticate your application when exchanging authorization codes for access tokens. Keep this value secure and never expose it in client-side code.
    """

    allowed_origins: str = pydantic.Field()
    """
    Comma-separated list of allowed domains for OAuth flows and CORS. This prevents unauthorized websites from using your OAuth credentials and should include all domains where your application is hosted.
    """

    id: str = pydantic.Field()
    """
    Unique system identifier for the white label integration. This UUID is generated automatically and used for API operations and OAuth flow tracking.
    """

    organization_id: str = pydantic.Field()
    """
    Identifier of the organization that owns this white label integration. White label integrations are isolated per organization for security and multi-tenancy.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the white label integration was created (ISO 8601 format).
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the white label integration was last modified (ISO 8601 format).
    """

    created_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the user who created this white label integration.
    """

    modified_by_email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the user who last modified this white label integration.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
