# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.source_connection import SourceConnection
from ..types.source_connection_create_with_white_label import SourceConnectionCreateWithWhiteLabel
from ..types.source_connection_list_item import SourceConnectionListItem
from ..types.white_label import WhiteLabel
from .raw_client import AsyncRawWhiteLabelsClient, RawWhiteLabelsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WhiteLabelsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWhiteLabelsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWhiteLabelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWhiteLabelsClient
        """
        return self._raw_client

    def list_white_labels(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[WhiteLabel]:
        """
        List all white label integrations for your organization.

        <br/><br/>
        Returns all custom OAuth integrations configured with your own branding and
        credentials. These integrations allow you to present OAuth consent screens with
        your company name instead of Airweave.<br/><br/>**White label integrations only
        work with OAuth2.0 sources** like Slack, Google Drive, or HubSpot that require
        OAuth consent flows.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WhiteLabel]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.list_white_labels()
        """
        _response = self._raw_client.list_white_labels(request_options=request_options)
        return _response.data

    def create_white_label(
        self,
        *,
        name: str,
        source_short_name: str,
        redirect_url: str,
        client_id: str,
        client_secret: str,
        allowed_origins: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabel:
        """
        Create a new white label integration.

        <br/><br/>
        **This only works for sources that use OAuth2.0 authentication** like Slack,
        Google Drive, GitHub, or HubSpot.<br/><br/>Sets up a custom OAuth integration
        using your own OAuth application credentials and branding. Once created,
        customers will see your company name during OAuth consent flows instead of
        Airweave. This requires you to have already configured your own OAuth
        application with the target service provider.

        Parameters
        ----------
        name : str
            Human-readable name for the white label integration. This helps you identify the integration in the UI and should clearly describe its purpose (e.g., 'Customer Portal Slack Integration', 'Enterprise Google Drive Access').

        source_short_name : str
            Technical identifier of the source type that this integration supports (e.g., 'slack', 'google_drive', 'github'). This determines which service provider the OAuth integration connects to.

        redirect_url : str
            OAuth2 callback URL where users are redirected after completing authentication. This must be a valid HTTPS URL that your application can handle to receive the authorization code.

        client_id : str
            OAuth2 client identifier provided by the service provider. This identifies your application during the OAuth consent flow and must match the client ID configured in the service provider's developer console.

        client_secret : str
            OAuth2 client secret from your registered application. This is used to securely authenticate your application when exchanging authorization codes for access tokens. Keep this value secure and never expose it in client-side code.

        allowed_origins : str
            Comma-separated list of allowed domains for OAuth flows and CORS. This prevents unauthorized websites from using your OAuth credentials and should include all domains where your application is hosted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.create_white_label(
            name="Customer Portal Slack Integration",
            source_short_name="slack",
            redirect_url="https://yourapp.com/auth/slack/callback",
            client_id="1234567890.1234567890123",
            client_secret="abcdefghijklmnopqrstuvwxyz123456",
            allowed_origins="https://yourapp.com,https://app.yourapp.com",
        )
        """
        _response = self._raw_client.create_white_label(
            name=name,
            source_short_name=source_short_name,
            redirect_url=redirect_url,
            client_id=client_id,
            client_secret=client_secret,
            allowed_origins=allowed_origins,
            request_options=request_options,
        )
        return _response.data

    def get_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabel:
        """
        Retrieve a specific white label integration by its ID.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.get_white_label(
            white_label_id="white_label_id",
        )
        """
        _response = self._raw_client.get_white_label(white_label_id, request_options=request_options)
        return _response.data

    def update_white_label(
        self,
        white_label_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabel:
        """
        Update a white label integration's configuration.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to update

        name : typing.Optional[str]
            Updated name for the white label integration.

        redirect_url : typing.Optional[str]
            Updated OAuth callback URL. Must be a valid HTTPS URL that matches your OAuth application configuration.

        client_id : typing.Optional[str]
            Updated OAuth2 client ID. Must match the client ID in your service provider's developer console.

        client_secret : typing.Optional[str]
            Updated OAuth2 client secret. This will replace the existing secret and affect all future OAuth flows.

        allowed_origins : typing.Optional[str]
            Updated comma-separated list of allowed domains for OAuth flows.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.update_white_label(
            white_label_id="white_label_id",
            name="Updated Customer Portal Integration",
            redirect_url="https://v2.yourapp.com/auth/slack/callback",
            allowed_origins="https://v2.yourapp.com,https://api.yourapp.com",
        )
        """
        _response = self._raw_client.update_white_label(
            white_label_id,
            name=name,
            redirect_url=redirect_url,
            client_id=client_id,
            client_secret=client_secret,
            allowed_origins=allowed_origins,
            request_options=request_options,
        )
        return _response.data

    def delete_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabel:
        """
        Delete a white label integration.

        <br/><br/>
        Permanently removes the white label configuration and OAuth credentials.
        Existing source connections created through this integration will continue to work,
        but no new OAuth flows can be initiated until a new white label integration is created.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.delete_white_label(
            white_label_id="white_label_id",
        )
        """
        _response = self._raw_client.delete_white_label(white_label_id, request_options=request_options)
        return _response.data

    def get_white_label_oauth_2_auth_url(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Generate a branded OAuth2 authorization URL for customer authentication.

        <br/><br/>
        Creates the OAuth consent URL that customers should be redirected to for
        authentication. The OAuth consent screen will display your company name and
        branding instead of Airweave.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            OAuth2 authorization URL with your branding

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.get_white_label_oauth_2_auth_url(
            white_label_id="white_label_id",
        )
        """
        _response = self._raw_client.get_white_label_oauth_2_auth_url(white_label_id, request_options=request_options)
        return _response.data

    def list_white_label_source_connections(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionListItem]:
        """
        List all source connections created through a specific white label integration.

        <br/><br/>
        Returns source connections that were established using this white label's OAuth flow.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionListItem]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.list_white_label_source_connections(
            white_label_id="white_label_id",
        )
        """
        _response = self._raw_client.list_white_label_source_connections(
            white_label_id, request_options=request_options
        )
        return _response.data

    def exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
        self,
        white_label_id: str,
        *,
        code: str,
        source_connection_in: typing.Optional[SourceConnectionCreateWithWhiteLabel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Complete the OAuth flow and create a source connection.

        <br/><br/>
        **This is the core endpoint that converts OAuth authorization codes into working
        source connections.**<br/><br/>The OAuth credentials are obtained automatically
        from the authorization code - you do not need to provide auth_fields. The white
        label integration is automatically linked to the created source connection for
        tracking and branding purposes.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        code : str
            The OAuth2 authorization code received from the OAuth callback after customer authentication

        source_connection_in : typing.Optional[SourceConnectionCreateWithWhiteLabel]
            Optional configuration for the source connection. If not provided, a source connection will be created automatically with default settings. The white label integration is automatically linked to the source connection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )
        client.white_labels.exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
            white_label_id="white_label_id",
            code="4/P7q7W91a-oMsCeLvIaQm6bTrgtp7",
        )
        """
        _response = self._raw_client.exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
            white_label_id, code=code, source_connection_in=source_connection_in, request_options=request_options
        )
        return _response.data


class AsyncWhiteLabelsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWhiteLabelsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWhiteLabelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWhiteLabelsClient
        """
        return self._raw_client

    async def list_white_labels(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[WhiteLabel]:
        """
        List all white label integrations for your organization.

        <br/><br/>
        Returns all custom OAuth integrations configured with your own branding and
        credentials. These integrations allow you to present OAuth consent screens with
        your company name instead of Airweave.<br/><br/>**White label integrations only
        work with OAuth2.0 sources** like Slack, Google Drive, or HubSpot that require
        OAuth consent flows.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WhiteLabel]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.list_white_labels()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_white_labels(request_options=request_options)
        return _response.data

    async def create_white_label(
        self,
        *,
        name: str,
        source_short_name: str,
        redirect_url: str,
        client_id: str,
        client_secret: str,
        allowed_origins: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabel:
        """
        Create a new white label integration.

        <br/><br/>
        **This only works for sources that use OAuth2.0 authentication** like Slack,
        Google Drive, GitHub, or HubSpot.<br/><br/>Sets up a custom OAuth integration
        using your own OAuth application credentials and branding. Once created,
        customers will see your company name during OAuth consent flows instead of
        Airweave. This requires you to have already configured your own OAuth
        application with the target service provider.

        Parameters
        ----------
        name : str
            Human-readable name for the white label integration. This helps you identify the integration in the UI and should clearly describe its purpose (e.g., 'Customer Portal Slack Integration', 'Enterprise Google Drive Access').

        source_short_name : str
            Technical identifier of the source type that this integration supports (e.g., 'slack', 'google_drive', 'github'). This determines which service provider the OAuth integration connects to.

        redirect_url : str
            OAuth2 callback URL where users are redirected after completing authentication. This must be a valid HTTPS URL that your application can handle to receive the authorization code.

        client_id : str
            OAuth2 client identifier provided by the service provider. This identifies your application during the OAuth consent flow and must match the client ID configured in the service provider's developer console.

        client_secret : str
            OAuth2 client secret from your registered application. This is used to securely authenticate your application when exchanging authorization codes for access tokens. Keep this value secure and never expose it in client-side code.

        allowed_origins : str
            Comma-separated list of allowed domains for OAuth flows and CORS. This prevents unauthorized websites from using your OAuth credentials and should include all domains where your application is hosted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.create_white_label(
                name="Customer Portal Slack Integration",
                source_short_name="slack",
                redirect_url="https://yourapp.com/auth/slack/callback",
                client_id="1234567890.1234567890123",
                client_secret="abcdefghijklmnopqrstuvwxyz123456",
                allowed_origins="https://yourapp.com,https://app.yourapp.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_white_label(
            name=name,
            source_short_name=source_short_name,
            redirect_url=redirect_url,
            client_id=client_id,
            client_secret=client_secret,
            allowed_origins=allowed_origins,
            request_options=request_options,
        )
        return _response.data

    async def get_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabel:
        """
        Retrieve a specific white label integration by its ID.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.get_white_label(
                white_label_id="white_label_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_white_label(white_label_id, request_options=request_options)
        return _response.data

    async def update_white_label(
        self,
        white_label_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhiteLabel:
        """
        Update a white label integration's configuration.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to update

        name : typing.Optional[str]
            Updated name for the white label integration.

        redirect_url : typing.Optional[str]
            Updated OAuth callback URL. Must be a valid HTTPS URL that matches your OAuth application configuration.

        client_id : typing.Optional[str]
            Updated OAuth2 client ID. Must match the client ID in your service provider's developer console.

        client_secret : typing.Optional[str]
            Updated OAuth2 client secret. This will replace the existing secret and affect all future OAuth flows.

        allowed_origins : typing.Optional[str]
            Updated comma-separated list of allowed domains for OAuth flows.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.update_white_label(
                white_label_id="white_label_id",
                name="Updated Customer Portal Integration",
                redirect_url="https://v2.yourapp.com/auth/slack/callback",
                allowed_origins="https://v2.yourapp.com,https://api.yourapp.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_white_label(
            white_label_id,
            name=name,
            redirect_url=redirect_url,
            client_id=client_id,
            client_secret=client_secret,
            allowed_origins=allowed_origins,
            request_options=request_options,
        )
        return _response.data

    async def delete_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WhiteLabel:
        """
        Delete a white label integration.

        <br/><br/>
        Permanently removes the white label configuration and OAuth credentials.
        Existing source connections created through this integration will continue to work,
        but no new OAuth flows can be initiated until a new white label integration is created.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhiteLabel
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.delete_white_label(
                white_label_id="white_label_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_white_label(white_label_id, request_options=request_options)
        return _response.data

    async def get_white_label_oauth_2_auth_url(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Generate a branded OAuth2 authorization URL for customer authentication.

        <br/><br/>
        Creates the OAuth consent URL that customers should be redirected to for
        authentication. The OAuth consent screen will display your company name and
        branding instead of Airweave.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            OAuth2 authorization URL with your branding

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.get_white_label_oauth_2_auth_url(
                white_label_id="white_label_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_white_label_oauth_2_auth_url(
            white_label_id, request_options=request_options
        )
        return _response.data

    async def list_white_label_source_connections(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionListItem]:
        """
        List all source connections created through a specific white label integration.

        <br/><br/>
        Returns source connections that were established using this white label's OAuth flow.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionListItem]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.list_white_label_source_connections(
                white_label_id="white_label_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_white_label_source_connections(
            white_label_id, request_options=request_options
        )
        return _response.data

    async def exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
        self,
        white_label_id: str,
        *,
        code: str,
        source_connection_in: typing.Optional[SourceConnectionCreateWithWhiteLabel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SourceConnection:
        """
        Complete the OAuth flow and create a source connection.

        <br/><br/>
        **This is the core endpoint that converts OAuth authorization codes into working
        source connections.**<br/><br/>The OAuth credentials are obtained automatically
        from the authorization code - you do not need to provide auth_fields. The white
        label integration is automatically linked to the created source connection for
        tracking and branding purposes.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        code : str
            The OAuth2 authorization code received from the OAuth callback after customer authentication

        source_connection_in : typing.Optional[SourceConnectionCreateWithWhiteLabel]
            Optional configuration for the source connection. If not provided, a source connection will be created automatically with default settings. The white label integration is automatically linked to the source connection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SourceConnection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
            organization_id="YOUR_ORGANIZATION_ID",
        )


        async def main() -> None:
            await client.white_labels.exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
                white_label_id="white_label_id",
                code="4/P7q7W91a-oMsCeLvIaQm6bTrgtp7",
            )


        asyncio.run(main())
        """
        _response = (
            await self._raw_client.exchange_white_label_oauth_2_code_white_labels_white_label_id_oauth_2_code_options(
                white_label_id, code=code, source_connection_in=source_connection_in, request_options=request_options
            )
        )
        return _response.data
