# mypy-boto3-acm-pca

[![PyPI - mypy-boto3-acm-pca](https://img.shields.io/pypi/v/mypy-boto3-acm-pca.svg?color=blue)](https://pypi.org/project/mypy-boto3-acm-pca)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-acm-pca.svg?color=blue)](https://pypi.org/project/mypy-boto3-acm-pca)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-acm-pca?color=blue)](https://pypistats.org/packages/mypy-boto3-acm-pca)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ACMPCA 1.17.64](https://boto3.amazonaws.com/v1/documentation/api/1.17.64/reference/services/acm-pca.html#ACMPCA)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-acm-pca docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_acm_pca/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-acm-pca](#mypy-boto3-acm-pca)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `ACMPCA` service.

```bash
python -m pip install boto3-stubs[acm-pca]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[acm-pca]` in your environment:
  `python -m pip install 'boto3-stubs[acm-pca]'`

Both type checking and auto-complete should work for `ACMPCA` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[acm-pca]` in your environment:
  `python -m pip install 'boto3-stubs[acm-pca]'`

Both type checking and auto-complete should work for `ACMPCA` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[acm-pca]` in your environment:
  `python -m pip install 'boto3-stubs[acm-pca]'`
- Run `mypy` as usual

Type checking should work for `ACMPCA` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[acm-pca]` in your environment:
  `python -m pip install 'boto3-stubs[acm-pca]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ACMPCA` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ACMPCAClient` provides annotations for `boto3.client("acm-pca")`.

```python
import boto3

from mypy_boto3_acm_pca import ACMPCAClient

client: ACMPCAClient = boto3.client("acm-pca")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ACMPCAClient = session.client("acm-pca")
```

### Paginators annotations

`mypy_boto3_acm_pca.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_acm_pca import ACMPCAClient
from mypy_boto3_acm_pca.paginator import (
    ListCertificateAuthoritiesPaginator,
    ListPermissionsPaginator,
    ListTagsPaginator,
)

client: ACMPCAClient = boto3.client("acm-pca")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_certificate_authorities_paginator: ListCertificateAuthoritiesPaginator = client.get_paginator("list_certificate_authorities")
list_permissions_paginator: ListPermissionsPaginator = client.get_paginator("list_permissions")
list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
```

### Waiters annotations

`mypy_boto3_acm_pca.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_acm_pca import ACMPCAClient
from mypy_boto3_acm_pca.waiter import (
    AuditReportCreatedWaiter,
    CertificateAuthorityCSRCreatedWaiter,
    CertificateIssuedWaiter,
)

client: ACMPCAClient = boto3.client("acm-pca")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
audit_report_created_waiter: AuditReportCreatedWaiter = client.get_waiter("audit_report_created")
certificate_authority_csr_created_waiter: CertificateAuthorityCSRCreatedWaiter = client.get_waiter("certificate_authority_csr_created")
certificate_issued_waiter: CertificateIssuedWaiter = client.get_waiter("certificate_issued")
```

### Literals

`mypy_boto3_acm_pca.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_acm_pca.literals import (
    AccessMethodType,
    ActionType,
    AuditReportCreatedWaiterName,
    AuditReportResponseFormat,
    AuditReportStatus,
    CertificateAuthorityCSRCreatedWaiterName,
    CertificateAuthorityStatus,
    CertificateAuthorityType,
    CertificateIssuedWaiterName,
    ExtendedKeyUsageType,
    FailureReason,
    KeyAlgorithm,
    ListCertificateAuthoritiesPaginatorName,
    ListPermissionsPaginatorName,
    ListTagsPaginatorName,
    PolicyQualifierId,
    ResourceOwner,
    RevocationReason,
    SigningAlgorithm,
    ValidityPeriodType,
)

def check_value(value: AccessMethodType) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_acm_pca.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_acm_pca.type_defs import (
    ASN1SubjectTypeDef,
    AccessDescriptionTypeDef,
    AccessMethodTypeDef,
    ApiPassthroughTypeDef,
    CertificateAuthorityConfigurationTypeDef,
    CertificateAuthorityTypeDef,
    CreateCertificateAuthorityAuditReportResponseTypeDef,
    CreateCertificateAuthorityResponseTypeDef,
    CrlConfigurationTypeDef,
    CsrExtensionsTypeDef,
    DescribeCertificateAuthorityAuditReportResponseTypeDef,
    DescribeCertificateAuthorityResponseTypeDef,
    EdiPartyNameTypeDef,
    ExtendedKeyUsageTypeDef,
    ExtensionsTypeDef,
    GeneralNameTypeDef,
    GetCertificateAuthorityCertificateResponseTypeDef,
    GetCertificateAuthorityCsrResponseTypeDef,
    GetCertificateResponseTypeDef,
    GetPolicyResponseTypeDef,
    IssueCertificateResponseTypeDef,
    KeyUsageTypeDef,
    ListCertificateAuthoritiesResponseTypeDef,
    ListPermissionsResponseTypeDef,
    ListTagsResponseTypeDef,
    OtherNameTypeDef,
    PaginatorConfigTypeDef,
    PermissionTypeDef,
    PolicyInformationTypeDef,
    PolicyQualifierInfoTypeDef,
    QualifierTypeDef,
    RevocationConfigurationTypeDef,
    TagTypeDef,
    ValidityTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> ASN1SubjectTypeDef:
    return {
      ...
    }
```
