# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str],
                 activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connection_config: Optional[pulumi.Input['InstanceClientConnectionConfigArgs']] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gce_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_config: Optional[pulumi.Input['InstanceMachineConfigArgs']] = None,
                 network_config: Optional[pulumi.Input['InstanceNetworkConfigArgs']] = None,
                 observability_config: Optional[pulumi.Input['InstanceObservabilityConfigArgs']] = None,
                 psc_instance_config: Optional[pulumi.Input['InstancePscInstanceConfigArgs']] = None,
                 query_insights_config: Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']] = None,
                 read_pool_config: Optional[pulumi.Input['InstanceReadPoolConfigArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[_builtins.str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[_builtins.str] activation_policy: 'Specifies whether an instance needs to spin up. Once the instance is
               active, the activation policy can be updated to the `NEVER` to stop the
               instance. Likewise, the activation policy can be updated to `ALWAYS` to
               start the instance.
               There are restrictions around when an instance can/cannot be activated (for
               example, a read pool instance should be stopped before stopping primary
               etc.). Please refer to the API documentation for more details.
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] availability_type: 'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
               Note that primary and read instances can have different availability types.
               Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
               Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
               can have regional availability (nodes are present in 2 or more zones in a region).
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        :param pulumi.Input['InstanceClientConnectionConfigArgs'] client_connection_config: Client connection specific configurations.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[_builtins.str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[_builtins.str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the alloydb instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InstanceMachineConfigArgs'] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input['InstanceNetworkConfigArgs'] network_config: Instance level network configuration.
               Structure is documented below.
        :param pulumi.Input['InstanceObservabilityConfigArgs'] observability_config: Configuration for enhanced query insights.
               Structure is documented below.
        :param pulumi.Input['InstancePscInstanceConfigArgs'] psc_instance_config: Configuration for Private Service Connect (PSC) for the instance.
               Structure is documented below.
        :param pulumi.Input['InstanceQueryInsightsConfigArgs'] query_insights_config: Configuration for query insights.
               Structure is documented below.
        :param pulumi.Input['InstanceReadPoolConfigArgs'] read_pool_config: Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if client_connection_config is not None:
            pulumi.set(__self__, "client_connection_config", client_connection_config)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gce_zone is not None:
            pulumi.set(__self__, "gce_zone", gce_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_config is not None:
            pulumi.set(__self__, "machine_config", machine_config)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if observability_config is not None:
            pulumi.set(__self__, "observability_config", observability_config)
        if psc_instance_config is not None:
            pulumi.set(__self__, "psc_instance_config", psc_instance_config)
        if query_insights_config is not None:
            pulumi.set(__self__, "query_insights_config", query_insights_config)
        if read_pool_config is not None:
            pulumi.set(__self__, "read_pool_config", read_pool_config)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Specifies whether an instance needs to spin up. Once the instance is
        active, the activation policy can be updated to the `NEVER` to stop the
        instance. Likewise, the activation policy can be updated to `ALWAYS` to
        start the instance.
        There are restrictions around when an instance can/cannot be activated (for
        example, a read pool instance should be stopped before stopping primary
        etc.). Please refer to the API documentation for more details.
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_policy", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
        Note that primary and read instances can have different availability types.
        Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
        Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
        can have regional availability (nodes are present in 2 or more zones in a region).
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_type", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectionConfig")
    def client_connection_config(self) -> Optional[pulumi.Input['InstanceClientConnectionConfigArgs']]:
        """
        Client connection specific configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "client_connection_config")

    @client_connection_config.setter
    def client_connection_config(self, value: Optional[pulumi.Input['InstanceClientConnectionConfigArgs']]):
        pulumi.set(self, "client_connection_config", value)

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "database_flags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @gce_zone.setter
    def gce_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gce_zone", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels for the alloydb instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> Optional[pulumi.Input['InstanceMachineConfigArgs']]:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: Optional[pulumi.Input['InstanceMachineConfigArgs']]):
        pulumi.set(self, "machine_config", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['InstanceNetworkConfigArgs']]:
        """
        Instance level network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['InstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter(name="observabilityConfig")
    def observability_config(self) -> Optional[pulumi.Input['InstanceObservabilityConfigArgs']]:
        """
        Configuration for enhanced query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "observability_config")

    @observability_config.setter
    def observability_config(self, value: Optional[pulumi.Input['InstanceObservabilityConfigArgs']]):
        pulumi.set(self, "observability_config", value)

    @_builtins.property
    @pulumi.getter(name="pscInstanceConfig")
    def psc_instance_config(self) -> Optional[pulumi.Input['InstancePscInstanceConfigArgs']]:
        """
        Configuration for Private Service Connect (PSC) for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_instance_config")

    @psc_instance_config.setter
    def psc_instance_config(self, value: Optional[pulumi.Input['InstancePscInstanceConfigArgs']]):
        pulumi.set(self, "psc_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="queryInsightsConfig")
    def query_insights_config(self) -> Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']]:
        """
        Configuration for query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "query_insights_config")

    @query_insights_config.setter
    def query_insights_config(self, value: Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']]):
        pulumi.set(self, "query_insights_config", value)

    @_builtins.property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> Optional[pulumi.Input['InstanceReadPoolConfigArgs']]:
        """
        Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @read_pool_config.setter
    def read_pool_config(self, value: Optional[pulumi.Input['InstanceReadPoolConfigArgs']]):
        pulumi.set(self, "read_pool_config", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connection_config: Optional[pulumi.Input['InstanceClientConnectionConfigArgs']] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gce_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_config: Optional[pulumi.Input['InstanceMachineConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_config: Optional[pulumi.Input['InstanceNetworkConfigArgs']] = None,
                 observability_config: Optional[pulumi.Input['InstanceObservabilityConfigArgs']] = None,
                 outbound_public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 psc_instance_config: Optional[pulumi.Input['InstancePscInstanceConfigArgs']] = None,
                 public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 query_insights_config: Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']] = None,
                 read_pool_config: Optional[pulumi.Input['InstanceReadPoolConfigArgs']] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] activation_policy: 'Specifies whether an instance needs to spin up. Once the instance is
               active, the activation policy can be updated to the `NEVER` to stop the
               instance. Likewise, the activation policy can be updated to `ALWAYS` to
               start the instance.
               There are restrictions around when an instance can/cannot be activated (for
               example, a read pool instance should be stopped before stopping primary
               etc.). Please refer to the API documentation for more details.
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] availability_type: 'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
               Note that primary and read instances can have different availability types.
               Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
               Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
               can have regional availability (nodes are present in 2 or more zones in a region).
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        :param pulumi.Input['InstanceClientConnectionConfigArgs'] client_connection_config: Client connection specific configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[_builtins.str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[_builtins.str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[_builtins.str] ip_address: The IP address for the Instance. This is the connection endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the alloydb instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InstanceMachineConfigArgs'] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the instance resource.
        :param pulumi.Input['InstanceNetworkConfigArgs'] network_config: Instance level network configuration.
               Structure is documented below.
        :param pulumi.Input['InstanceObservabilityConfigArgs'] observability_config: Configuration for enhanced query insights.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_public_ip_addresses: The outbound public IP addresses for the instance. This is available ONLY when
               networkConfig.enableOutboundPublicIp is set to true. These IP addresses are used
               for outbound connections.
        :param pulumi.Input['InstancePscInstanceConfigArgs'] psc_instance_config: Configuration for Private Service Connect (PSC) for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] public_ip_address: The public IP addresses for the Instance. This is available ONLY when
               networkConfig.enablePublicIp is set to true. This is the connection
               endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['InstanceQueryInsightsConfigArgs'] query_insights_config: Configuration for query insights.
               Structure is documented below.
        :param pulumi.Input['InstanceReadPoolConfigArgs'] read_pool_config: Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input[_builtins.str] state: The current state of the alloydb instance.
        :param pulumi.Input[_builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[_builtins.str] update_time: Time the Instance was updated in UTC.
        """
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if client_connection_config is not None:
            pulumi.set(__self__, "client_connection_config", client_connection_config)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if gce_zone is not None:
            pulumi.set(__self__, "gce_zone", gce_zone)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_config is not None:
            pulumi.set(__self__, "machine_config", machine_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if observability_config is not None:
            pulumi.set(__self__, "observability_config", observability_config)
        if outbound_public_ip_addresses is not None:
            pulumi.set(__self__, "outbound_public_ip_addresses", outbound_public_ip_addresses)
        if psc_instance_config is not None:
            pulumi.set(__self__, "psc_instance_config", psc_instance_config)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if query_insights_config is not None:
            pulumi.set(__self__, "query_insights_config", query_insights_config)
        if read_pool_config is not None:
            pulumi.set(__self__, "read_pool_config", read_pool_config)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Specifies whether an instance needs to spin up. Once the instance is
        active, the activation policy can be updated to the `NEVER` to stop the
        instance. Likewise, the activation policy can be updated to `ALWAYS` to
        start the instance.
        There are restrictions around when an instance can/cannot be activated (for
        example, a read pool instance should be stopped before stopping primary
        etc.). Please refer to the API documentation for more details.
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_policy", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
        Note that primary and read instances can have different availability types.
        Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
        Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
        can have regional availability (nodes are present in 2 or more zones in a region).
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_type", value)

    @_builtins.property
    @pulumi.getter(name="clientConnectionConfig")
    def client_connection_config(self) -> Optional[pulumi.Input['InstanceClientConnectionConfigArgs']]:
        """
        Client connection specific configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "client_connection_config")

    @client_connection_config.setter
    def client_connection_config(self, value: Optional[pulumi.Input['InstanceClientConnectionConfigArgs']]):
        pulumi.set(self, "client_connection_config", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "database_flags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @gce_zone.setter
    def gce_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gce_zone", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels for the alloydb instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> Optional[pulumi.Input['InstanceMachineConfigArgs']]:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: Optional[pulumi.Input['InstanceMachineConfigArgs']]):
        pulumi.set(self, "machine_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['InstanceNetworkConfigArgs']]:
        """
        Instance level network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['InstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @_builtins.property
    @pulumi.getter(name="observabilityConfig")
    def observability_config(self) -> Optional[pulumi.Input['InstanceObservabilityConfigArgs']]:
        """
        Configuration for enhanced query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "observability_config")

    @observability_config.setter
    def observability_config(self, value: Optional[pulumi.Input['InstanceObservabilityConfigArgs']]):
        pulumi.set(self, "observability_config", value)

    @_builtins.property
    @pulumi.getter(name="outboundPublicIpAddresses")
    def outbound_public_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The outbound public IP addresses for the instance. This is available ONLY when
        networkConfig.enableOutboundPublicIp is set to true. These IP addresses are used
        for outbound connections.
        """
        return pulumi.get(self, "outbound_public_ip_addresses")

    @outbound_public_ip_addresses.setter
    def outbound_public_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_public_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="pscInstanceConfig")
    def psc_instance_config(self) -> Optional[pulumi.Input['InstancePscInstanceConfigArgs']]:
        """
        Configuration for Private Service Connect (PSC) for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_instance_config")

    @psc_instance_config.setter
    def psc_instance_config(self, value: Optional[pulumi.Input['InstancePscInstanceConfigArgs']]):
        pulumi.set(self, "psc_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IP addresses for the Instance. This is available ONLY when
        networkConfig.enablePublicIp is set to true. This is the connection
        endpoint for an end-user application.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="queryInsightsConfig")
    def query_insights_config(self) -> Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']]:
        """
        Configuration for query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "query_insights_config")

    @query_insights_config.setter
    def query_insights_config(self, value: Optional[pulumi.Input['InstanceQueryInsightsConfigArgs']]):
        pulumi.set(self, "query_insights_config", value)

    @_builtins.property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> Optional[pulumi.Input['InstanceReadPoolConfigArgs']]:
        """
        Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @read_pool_config.setter
    def read_pool_config(self, value: Optional[pulumi.Input['InstanceReadPoolConfigArgs']]):
        pulumi.set(self, "read_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the alloydb instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:alloydb/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connection_config: Optional[pulumi.Input[Union['InstanceClientConnectionConfigArgs', 'InstanceClientConnectionConfigArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gce_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_config: Optional[pulumi.Input[Union['InstanceMachineConfigArgs', 'InstanceMachineConfigArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
                 observability_config: Optional[pulumi.Input[Union['InstanceObservabilityConfigArgs', 'InstanceObservabilityConfigArgsDict']]] = None,
                 psc_instance_config: Optional[pulumi.Input[Union['InstancePscInstanceConfigArgs', 'InstancePscInstanceConfigArgsDict']]] = None,
                 query_insights_config: Optional[pulumi.Input[Union['InstanceQueryInsightsConfigArgs', 'InstanceQueryInsightsConfigArgsDict']]] = None,
                 read_pool_config: Optional[pulumi.Input[Union['InstanceReadPoolConfigArgs', 'InstanceReadPoolConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Alloydb Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default_network.id,
            },
            initial_user={
                "password": "alloydb-cluster",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-cluster",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default_network.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        default = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Secondary Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-secondary-network")
        primary = gcp.alloydb.Cluster("primary",
            cluster_id="alloydb-primary-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-secondary-instance",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        primary_instance = gcp.alloydb.Instance("primary",
            cluster=primary.name,
            instance_id="alloydb-primary-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        secondary = gcp.alloydb.Cluster("secondary",
            cluster_id="alloydb-secondary-cluster",
            location="us-east1",
            network_config={
                "network": default_google_compute_network["id"],
            },
            cluster_type="SECONDARY",
            continuous_backup_config={
                "enabled": False,
            },
            secondary_config={
                "primary_cluster_name": primary.name,
            },
            deletion_policy="FORCE",
            opts = pulumi.ResourceOptions(depends_on=[primary_instance]))
        secondary_instance = gcp.alloydb.Instance("secondary",
            cluster=secondary.name,
            instance_id="alloydb-secondary-instance",
            instance_type=secondary.cluster_type,
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{cluster}}/{{instance_id}}`

        * `{{location}}/{{cluster}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default {{project}}/{{location}}/{{cluster}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default {{location}}/{{cluster}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_policy: 'Specifies whether an instance needs to spin up. Once the instance is
               active, the activation policy can be updated to the `NEVER` to stop the
               instance. Likewise, the activation policy can be updated to `ALWAYS` to
               start the instance.
               There are restrictions around when an instance can/cannot be activated (for
               example, a read pool instance should be stopped before stopping primary
               etc.). Please refer to the API documentation for more details.
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] availability_type: 'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
               Note that primary and read instances can have different availability types.
               Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
               Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
               can have regional availability (nodes are present in 2 or more zones in a region).
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        :param pulumi.Input[Union['InstanceClientConnectionConfigArgs', 'InstanceClientConnectionConfigArgsDict']] client_connection_config: Client connection specific configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[_builtins.str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[_builtins.str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the alloydb instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['InstanceMachineConfigArgs', 'InstanceMachineConfigArgsDict']] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']] network_config: Instance level network configuration.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceObservabilityConfigArgs', 'InstanceObservabilityConfigArgsDict']] observability_config: Configuration for enhanced query insights.
               Structure is documented below.
        :param pulumi.Input[Union['InstancePscInstanceConfigArgs', 'InstancePscInstanceConfigArgsDict']] psc_instance_config: Configuration for Private Service Connect (PSC) for the instance.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceQueryInsightsConfigArgs', 'InstanceQueryInsightsConfigArgsDict']] query_insights_config: Configuration for query insights.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceReadPoolConfigArgs', 'InstanceReadPoolConfigArgsDict']] read_pool_config: Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Alloydb Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="alloydb-network")
        default_cluster = gcp.alloydb.Cluster("default",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network_config={
                "network": default_network.id,
            },
            initial_user={
                "password": "alloydb-cluster",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-cluster",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default_network.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        default = gcp.alloydb.Instance("default",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        project = gcp.organizations.get_project()
        ```
        ### Alloydb Secondary Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="alloydb-secondary-network")
        primary = gcp.alloydb.Cluster("primary",
            cluster_id="alloydb-primary-cluster",
            location="us-central1",
            network_config={
                "network": default.id,
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="alloydb-secondary-instance",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        primary_instance = gcp.alloydb.Instance("primary",
            cluster=primary.name,
            instance_id="alloydb-primary-instance",
            instance_type="PRIMARY",
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        secondary = gcp.alloydb.Cluster("secondary",
            cluster_id="alloydb-secondary-cluster",
            location="us-east1",
            network_config={
                "network": default_google_compute_network["id"],
            },
            cluster_type="SECONDARY",
            continuous_backup_config={
                "enabled": False,
            },
            secondary_config={
                "primary_cluster_name": primary.name,
            },
            deletion_policy="FORCE",
            opts = pulumi.ResourceOptions(depends_on=[primary_instance]))
        secondary_instance = gcp.alloydb.Instance("secondary",
            cluster=secondary.name,
            instance_id="alloydb-secondary-instance",
            instance_type=secondary.cluster_type,
            machine_config={
                "cpu_count": 2,
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        project = gcp.organizations.get_project()
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{cluster}}/{{instance_id}}`

        * `{{location}}/{{cluster}}/{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default projects/{{project}}/locations/{{location}}/clusters/{{cluster}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default {{project}}/{{location}}/{{cluster}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:alloydb/instance:Instance default {{location}}/{{cluster}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 availability_type: Optional[pulumi.Input[_builtins.str]] = None,
                 client_connection_config: Optional[pulumi.Input[Union['InstanceClientConnectionConfigArgs', 'InstanceClientConnectionConfigArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gce_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_config: Optional[pulumi.Input[Union['InstanceMachineConfigArgs', 'InstanceMachineConfigArgsDict']]] = None,
                 network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
                 observability_config: Optional[pulumi.Input[Union['InstanceObservabilityConfigArgs', 'InstanceObservabilityConfigArgsDict']]] = None,
                 psc_instance_config: Optional[pulumi.Input[Union['InstancePscInstanceConfigArgs', 'InstancePscInstanceConfigArgsDict']]] = None,
                 query_insights_config: Optional[pulumi.Input[Union['InstanceQueryInsightsConfigArgs', 'InstanceQueryInsightsConfigArgsDict']]] = None,
                 read_pool_config: Optional[pulumi.Input[Union['InstanceReadPoolConfigArgs', 'InstanceReadPoolConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["activation_policy"] = activation_policy
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["availability_type"] = availability_type
            __props__.__dict__["client_connection_config"] = client_connection_config
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["database_flags"] = database_flags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["gce_zone"] = gce_zone
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["machine_config"] = machine_config
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["observability_config"] = observability_config
            __props__.__dict__["psc_instance_config"] = psc_instance_config
            __props__.__dict__["query_insights_config"] = query_insights_config
            __props__.__dict__["read_pool_config"] = read_pool_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["outbound_public_ip_addresses"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:alloydb/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_policy: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            availability_type: Optional[pulumi.Input[_builtins.str]] = None,
            client_connection_config: Optional[pulumi.Input[Union['InstanceClientConnectionConfigArgs', 'InstanceClientConnectionConfigArgsDict']]] = None,
            cluster: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gce_zone: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            machine_config: Optional[pulumi.Input[Union['InstanceMachineConfigArgs', 'InstanceMachineConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
            observability_config: Optional[pulumi.Input[Union['InstanceObservabilityConfigArgs', 'InstanceObservabilityConfigArgsDict']]] = None,
            outbound_public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            psc_instance_config: Optional[pulumi.Input[Union['InstancePscInstanceConfigArgs', 'InstancePscInstanceConfigArgsDict']]] = None,
            public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            query_insights_config: Optional[pulumi.Input[Union['InstanceQueryInsightsConfigArgs', 'InstanceQueryInsightsConfigArgsDict']]] = None,
            read_pool_config: Optional[pulumi.Input[Union['InstanceReadPoolConfigArgs', 'InstanceReadPoolConfigArgsDict']]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_policy: 'Specifies whether an instance needs to spin up. Once the instance is
               active, the activation policy can be updated to the `NEVER` to stop the
               instance. Likewise, the activation policy can be updated to `ALWAYS` to
               start the instance.
               There are restrictions around when an instance can/cannot be activated (for
               example, a read pool instance should be stopped before stopping primary
               etc.). Please refer to the API documentation for more details.
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
               Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] availability_type: 'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
               Note that primary and read instances can have different availability types.
               Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
               Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
               can have regional availability (nodes are present in 2 or more zones in a region).
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
               Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        :param pulumi.Input[Union['InstanceClientConnectionConfigArgs', 'InstanceClientConnectionConfigArgsDict']] client_connection_config: Client connection specific configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[_builtins.str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[_builtins.str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[_builtins.str] ip_address: The IP address for the Instance. This is the connection endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels for the alloydb instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['InstanceMachineConfigArgs', 'InstanceMachineConfigArgsDict']] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the instance resource.
        :param pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']] network_config: Instance level network configuration.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceObservabilityConfigArgs', 'InstanceObservabilityConfigArgsDict']] observability_config: Configuration for enhanced query insights.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_public_ip_addresses: The outbound public IP addresses for the instance. This is available ONLY when
               networkConfig.enableOutboundPublicIp is set to true. These IP addresses are used
               for outbound connections.
        :param pulumi.Input[Union['InstancePscInstanceConfigArgs', 'InstancePscInstanceConfigArgsDict']] psc_instance_config: Configuration for Private Service Connect (PSC) for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] public_ip_address: The public IP addresses for the Instance. This is available ONLY when
               networkConfig.enablePublicIp is set to true. This is the connection
               endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['InstanceQueryInsightsConfigArgs', 'InstanceQueryInsightsConfigArgsDict']] query_insights_config: Configuration for query insights.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceReadPoolConfigArgs', 'InstanceReadPoolConfigArgsDict']] read_pool_config: Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] reconciling: Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input[_builtins.str] state: The current state of the alloydb instance.
        :param pulumi.Input[_builtins.str] uid: The system-generated UID of the resource.
        :param pulumi.Input[_builtins.str] update_time: Time the Instance was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["activation_policy"] = activation_policy
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["availability_type"] = availability_type
        __props__.__dict__["client_connection_config"] = client_connection_config
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database_flags"] = database_flags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["gce_zone"] = gce_zone
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_config"] = machine_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["observability_config"] = observability_config
        __props__.__dict__["outbound_public_ip_addresses"] = outbound_public_ip_addresses
        __props__.__dict__["psc_instance_config"] = psc_instance_config
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["query_insights_config"] = query_insights_config
        __props__.__dict__["read_pool_config"] = read_pool_config
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> pulumi.Output[_builtins.str]:
        """
        'Specifies whether an instance needs to spin up. Once the instance is
        active, the activation policy can be updated to the `NEVER` to stop the
        instance. Likewise, the activation policy can be updated to `ALWAYS` to
        start the instance.
        There are restrictions around when an instance can/cannot be activated (for
        example, a read pool instance should be stopped before stopping primary
        etc.). Please refer to the API documentation for more details.
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.'
        Possible values are: `ACTIVATION_POLICY_UNSPECIFIED`, `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> pulumi.Output[_builtins.str]:
        """
        'Availability type of an Instance. Defaults to REGIONAL for both primary and read instances.
        Note that primary and read instances can have different availability types.
        Primary instances can be either ZONAL or REGIONAL. Read Pool instances can also be either ZONAL or REGIONAL.
        Read pools of size 1 can only have zonal availability. Read pools with a node count of 2 or more
        can have regional availability (nodes are present in 2 or more zones in a region).
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.'
        Possible values are: `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @_builtins.property
    @pulumi.getter(name="clientConnectionConfig")
    def client_connection_config(self) -> pulumi.Output['outputs.InstanceClientConnectionConfig']:
        """
        Client connection specific configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "client_connection_config")

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined labels for the alloydb instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> pulumi.Output['outputs.InstanceMachineConfig']:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.InstanceNetworkConfig']:
        """
        Instance level network configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @_builtins.property
    @pulumi.getter(name="observabilityConfig")
    def observability_config(self) -> pulumi.Output['outputs.InstanceObservabilityConfig']:
        """
        Configuration for enhanced query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "observability_config")

    @_builtins.property
    @pulumi.getter(name="outboundPublicIpAddresses")
    def outbound_public_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The outbound public IP addresses for the instance. This is available ONLY when
        networkConfig.enableOutboundPublicIp is set to true. These IP addresses are used
        for outbound connections.
        """
        return pulumi.get(self, "outbound_public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="pscInstanceConfig")
    def psc_instance_config(self) -> pulumi.Output['outputs.InstancePscInstanceConfig']:
        """
        Configuration for Private Service Connect (PSC) for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_instance_config")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The public IP addresses for the Instance. This is available ONLY when
        networkConfig.enablePublicIp is set to true. This is the connection
        endpoint for an end-user application.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="queryInsightsConfig")
    def query_insights_config(self) -> pulumi.Output['outputs.InstanceQueryInsightsConfig']:
        """
        Configuration for query insights.
        Structure is documented below.
        """
        return pulumi.get(self, "query_insights_config")

    @_builtins.property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> pulumi.Output[Optional['outputs.InstanceReadPoolConfig']]:
        """
        Read pool specific config. If the instance type is READ_POOL, this configuration must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the alloydb instance.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

