# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 config_bundle: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 detect_md5hash: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[_builtins.str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[_builtins.str] name: The ID of the API proxy.
        """
        pulumi.set(__self__, "config_bundle", config_bundle)
        pulumi.set(__self__, "org_id", org_id)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> pulumi.Input[_builtins.str]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @config_bundle.setter
    def config_bundle(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "config_bundle", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detect_md5hash", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API proxy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 config_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_md5hash: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 md5hash: Optional[pulumi.Input[_builtins.str]] = None,
                 meta_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMetaDataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revisions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[_builtins.str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[_builtins.str] latest_revision_id: The id of the most recently created revision for this API proxy.
        :param pulumi.Input[_builtins.str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMetaDataArgs']]] meta_datas: Metadata describing the API proxy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The ID of the API proxy.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revisions: A list of revisions of this API proxy.
        """
        if config_bundle is not None:
            pulumi.set(__self__, "config_bundle", config_bundle)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if latest_revision_id is not None:
            pulumi.set(__self__, "latest_revision_id", latest_revision_id)
        if md5hash is not None:
            pulumi.set(__self__, "md5hash", md5hash)
        if meta_datas is not None:
            pulumi.set(__self__, "meta_datas", meta_datas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if revisions is not None:
            pulumi.set(__self__, "revisions", revisions)

    @_builtins.property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @config_bundle.setter
    def config_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_bundle", value)

    @_builtins.property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detect_md5hash", value)

    @_builtins.property
    @pulumi.getter(name="latestRevisionId")
    def latest_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the most recently created revision for this API proxy.
        """
        return pulumi.get(self, "latest_revision_id")

    @latest_revision_id.setter
    def latest_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_revision_id", value)

    @_builtins.property
    @pulumi.getter
    def md5hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        """
        return pulumi.get(self, "md5hash")

    @md5hash.setter
    def md5hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "md5hash", value)

    @_builtins.property
    @pulumi.getter(name="metaDatas")
    def meta_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMetaDataArgs']]]]:
        """
        Metadata describing the API proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "meta_datas")

    @meta_datas.setter
    def meta_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMetaDataArgs']]]]):
        pulumi.set(self, "meta_datas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API proxy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def revisions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of revisions of this API proxy.
        """
        return pulumi.get(self, "revisions")

    @revisions.setter
    def revisions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "revisions", value)


@pulumi.type_token("gcp:apigee/api:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_md5hash: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        To get more information about API proxies see, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.apis)
        * How-to Guides
          * [API proxies](https://cloud.google.com/apigee/docs/resources)

        ## Import

        An API proxy can be imported using any of these accepted formats:

        * `{{org_id}}/apis/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, API proxy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/api:Api default {{org_id}}/apis/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/api:Api default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[_builtins.str] name: The ID of the API proxy.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization name associated with the Apigee instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        To get more information about API proxies see, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.apis)
        * How-to Guides
          * [API proxies](https://cloud.google.com/apigee/docs/resources)

        ## Import

        An API proxy can be imported using any of these accepted formats:

        * `{{org_id}}/apis/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, API proxy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/api:Api default {{org_id}}/apis/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/api:Api default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_md5hash: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            if config_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'config_bundle'")
            __props__.__dict__["config_bundle"] = config_bundle
            __props__.__dict__["detect_md5hash"] = detect_md5hash
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["latest_revision_id"] = None
            __props__.__dict__["md5hash"] = None
            __props__.__dict__["meta_datas"] = None
            __props__.__dict__["revisions"] = None
        super(Api, __self__).__init__(
            'gcp:apigee/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_bundle: Optional[pulumi.Input[_builtins.str]] = None,
            detect_md5hash: Optional[pulumi.Input[_builtins.str]] = None,
            latest_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            md5hash: Optional[pulumi.Input[_builtins.str]] = None,
            meta_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiMetaDataArgs', 'ApiMetaDataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            revisions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_bundle: Path to the config zip bundle.
               
               - - -
        :param pulumi.Input[_builtins.str] latest_revision_id: The id of the most recently created revision for this API proxy.
        :param pulumi.Input[_builtins.str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiMetaDataArgs', 'ApiMetaDataArgsDict']]]] meta_datas: Metadata describing the API proxy.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The ID of the API proxy.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization name associated with the Apigee instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] revisions: A list of revisions of this API proxy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["config_bundle"] = config_bundle
        __props__.__dict__["detect_md5hash"] = detect_md5hash
        __props__.__dict__["latest_revision_id"] = latest_revision_id
        __props__.__dict__["md5hash"] = md5hash
        __props__.__dict__["meta_datas"] = meta_datas
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["revisions"] = revisions
        return Api(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configBundle")
    def config_bundle(self) -> pulumi.Output[_builtins.str]:
        """
        Path to the config zip bundle.

        - - -
        """
        return pulumi.get(self, "config_bundle")

    @_builtins.property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "detect_md5hash")

    @_builtins.property
    @pulumi.getter(name="latestRevisionId")
    def latest_revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the most recently created revision for this API proxy.
        """
        return pulumi.get(self, "latest_revision_id")

    @_builtins.property
    @pulumi.getter
    def md5hash(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data. It is speculative as remote does not return hash of the bundle. Remote changes are detected using returned last_modified timestamp.
        """
        return pulumi.get(self, "md5hash")

    @_builtins.property
    @pulumi.getter(name="metaDatas")
    def meta_datas(self) -> pulumi.Output[Sequence['outputs.ApiMetaData']]:
        """
        Metadata describing the API proxy.
        Structure is documented below.
        """
        return pulumi.get(self, "meta_datas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the API proxy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization name associated with the Apigee instance.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def revisions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of revisions of this API proxy.
        """
        return pulumi.get(self, "revisions")

