# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppGroupArgs', 'AppGroup']

@pulumi.input_type
class AppGroupArgs:
    def __init__(__self__, *,
                 org_id: pulumi.Input[_builtins.str],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]] = None,
                 channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppGroup resource.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee app group,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]] attributes: A list of attributes
               Structure is documented below.
        :param pulumi.Input[_builtins.str] channel_id: Channel identifier identifies the owner maintaining this grouping.
        :param pulumi.Input[_builtins.str] channel_uri: A reference to the associated storefront/marketplace.
        :param pulumi.Input[_builtins.str] display_name: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] name: Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        :param pulumi.Input[_builtins.str] status: Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
               Possible values are: `active`, `inactive`.
        """
        pulumi.set(__self__, "org_id", org_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if channel_uri is not None:
            pulumi.set(__self__, "channel_uri", channel_uri)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee app group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]]:
        """
        A list of attributes
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Channel identifier identifies the owner maintaining this grouping.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_id", value)

    @_builtins.property
    @pulumi.getter(name="channelUri")
    def channel_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the associated storefront/marketplace.
        """
        return pulumi.get(self, "channel_uri")

    @channel_uri.setter
    def channel_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_uri", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App group name displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
        Possible values are: `active`, `inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AppGroupState:
    def __init__(__self__, *,
                 app_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]] = None,
                 channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppGroup resources.
        :param pulumi.Input[_builtins.str] app_group_id: Internal identifier that cannot be edited
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]] attributes: A list of attributes
               Structure is documented below.
        :param pulumi.Input[_builtins.str] channel_id: Channel identifier identifies the owner maintaining this grouping.
        :param pulumi.Input[_builtins.str] channel_uri: A reference to the associated storefront/marketplace.
        :param pulumi.Input[_builtins.str] created_at: Created time as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] display_name: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] last_modified_at: Modified time as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee app group,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[_builtins.str] organization: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] status: Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
               Possible values are: `active`, `inactive`.
        """
        if app_group_id is not None:
            pulumi.set(__self__, "app_group_id", app_group_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if channel_uri is not None:
            pulumi.set(__self__, "channel_uri", channel_uri)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="appGroupId")
    def app_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internal identifier that cannot be edited
        """
        return pulumi.get(self, "app_group_id")

    @app_group_id.setter
    def app_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_group_id", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]]:
        """
        A list of attributes
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Channel identifier identifies the owner maintaining this grouping.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_id", value)

    @_builtins.property
    @pulumi.getter(name="channelUri")
    def channel_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to the associated storefront/marketplace.
        """
        return pulumi.get(self, "channel_uri")

    @channel_uri.setter
    def channel_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_uri", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created time as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App group name displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modified time as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee app group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App group name displayed in the UI
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
        Possible values are: `active`, `inactive`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("gcp:apigee/appGroup:AppGroup")
class AppGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAttributeArgs', 'AppGroupAttributeArgsDict']]]]] = None,
                 channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An `AppGroup` in Apigee.

        To get more information about AppGroup, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.appgroups)
        * How-to Guides
            * [Organizing client app ownership](https://cloud.google.com/apigee/docs/api-platform/publish/organizing-client-app-ownership)

        ## Example Usage

        ### Apigee App Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_app_group = gcp.apigee.AppGroup("apigee_app_group",
            name="my-app-group",
            display_name="Test app group",
            channel_id="storefront",
            channel_uri="https://my-dev-portal.org/groups/my-group",
            status="active",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee App Group With Attributes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_app_group = gcp.apigee.AppGroup("apigee_app_group",
            name="my-app-group",
            display_name="Test app group",
            channel_id="storefront",
            channel_uri="https://my-dev-portal.org/groups/my-group",
            status="active",
            org_id=apigee_org.id,
            attributes=[
                {
                    "name": "business_unit",
                    "value": "HR",
                },
                {
                    "name": "department",
                    "value": "payroll",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```

        ## Import

        AppGroup can be imported using any of these accepted formats:

        * `{{org_id}}/appgroups/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, AppGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/appGroup:AppGroup default {{org_id}}/appgroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/appGroup:AppGroup default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAttributeArgs', 'AppGroupAttributeArgsDict']]]] attributes: A list of attributes
               Structure is documented below.
        :param pulumi.Input[_builtins.str] channel_id: Channel identifier identifies the owner maintaining this grouping.
        :param pulumi.Input[_builtins.str] channel_uri: A reference to the associated storefront/marketplace.
        :param pulumi.Input[_builtins.str] display_name: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] name: Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee app group,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[_builtins.str] status: Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
               Possible values are: `active`, `inactive`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `AppGroup` in Apigee.

        To get more information about AppGroup, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.appgroups)
        * How-to Guides
            * [Organizing client app ownership](https://cloud.google.com/apigee/docs/api-platform/publish/organizing-client-app-ownership)

        ## Example Usage

        ### Apigee App Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_app_group = gcp.apigee.AppGroup("apigee_app_group",
            name="my-app-group",
            display_name="Test app group",
            channel_id="storefront",
            channel_uri="https://my-dev-portal.org/groups/my-group",
            status="active",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee App Group With Attributes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        apigee_app_group = gcp.apigee.AppGroup("apigee_app_group",
            name="my-app-group",
            display_name="Test app group",
            channel_id="storefront",
            channel_uri="https://my-dev-portal.org/groups/my-group",
            status="active",
            org_id=apigee_org.id,
            attributes=[
                {
                    "name": "business_unit",
                    "value": "HR",
                },
                {
                    "name": "department",
                    "value": "payroll",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```

        ## Import

        AppGroup can be imported using any of these accepted formats:

        * `{{org_id}}/appgroups/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, AppGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/appGroup:AppGroup default {{org_id}}/appgroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/appGroup:AppGroup default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AppGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAttributeArgs', 'AppGroupAttributeArgsDict']]]]] = None,
                 channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppGroupArgs.__new__(AppGroupArgs)

            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["channel_id"] = channel_id
            __props__.__dict__["channel_uri"] = channel_uri
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["status"] = status
            __props__.__dict__["app_group_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_modified_at"] = None
            __props__.__dict__["organization"] = None
        super(AppGroup, __self__).__init__(
            'gcp:apigee/appGroup:AppGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAttributeArgs', 'AppGroupAttributeArgsDict']]]]] = None,
            channel_id: Optional[pulumi.Input[_builtins.str]] = None,
            channel_uri: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppGroup':
        """
        Get an existing AppGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_group_id: Internal identifier that cannot be edited
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAttributeArgs', 'AppGroupAttributeArgsDict']]]] attributes: A list of attributes
               Structure is documented below.
        :param pulumi.Input[_builtins.str] channel_id: Channel identifier identifies the owner maintaining this grouping.
        :param pulumi.Input[_builtins.str] channel_uri: A reference to the associated storefront/marketplace.
        :param pulumi.Input[_builtins.str] created_at: Created time as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] display_name: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] last_modified_at: Modified time as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee app group,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[_builtins.str] organization: App group name displayed in the UI
        :param pulumi.Input[_builtins.str] status: Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
               Possible values are: `active`, `inactive`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppGroupState.__new__(_AppGroupState)

        __props__.__dict__["app_group_id"] = app_group_id
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["channel_id"] = channel_id
        __props__.__dict__["channel_uri"] = channel_uri
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_modified_at"] = last_modified_at
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["organization"] = organization
        __props__.__dict__["status"] = status
        return AppGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appGroupId")
    def app_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Internal identifier that cannot be edited
        """
        return pulumi.get(self, "app_group_id")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Sequence['outputs.AppGroupAttribute']]]:
        """
        A list of attributes
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Channel identifier identifies the owner maintaining this grouping.
        """
        return pulumi.get(self, "channel_id")

    @_builtins.property
    @pulumi.getter(name="channelUri")
    def channel_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A reference to the associated storefront/marketplace.
        """
        return pulumi.get(self, "channel_uri")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Created time as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        App group name displayed in the UI
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Modified time as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the AppGroup. Characters you can use in the name are restricted to: A-Z0-9._-$ %.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee app group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        App group name displayed in the UI
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are active or inactive. Note that the status of the AppGroup should be updated via UpdateAppGroupRequest by setting the action as active or inactive.
        Possible values are: `active`, `inactive`.
        """
        return pulumi.get(self, "status")

