# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 plugin_id: pulumi.Input[_builtins.str],
                 actions_configs: Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]] = None,
                 config_template: Optional[pulumi.Input['PluginConfigTemplateArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input['PluginDocumentationArgs']] = None,
                 hosting_service: Optional[pulumi.Input['PluginHostingServiceArgs']] = None,
                 plugin_category: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the plugin. Max length is 50 characters (Unicode code
               points).
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] plugin_id: The ID to use for the Plugin resource, which will become the final
               component of the Plugin's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another Plugin resource in the API hub
               instance.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, overall resource name which will be
               of format
               `projects/{project}/locations/{location}/plugins/{plugin}`,
               its length is limited to 1000 characters and valid characters are
               /a-z[0-9]-_/.
        :param pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]] actions_configs: The configuration of actions supported by the plugin.
               Structure is documented below.
        :param pulumi.Input['PluginConfigTemplateArgs'] config_template: ConfigTemplate represents the configuration template for a plugin.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The plugin description. Max length is 2000 characters (Unicode code
               points).
        :param pulumi.Input['PluginDocumentationArgs'] documentation: Documentation details.
               Structure is documented below.
        :param pulumi.Input['PluginHostingServiceArgs'] hosting_service: The information related to the service implemented by the plugin
               developer, used to invoke the plugin's functionality.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] plugin_category: Possible values:
               PLUGIN_CATEGORY_UNSPECIFIED
               API_GATEWAY
               API_PRODUCER
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "plugin_id", plugin_id)
        if actions_configs is not None:
            pulumi.set(__self__, "actions_configs", actions_configs)
        if config_template is not None:
            pulumi.set(__self__, "config_template", config_template)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if hosting_service is not None:
            pulumi.set(__self__, "hosting_service", hosting_service)
        if plugin_category is not None:
            pulumi.set(__self__, "plugin_category", plugin_category)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the plugin. Max length is 50 characters (Unicode code
        points).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the Plugin resource, which will become the final
        component of the Plugin's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another Plugin resource in the API hub
        instance.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, overall resource name which will be
        of format
        `projects/{project}/locations/{location}/plugins/{plugin}`,
        its length is limited to 1000 characters and valid characters are
        /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter(name="actionsConfigs")
    def actions_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]]:
        """
        The configuration of actions supported by the plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "actions_configs")

    @actions_configs.setter
    def actions_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]]):
        pulumi.set(self, "actions_configs", value)

    @_builtins.property
    @pulumi.getter(name="configTemplate")
    def config_template(self) -> Optional[pulumi.Input['PluginConfigTemplateArgs']]:
        """
        ConfigTemplate represents the configuration template for a plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "config_template")

    @config_template.setter
    def config_template(self, value: Optional[pulumi.Input['PluginConfigTemplateArgs']]):
        pulumi.set(self, "config_template", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plugin description. Max length is 2000 characters (Unicode code
        points).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input['PluginDocumentationArgs']]:
        """
        Documentation details.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input['PluginDocumentationArgs']]):
        pulumi.set(self, "documentation", value)

    @_builtins.property
    @pulumi.getter(name="hostingService")
    def hosting_service(self) -> Optional[pulumi.Input['PluginHostingServiceArgs']]:
        """
        The information related to the service implemented by the plugin
        developer, used to invoke the plugin's functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "hosting_service")

    @hosting_service.setter
    def hosting_service(self, value: Optional[pulumi.Input['PluginHostingServiceArgs']]):
        pulumi.set(self, "hosting_service", value)

    @_builtins.property
    @pulumi.getter(name="pluginCategory")
    def plugin_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values:
        PLUGIN_CATEGORY_UNSPECIFIED
        API_GATEWAY
        API_PRODUCER
        """
        return pulumi.get(self, "plugin_category")

    @plugin_category.setter
    def plugin_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_category", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _PluginState:
    def __init__(__self__, *,
                 actions_configs: Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]] = None,
                 config_template: Optional[pulumi.Input['PluginConfigTemplateArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input['PluginDocumentationArgs']] = None,
                 hosting_service: Optional[pulumi.Input['PluginHostingServiceArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_type: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_category: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Plugin resources.
        :param pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]] actions_configs: The configuration of actions supported by the plugin.
               Structure is documented below.
        :param pulumi.Input['PluginConfigTemplateArgs'] config_template: ConfigTemplate represents the configuration template for a plugin.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp indicating when the plugin was created.
        :param pulumi.Input[_builtins.str] description: The plugin description. Max length is 2000 characters (Unicode code
               points).
        :param pulumi.Input[_builtins.str] display_name: The display name of the plugin. Max length is 50 characters (Unicode code
               points).
        :param pulumi.Input['PluginDocumentationArgs'] documentation: Documentation details.
               Structure is documented below.
        :param pulumi.Input['PluginHostingServiceArgs'] hosting_service: The information related to the service implemented by the plugin
               developer, used to invoke the plugin's functionality.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the plugin.
               Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        :param pulumi.Input[_builtins.str] ownership_type: The type of the plugin, indicating whether it is 'SYSTEM_OWNED' or
               'USER_OWNED'.
               Possible values:
               OWNERSHIP_TYPE_UNSPECIFIED
               SYSTEM_OWNED
               USER_OWNED
        :param pulumi.Input[_builtins.str] plugin_category: Possible values:
               PLUGIN_CATEGORY_UNSPECIFIED
               API_GATEWAY
               API_PRODUCER
        :param pulumi.Input[_builtins.str] plugin_id: The ID to use for the Plugin resource, which will become the final
               component of the Plugin's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another Plugin resource in the API hub
               instance.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, overall resource name which will be
               of format
               `projects/{project}/locations/{location}/plugins/{plugin}`,
               its length is limited to 1000 characters and valid characters are
               /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] state: Represents the state of the plugin.
               Note this field will not be set for plugins developed via plugin
               framework as the state will be managed at plugin instance level.
               Possible values:
               STATE_UNSPECIFIED
               ENABLED
               DISABLED
        :param pulumi.Input[_builtins.str] update_time: Timestamp indicating when the plugin was last updated.
        """
        if actions_configs is not None:
            pulumi.set(__self__, "actions_configs", actions_configs)
        if config_template is not None:
            pulumi.set(__self__, "config_template", config_template)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if hosting_service is not None:
            pulumi.set(__self__, "hosting_service", hosting_service)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_type is not None:
            pulumi.set(__self__, "ownership_type", ownership_type)
        if plugin_category is not None:
            pulumi.set(__self__, "plugin_category", plugin_category)
        if plugin_id is not None:
            pulumi.set(__self__, "plugin_id", plugin_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="actionsConfigs")
    def actions_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]]:
        """
        The configuration of actions supported by the plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "actions_configs")

    @actions_configs.setter
    def actions_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginActionsConfigArgs']]]]):
        pulumi.set(self, "actions_configs", value)

    @_builtins.property
    @pulumi.getter(name="configTemplate")
    def config_template(self) -> Optional[pulumi.Input['PluginConfigTemplateArgs']]:
        """
        ConfigTemplate represents the configuration template for a plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "config_template")

    @config_template.setter
    def config_template(self, value: Optional[pulumi.Input['PluginConfigTemplateArgs']]):
        pulumi.set(self, "config_template", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp indicating when the plugin was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plugin description. Max length is 2000 characters (Unicode code
        points).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the plugin. Max length is 50 characters (Unicode code
        points).
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input['PluginDocumentationArgs']]:
        """
        Documentation details.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input['PluginDocumentationArgs']]):
        pulumi.set(self, "documentation", value)

    @_builtins.property
    @pulumi.getter(name="hostingService")
    def hosting_service(self) -> Optional[pulumi.Input['PluginHostingServiceArgs']]:
        """
        The information related to the service implemented by the plugin
        developer, used to invoke the plugin's functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "hosting_service")

    @hosting_service.setter
    def hosting_service(self, value: Optional[pulumi.Input['PluginHostingServiceArgs']]):
        pulumi.set(self, "hosting_service", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the plugin.
        Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipType")
    def ownership_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the plugin, indicating whether it is 'SYSTEM_OWNED' or
        'USER_OWNED'.
        Possible values:
        OWNERSHIP_TYPE_UNSPECIFIED
        SYSTEM_OWNED
        USER_OWNED
        """
        return pulumi.get(self, "ownership_type")

    @ownership_type.setter
    def ownership_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_type", value)

    @_builtins.property
    @pulumi.getter(name="pluginCategory")
    def plugin_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values:
        PLUGIN_CATEGORY_UNSPECIFIED
        API_GATEWAY
        API_PRODUCER
        """
        return pulumi.get(self, "plugin_category")

    @plugin_category.setter
    def plugin_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_category", value)

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the Plugin resource, which will become the final
        component of the Plugin's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another Plugin resource in the API hub
        instance.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, overall resource name which will be
        of format
        `projects/{project}/locations/{location}/plugins/{plugin}`,
        its length is limited to 1000 characters and valid characters are
        /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_id")

    @plugin_id.setter
    def plugin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the state of the plugin.
        Note this field will not be set for plugins developed via plugin
        framework as the state will be managed at plugin instance level.
        Possible values:
        STATE_UNSPECIFIED
        ENABLED
        DISABLED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp indicating when the plugin was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apihub/plugin:Plugin")
class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginActionsConfigArgs', 'PluginActionsConfigArgsDict']]]]] = None,
                 config_template: Optional[pulumi.Input[Union['PluginConfigTemplateArgs', 'PluginConfigTemplateArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[Union['PluginDocumentationArgs', 'PluginDocumentationArgsDict']]] = None,
                 hosting_service: Optional[pulumi.Input[Union['PluginHostingServiceArgs', 'PluginHostingServiceArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_category: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A plugin resource in the API hub.

        ## Example Usage

        ### Apihub Plugin Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_plugin_full = gcp.apihub.Plugin("apihub_plugin_full",
            location="us-central1",
            display_name="Test Plugin",
            description="Test description",
            plugin_id="plugin-full",
            plugin_category="API_GATEWAY",
            actions_configs=[{
                "id": "sync-metadata",
                "display_name": "Sync Metadata",
                "description": "Syncs API metadata.",
                "trigger_mode": "API_HUB_SCHEDULE_TRIGGER",
            }],
            documentation={
                "external_uri": "https://example.com/plugin-documentation",
            },
            hosting_service={
                "service_uri": "https://your-plugin-service.example.com/api",
            },
            config_template={
                "auth_config_template": {
                    "supported_auth_types": [
                        "NO_AUTH",
                        "USER_PASSWORD",
                    ],
                    "service_account": {
                        "service_account": "test@developer.gserviceaccount.com",
                    },
                },
                "additional_config_templates": [
                    {
                        "id": "string-val",
                        "description": "API key for the service.",
                        "value_type": "STRING",
                        "required": False,
                        "validation_regex": "^[a-zA-Z0-9]{5,20}$",
                    },
                    {
                        "id": "integer-val",
                        "description": "API key for the service.",
                        "value_type": "INT",
                        "required": True,
                        "validation_regex": "",
                    },
                    {
                        "id": "bool-val",
                        "description": "API key for the service.",
                        "value_type": "BOOL",
                        "required": False,
                        "validation_regex": "",
                    },
                    {
                        "id": "enum-val",
                        "description": "API key for the service.",
                        "value_type": "ENUM",
                        "enum_options": [
                            {
                                "id": "Option1",
                                "display_name": "Option1",
                                "description": "Description for Option1",
                            },
                            {
                                "id": "Option2",
                                "display_name": "Option2",
                                "description": "Description for Option2",
                            },
                        ],
                        "required": False,
                        "validation_regex": "",
                    },
                ],
            })
        ```

        ## Import

        Plugin can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/plugins/{{plugin_id}}`

        * `{{project}}/{{location}}/{{plugin_id}}`

        * `{{location}}/{{plugin_id}}`

        When using the `pulumi import` command, Plugin can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default projects/{{project}}/locations/{{location}}/plugins/{{plugin_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default {{project}}/{{location}}/{{plugin_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default {{location}}/{{plugin_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluginActionsConfigArgs', 'PluginActionsConfigArgsDict']]]] actions_configs: The configuration of actions supported by the plugin.
               Structure is documented below.
        :param pulumi.Input[Union['PluginConfigTemplateArgs', 'PluginConfigTemplateArgsDict']] config_template: ConfigTemplate represents the configuration template for a plugin.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The plugin description. Max length is 2000 characters (Unicode code
               points).
        :param pulumi.Input[_builtins.str] display_name: The display name of the plugin. Max length is 50 characters (Unicode code
               points).
        :param pulumi.Input[Union['PluginDocumentationArgs', 'PluginDocumentationArgsDict']] documentation: Documentation details.
               Structure is documented below.
        :param pulumi.Input[Union['PluginHostingServiceArgs', 'PluginHostingServiceArgsDict']] hosting_service: The information related to the service implemented by the plugin
               developer, used to invoke the plugin's functionality.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] plugin_category: Possible values:
               PLUGIN_CATEGORY_UNSPECIFIED
               API_GATEWAY
               API_PRODUCER
        :param pulumi.Input[_builtins.str] plugin_id: The ID to use for the Plugin resource, which will become the final
               component of the Plugin's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another Plugin resource in the API hub
               instance.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, overall resource name which will be
               of format
               `projects/{project}/locations/{location}/plugins/{plugin}`,
               its length is limited to 1000 characters and valid characters are
               /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A plugin resource in the API hub.

        ## Example Usage

        ### Apihub Plugin Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_plugin_full = gcp.apihub.Plugin("apihub_plugin_full",
            location="us-central1",
            display_name="Test Plugin",
            description="Test description",
            plugin_id="plugin-full",
            plugin_category="API_GATEWAY",
            actions_configs=[{
                "id": "sync-metadata",
                "display_name": "Sync Metadata",
                "description": "Syncs API metadata.",
                "trigger_mode": "API_HUB_SCHEDULE_TRIGGER",
            }],
            documentation={
                "external_uri": "https://example.com/plugin-documentation",
            },
            hosting_service={
                "service_uri": "https://your-plugin-service.example.com/api",
            },
            config_template={
                "auth_config_template": {
                    "supported_auth_types": [
                        "NO_AUTH",
                        "USER_PASSWORD",
                    ],
                    "service_account": {
                        "service_account": "test@developer.gserviceaccount.com",
                    },
                },
                "additional_config_templates": [
                    {
                        "id": "string-val",
                        "description": "API key for the service.",
                        "value_type": "STRING",
                        "required": False,
                        "validation_regex": "^[a-zA-Z0-9]{5,20}$",
                    },
                    {
                        "id": "integer-val",
                        "description": "API key for the service.",
                        "value_type": "INT",
                        "required": True,
                        "validation_regex": "",
                    },
                    {
                        "id": "bool-val",
                        "description": "API key for the service.",
                        "value_type": "BOOL",
                        "required": False,
                        "validation_regex": "",
                    },
                    {
                        "id": "enum-val",
                        "description": "API key for the service.",
                        "value_type": "ENUM",
                        "enum_options": [
                            {
                                "id": "Option1",
                                "display_name": "Option1",
                                "description": "Description for Option1",
                            },
                            {
                                "id": "Option2",
                                "display_name": "Option2",
                                "description": "Description for Option2",
                            },
                        ],
                        "required": False,
                        "validation_regex": "",
                    },
                ],
            })
        ```

        ## Import

        Plugin can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/plugins/{{plugin_id}}`

        * `{{project}}/{{location}}/{{plugin_id}}`

        * `{{location}}/{{plugin_id}}`

        When using the `pulumi import` command, Plugin can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default projects/{{project}}/locations/{{location}}/plugins/{{plugin_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default {{project}}/{{location}}/{{plugin_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/plugin:Plugin default {{location}}/{{plugin_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginActionsConfigArgs', 'PluginActionsConfigArgsDict']]]]] = None,
                 config_template: Optional[pulumi.Input[Union['PluginConfigTemplateArgs', 'PluginConfigTemplateArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[Union['PluginDocumentationArgs', 'PluginDocumentationArgsDict']]] = None,
                 hosting_service: Optional[pulumi.Input[Union['PluginHostingServiceArgs', 'PluginHostingServiceArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_category: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            __props__.__dict__["actions_configs"] = actions_configs
            __props__.__dict__["config_template"] = config_template
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["hosting_service"] = hosting_service
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["plugin_category"] = plugin_category
            if plugin_id is None and not opts.urn:
                raise TypeError("Missing required property 'plugin_id'")
            __props__.__dict__["plugin_id"] = plugin_id
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["ownership_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(Plugin, __self__).__init__(
            'gcp:apihub/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluginActionsConfigArgs', 'PluginActionsConfigArgsDict']]]]] = None,
            config_template: Optional[pulumi.Input[Union['PluginConfigTemplateArgs', 'PluginConfigTemplateArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            documentation: Optional[pulumi.Input[Union['PluginDocumentationArgs', 'PluginDocumentationArgsDict']]] = None,
            hosting_service: Optional[pulumi.Input[Union['PluginHostingServiceArgs', 'PluginHostingServiceArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_type: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_category: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluginActionsConfigArgs', 'PluginActionsConfigArgsDict']]]] actions_configs: The configuration of actions supported by the plugin.
               Structure is documented below.
        :param pulumi.Input[Union['PluginConfigTemplateArgs', 'PluginConfigTemplateArgsDict']] config_template: ConfigTemplate represents the configuration template for a plugin.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp indicating when the plugin was created.
        :param pulumi.Input[_builtins.str] description: The plugin description. Max length is 2000 characters (Unicode code
               points).
        :param pulumi.Input[_builtins.str] display_name: The display name of the plugin. Max length is 50 characters (Unicode code
               points).
        :param pulumi.Input[Union['PluginDocumentationArgs', 'PluginDocumentationArgsDict']] documentation: Documentation details.
               Structure is documented below.
        :param pulumi.Input[Union['PluginHostingServiceArgs', 'PluginHostingServiceArgsDict']] hosting_service: The information related to the service implemented by the plugin
               developer, used to invoke the plugin's functionality.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the plugin.
               Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        :param pulumi.Input[_builtins.str] ownership_type: The type of the plugin, indicating whether it is 'SYSTEM_OWNED' or
               'USER_OWNED'.
               Possible values:
               OWNERSHIP_TYPE_UNSPECIFIED
               SYSTEM_OWNED
               USER_OWNED
        :param pulumi.Input[_builtins.str] plugin_category: Possible values:
               PLUGIN_CATEGORY_UNSPECIFIED
               API_GATEWAY
               API_PRODUCER
        :param pulumi.Input[_builtins.str] plugin_id: The ID to use for the Plugin resource, which will become the final
               component of the Plugin's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified id is already used by another Plugin resource in the API hub
               instance.
               * If not provided, a system generated id will be used.
               This value should be 4-63 characters, overall resource name which will be
               of format
               `projects/{project}/locations/{location}/plugins/{plugin}`,
               its length is limited to 1000 characters and valid characters are
               /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] state: Represents the state of the plugin.
               Note this field will not be set for plugins developed via plugin
               framework as the state will be managed at plugin instance level.
               Possible values:
               STATE_UNSPECIFIED
               ENABLED
               DISABLED
        :param pulumi.Input[_builtins.str] update_time: Timestamp indicating when the plugin was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginState.__new__(_PluginState)

        __props__.__dict__["actions_configs"] = actions_configs
        __props__.__dict__["config_template"] = config_template
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation"] = documentation
        __props__.__dict__["hosting_service"] = hosting_service
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_type"] = ownership_type
        __props__.__dict__["plugin_category"] = plugin_category
        __props__.__dict__["plugin_id"] = plugin_id
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionsConfigs")
    def actions_configs(self) -> pulumi.Output[Optional[Sequence['outputs.PluginActionsConfig']]]:
        """
        The configuration of actions supported by the plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "actions_configs")

    @_builtins.property
    @pulumi.getter(name="configTemplate")
    def config_template(self) -> pulumi.Output[Optional['outputs.PluginConfigTemplate']]:
        """
        ConfigTemplate represents the configuration template for a plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "config_template")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp indicating when the plugin was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The plugin description. Max length is 2000 characters (Unicode code
        points).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the plugin. Max length is 50 characters (Unicode code
        points).
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[Optional['outputs.PluginDocumentation']]:
        """
        Documentation details.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @_builtins.property
    @pulumi.getter(name="hostingService")
    def hosting_service(self) -> pulumi.Output[Optional['outputs.PluginHostingService']]:
        """
        The information related to the service implemented by the plugin
        developer, used to invoke the plugin's functionality.
        Structure is documented below.
        """
        return pulumi.get(self, "hosting_service")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the plugin.
        Format: `projects/{project}/locations/{location}/plugins/{plugin}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipType")
    def ownership_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the plugin, indicating whether it is 'SYSTEM_OWNED' or
        'USER_OWNED'.
        Possible values:
        OWNERSHIP_TYPE_UNSPECIFIED
        SYSTEM_OWNED
        USER_OWNED
        """
        return pulumi.get(self, "ownership_type")

    @_builtins.property
    @pulumi.getter(name="pluginCategory")
    def plugin_category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Possible values:
        PLUGIN_CATEGORY_UNSPECIFIED
        API_GATEWAY
        API_PRODUCER
        """
        return pulumi.get(self, "plugin_category")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the Plugin resource, which will become the final
        component of the Plugin's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified id is already used by another Plugin resource in the API hub
        instance.
        * If not provided, a system generated id will be used.
        This value should be 4-63 characters, overall resource name which will be
        of format
        `projects/{project}/locations/{location}/plugins/{plugin}`,
        its length is limited to 1000 characters and valid characters are
        /a-z[0-9]-_/.
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Represents the state of the plugin.
        Note this field will not be set for plugins developed via plugin
        framework as the state will be managed at plugin instance level.
        Possible values:
        STATE_UNSPECIFIED
        ENABLED
        DISABLED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp indicating when the plugin was last updated.
        """
        return pulumi.get(self, "update_time")

