# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupResult',
    'AwaitableGetBackupResult',
    'get_backup',
    'get_backup_output',
]

@pulumi.output_type
class GetBackupResult:
    """
    A collection of values returned by getBackup.
    """
    def __init__(__self__, backup_vault_id=None, backups=None, data_source_id=None, id=None, location=None, name=None, project=None):
        if backup_vault_id and not isinstance(backup_vault_id, str):
            raise TypeError("Expected argument 'backup_vault_id' to be a str")
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_vault_id")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetBackupBackupResult']:
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetBackupResult(GetBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupResult(
            backup_vault_id=self.backup_vault_id,
            backups=self.backups,
            data_source_id=self.data_source_id,
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project)


def get_backup(backup_vault_id: Optional[_builtins.str] = None,
               data_source_id: Optional[_builtins.str] = None,
               location: Optional[_builtins.str] = None,
               project: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupResult:
    """
    A Backup and DR Backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.backupdisasterrecovery.get_backup(location="us-central1",
        project="project-test",
        data_source_id="ds-test",
        backup_vault_id="bv-test")
    ```


    :param _builtins.str backup_vault_id: The ID of the Backup Vault of the Data Source in which the Backup belongs.
    :param _builtins.str data_source_id: The ID of the Data Source in which the Backup belongs.
    :param _builtins.str location: The location in which the Backup belongs.
    :param _builtins.str project: The Google Cloud Project in which the Backup belongs.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['dataSourceId'] = data_source_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:backupdisasterrecovery/getBackup:getBackup', __args__, opts=opts, typ=GetBackupResult).value

    return AwaitableGetBackupResult(
        backup_vault_id=pulumi.get(__ret__, 'backup_vault_id'),
        backups=pulumi.get(__ret__, 'backups'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'))
def get_backup_output(backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                      data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                      location: Optional[pulumi.Input[_builtins.str]] = None,
                      project: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupResult]:
    """
    A Backup and DR Backup.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.backupdisasterrecovery.get_backup(location="us-central1",
        project="project-test",
        data_source_id="ds-test",
        backup_vault_id="bv-test")
    ```


    :param _builtins.str backup_vault_id: The ID of the Backup Vault of the Data Source in which the Backup belongs.
    :param _builtins.str data_source_id: The ID of the Data Source in which the Backup belongs.
    :param _builtins.str location: The location in which the Backup belongs.
    :param _builtins.str project: The Google Cloud Project in which the Backup belongs.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['dataSourceId'] = data_source_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:backupdisasterrecovery/getBackup:getBackup', __args__, opts=opts, typ=GetBackupResult)
    return __ret__.apply(lambda __response__: GetBackupResult(
        backup_vault_id=pulumi.get(__response__, 'backup_vault_id'),
        backups=pulumi.get(__response__, 'backups'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project')))
