# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupPlanAssociationResult',
    'AwaitableGetBackupPlanAssociationResult',
    'get_backup_plan_association',
    'get_backup_plan_association_output',
]

@pulumi.output_type
class GetBackupPlanAssociationResult:
    """
    A collection of values returned by getBackupPlanAssociation.
    """
    def __init__(__self__, backup_plan=None, backup_plan_association_id=None, create_time=None, data_source=None, id=None, last_successful_backup_consistency_time=None, location=None, name=None, project=None, resource=None, resource_type=None, rules_config_infos=None, update_time=None):
        if backup_plan and not isinstance(backup_plan, str):
            raise TypeError("Expected argument 'backup_plan' to be a str")
        pulumi.set(__self__, "backup_plan", backup_plan)
        if backup_plan_association_id and not isinstance(backup_plan_association_id, str):
            raise TypeError("Expected argument 'backup_plan_association_id' to be a str")
        pulumi.set(__self__, "backup_plan_association_id", backup_plan_association_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_source and not isinstance(data_source, str):
            raise TypeError("Expected argument 'data_source' to be a str")
        pulumi.set(__self__, "data_source", data_source)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_successful_backup_consistency_time and not isinstance(last_successful_backup_consistency_time, str):
            raise TypeError("Expected argument 'last_successful_backup_consistency_time' to be a str")
        pulumi.set(__self__, "last_successful_backup_consistency_time", last_successful_backup_consistency_time)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if resource and not isinstance(resource, str):
            raise TypeError("Expected argument 'resource' to be a str")
        pulumi.set(__self__, "resource", resource)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if rules_config_infos and not isinstance(rules_config_infos, list):
            raise TypeError("Expected argument 'rules_config_infos' to be a list")
        pulumi.set(__self__, "rules_config_infos", rules_config_infos)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="backupPlan")
    def backup_plan(self) -> _builtins.str:
        return pulumi.get(self, "backup_plan")

    @_builtins.property
    @pulumi.getter(name="backupPlanAssociationId")
    def backup_plan_association_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_plan_association_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> _builtins.str:
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulBackupConsistencyTime")
    def last_successful_backup_consistency_time(self) -> _builtins.str:
        return pulumi.get(self, "last_successful_backup_consistency_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> _builtins.str:
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="rulesConfigInfos")
    def rules_config_infos(self) -> Sequence['outputs.GetBackupPlanAssociationRulesConfigInfoResult']:
        return pulumi.get(self, "rules_config_infos")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetBackupPlanAssociationResult(GetBackupPlanAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlanAssociationResult(
            backup_plan=self.backup_plan,
            backup_plan_association_id=self.backup_plan_association_id,
            create_time=self.create_time,
            data_source=self.data_source,
            id=self.id,
            last_successful_backup_consistency_time=self.last_successful_backup_consistency_time,
            location=self.location,
            name=self.name,
            project=self.project,
            resource=self.resource,
            resource_type=self.resource_type,
            rules_config_infos=self.rules_config_infos,
            update_time=self.update_time)


def get_backup_plan_association(backup_plan_association_id: Optional[_builtins.str] = None,
                                location: Optional[_builtins.str] = None,
                                project: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlanAssociationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_backupplan_association = gcp.backupdisasterrecovery.get_backup_plan_association(location="us-central1",
        backup_plan_association_id="bpa-id")
    ```


    :param _builtins.str backup_plan_association_id: The id of Backupplan association resource.
           
           - - -
    :param _builtins.str location: The location in which the Backupplan association resource belongs.
    """
    __args__ = dict()
    __args__['backupPlanAssociationId'] = backup_plan_association_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:backupdisasterrecovery/getBackupPlanAssociation:getBackupPlanAssociation', __args__, opts=opts, typ=GetBackupPlanAssociationResult).value

    return AwaitableGetBackupPlanAssociationResult(
        backup_plan=pulumi.get(__ret__, 'backup_plan'),
        backup_plan_association_id=pulumi.get(__ret__, 'backup_plan_association_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        data_source=pulumi.get(__ret__, 'data_source'),
        id=pulumi.get(__ret__, 'id'),
        last_successful_backup_consistency_time=pulumi.get(__ret__, 'last_successful_backup_consistency_time'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        resource=pulumi.get(__ret__, 'resource'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        rules_config_infos=pulumi.get(__ret__, 'rules_config_infos'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_backup_plan_association_output(backup_plan_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       location: Optional[pulumi.Input[_builtins.str]] = None,
                                       project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupPlanAssociationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_backupplan_association = gcp.backupdisasterrecovery.get_backup_plan_association(location="us-central1",
        backup_plan_association_id="bpa-id")
    ```


    :param _builtins.str backup_plan_association_id: The id of Backupplan association resource.
           
           - - -
    :param _builtins.str location: The location in which the Backupplan association resource belongs.
    """
    __args__ = dict()
    __args__['backupPlanAssociationId'] = backup_plan_association_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:backupdisasterrecovery/getBackupPlanAssociation:getBackupPlanAssociation', __args__, opts=opts, typ=GetBackupPlanAssociationResult)
    return __ret__.apply(lambda __response__: GetBackupPlanAssociationResult(
        backup_plan=pulumi.get(__response__, 'backup_plan'),
        backup_plan_association_id=pulumi.get(__response__, 'backup_plan_association_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        data_source=pulumi.get(__response__, 'data_source'),
        id=pulumi.get(__response__, 'id'),
        last_successful_backup_consistency_time=pulumi.get(__response__, 'last_successful_backup_consistency_time'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        resource=pulumi.get(__response__, 'resource'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        rules_config_infos=pulumi.get(__response__, 'rules_config_infos'),
        update_time=pulumi.get(__response__, 'update_time')))
