# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBackupVaultResult',
    'AwaitableGetBackupVaultResult',
    'get_backup_vault',
    'get_backup_vault_output',
]

@pulumi.output_type
class GetBackupVaultResult:
    """
    A collection of values returned by getBackupVault.
    """
    def __init__(__self__, access_restriction=None, allow_missing=None, annotations=None, backup_count=None, backup_minimum_enforced_retention_duration=None, backup_vault_id=None, create_time=None, deletable=None, description=None, effective_annotations=None, effective_labels=None, effective_time=None, etag=None, force_delete=None, force_update=None, id=None, ignore_backup_plan_references=None, ignore_inactive_datasources=None, labels=None, location=None, name=None, project=None, pulumi_labels=None, service_account=None, state=None, total_stored_bytes=None, uid=None, update_time=None):
        if access_restriction and not isinstance(access_restriction, str):
            raise TypeError("Expected argument 'access_restriction' to be a str")
        pulumi.set(__self__, "access_restriction", access_restriction)
        if allow_missing and not isinstance(allow_missing, bool):
            raise TypeError("Expected argument 'allow_missing' to be a bool")
        pulumi.set(__self__, "allow_missing", allow_missing)
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if backup_count and not isinstance(backup_count, str):
            raise TypeError("Expected argument 'backup_count' to be a str")
        pulumi.set(__self__, "backup_count", backup_count)
        if backup_minimum_enforced_retention_duration and not isinstance(backup_minimum_enforced_retention_duration, str):
            raise TypeError("Expected argument 'backup_minimum_enforced_retention_duration' to be a str")
        pulumi.set(__self__, "backup_minimum_enforced_retention_duration", backup_minimum_enforced_retention_duration)
        if backup_vault_id and not isinstance(backup_vault_id, str):
            raise TypeError("Expected argument 'backup_vault_id' to be a str")
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deletable and not isinstance(deletable, bool):
            raise TypeError("Expected argument 'deletable' to be a bool")
        pulumi.set(__self__, "deletable", deletable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if effective_annotations and not isinstance(effective_annotations, dict):
            raise TypeError("Expected argument 'effective_annotations' to be a dict")
        pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_time and not isinstance(effective_time, str):
            raise TypeError("Expected argument 'effective_time' to be a str")
        pulumi.set(__self__, "effective_time", effective_time)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if force_delete and not isinstance(force_delete, bool):
            raise TypeError("Expected argument 'force_delete' to be a bool")
        pulumi.set(__self__, "force_delete", force_delete)
        if force_update and not isinstance(force_update, bool):
            raise TypeError("Expected argument 'force_update' to be a bool")
        pulumi.set(__self__, "force_update", force_update)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_backup_plan_references and not isinstance(ignore_backup_plan_references, bool):
            raise TypeError("Expected argument 'ignore_backup_plan_references' to be a bool")
        pulumi.set(__self__, "ignore_backup_plan_references", ignore_backup_plan_references)
        if ignore_inactive_datasources and not isinstance(ignore_inactive_datasources, bool):
            raise TypeError("Expected argument 'ignore_inactive_datasources' to be a bool")
        pulumi.set(__self__, "ignore_inactive_datasources", ignore_inactive_datasources)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if total_stored_bytes and not isinstance(total_stored_bytes, str):
            raise TypeError("Expected argument 'total_stored_bytes' to be a str")
        pulumi.set(__self__, "total_stored_bytes", total_stored_bytes)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accessRestriction")
    def access_restriction(self) -> _builtins.str:
        return pulumi.get(self, "access_restriction")

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> _builtins.bool:
        return pulumi.get(self, "allow_missing")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="backupCount")
    def backup_count(self) -> _builtins.str:
        return pulumi.get(self, "backup_count")

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDuration")
    def backup_minimum_enforced_retention_duration(self) -> _builtins.str:
        return pulumi.get(self, "backup_minimum_enforced_retention_duration")

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_vault_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def deletable(self) -> _builtins.bool:
        return pulumi.get(self, "deletable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> _builtins.bool:
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> _builtins.bool:
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreBackupPlanReferences")
    def ignore_backup_plan_references(self) -> _builtins.bool:
        return pulumi.get(self, "ignore_backup_plan_references")

    @_builtins.property
    @pulumi.getter(name="ignoreInactiveDatasources")
    def ignore_inactive_datasources(self) -> _builtins.bool:
        return pulumi.get(self, "ignore_inactive_datasources")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="totalStoredBytes")
    def total_stored_bytes(self) -> _builtins.str:
        return pulumi.get(self, "total_stored_bytes")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        return pulumi.get(self, "update_time")


class AwaitableGetBackupVaultResult(GetBackupVaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupVaultResult(
            access_restriction=self.access_restriction,
            allow_missing=self.allow_missing,
            annotations=self.annotations,
            backup_count=self.backup_count,
            backup_minimum_enforced_retention_duration=self.backup_minimum_enforced_retention_duration,
            backup_vault_id=self.backup_vault_id,
            create_time=self.create_time,
            deletable=self.deletable,
            description=self.description,
            effective_annotations=self.effective_annotations,
            effective_labels=self.effective_labels,
            effective_time=self.effective_time,
            etag=self.etag,
            force_delete=self.force_delete,
            force_update=self.force_update,
            id=self.id,
            ignore_backup_plan_references=self.ignore_backup_plan_references,
            ignore_inactive_datasources=self.ignore_inactive_datasources,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            service_account=self.service_account,
            state=self.state,
            total_stored_bytes=self.total_stored_bytes,
            uid=self.uid,
            update_time=self.update_time)


def get_backup_vault(backup_vault_id: Optional[_builtins.str] = None,
                     location: Optional[_builtins.str] = None,
                     project: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupVaultResult:
    """
    A Backup and DRBackupVault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_backup_vault = gcp.backupdisasterrecovery.get_backup_vault(location="us-central1",
        backup_vault_id="bv-1")
    ```


    :param _builtins.str backup_vault_id: The id of Backup Vault resource.
           
           - - -
    :param _builtins.str location: The location in which the Backup Vault resource belongs.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:backupdisasterrecovery/getBackupVault:getBackupVault', __args__, opts=opts, typ=GetBackupVaultResult).value

    return AwaitableGetBackupVaultResult(
        access_restriction=pulumi.get(__ret__, 'access_restriction'),
        allow_missing=pulumi.get(__ret__, 'allow_missing'),
        annotations=pulumi.get(__ret__, 'annotations'),
        backup_count=pulumi.get(__ret__, 'backup_count'),
        backup_minimum_enforced_retention_duration=pulumi.get(__ret__, 'backup_minimum_enforced_retention_duration'),
        backup_vault_id=pulumi.get(__ret__, 'backup_vault_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        deletable=pulumi.get(__ret__, 'deletable'),
        description=pulumi.get(__ret__, 'description'),
        effective_annotations=pulumi.get(__ret__, 'effective_annotations'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        effective_time=pulumi.get(__ret__, 'effective_time'),
        etag=pulumi.get(__ret__, 'etag'),
        force_delete=pulumi.get(__ret__, 'force_delete'),
        force_update=pulumi.get(__ret__, 'force_update'),
        id=pulumi.get(__ret__, 'id'),
        ignore_backup_plan_references=pulumi.get(__ret__, 'ignore_backup_plan_references'),
        ignore_inactive_datasources=pulumi.get(__ret__, 'ignore_inactive_datasources'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        service_account=pulumi.get(__ret__, 'service_account'),
        state=pulumi.get(__ret__, 'state'),
        total_stored_bytes=pulumi.get(__ret__, 'total_stored_bytes'),
        uid=pulumi.get(__ret__, 'uid'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_backup_vault_output(backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                            location: Optional[pulumi.Input[_builtins.str]] = None,
                            project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupVaultResult]:
    """
    A Backup and DRBackupVault.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_backup_vault = gcp.backupdisasterrecovery.get_backup_vault(location="us-central1",
        backup_vault_id="bv-1")
    ```


    :param _builtins.str backup_vault_id: The id of Backup Vault resource.
           
           - - -
    :param _builtins.str location: The location in which the Backup Vault resource belongs.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['backupVaultId'] = backup_vault_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:backupdisasterrecovery/getBackupVault:getBackupVault', __args__, opts=opts, typ=GetBackupVaultResult)
    return __ret__.apply(lambda __response__: GetBackupVaultResult(
        access_restriction=pulumi.get(__response__, 'access_restriction'),
        allow_missing=pulumi.get(__response__, 'allow_missing'),
        annotations=pulumi.get(__response__, 'annotations'),
        backup_count=pulumi.get(__response__, 'backup_count'),
        backup_minimum_enforced_retention_duration=pulumi.get(__response__, 'backup_minimum_enforced_retention_duration'),
        backup_vault_id=pulumi.get(__response__, 'backup_vault_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        deletable=pulumi.get(__response__, 'deletable'),
        description=pulumi.get(__response__, 'description'),
        effective_annotations=pulumi.get(__response__, 'effective_annotations'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        effective_time=pulumi.get(__response__, 'effective_time'),
        etag=pulumi.get(__response__, 'etag'),
        force_delete=pulumi.get(__response__, 'force_delete'),
        force_update=pulumi.get(__response__, 'force_update'),
        id=pulumi.get(__response__, 'id'),
        ignore_backup_plan_references=pulumi.get(__response__, 'ignore_backup_plan_references'),
        ignore_inactive_datasources=pulumi.get(__response__, 'ignore_inactive_datasources'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        service_account=pulumi.get(__response__, 'service_account'),
        state=pulumi.get(__response__, 'state'),
        total_stored_bytes=pulumi.get(__response__, 'total_stored_bytes'),
        uid=pulumi.get(__response__, 'uid'),
        update_time=pulumi.get(__response__, 'update_time')))
