# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementServerArgs', 'ManagementServer']

@pulumi.input_type
class ManagementServerArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagementServer resource.
        :param pulumi.Input[_builtins.str] location: The location for the management server (management console)
        :param pulumi.Input[_builtins.str] name: The name of management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]] networks: Network details to create management server (management console).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: The type of management server (management console).
               Default value is `BACKUP_RESTORE`.
               Possible values are: `BACKUP_RESTORE`.
        """
        pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the management server (management console)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of management server (management console)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]]:
        """
        Network details to create management server (management console).
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of management server (management console).
        Default value is `BACKUP_RESTORE`.
        Possible values are: `BACKUP_RESTORE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ManagementServerState:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_uris: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerManagementUriArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]] = None,
                 oauth2_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagementServer resources.
        :param pulumi.Input[_builtins.str] location: The location for the management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input['ManagementServerManagementUriArgs']]] management_uris: The management console URI
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]] networks: Network details to create management server (management console).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] oauth2_client_id: The oauth2ClientId of management console.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: The type of management server (management console).
               Default value is `BACKUP_RESTORE`.
               Possible values are: `BACKUP_RESTORE`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_uris is not None:
            pulumi.set(__self__, "management_uris", management_uris)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if oauth2_client_id is not None:
            pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the management server (management console)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementUris")
    def management_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerManagementUriArgs']]]]:
        """
        The management console URI
        Structure is documented below.
        """
        return pulumi.get(self, "management_uris")

    @management_uris.setter
    def management_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerManagementUriArgs']]]]):
        pulumi.set(self, "management_uris", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of management server (management console)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]]:
        """
        Network details to create management server (management console).
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementServerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The oauth2ClientId of management console.
        """
        return pulumi.get(self, "oauth2_client_id")

    @oauth2_client_id.setter
    def oauth2_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth2_client_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of management server (management console).
        Default value is `BACKUP_RESTORE`.
        Possible values are: `BACKUP_RESTORE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:backupdisasterrecovery/managementServer:ManagementServer")
class ManagementServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerNetworkArgs', 'ManagementServerNetworkArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Backup and DR Management Server (Also referred as Management Console)

        To get more information about ManagementServer, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/deployment/deployment-plan)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Management Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="vpc-network")
        private_ip_address = gcp.compute.GlobalAddress("private_ip_address",
            name="vpc-network",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=20,
            network=default.id)
        default_connection = gcp.servicenetworking.Connection("default",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name])
        ms_console = gcp.backupdisasterrecovery.ManagementServer("ms-console",
            location="us-central1",
            name="ms-console",
            type="BACKUP_RESTORE",
            opts = pulumi.ResourceOptions(depends_on=[default_connection]))
        ```

        ## Import

        ManagementServer can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/managementServers/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ManagementServer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default projects/{{project}}/locations/{{location}}/managementServers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location for the management server (management console)
        :param pulumi.Input[_builtins.str] name: The name of management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerNetworkArgs', 'ManagementServerNetworkArgsDict']]]] networks: Network details to create management server (management console).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: The type of management server (management console).
               Default value is `BACKUP_RESTORE`.
               Possible values are: `BACKUP_RESTORE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Backup and DR Management Server (Also referred as Management Console)

        To get more information about ManagementServer, see:

        * [API documentation](https://cloud.google.com/backup-disaster-recovery/docs/deployment/deployment-plan)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/backup-disaster-recovery/docs)

        ## Example Usage

        ### Backup Dr Management Server

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="vpc-network")
        private_ip_address = gcp.compute.GlobalAddress("private_ip_address",
            name="vpc-network",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=20,
            network=default.id)
        default_connection = gcp.servicenetworking.Connection("default",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_address.name])
        ms_console = gcp.backupdisasterrecovery.ManagementServer("ms-console",
            location="us-central1",
            name="ms-console",
            type="BACKUP_RESTORE",
            opts = pulumi.ResourceOptions(depends_on=[default_connection]))
        ```

        ## Import

        ManagementServer can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/managementServers/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, ManagementServer can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default projects/{{project}}/locations/{{location}}/managementServers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/managementServer:ManagementServer default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ManagementServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerNetworkArgs', 'ManagementServerNetworkArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementServerArgs.__new__(ManagementServerArgs)

            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["project"] = project
            __props__.__dict__["type"] = type
            __props__.__dict__["management_uris"] = None
            __props__.__dict__["oauth2_client_id"] = None
        super(ManagementServer, __self__).__init__(
            'gcp:backupdisasterrecovery/managementServer:ManagementServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_uris: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerManagementUriArgs', 'ManagementServerManagementUriArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerNetworkArgs', 'ManagementServerNetworkArgsDict']]]]] = None,
            oauth2_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagementServer':
        """
        Get an existing ManagementServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location for the management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerManagementUriArgs', 'ManagementServerManagementUriArgsDict']]]] management_uris: The management console URI
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of management server (management console)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagementServerNetworkArgs', 'ManagementServerNetworkArgsDict']]]] networks: Network details to create management server (management console).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] oauth2_client_id: The oauth2ClientId of management console.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: The type of management server (management console).
               Default value is `BACKUP_RESTORE`.
               Possible values are: `BACKUP_RESTORE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementServerState.__new__(_ManagementServerState)

        __props__.__dict__["location"] = location
        __props__.__dict__["management_uris"] = management_uris
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["oauth2_client_id"] = oauth2_client_id
        __props__.__dict__["project"] = project
        __props__.__dict__["type"] = type
        return ManagementServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the management server (management console)
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementUris")
    def management_uris(self) -> pulumi.Output[Sequence['outputs.ManagementServerManagementUri']]:
        """
        The management console URI
        Structure is documented below.
        """
        return pulumi.get(self, "management_uris")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of management server (management console)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.ManagementServerNetwork']]]:
        """
        Network details to create management server (management console).
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The oauth2ClientId of management console.
        """
        return pulumi.get(self, "oauth2_client_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of management server (management console).
        Default value is `BACKUP_RESTORE`.
        Possible values are: `BACKUP_RESTORE`.
        """
        return pulumi.get(self, "type")

