# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationIamPolicyResult',
    'AwaitableGetApplicationIamPolicyResult',
    'get_application_iam_policy',
    'get_application_iam_policy_output',
]

@pulumi.output_type
class GetApplicationIamPolicyResult:
    """
    A collection of values returned by getApplicationIamPolicy.
    """
    def __init__(__self__, application_id=None, etag=None, id=None, policy_data=None, project=None, security_gateways_id=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if security_gateways_id and not isinstance(security_gateways_id, str):
            raise TypeError("Expected argument 'security_gateways_id' to be a str")
        pulumi.set(__self__, "security_gateways_id", security_gateways_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `beyondcorp.ApplicationIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="securityGatewaysId")
    def security_gateways_id(self) -> _builtins.str:
        return pulumi.get(self, "security_gateways_id")


class AwaitableGetApplicationIamPolicyResult(GetApplicationIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationIamPolicyResult(
            application_id=self.application_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project,
            security_gateways_id=self.security_gateways_id)


def get_application_iam_policy(application_id: Optional[_builtins.str] = None,
                               project: Optional[_builtins.str] = None,
                               security_gateways_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationIamPolicyResult:
    """
    Retrieves the current IAM policy data for application

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.beyondcorp.get_application_iam_policy(project=example["project"],
        security_gateways_id=example["securityGatewaysId"],
        application_id=example["applicationId"])
    ```


    :param _builtins.str application_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str security_gateways_id: Part of `parent`. See documentation of `projectsId`. Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['project'] = project
    __args__['securityGatewaysId'] = security_gateways_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:beyondcorp/getApplicationIamPolicy:getApplicationIamPolicy', __args__, opts=opts, typ=GetApplicationIamPolicyResult).value

    return AwaitableGetApplicationIamPolicyResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        security_gateways_id=pulumi.get(__ret__, 'security_gateways_id'))
def get_application_iam_policy_output(application_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      security_gateways_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationIamPolicyResult]:
    """
    Retrieves the current IAM policy data for application

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.beyondcorp.get_application_iam_policy(project=example["project"],
        security_gateways_id=example["securityGatewaysId"],
        application_id=example["applicationId"])
    ```


    :param _builtins.str application_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str security_gateways_id: Part of `parent`. See documentation of `projectsId`. Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['project'] = project
    __args__['securityGatewaysId'] = security_gateways_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:beyondcorp/getApplicationIamPolicy:getApplicationIamPolicy', __args__, opts=opts, typ=GetApplicationIamPolicyResult)
    return __ret__.apply(lambda __response__: GetApplicationIamPolicyResult(
        application_id=pulumi.get(__response__, 'application_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        security_gateways_id=pulumi.get(__response__, 'security_gateways_id')))
