# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetAccessInitArgs', 'DatasetAccess']

@pulumi.input_type
class DatasetAccessInitArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[_builtins.str],
                 authorized_dataset: Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']] = None,
                 condition: Optional[pulumi.Input['DatasetAccessConditionArgs']] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 group_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 routine: Optional[pulumi.Input['DatasetAccessRoutineArgs']] = None,
                 special_group: Optional[pulumi.Input[_builtins.str]] = None,
                 user_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 view: Optional[pulumi.Input['DatasetAccessViewArgs']] = None):
        """
        The set of arguments for constructing a DatasetAccess resource.
        :param pulumi.Input[_builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input['DatasetAccessAuthorizedDatasetArgs'] authorized_dataset: Grants all resources of particular types in a particular dataset read access to the current dataset.
               Structure is documented below.
        :param pulumi.Input['DatasetAccessConditionArgs'] condition: Condition for the binding. If CEL expression in this field is true, this
               access binding will be considered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param pulumi.Input[_builtins.str] group_by_email: An email address of a Google Group to grant access to.
        :param pulumi.Input[_builtins.str] iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: `allUsers`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles are
               supported. Predefined roles that have equivalent basic roles are
               swapped by the API to their basic counterparts, and will show a diff
               post-create. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param pulumi.Input['DatasetAccessRoutineArgs'] routine: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] special_group: A special group to grant access to. Possible values include:
               * `projectOwners`: Owners of the enclosing project.
               * `projectReaders`: Readers of the enclosing project.
               * `projectWriters`: Writers of the enclosing project.
               * `allAuthenticatedUsers`: All authenticated BigQuery users.
        :param pulumi.Input[_builtins.str] user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param pulumi.Input['DatasetAccessViewArgs'] view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if authorized_dataset is not None:
            pulumi.set(__self__, "authorized_dataset", authorized_dataset)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if group_by_email is not None:
            pulumi.set(__self__, "group_by_email", group_by_email)
        if iam_member is not None:
            pulumi.set(__self__, "iam_member", iam_member)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if routine is not None:
            pulumi.set(__self__, "routine", routine)
        if special_group is not None:
            pulumi.set(__self__, "special_group", special_group)
        if user_by_email is not None:
            pulumi.set(__self__, "user_by_email", user_by_email)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[_builtins.str]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter(name="authorizedDataset")
    def authorized_dataset(self) -> Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']]:
        """
        Grants all resources of particular types in a particular dataset read access to the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_dataset")

    @authorized_dataset.setter
    def authorized_dataset(self, value: Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']]):
        pulumi.set(self, "authorized_dataset", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['DatasetAccessConditionArgs']]:
        """
        Condition for the binding. If CEL expression in this field is true, this
        access binding will be considered.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['DatasetAccessConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @group_by_email.setter
    def group_by_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_by_email", value)

    @_builtins.property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Some other type of member that appears in the IAM Policy but isn't a user,
        group, domain, or special group. For example: `allUsers`
        """
        return pulumi.get(self, "iam_member")

    @iam_member.setter
    def iam_member(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_member", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Basic, predefined, and custom roles are
        supported. Predefined roles that have equivalent basic roles are
        swapped by the API to their basic counterparts, and will show a diff
        post-create. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def routine(self) -> Optional[pulumi.Input['DatasetAccessRoutineArgs']]:
        """
        A routine from a different dataset to grant access to. Queries
        executed against that routine will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that routine is updated by any user, access to the routine
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "routine")

    @routine.setter
    def routine(self, value: Optional[pulumi.Input['DatasetAccessRoutineArgs']]):
        pulumi.set(self, "routine", value)

    @_builtins.property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A special group to grant access to. Possible values include:
        * `projectOwners`: Owners of the enclosing project.
        * `projectReaders`: Readers of the enclosing project.
        * `projectWriters`: Writers of the enclosing project.
        * `allAuthenticatedUsers`: All authenticated BigQuery users.
        """
        return pulumi.get(self, "special_group")

    @special_group.setter
    def special_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "special_group", value)

    @_builtins.property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @user_by_email.setter
    def user_by_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_by_email", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['DatasetAccessViewArgs']]:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['DatasetAccessViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.input_type
class _DatasetAccessState:
    def __init__(__self__, *,
                 api_updated_member: Optional[pulumi.Input[_builtins.bool]] = None,
                 authorized_dataset: Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']] = None,
                 condition: Optional[pulumi.Input['DatasetAccessConditionArgs']] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 group_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 routine: Optional[pulumi.Input['DatasetAccessRoutineArgs']] = None,
                 special_group: Optional[pulumi.Input[_builtins.str]] = None,
                 user_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 view: Optional[pulumi.Input['DatasetAccessViewArgs']] = None):
        """
        Input properties used for looking up and filtering DatasetAccess resources.
        :param pulumi.Input[_builtins.bool] api_updated_member: If true, represents that that the iam_member in the config was translated to a different member type by the API, and is
               stored in state as a different member type
        :param pulumi.Input['DatasetAccessAuthorizedDatasetArgs'] authorized_dataset: Grants all resources of particular types in a particular dataset read access to the current dataset.
               Structure is documented below.
        :param pulumi.Input['DatasetAccessConditionArgs'] condition: Condition for the binding. If CEL expression in this field is true, this
               access binding will be considered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input[_builtins.str] domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param pulumi.Input[_builtins.str] group_by_email: An email address of a Google Group to grant access to.
        :param pulumi.Input[_builtins.str] iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: `allUsers`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles are
               supported. Predefined roles that have equivalent basic roles are
               swapped by the API to their basic counterparts, and will show a diff
               post-create. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param pulumi.Input['DatasetAccessRoutineArgs'] routine: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] special_group: A special group to grant access to. Possible values include:
               * `projectOwners`: Owners of the enclosing project.
               * `projectReaders`: Readers of the enclosing project.
               * `projectWriters`: Writers of the enclosing project.
               * `allAuthenticatedUsers`: All authenticated BigQuery users.
        :param pulumi.Input[_builtins.str] user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param pulumi.Input['DatasetAccessViewArgs'] view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        if api_updated_member is not None:
            pulumi.set(__self__, "api_updated_member", api_updated_member)
        if authorized_dataset is not None:
            pulumi.set(__self__, "authorized_dataset", authorized_dataset)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if group_by_email is not None:
            pulumi.set(__self__, "group_by_email", group_by_email)
        if iam_member is not None:
            pulumi.set(__self__, "iam_member", iam_member)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if routine is not None:
            pulumi.set(__self__, "routine", routine)
        if special_group is not None:
            pulumi.set(__self__, "special_group", special_group)
        if user_by_email is not None:
            pulumi.set(__self__, "user_by_email", user_by_email)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @_builtins.property
    @pulumi.getter(name="apiUpdatedMember")
    def api_updated_member(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, represents that that the iam_member in the config was translated to a different member type by the API, and is
        stored in state as a different member type
        """
        return pulumi.get(self, "api_updated_member")

    @api_updated_member.setter
    def api_updated_member(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "api_updated_member", value)

    @_builtins.property
    @pulumi.getter(name="authorizedDataset")
    def authorized_dataset(self) -> Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']]:
        """
        Grants all resources of particular types in a particular dataset read access to the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_dataset")

    @authorized_dataset.setter
    def authorized_dataset(self, value: Optional[pulumi.Input['DatasetAccessAuthorizedDatasetArgs']]):
        pulumi.set(self, "authorized_dataset", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['DatasetAccessConditionArgs']]:
        """
        Condition for the binding. If CEL expression in this field is true, this
        access binding will be considered.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['DatasetAccessConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @group_by_email.setter
    def group_by_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_by_email", value)

    @_builtins.property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Some other type of member that appears in the IAM Policy but isn't a user,
        group, domain, or special group. For example: `allUsers`
        """
        return pulumi.get(self, "iam_member")

    @iam_member.setter
    def iam_member(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_member", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Basic, predefined, and custom roles are
        supported. Predefined roles that have equivalent basic roles are
        swapped by the API to their basic counterparts, and will show a diff
        post-create. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def routine(self) -> Optional[pulumi.Input['DatasetAccessRoutineArgs']]:
        """
        A routine from a different dataset to grant access to. Queries
        executed against that routine will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that routine is updated by any user, access to the routine
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "routine")

    @routine.setter
    def routine(self, value: Optional[pulumi.Input['DatasetAccessRoutineArgs']]):
        pulumi.set(self, "routine", value)

    @_builtins.property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A special group to grant access to. Possible values include:
        * `projectOwners`: Owners of the enclosing project.
        * `projectReaders`: Readers of the enclosing project.
        * `projectWriters`: Writers of the enclosing project.
        * `allAuthenticatedUsers`: All authenticated BigQuery users.
        """
        return pulumi.get(self, "special_group")

    @special_group.setter
    def special_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "special_group", value)

    @_builtins.property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @user_by_email.setter
    def user_by_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_by_email", value)

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['DatasetAccessViewArgs']]:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['DatasetAccessViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.type_token("gcp:bigquery/datasetAccess:DatasetAccess")
class DatasetAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_dataset: Optional[pulumi.Input[Union['DatasetAccessAuthorizedDatasetArgs', 'DatasetAccessAuthorizedDatasetArgsDict']]] = None,
                 condition: Optional[pulumi.Input[Union['DatasetAccessConditionArgs', 'DatasetAccessConditionArgsDict']]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 group_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 routine: Optional[pulumi.Input[Union['DatasetAccessRoutineArgs', 'DatasetAccessRoutineArgsDict']]] = None,
                 special_group: Optional[pulumi.Input[_builtins.str]] = None,
                 user_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 view: Optional[pulumi.Input[Union['DatasetAccessViewArgs', 'DatasetAccessViewArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Bigquery Dataset Access Basic User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset", dataset_id="example_dataset")
        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=dataset.dataset_id,
            role="OWNER",
            user_by_email=bqowner.email)
        ```
        ### Bigquery Dataset Access View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        private = gcp.bigquery.Dataset("private", dataset_id="example_dataset")
        public = gcp.bigquery.Dataset("public", dataset_id="example_dataset2")
        public_table = gcp.bigquery.Table("public",
            deletion_protection=False,
            dataset_id=public.dataset_id,
            table_id="example_table",
            view={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "use_legacy_sql": False,
            })
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=private.dataset_id,
            view={
                "project_id": public_table.project,
                "dataset_id": public.dataset_id,
                "table_id": public_table.table_id,
            })
        ```
        ### Bigquery Dataset Access Authorized Dataset

        ```python
        import pulumi
        import pulumi_gcp as gcp

        private = gcp.bigquery.Dataset("private", dataset_id="private")
        public = gcp.bigquery.Dataset("public", dataset_id="public")
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=private.dataset_id,
            authorized_dataset={
                "dataset": {
                    "project_id": public.project,
                    "dataset_id": public.dataset_id,
                },
                "target_types": ["VIEWS"],
            })
        ```
        ### Bigquery Dataset Access Authorized Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        public = gcp.bigquery.Dataset("public",
            dataset_id="public_dataset",
            description="This dataset is public")
        public_routine = gcp.bigquery.Routine("public",
            dataset_id=public.dataset_id,
            routine_id="public_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        private = gcp.bigquery.Dataset("private",
            dataset_id="private_dataset",
            description="This dataset is private")
        authorized_routine = gcp.bigquery.DatasetAccess("authorized_routine",
            dataset_id=private.dataset_id,
            routine={
                "project_id": public_routine.project,
                "dataset_id": public_routine.dataset_id,
                "routine_id": public_routine.routine_id,
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DatasetAccessAuthorizedDatasetArgs', 'DatasetAccessAuthorizedDatasetArgsDict']] authorized_dataset: Grants all resources of particular types in a particular dataset read access to the current dataset.
               Structure is documented below.
        :param pulumi.Input[Union['DatasetAccessConditionArgs', 'DatasetAccessConditionArgsDict']] condition: Condition for the binding. If CEL expression in this field is true, this
               access binding will be considered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input[_builtins.str] domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param pulumi.Input[_builtins.str] group_by_email: An email address of a Google Group to grant access to.
        :param pulumi.Input[_builtins.str] iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: `allUsers`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles are
               supported. Predefined roles that have equivalent basic roles are
               swapped by the API to their basic counterparts, and will show a diff
               post-create. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param pulumi.Input[Union['DatasetAccessRoutineArgs', 'DatasetAccessRoutineArgsDict']] routine: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] special_group: A special group to grant access to. Possible values include:
               * `projectOwners`: Owners of the enclosing project.
               * `projectReaders`: Readers of the enclosing project.
               * `projectWriters`: Writers of the enclosing project.
               * `allAuthenticatedUsers`: All authenticated BigQuery users.
        :param pulumi.Input[_builtins.str] user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param pulumi.Input[Union['DatasetAccessViewArgs', 'DatasetAccessViewArgsDict']] view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetAccessInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Bigquery Dataset Access Basic User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.bigquery.Dataset("dataset", dataset_id="example_dataset")
        bqowner = gcp.serviceaccount.Account("bqowner", account_id="bqowner")
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=dataset.dataset_id,
            role="OWNER",
            user_by_email=bqowner.email)
        ```
        ### Bigquery Dataset Access View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        private = gcp.bigquery.Dataset("private", dataset_id="example_dataset")
        public = gcp.bigquery.Dataset("public", dataset_id="example_dataset2")
        public_table = gcp.bigquery.Table("public",
            deletion_protection=False,
            dataset_id=public.dataset_id,
            table_id="example_table",
            view={
                "query": "SELECT state FROM [lookerdata:cdc.project_tycho_reports]",
                "use_legacy_sql": False,
            })
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=private.dataset_id,
            view={
                "project_id": public_table.project,
                "dataset_id": public.dataset_id,
                "table_id": public_table.table_id,
            })
        ```
        ### Bigquery Dataset Access Authorized Dataset

        ```python
        import pulumi
        import pulumi_gcp as gcp

        private = gcp.bigquery.Dataset("private", dataset_id="private")
        public = gcp.bigquery.Dataset("public", dataset_id="public")
        access = gcp.bigquery.DatasetAccess("access",
            dataset_id=private.dataset_id,
            authorized_dataset={
                "dataset": {
                    "project_id": public.project,
                    "dataset_id": public.dataset_id,
                },
                "target_types": ["VIEWS"],
            })
        ```
        ### Bigquery Dataset Access Authorized Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        public = gcp.bigquery.Dataset("public",
            dataset_id="public_dataset",
            description="This dataset is public")
        public_routine = gcp.bigquery.Routine("public",
            dataset_id=public.dataset_id,
            routine_id="public_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        private = gcp.bigquery.Dataset("private",
            dataset_id="private_dataset",
            description="This dataset is private")
        authorized_routine = gcp.bigquery.DatasetAccess("authorized_routine",
            dataset_id=private.dataset_id,
            routine={
                "project_id": public_routine.project,
                "dataset_id": public_routine.dataset_id,
                "routine_id": public_routine.routine_id,
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param DatasetAccessInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetAccessInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_dataset: Optional[pulumi.Input[Union['DatasetAccessAuthorizedDatasetArgs', 'DatasetAccessAuthorizedDatasetArgsDict']]] = None,
                 condition: Optional[pulumi.Input[Union['DatasetAccessConditionArgs', 'DatasetAccessConditionArgsDict']]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 group_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_member: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 routine: Optional[pulumi.Input[Union['DatasetAccessRoutineArgs', 'DatasetAccessRoutineArgsDict']]] = None,
                 special_group: Optional[pulumi.Input[_builtins.str]] = None,
                 user_by_email: Optional[pulumi.Input[_builtins.str]] = None,
                 view: Optional[pulumi.Input[Union['DatasetAccessViewArgs', 'DatasetAccessViewArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetAccessInitArgs.__new__(DatasetAccessInitArgs)

            __props__.__dict__["authorized_dataset"] = authorized_dataset
            __props__.__dict__["condition"] = condition
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["domain"] = domain
            __props__.__dict__["group_by_email"] = group_by_email
            __props__.__dict__["iam_member"] = iam_member
            __props__.__dict__["project"] = project
            __props__.__dict__["role"] = role
            __props__.__dict__["routine"] = routine
            __props__.__dict__["special_group"] = special_group
            __props__.__dict__["user_by_email"] = user_by_email
            __props__.__dict__["view"] = view
            __props__.__dict__["api_updated_member"] = None
        super(DatasetAccess, __self__).__init__(
            'gcp:bigquery/datasetAccess:DatasetAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_updated_member: Optional[pulumi.Input[_builtins.bool]] = None,
            authorized_dataset: Optional[pulumi.Input[Union['DatasetAccessAuthorizedDatasetArgs', 'DatasetAccessAuthorizedDatasetArgsDict']]] = None,
            condition: Optional[pulumi.Input[Union['DatasetAccessConditionArgs', 'DatasetAccessConditionArgsDict']]] = None,
            dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            group_by_email: Optional[pulumi.Input[_builtins.str]] = None,
            iam_member: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            routine: Optional[pulumi.Input[Union['DatasetAccessRoutineArgs', 'DatasetAccessRoutineArgsDict']]] = None,
            special_group: Optional[pulumi.Input[_builtins.str]] = None,
            user_by_email: Optional[pulumi.Input[_builtins.str]] = None,
            view: Optional[pulumi.Input[Union['DatasetAccessViewArgs', 'DatasetAccessViewArgsDict']]] = None) -> 'DatasetAccess':
        """
        Get an existing DatasetAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] api_updated_member: If true, represents that that the iam_member in the config was translated to a different member type by the API, and is
               stored in state as a different member type
        :param pulumi.Input[Union['DatasetAccessAuthorizedDatasetArgs', 'DatasetAccessAuthorizedDatasetArgsDict']] authorized_dataset: Grants all resources of particular types in a particular dataset read access to the current dataset.
               Structure is documented below.
        :param pulumi.Input[Union['DatasetAccessConditionArgs', 'DatasetAccessConditionArgsDict']] condition: Condition for the binding. If CEL expression in this field is true, this
               access binding will be considered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset_id: A unique ID for this dataset, without the project name. The ID
               must contain only letters (a-z, A-Z), numbers (0-9), or
               underscores (_). The maximum length is 1,024 characters.
        :param pulumi.Input[_builtins.str] domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param pulumi.Input[_builtins.str] group_by_email: An email address of a Google Group to grant access to.
        :param pulumi.Input[_builtins.str] iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: `allUsers`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles are
               supported. Predefined roles that have equivalent basic roles are
               swapped by the API to their basic counterparts, and will show a diff
               post-create. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param pulumi.Input[Union['DatasetAccessRoutineArgs', 'DatasetAccessRoutineArgsDict']] routine: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] special_group: A special group to grant access to. Possible values include:
               * `projectOwners`: Owners of the enclosing project.
               * `projectReaders`: Readers of the enclosing project.
               * `projectWriters`: Writers of the enclosing project.
               * `allAuthenticatedUsers`: All authenticated BigQuery users.
        :param pulumi.Input[_builtins.str] user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param pulumi.Input[Union['DatasetAccessViewArgs', 'DatasetAccessViewArgsDict']] view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetAccessState.__new__(_DatasetAccessState)

        __props__.__dict__["api_updated_member"] = api_updated_member
        __props__.__dict__["authorized_dataset"] = authorized_dataset
        __props__.__dict__["condition"] = condition
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["group_by_email"] = group_by_email
        __props__.__dict__["iam_member"] = iam_member
        __props__.__dict__["project"] = project
        __props__.__dict__["role"] = role
        __props__.__dict__["routine"] = routine
        __props__.__dict__["special_group"] = special_group
        __props__.__dict__["user_by_email"] = user_by_email
        __props__.__dict__["view"] = view
        return DatasetAccess(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiUpdatedMember")
    def api_updated_member(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, represents that that the iam_member in the config was translated to a different member type by the API, and is
        stored in state as a different member type
        """
        return pulumi.get(self, "api_updated_member")

    @_builtins.property
    @pulumi.getter(name="authorizedDataset")
    def authorized_dataset(self) -> pulumi.Output[Optional['outputs.DatasetAccessAuthorizedDataset']]:
        """
        Grants all resources of particular types in a particular dataset read access to the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_dataset")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional['outputs.DatasetAccessCondition']]:
        """
        Condition for the binding. If CEL expression in this field is true, this
        access binding will be considered.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique ID for this dataset, without the project name. The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @_builtins.property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Some other type of member that appears in the IAM Policy but isn't a user,
        group, domain, or special group. For example: `allUsers`
        """
        return pulumi.get(self, "iam_member")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Basic, predefined, and custom roles are
        supported. Predefined roles that have equivalent basic roles are
        swapped by the API to their basic counterparts, and will show a diff
        post-create. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def routine(self) -> pulumi.Output[Optional['outputs.DatasetAccessRoutine']]:
        """
        A routine from a different dataset to grant access to. Queries
        executed against that routine will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that routine is updated by any user, access to the routine
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "routine")

    @_builtins.property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A special group to grant access to. Possible values include:
        * `projectOwners`: Owners of the enclosing project.
        * `projectReaders`: Readers of the enclosing project.
        * `projectWriters`: Writers of the enclosing project.
        * `allAuthenticatedUsers`: All authenticated BigQuery users.
        """
        return pulumi.get(self, "special_group")

    @_builtins.property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @_builtins.property
    @pulumi.getter
    def view(self) -> pulumi.Output[Optional['outputs.DatasetAccessView']]:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

