# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReservationArgs', 'Reservation']

@pulumi.input_type
class ReservationArgs:
    def __init__(__self__, *,
                 slot_capacity: pulumi.Input[_builtins.int],
                 autoscale: Optional[pulumi.Input['ReservationAutoscaleArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_idle_slots: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Reservation resource.
        :param pulumi.Input[_builtins.int] slot_capacity: Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
               unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        :param pulumi.Input['ReservationAutoscaleArgs'] autoscale: The configuration parameters for the auto scaling feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] concurrency: Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        :param pulumi.Input[_builtins.str] edition: The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        :param pulumi.Input[_builtins.bool] ignore_idle_slots: If false, any query using this reservation will use idle slots from other reservations within
               the same admin project. If true, a query using this reservation will execute with the slot
               capacity specified above at most.
        :param pulumi.Input[_builtins.str] location: The geographic location where the transfer config should reside.
               Examples: US, EU, asia-northeast1. The default value is US.
        :param pulumi.Input[_builtins.str] name: The name of the reservation. This field must only contain alphanumeric characters or dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] secondary_location: The current location of the reservation's secondary replica. This field is only set for
               reservations using the managed disaster recovery feature. Users can set this in create
               reservation calls to create a failover reservation or in update reservation calls to convert
               a non-failover reservation to a failover reservation(or vice versa).
        """
        pulumi.set(__self__, "slot_capacity", slot_capacity)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if ignore_idle_slots is not None:
            pulumi.set(__self__, "ignore_idle_slots", ignore_idle_slots)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if secondary_location is not None:
            pulumi.set(__self__, "secondary_location", secondary_location)

    @_builtins.property
    @pulumi.getter(name="slotCapacity")
    def slot_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
        unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        return pulumi.get(self, "slot_capacity")

    @slot_capacity.setter
    def slot_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "slot_capacity", value)

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input['ReservationAutoscaleArgs']]:
        """
        The configuration parameters for the auto scaling feature.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input['ReservationAutoscaleArgs']]):
        pulumi.set(self, "autoscale", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="ignoreIdleSlots")
    def ignore_idle_slots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If false, any query using this reservation will use idle slots from other reservations within
        the same admin project. If true, a query using this reservation will execute with the slot
        capacity specified above at most.
        """
        return pulumi.get(self, "ignore_idle_slots")

    @ignore_idle_slots.setter
    def ignore_idle_slots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_idle_slots", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the transfer config should reside.
        Examples: US, EU, asia-northeast1. The default value is US.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the reservation. This field must only contain alphanumeric characters or dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current location of the reservation's secondary replica. This field is only set for
        reservations using the managed disaster recovery feature. Users can set this in create
        reservation calls to create a failover reservation or in update reservation calls to convert
        a non-failover reservation to a failover reservation(or vice versa).
        """
        return pulumi.get(self, "secondary_location")

    @secondary_location.setter
    def secondary_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_location", value)


@pulumi.input_type
class _ReservationState:
    def __init__(__self__, *,
                 autoscale: Optional[pulumi.Input['ReservationAutoscaleArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_idle_slots: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 original_primary_location: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ReservationReplicationStatusArgs']]]] = None,
                 secondary_location: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_capacity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Reservation resources.
        :param pulumi.Input['ReservationAutoscaleArgs'] autoscale: The configuration parameters for the auto scaling feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] concurrency: Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        :param pulumi.Input[_builtins.str] edition: The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        :param pulumi.Input[_builtins.bool] ignore_idle_slots: If false, any query using this reservation will use idle slots from other reservations within
               the same admin project. If true, a query using this reservation will execute with the slot
               capacity specified above at most.
        :param pulumi.Input[_builtins.str] location: The geographic location where the transfer config should reside.
               Examples: US, EU, asia-northeast1. The default value is US.
        :param pulumi.Input[_builtins.str] name: The name of the reservation. This field must only contain alphanumeric characters or dash.
        :param pulumi.Input[_builtins.str] original_primary_location: The location where the reservation was originally created. This is set only during the
               failover reservation's creation. All billing charges for the failover reservation will be
               applied to this location.
        :param pulumi.Input[_builtins.str] primary_location: The current location of the reservation's primary replica. This field is only set for
               reservations using the managed disaster recovery feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ReservationReplicationStatusArgs']]] replication_statuses: The Disaster Recovery(DR) replication status of the reservation. This is only available for
               the primary replicas of DR/failover reservations and provides information about the both the
               staleness of the secondary and the last error encountered while trying to replicate changes
               from the primary to the secondary. If this field is blank, it means that the reservation is
               either not a DR reservation or the reservation is a DR secondary or that any replication
               operations on the reservation have succeeded.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] secondary_location: The current location of the reservation's secondary replica. This field is only set for
               reservations using the managed disaster recovery feature. Users can set this in create
               reservation calls to create a failover reservation or in update reservation calls to convert
               a non-failover reservation to a failover reservation(or vice versa).
        :param pulumi.Input[_builtins.int] slot_capacity: Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
               unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if ignore_idle_slots is not None:
            pulumi.set(__self__, "ignore_idle_slots", ignore_idle_slots)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if original_primary_location is not None:
            pulumi.set(__self__, "original_primary_location", original_primary_location)
        if primary_location is not None:
            pulumi.set(__self__, "primary_location", primary_location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_statuses is not None:
            pulumi.set(__self__, "replication_statuses", replication_statuses)
        if secondary_location is not None:
            pulumi.set(__self__, "secondary_location", secondary_location)
        if slot_capacity is not None:
            pulumi.set(__self__, "slot_capacity", slot_capacity)

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input['ReservationAutoscaleArgs']]:
        """
        The configuration parameters for the auto scaling feature.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input['ReservationAutoscaleArgs']]):
        pulumi.set(self, "autoscale", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="ignoreIdleSlots")
    def ignore_idle_slots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If false, any query using this reservation will use idle slots from other reservations within
        the same admin project. If true, a query using this reservation will execute with the slot
        capacity specified above at most.
        """
        return pulumi.get(self, "ignore_idle_slots")

    @ignore_idle_slots.setter
    def ignore_idle_slots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_idle_slots", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the transfer config should reside.
        Examples: US, EU, asia-northeast1. The default value is US.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the reservation. This field must only contain alphanumeric characters or dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="originalPrimaryLocation")
    def original_primary_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the reservation was originally created. This is set only during the
        failover reservation's creation. All billing charges for the failover reservation will be
        applied to this location.
        """
        return pulumi.get(self, "original_primary_location")

    @original_primary_location.setter
    def original_primary_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "original_primary_location", value)

    @_builtins.property
    @pulumi.getter(name="primaryLocation")
    def primary_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current location of the reservation's primary replica. This field is only set for
        reservations using the managed disaster recovery feature.
        """
        return pulumi.get(self, "primary_location")

    @primary_location.setter
    def primary_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicationStatuses")
    def replication_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReservationReplicationStatusArgs']]]]:
        """
        The Disaster Recovery(DR) replication status of the reservation. This is only available for
        the primary replicas of DR/failover reservations and provides information about the both the
        staleness of the secondary and the last error encountered while trying to replicate changes
        from the primary to the secondary. If this field is blank, it means that the reservation is
        either not a DR reservation or the reservation is a DR secondary or that any replication
        operations on the reservation have succeeded.
        Structure is documented below.
        """
        return pulumi.get(self, "replication_statuses")

    @replication_statuses.setter
    def replication_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReservationReplicationStatusArgs']]]]):
        pulumi.set(self, "replication_statuses", value)

    @_builtins.property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current location of the reservation's secondary replica. This field is only set for
        reservations using the managed disaster recovery feature. Users can set this in create
        reservation calls to create a failover reservation or in update reservation calls to convert
        a non-failover reservation to a failover reservation(or vice versa).
        """
        return pulumi.get(self, "secondary_location")

    @secondary_location.setter
    def secondary_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_location", value)

    @_builtins.property
    @pulumi.getter(name="slotCapacity")
    def slot_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
        unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        return pulumi.get(self, "slot_capacity")

    @slot_capacity.setter
    def slot_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slot_capacity", value)


@pulumi.type_token("gcp:bigquery/reservation:Reservation")
class Reservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscale: Optional[pulumi.Input[Union['ReservationAutoscaleArgs', 'ReservationAutoscaleArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_idle_slots: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_location: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        A reservation is a mechanism used to guarantee BigQuery slots to users.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/reservations/rest/v1/projects.locations.reservations/create)
        * How-to Guides
            * [Introduction to Reservations](https://cloud.google.com/bigquery/docs/reservations-intro)

        ## Example Usage

        ### Bigquery Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        reservation = gcp.bigquery.Reservation("reservation",
            name="my-reservation",
            location="us-west2",
            slot_capacity=0,
            edition="STANDARD",
            ignore_idle_slots=True,
            concurrency=0,
            autoscale={
                "max_slots": 100,
            })
        ```

        ## Import

        Reservation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/reservations/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Reservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default projects/{{project}}/locations/{{location}}/reservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReservationAutoscaleArgs', 'ReservationAutoscaleArgsDict']] autoscale: The configuration parameters for the auto scaling feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] concurrency: Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        :param pulumi.Input[_builtins.str] edition: The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        :param pulumi.Input[_builtins.bool] ignore_idle_slots: If false, any query using this reservation will use idle slots from other reservations within
               the same admin project. If true, a query using this reservation will execute with the slot
               capacity specified above at most.
        :param pulumi.Input[_builtins.str] location: The geographic location where the transfer config should reside.
               Examples: US, EU, asia-northeast1. The default value is US.
        :param pulumi.Input[_builtins.str] name: The name of the reservation. This field must only contain alphanumeric characters or dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] secondary_location: The current location of the reservation's secondary replica. This field is only set for
               reservations using the managed disaster recovery feature. Users can set this in create
               reservation calls to create a failover reservation or in update reservation calls to convert
               a non-failover reservation to a failover reservation(or vice versa).
        :param pulumi.Input[_builtins.int] slot_capacity: Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
               unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A reservation is a mechanism used to guarantee BigQuery slots to users.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/reservations/rest/v1/projects.locations.reservations/create)
        * How-to Guides
            * [Introduction to Reservations](https://cloud.google.com/bigquery/docs/reservations-intro)

        ## Example Usage

        ### Bigquery Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        reservation = gcp.bigquery.Reservation("reservation",
            name="my-reservation",
            location="us-west2",
            slot_capacity=0,
            edition="STANDARD",
            ignore_idle_slots=True,
            concurrency=0,
            autoscale={
                "max_slots": 100,
            })
        ```

        ## Import

        Reservation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/reservations/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Reservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default projects/{{project}}/locations/{{location}}/reservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/reservation:Reservation default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscale: Optional[pulumi.Input[Union['ReservationAutoscaleArgs', 'ReservationAutoscaleArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_idle_slots: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_location: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservationArgs.__new__(ReservationArgs)

            __props__.__dict__["autoscale"] = autoscale
            __props__.__dict__["concurrency"] = concurrency
            __props__.__dict__["edition"] = edition
            __props__.__dict__["ignore_idle_slots"] = ignore_idle_slots
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["secondary_location"] = secondary_location
            if slot_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'slot_capacity'")
            __props__.__dict__["slot_capacity"] = slot_capacity
            __props__.__dict__["original_primary_location"] = None
            __props__.__dict__["primary_location"] = None
            __props__.__dict__["replication_statuses"] = None
        super(Reservation, __self__).__init__(
            'gcp:bigquery/reservation:Reservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscale: Optional[pulumi.Input[Union['ReservationAutoscaleArgs', 'ReservationAutoscaleArgsDict']]] = None,
            concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            edition: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_idle_slots: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            original_primary_location: Optional[pulumi.Input[_builtins.str]] = None,
            primary_location: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            replication_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReservationReplicationStatusArgs', 'ReservationReplicationStatusArgsDict']]]]] = None,
            secondary_location: Optional[pulumi.Input[_builtins.str]] = None,
            slot_capacity: Optional[pulumi.Input[_builtins.int]] = None) -> 'Reservation':
        """
        Get an existing Reservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReservationAutoscaleArgs', 'ReservationAutoscaleArgsDict']] autoscale: The configuration parameters for the auto scaling feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] concurrency: Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        :param pulumi.Input[_builtins.str] edition: The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        :param pulumi.Input[_builtins.bool] ignore_idle_slots: If false, any query using this reservation will use idle slots from other reservations within
               the same admin project. If true, a query using this reservation will execute with the slot
               capacity specified above at most.
        :param pulumi.Input[_builtins.str] location: The geographic location where the transfer config should reside.
               Examples: US, EU, asia-northeast1. The default value is US.
        :param pulumi.Input[_builtins.str] name: The name of the reservation. This field must only contain alphanumeric characters or dash.
        :param pulumi.Input[_builtins.str] original_primary_location: The location where the reservation was originally created. This is set only during the
               failover reservation's creation. All billing charges for the failover reservation will be
               applied to this location.
        :param pulumi.Input[_builtins.str] primary_location: The current location of the reservation's primary replica. This field is only set for
               reservations using the managed disaster recovery feature.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReservationReplicationStatusArgs', 'ReservationReplicationStatusArgsDict']]]] replication_statuses: The Disaster Recovery(DR) replication status of the reservation. This is only available for
               the primary replicas of DR/failover reservations and provides information about the both the
               staleness of the secondary and the last error encountered while trying to replicate changes
               from the primary to the secondary. If this field is blank, it means that the reservation is
               either not a DR reservation or the reservation is a DR secondary or that any replication
               operations on the reservation have succeeded.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] secondary_location: The current location of the reservation's secondary replica. This field is only set for
               reservations using the managed disaster recovery feature. Users can set this in create
               reservation calls to create a failover reservation or in update reservation calls to convert
               a non-failover reservation to a failover reservation(or vice versa).
        :param pulumi.Input[_builtins.int] slot_capacity: Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
               unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservationState.__new__(_ReservationState)

        __props__.__dict__["autoscale"] = autoscale
        __props__.__dict__["concurrency"] = concurrency
        __props__.__dict__["edition"] = edition
        __props__.__dict__["ignore_idle_slots"] = ignore_idle_slots
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["original_primary_location"] = original_primary_location
        __props__.__dict__["primary_location"] = primary_location
        __props__.__dict__["project"] = project
        __props__.__dict__["replication_statuses"] = replication_statuses
        __props__.__dict__["secondary_location"] = secondary_location
        __props__.__dict__["slot_capacity"] = slot_capacity
        return Reservation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def autoscale(self) -> pulumi.Output[Optional['outputs.ReservationAutoscale']]:
        """
        The configuration parameters for the auto scaling feature.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscale")

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
        """
        return pulumi.get(self, "concurrency")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Output[_builtins.str]:
        """
        The edition type. Valid values are STANDARD, ENTERPRISE, ENTERPRISE_PLUS
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="ignoreIdleSlots")
    def ignore_idle_slots(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If false, any query using this reservation will use idle slots from other reservations within
        the same admin project. If true, a query using this reservation will execute with the slot
        capacity specified above at most.
        """
        return pulumi.get(self, "ignore_idle_slots")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The geographic location where the transfer config should reside.
        Examples: US, EU, asia-northeast1. The default value is US.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the reservation. This field must only contain alphanumeric characters or dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="originalPrimaryLocation")
    def original_primary_location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the reservation was originally created. This is set only during the
        failover reservation's creation. All billing charges for the failover reservation will be
        applied to this location.
        """
        return pulumi.get(self, "original_primary_location")

    @_builtins.property
    @pulumi.getter(name="primaryLocation")
    def primary_location(self) -> pulumi.Output[_builtins.str]:
        """
        The current location of the reservation's primary replica. This field is only set for
        reservations using the managed disaster recovery feature.
        """
        return pulumi.get(self, "primary_location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="replicationStatuses")
    def replication_statuses(self) -> pulumi.Output[Sequence['outputs.ReservationReplicationStatus']]:
        """
        The Disaster Recovery(DR) replication status of the reservation. This is only available for
        the primary replicas of DR/failover reservations and provides information about the both the
        staleness of the secondary and the last error encountered while trying to replicate changes
        from the primary to the secondary. If this field is blank, it means that the reservation is
        either not a DR reservation or the reservation is a DR secondary or that any replication
        operations on the reservation have succeeded.
        Structure is documented below.
        """
        return pulumi.get(self, "replication_statuses")

    @_builtins.property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The current location of the reservation's secondary replica. This field is only set for
        reservations using the managed disaster recovery feature. Users can set this in create
        reservation calls to create a failover reservation or in update reservation calls to convert
        a non-failover reservation to a failover reservation(or vice versa).
        """
        return pulumi.get(self, "secondary_location")

    @_builtins.property
    @pulumi.getter(name="slotCapacity")
    def slot_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
        unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
        """
        return pulumi.get(self, "slot_capacity")

