# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogicalViewArgs', 'LogicalView']

@pulumi.input_type
class LogicalViewArgs:
    def __init__(__self__, *,
                 logical_view_id: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogicalView resource.
        :param pulumi.Input[_builtins.str] logical_view_id: The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] query: The logical view's select query.
        :param pulumi.Input[_builtins.bool] deletion_protection: Set to true to make the logical view protected against deletion.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the logical view within.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "logical_view_id", logical_view_id)
        pulumi.set(__self__, "query", query)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="logicalViewId")
    def logical_view_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "logical_view_id")

    @logical_view_id.setter
    def logical_view_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logical_view_id", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        The logical view's select query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to make the logical view protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance to create the logical view within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _LogicalViewState:
    def __init__(__self__, *,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogicalView resources.
        :param pulumi.Input[_builtins.bool] deletion_protection: Set to true to make the logical view protected against deletion.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the logical view within.
        :param pulumi.Input[_builtins.str] logical_view_id: The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] name: The unique name of the requested logical view. Values are of the form `projects/<project>/instances/<instance>/logicalViews/<logicalViewId>`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query: The logical view's select query.
        """
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if logical_view_id is not None:
            pulumi.set(__self__, "logical_view_id", logical_view_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to make the logical view protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance to create the logical view within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter(name="logicalViewId")
    def logical_view_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "logical_view_id")

    @logical_view_id.setter
    def logical_view_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logical_view_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the requested logical view. Values are of the form `projects/<project>/instances/<instance>/logicalViews/<logicalViewId>`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The logical view's select query.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)


@pulumi.type_token("gcp:bigtable/logicalView:LogicalView")
class LogicalView(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A logical view object that can be referenced in SQL queries.

        To get more information about LogicalView, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.logicalViews)

        ## Example Usage

        ### Bigtable Logical View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }],
            deletion_protection=False)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        logical_view = gcp.bigtable.LogicalView("logical_view",
            logical_view_id="bt-logical-view",
            instance=instance.name,
            deletion_protection=False,
            query=\"\"\"SELECT _key, CF
        FROM ` + "`bt-table`" + `
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[table]))
        ```

        ## Import

        LogicalView can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/logicalViews/{{logical_view_id}}`

        * `{{project}}/{{instance}}/{{logical_view_id}}`

        * `{{instance}}/{{logical_view_id}}`

        When using the `pulumi import` command, LogicalView can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default projects/{{project}}/instances/{{instance}}/logicalViews/{{logical_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default {{project}}/{{instance}}/{{logical_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default {{instance}}/{{logical_view_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: Set to true to make the logical view protected against deletion.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the logical view within.
        :param pulumi.Input[_builtins.str] logical_view_id: The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query: The logical view's select query.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogicalViewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A logical view object that can be referenced in SQL queries.

        To get more information about LogicalView, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.logicalViews)

        ## Example Usage

        ### Bigtable Logical View

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }],
            deletion_protection=False)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        logical_view = gcp.bigtable.LogicalView("logical_view",
            logical_view_id="bt-logical-view",
            instance=instance.name,
            deletion_protection=False,
            query=\"\"\"SELECT _key, CF
        FROM ` + "`bt-table`" + `
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[table]))
        ```

        ## Import

        LogicalView can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/logicalViews/{{logical_view_id}}`

        * `{{project}}/{{instance}}/{{logical_view_id}}`

        * `{{instance}}/{{logical_view_id}}`

        When using the `pulumi import` command, LogicalView can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default projects/{{project}}/instances/{{instance}}/logicalViews/{{logical_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default {{project}}/{{instance}}/{{logical_view_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/logicalView:LogicalView default {{instance}}/{{logical_view_id}}
        ```

        :param str resource_name: The name of the resource.
        :param LogicalViewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogicalViewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogicalViewArgs.__new__(LogicalViewArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["instance"] = instance
            if logical_view_id is None and not opts.urn:
                raise TypeError("Missing required property 'logical_view_id'")
            __props__.__dict__["logical_view_id"] = logical_view_id
            __props__.__dict__["project"] = project
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["name"] = None
        super(LogicalView, __self__).__init__(
            'gcp:bigtable/logicalView:LogicalView',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            instance: Optional[pulumi.Input[_builtins.str]] = None,
            logical_view_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogicalView':
        """
        Get an existing LogicalView resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: Set to true to make the logical view protected against deletion.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the logical view within.
        :param pulumi.Input[_builtins.str] logical_view_id: The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] name: The unique name of the requested logical view. Values are of the form `projects/<project>/instances/<instance>/logicalViews/<logicalViewId>`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] query: The logical view's select query.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogicalViewState.__new__(_LogicalViewState)

        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["instance"] = instance
        __props__.__dict__["logical_view_id"] = logical_view_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["query"] = query
        return LogicalView(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to make the logical view protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the instance to create the logical view within.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="logicalViewId")
    def logical_view_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the logical view in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "logical_view_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the requested logical view. Values are of the form `projects/<project>/instances/<instance>/logicalViews/<logicalViewId>`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The logical view's select query.
        """
        return pulumi.get(self, "query")

