# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppProfileDataBoostIsolationReadOnly',
    'AppProfileSingleClusterRouting',
    'AppProfileStandardIsolation',
    'AuthorizedViewSubsetView',
    'AuthorizedViewSubsetViewFamilySubset',
    'GCPolicyMaxAge',
    'GCPolicyMaxVersion',
    'InstanceCluster',
    'InstanceClusterAutoscalingConfig',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'TableAutomatedBackupPolicy',
    'TableColumnFamily',
    'TableIamBindingCondition',
    'TableIamMemberCondition',
]

@pulumi.output_type
class AppProfileDataBoostIsolationReadOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeBillingOwner":
            suggest = "compute_billing_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileDataBoostIsolationReadOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_billing_owner: _builtins.str):
        """
        :param _builtins.str compute_billing_owner: The Compute Billing Owner for this Data Boost App Profile.
               Possible values are: `HOST_PAYS`.
        """
        pulumi.set(__self__, "compute_billing_owner", compute_billing_owner)

    @_builtins.property
    @pulumi.getter(name="computeBillingOwner")
    def compute_billing_owner(self) -> _builtins.str:
        """
        The Compute Billing Owner for this Data Boost App Profile.
        Possible values are: `HOST_PAYS`.
        """
        return pulumi.get(self, "compute_billing_owner")


@pulumi.output_type
class AppProfileSingleClusterRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "allowTransactionalWrites":
            suggest = "allow_transactional_writes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileSingleClusterRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 allow_transactional_writes: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cluster_id: The cluster to which read/write requests should be routed.
        :param _builtins.bool allow_transactional_writes: If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
               It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if allow_transactional_writes is not None:
            pulumi.set(__self__, "allow_transactional_writes", allow_transactional_writes)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The cluster to which read/write requests should be routed.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="allowTransactionalWrites")
    def allow_transactional_writes(self) -> Optional[_builtins.bool]:
        """
        If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
        It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return pulumi.get(self, "allow_transactional_writes")


@pulumi.output_type
class AppProfileStandardIsolation(dict):
    def __init__(__self__, *,
                 priority: _builtins.str):
        """
        :param _builtins.str priority: The priority of requests sent using this app profile.
               Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.str:
        """
        The priority of requests sent using this app profile.
        Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class AuthorizedViewSubsetView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familySubsets":
            suggest = "family_subsets"
        elif key == "rowPrefixes":
            suggest = "row_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizedViewSubsetView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizedViewSubsetView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizedViewSubsetView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_subsets: Optional[Sequence['outputs.AuthorizedViewSubsetViewFamilySubset']] = None,
                 row_prefixes: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['AuthorizedViewSubsetViewFamilySubsetArgs'] family_subsets: A group of column family subsets to be included in the authorized view. This can be specified multiple times. Structure is documented below.
               
               -----
        :param Sequence[_builtins.str] row_prefixes: A list of Base64-encoded row prefixes to be included in the authorized view. To provide access to all rows, include the empty string as a prefix ("").
        """
        if family_subsets is not None:
            pulumi.set(__self__, "family_subsets", family_subsets)
        if row_prefixes is not None:
            pulumi.set(__self__, "row_prefixes", row_prefixes)

    @_builtins.property
    @pulumi.getter(name="familySubsets")
    def family_subsets(self) -> Optional[Sequence['outputs.AuthorizedViewSubsetViewFamilySubset']]:
        """
        A group of column family subsets to be included in the authorized view. This can be specified multiple times. Structure is documented below.

        -----
        """
        return pulumi.get(self, "family_subsets")

    @_builtins.property
    @pulumi.getter(name="rowPrefixes")
    def row_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Base64-encoded row prefixes to be included in the authorized view. To provide access to all rows, include the empty string as a prefix ("").
        """
        return pulumi.get(self, "row_prefixes")


@pulumi.output_type
class AuthorizedViewSubsetViewFamilySubset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familyName":
            suggest = "family_name"
        elif key == "qualifierPrefixes":
            suggest = "qualifier_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizedViewSubsetViewFamilySubset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizedViewSubsetViewFamilySubset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizedViewSubsetViewFamilySubset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_name: _builtins.str,
                 qualifier_prefixes: Optional[Sequence[_builtins.str]] = None,
                 qualifiers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str family_name: Name of the column family to be included in the authorized view. The specified column family must exist in the parent table of this authorized view.
        :param Sequence[_builtins.str] qualifier_prefixes: A list of Base64-encoded prefixes for qualifiers of the column family to be included in the authorized view.
               Every qualifier starting with one of these prefixes is included in the authorized view. To provide access to all qualifiers, include the empty string as a prefix ("").
        :param Sequence[_builtins.str] qualifiers: A list of Base64-encoded individual exact column qualifiers of the column family to be included in the authorized view.
        """
        pulumi.set(__self__, "family_name", family_name)
        if qualifier_prefixes is not None:
            pulumi.set(__self__, "qualifier_prefixes", qualifier_prefixes)
        if qualifiers is not None:
            pulumi.set(__self__, "qualifiers", qualifiers)

    @_builtins.property
    @pulumi.getter(name="familyName")
    def family_name(self) -> _builtins.str:
        """
        Name of the column family to be included in the authorized view. The specified column family must exist in the parent table of this authorized view.
        """
        return pulumi.get(self, "family_name")

    @_builtins.property
    @pulumi.getter(name="qualifierPrefixes")
    def qualifier_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Base64-encoded prefixes for qualifiers of the column family to be included in the authorized view.
        Every qualifier starting with one of these prefixes is included in the authorized view. To provide access to all qualifiers, include the empty string as a prefix ("").
        """
        return pulumi.get(self, "qualifier_prefixes")

    @_builtins.property
    @pulumi.getter
    def qualifiers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Base64-encoded individual exact column qualifiers of the column family to be included in the authorized view.
        """
        return pulumi.get(self, "qualifiers")


@pulumi.output_type
class GCPolicyMaxAge(dict):
    def __init__(__self__, *,
                 days: Optional[_builtins.int] = None,
                 duration: Optional[_builtins.str] = None):
        """
        :param _builtins.int days: Number of days before applying GC policy.
        :param _builtins.str duration: Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set
               
               -----
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated in favor of duration""")
    def days(self) -> Optional[_builtins.int]:
        """
        Number of days before applying GC policy.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set

        -----
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class GCPolicyMaxVersion(dict):
    def __init__(__self__, *,
                 number: _builtins.int):
        """
        :param _builtins.int number: Number of version before applying the GC policy.
               
               -----
               `gc_rules` include 2 fields:
        """
        pulumi.set(__self__, "number", number)

    @_builtins.property
    @pulumi.getter
    def number(self) -> _builtins.int:
        """
        Number of version before applying the GC policy.

        -----
        `gc_rules` include 2 fields:
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class InstanceCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "nodeScalingFactor":
            suggest = "node_scaling_factor"
        elif key == "numNodes":
            suggest = "num_nodes"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 autoscaling_config: Optional['outputs.InstanceClusterAutoscalingConfig'] = None,
                 kms_key_name: Optional[_builtins.str] = None,
                 node_scaling_factor: Optional[_builtins.str] = None,
                 num_nodes: Optional[_builtins.int] = None,
                 state: Optional[_builtins.str] = None,
                 storage_type: Optional[_builtins.str] = None,
                 zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_id: The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        :param 'InstanceClusterAutoscalingConfigArgs' autoscaling_config: [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        :param _builtins.str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        :param _builtins.str node_scaling_factor: The node scaling factor for this cluster. One of `"NodeScalingFactor1X"` or `"NodeScalingFactor2X"`. Defaults to `"NodeScalingFactor1X"`. If `"NodeScalingFactor2X"` is specified, then `num_nodes`, `min_nodes`, and `max_nodes` would need to be specified in increments of 2. This value cannot be updated after the cluster is created.
               
               > **Note**: Removing the field entirely from the config will cause the provider to default to the backend value.
               
               !> **Warning**: Modifying this field will cause the provider to delete/recreate the entire resource.
               
               !> **Warning:** Modifying the `storage_type`, `zone` or `kms_key_name` of an existing cluster (by
               `cluster_id`) will cause the provider to delete/recreate the entire
               `bigtable.Instance` resource. If these values are changing, use a new
               `cluster_id`.
        :param _builtins.int num_nodes: The number of nodes in the cluster.
               If no value is set, Cloud Bigtable automatically allocates nodes based on your data footprint and optimized for 50% storage utilization.
        :param _builtins.str state: describes the current state of the cluster.
        :param _builtins.str storage_type: The storage type to use. One of `"SSD"` or
               `"HDD"`. Defaults to `"SSD"`.
        :param _builtins.str zone: The zone to create the Cloud Bigtable cluster in. If it not
               specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
               Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if node_scaling_factor is not None:
            pulumi.set(__self__, "node_scaling_factor", node_scaling_factor)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.InstanceClusterAutoscalingConfig']:
        """
        [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        """
        return pulumi.get(self, "autoscaling_config")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="nodeScalingFactor")
    def node_scaling_factor(self) -> Optional[_builtins.str]:
        """
        The node scaling factor for this cluster. One of `"NodeScalingFactor1X"` or `"NodeScalingFactor2X"`. Defaults to `"NodeScalingFactor1X"`. If `"NodeScalingFactor2X"` is specified, then `num_nodes`, `min_nodes`, and `max_nodes` would need to be specified in increments of 2. This value cannot be updated after the cluster is created.

        > **Note**: Removing the field entirely from the config will cause the provider to default to the backend value.

        !> **Warning**: Modifying this field will cause the provider to delete/recreate the entire resource.

        !> **Warning:** Modifying the `storage_type`, `zone` or `kms_key_name` of an existing cluster (by
        `cluster_id`) will cause the provider to delete/recreate the entire
        `bigtable.Instance` resource. If these values are changing, use a new
        `cluster_id`.
        """
        return pulumi.get(self, "node_scaling_factor")

    @_builtins.property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[_builtins.int]:
        """
        The number of nodes in the cluster.
        If no value is set, Cloud Bigtable automatically allocates nodes based on your data footprint and optimized for 50% storage utilization.
        """
        return pulumi.get(self, "num_nodes")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        describes the current state of the cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[_builtins.str]:
        """
        The storage type to use. One of `"SSD"` or
        `"HDD"`. Defaults to `"SSD"`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        """
        The zone to create the Cloud Bigtable cluster in. If it not
        specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
        Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceClusterAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuTarget":
            suggest = "cpu_target"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "storageTarget":
            suggest = "storage_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClusterAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_target: _builtins.int,
                 max_nodes: _builtins.int,
                 min_nodes: _builtins.int,
                 storage_target: Optional[_builtins.int] = None):
        """
        :param _builtins.int cpu_target: The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        :param _builtins.int max_nodes: The maximum number of nodes for autoscaling.
        :param _builtins.int min_nodes: The minimum number of nodes for autoscaling.
        :param _builtins.int storage_target: The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.
               
               !> **Warning**: Only one of `autoscaling_config` or `num_nodes` should be set for a cluster. If both are set, `num_nodes` is ignored. If none is set, autoscaling will be disabled and sized to the current node count.
        """
        pulumi.set(__self__, "cpu_target", cpu_target)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        if storage_target is not None:
            pulumi.set(__self__, "storage_target", storage_target)

    @_builtins.property
    @pulumi.getter(name="cpuTarget")
    def cpu_target(self) -> _builtins.int:
        """
        The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        """
        return pulumi.get(self, "cpu_target")

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> _builtins.int:
        """
        The maximum number of nodes for autoscaling.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> _builtins.int:
        """
        The minimum number of nodes for autoscaling.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter(name="storageTarget")
    def storage_target(self) -> Optional[_builtins.int]:
        """
        The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.

        !> **Warning**: Only one of `autoscaling_config` or `num_nodes` should be set for a cluster. If both are set, `num_nodes` is ignored. If none is set, autoscaling will be disabled and sized to the current node count.
        """
        return pulumi.get(self, "storage_target")


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param _builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               For `bigtable.InstanceIamPolicy` only:
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        For `bigtable.InstanceIamPolicy` only:
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param _builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               For `bigtable.InstanceIamPolicy` only:
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        For `bigtable.InstanceIamPolicy` only:
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class TableAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: Optional[_builtins.str] = None,
                 retention_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str frequency: How frequently automated backups should occur.
        :param _builtins.str retention_period: How long the automated backups should be retained.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[_builtins.str]:
        """
        How frequently automated backups should occur.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[_builtins.str]:
        """
        How long the automated backups should be retained.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class TableColumnFamily(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str family: The name of the column family.
        :param _builtins.str type: The type of the column family.
        """
        pulumi.set(__self__, "family", family)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        The name of the column family.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the column family.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TableIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


