# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 runtime: pulumi.Input[_builtins.str],
                 available_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 build_service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 build_worker_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_repository: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 https_trigger_security_level: Optional[pulumi.Input[_builtins.str]] = None,
                 https_trigger_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]] = None,
                 secret_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_object: Optional[pulumi.Input[_builtins.str]] = None,
                 source_repository: Optional[pulumi.Input['FunctionSourceRepositoryArgs']] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[_builtins.str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
               
               - - -
        :param pulumi.Input[_builtins.int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[_builtins.str] build_service_account: If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        :param pulumi.Input[_builtins.str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        :param pulumi.Input[_builtins.str] description: Description of the function.
        :param pulumi.Input[_builtins.str] docker_registry: Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        :param pulumi.Input[_builtins.str] docker_repository: User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        :param pulumi.Input[_builtins.str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[_builtins.str] https_trigger_security_level: The security level for the function. The following options are available:
               
               * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
               * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        :param pulumi.Input[_builtins.str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[_builtins.str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[_builtins.str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
               If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[_builtins.str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]] secret_environment_variables: Secret environment variables configuration. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]] secret_volumes: Secret volumes configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[_builtins.str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[_builtins.str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input['FunctionSourceRepositoryArgs'] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        :param pulumi.Input[_builtins.int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[_builtins.bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[_builtins.str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[_builtins.str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        pulumi.set(__self__, "runtime", runtime)
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if build_service_account is not None:
            pulumi.set(__self__, "build_service_account", build_service_account)
        if build_worker_pool is not None:
            pulumi.set(__self__, "build_worker_pool", build_worker_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker_registry is not None:
            pulumi.set(__self__, "docker_registry", docker_registry)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger_security_level is not None:
            pulumi.set(__self__, "https_trigger_security_level", https_trigger_security_level)
        if https_trigger_url is not None:
            pulumi.set(__self__, "https_trigger_url", https_trigger_url)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if secret_volumes is not None:
            pulumi.set(__self__, "secret_volumes", secret_volumes)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_bucket is not None:
            pulumi.set(__self__, "source_archive_bucket", source_archive_bucket)
        if source_archive_object is not None:
            pulumi.set(__self__, "source_archive_object", source_archive_object)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trigger_http is not None:
            pulumi.set(__self__, "trigger_http", trigger_http)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[_builtins.str]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.

        - - -
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_memory_mb", value)

    @_builtins.property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "build_environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="buildServiceAccount")
    def build_service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        """
        return pulumi.get(self, "build_service_account")

    @build_service_account.setter
    def build_service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_service_account", value)

    @_builtins.property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "build_worker_pool")

    @build_worker_pool.setter
    def build_worker_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_worker_pool", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dockerRegistry")
    def docker_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        """
        return pulumi.get(self, "docker_registry")

    @docker_registry.setter
    def docker_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_registry", value)

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        """
        return pulumi.get(self, "docker_repository")

    @docker_repository.setter
    def docker_repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_repository", value)

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_point", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @_builtins.property
    @pulumi.getter(name="httpsTriggerSecurityLevel")
    def https_trigger_security_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security level for the function. The following options are available:

        * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
        * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        """
        return pulumi.get(self, "https_trigger_security_level")

    @https_trigger_security_level.setter
    def https_trigger_security_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_trigger_security_level", value)

    @_builtins.property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @https_trigger_url.setter
    def https_trigger_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_trigger_url", value)

    @_builtins.property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_settings", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]]:
        """
        Secret environment variables configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]]:
        """
        Secret volumes configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_volumes")

    @secret_volumes.setter
    def secret_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]]):
        pulumi.set(self, "secret_volumes", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @source_archive_bucket.setter
    def source_archive_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_archive_bucket", value)

    @_builtins.property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @source_archive_object.setter
    def source_archive_object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_archive_object", value)

    @_builtins.property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['FunctionSourceRepositoryArgs']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['FunctionSourceRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @trigger_http.setter
    def trigger_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trigger_http", value)

    @_builtins.property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_connector", value)

    @_builtins.property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 available_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 build_service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 build_worker_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_repository: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 entry_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 https_trigger_security_level: Optional[pulumi.Input[_builtins.str]] = None,
                 https_trigger_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]] = None,
                 secret_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_object: Optional[pulumi.Input[_builtins.str]] = None,
                 source_repository: Optional[pulumi.Input['FunctionSourceRepositoryArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[_builtins.int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[_builtins.str] build_service_account: If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        :param pulumi.Input[_builtins.str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        :param pulumi.Input[_builtins.str] description: Description of the function.
        :param pulumi.Input[_builtins.str] docker_registry: Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        :param pulumi.Input[_builtins.str] docker_repository: User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[_builtins.str] https_trigger_security_level: The security level for the function. The following options are available:
               
               * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
               * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        :param pulumi.Input[_builtins.str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[_builtins.str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[_builtins.str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
               If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[_builtins.str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]] secret_environment_variables: Secret environment variables configuration. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]] secret_volumes: Secret volumes configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[_builtins.str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[_builtins.str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input['FunctionSourceRepositoryArgs'] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        :param pulumi.Input[_builtins.str] status: Describes the current stage of a deployment.
        :param pulumi.Input[_builtins.int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[_builtins.bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[_builtins.str] version_id: The version identifier of the Cloud Function. Each deployment attempt results in a new version of a function being
               created.
        :param pulumi.Input[_builtins.str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[_builtins.str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if build_service_account is not None:
            pulumi.set(__self__, "build_service_account", build_service_account)
        if build_worker_pool is not None:
            pulumi.set(__self__, "build_worker_pool", build_worker_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker_registry is not None:
            pulumi.set(__self__, "docker_registry", docker_registry)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger_security_level is not None:
            pulumi.set(__self__, "https_trigger_security_level", https_trigger_security_level)
        if https_trigger_url is not None:
            pulumi.set(__self__, "https_trigger_url", https_trigger_url)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if secret_volumes is not None:
            pulumi.set(__self__, "secret_volumes", secret_volumes)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_bucket is not None:
            pulumi.set(__self__, "source_archive_bucket", source_archive_bucket)
        if source_archive_object is not None:
            pulumi.set(__self__, "source_archive_object", source_archive_object)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trigger_http is not None:
            pulumi.set(__self__, "trigger_http", trigger_http)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @_builtins.property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_memory_mb", value)

    @_builtins.property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "build_environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="buildServiceAccount")
    def build_service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        """
        return pulumi.get(self, "build_service_account")

    @build_service_account.setter
    def build_service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_service_account", value)

    @_builtins.property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "build_worker_pool")

    @build_worker_pool.setter
    def build_worker_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_worker_pool", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dockerRegistry")
    def docker_registry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        """
        return pulumi.get(self, "docker_registry")

    @docker_registry.setter
    def docker_registry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_registry", value)

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        """
        return pulumi.get(self, "docker_repository")

    @docker_repository.setter
    def docker_repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_repository", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_point", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @_builtins.property
    @pulumi.getter(name="httpsTriggerSecurityLevel")
    def https_trigger_security_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security level for the function. The following options are available:

        * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
        * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        """
        return pulumi.get(self, "https_trigger_security_level")

    @https_trigger_security_level.setter
    def https_trigger_security_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_trigger_security_level", value)

    @_builtins.property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @https_trigger_url.setter
    def https_trigger_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_trigger_url", value)

    @_builtins.property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_settings", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_instances", value)

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_instances", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.

        - - -
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]]:
        """
        Secret environment variables configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretEnvironmentVariableArgs']]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]]:
        """
        Secret volumes configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_volumes")

    @secret_volumes.setter
    def secret_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionSecretVolumeArgs']]]]):
        pulumi.set(self, "secret_volumes", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @source_archive_bucket.setter
    def source_archive_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_archive_bucket", value)

    @_builtins.property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @source_archive_object.setter
    def source_archive_object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_archive_object", value)

    @_builtins.property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['FunctionSourceRepositoryArgs']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['FunctionSourceRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the current stage of a deployment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @trigger_http.setter
    def trigger_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trigger_http", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version identifier of the Cloud Function. Each deployment attempt results in a new version of a function being
        created.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_connector", value)

    @_builtins.property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


@pulumi.type_token("gcp:cloudfunctions/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 build_service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 build_worker_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_repository: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
                 https_trigger_security_level: Optional[pulumi.Input[_builtins.str]] = None,
                 https_trigger_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretEnvironmentVariableArgs', 'FunctionSecretEnvironmentVariableArgsDict']]]]] = None,
                 secret_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretVolumeArgs', 'FunctionSecretVolumeArgsDict']]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_object: Optional[pulumi.Input[_builtins.str]] = None,
                 source_repository: Optional[pulumi.Input[Union['FunctionSourceRepositoryArgs', 'FunctionSourceRepositoryArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new Cloud Function. For more information see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v1/projects.locations.functions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/functions/docs)

        > **Warning:** As of November 1, 2019, newly created Functions are
        private-by-default and will require [appropriate IAM permissions](https://cloud.google.com/functions/docs/reference/iam/roles)
        to be invoked. See below examples for how to set up the appropriate permissions,
        or view the [Cloud Functions IAM resources](https://www.terraform.io/docs/providers/google/r/cloudfunctions_cloud_function_iam.html)
        for Cloud Functions.

        ## Example Usage

        ### Public Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="test-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            name="function-test",
            description="My function",
            runtime="nodejs20",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            entry_point="helloGET")
        # IAM entry for all users to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="allUsers")
        ```

        ### Single User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="test-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            name="function-test",
            description="My function",
            runtime="nodejs20",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            https_trigger_security_level="SECURE_ALWAYS",
            timeout=60,
            entry_point="helloGET",
            labels={
                "my-label": "my-label-value",
            },
            environment_variables={
                "MY_ENV_VAR": "my-env-var-value",
            })
        # IAM entry for a single user to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="user:myFunctionInvoker@example.com")
        ```

        ## Import

        Functions can be imported using the `name` or `{{project}}/{{region}}/name`, e.g.

        * `{{project}}/{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Functions can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudfunctions/function:Function default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctions/function:Function default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[_builtins.str] build_service_account: If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        :param pulumi.Input[_builtins.str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        :param pulumi.Input[_builtins.str] description: Description of the function.
        :param pulumi.Input[_builtins.str] docker_registry: Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        :param pulumi.Input[_builtins.str] docker_repository: User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        :param pulumi.Input[_builtins.str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[_builtins.str] https_trigger_security_level: The security level for the function. The following options are available:
               
               * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
               * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        :param pulumi.Input[_builtins.str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[_builtins.str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[_builtins.str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
               If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[_builtins.str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretEnvironmentVariableArgs', 'FunctionSecretEnvironmentVariableArgsDict']]]] secret_environment_variables: Secret environment variables configuration. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretVolumeArgs', 'FunctionSecretVolumeArgsDict']]]] secret_volumes: Secret volumes configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[_builtins.str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[_builtins.str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input[Union['FunctionSourceRepositoryArgs', 'FunctionSourceRepositoryArgsDict']] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        :param pulumi.Input[_builtins.int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[_builtins.bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[_builtins.str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[_builtins.str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Cloud Function. For more information see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v1/projects.locations.functions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/functions/docs)

        > **Warning:** As of November 1, 2019, newly created Functions are
        private-by-default and will require [appropriate IAM permissions](https://cloud.google.com/functions/docs/reference/iam/roles)
        to be invoked. See below examples for how to set up the appropriate permissions,
        or view the [Cloud Functions IAM resources](https://www.terraform.io/docs/providers/google/r/cloudfunctions_cloud_function_iam.html)
        for Cloud Functions.

        ## Example Usage

        ### Public Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="test-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            name="function-test",
            description="My function",
            runtime="nodejs20",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            entry_point="helloGET")
        # IAM entry for all users to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="allUsers")
        ```

        ### Single User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="test-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            name="function-test",
            description="My function",
            runtime="nodejs20",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            https_trigger_security_level="SECURE_ALWAYS",
            timeout=60,
            entry_point="helloGET",
            labels={
                "my-label": "my-label-value",
            },
            environment_variables={
                "MY_ENV_VAR": "my-env-var-value",
            })
        # IAM entry for a single user to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="user:myFunctionInvoker@example.com")
        ```

        ## Import

        Functions can be imported using the `name` or `{{project}}/{{region}}/name`, e.g.

        * `{{project}}/{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Functions can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudfunctions/function:Function default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctions/function:Function default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 build_service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 build_worker_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_registry: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_repository: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
                 https_trigger_security_level: Optional[pulumi.Input[_builtins.str]] = None,
                 https_trigger_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 max_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 min_instances: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretEnvironmentVariableArgs', 'FunctionSecretEnvironmentVariableArgsDict']]]]] = None,
                 secret_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretVolumeArgs', 'FunctionSecretVolumeArgsDict']]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 source_archive_object: Optional[pulumi.Input[_builtins.str]] = None,
                 source_repository: Optional[pulumi.Input[Union['FunctionSourceRepositoryArgs', 'FunctionSourceRepositoryArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["available_memory_mb"] = available_memory_mb
            __props__.__dict__["build_environment_variables"] = build_environment_variables
            __props__.__dict__["build_service_account"] = build_service_account
            __props__.__dict__["build_worker_pool"] = build_worker_pool
            __props__.__dict__["description"] = description
            __props__.__dict__["docker_registry"] = docker_registry
            __props__.__dict__["docker_repository"] = docker_repository
            __props__.__dict__["entry_point"] = entry_point
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["https_trigger_security_level"] = https_trigger_security_level
            __props__.__dict__["https_trigger_url"] = https_trigger_url
            __props__.__dict__["ingress_settings"] = ingress_settings
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_instances"] = max_instances
            __props__.__dict__["min_instances"] = min_instances
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["secret_environment_variables"] = secret_environment_variables
            __props__.__dict__["secret_volumes"] = secret_volumes
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["source_archive_bucket"] = source_archive_bucket
            __props__.__dict__["source_archive_object"] = source_archive_object
            __props__.__dict__["source_repository"] = source_repository
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["trigger_http"] = trigger_http
            __props__.__dict__["vpc_connector"] = vpc_connector
            __props__.__dict__["vpc_connector_egress_settings"] = vpc_connector_egress_settings
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Function, __self__).__init__(
            'gcp:cloudfunctions/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_memory_mb: Optional[pulumi.Input[_builtins.int]] = None,
            build_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            build_service_account: Optional[pulumi.Input[_builtins.str]] = None,
            build_worker_pool: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            docker_registry: Optional[pulumi.Input[_builtins.str]] = None,
            docker_repository: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            entry_point: Optional[pulumi.Input[_builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
            https_trigger_security_level: Optional[pulumi.Input[_builtins.str]] = None,
            https_trigger_url: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_settings: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            max_instances: Optional[pulumi.Input[_builtins.int]] = None,
            min_instances: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            secret_environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretEnvironmentVariableArgs', 'FunctionSecretEnvironmentVariableArgsDict']]]]] = None,
            secret_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretVolumeArgs', 'FunctionSecretVolumeArgsDict']]]]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            source_archive_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            source_archive_object: Optional[pulumi.Input[_builtins.str]] = None,
            source_repository: Optional[pulumi.Input[Union['FunctionSourceRepositoryArgs', 'FunctionSourceRepositoryArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            trigger_http: Optional[pulumi.Input[_builtins.bool]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_connector: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_connector_egress_settings: Optional[pulumi.Input[_builtins.str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[_builtins.str] build_service_account: If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        :param pulumi.Input[_builtins.str] build_worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        :param pulumi.Input[_builtins.str] description: Description of the function.
        :param pulumi.Input[_builtins.str] docker_registry: Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        :param pulumi.Input[_builtins.str] docker_repository: User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[_builtins.str] https_trigger_security_level: The security level for the function. The following options are available:
               
               * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
               * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        :param pulumi.Input[_builtins.str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[_builtins.str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[_builtins.str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
               If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[_builtins.str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretEnvironmentVariableArgs', 'FunctionSecretEnvironmentVariableArgsDict']]]] secret_environment_variables: Secret environment variables configuration. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionSecretVolumeArgs', 'FunctionSecretVolumeArgsDict']]]] secret_volumes: Secret volumes configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[_builtins.str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[_builtins.str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input[Union['FunctionSourceRepositoryArgs', 'FunctionSourceRepositoryArgsDict']] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        :param pulumi.Input[_builtins.str] status: Describes the current stage of a deployment.
        :param pulumi.Input[_builtins.int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[_builtins.bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[_builtins.str] version_id: The version identifier of the Cloud Function. Each deployment attempt results in a new version of a function being
               created.
        :param pulumi.Input[_builtins.str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[_builtins.str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["available_memory_mb"] = available_memory_mb
        __props__.__dict__["build_environment_variables"] = build_environment_variables
        __props__.__dict__["build_service_account"] = build_service_account
        __props__.__dict__["build_worker_pool"] = build_worker_pool
        __props__.__dict__["description"] = description
        __props__.__dict__["docker_registry"] = docker_registry
        __props__.__dict__["docker_repository"] = docker_repository
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["entry_point"] = entry_point
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["event_trigger"] = event_trigger
        __props__.__dict__["https_trigger_security_level"] = https_trigger_security_level
        __props__.__dict__["https_trigger_url"] = https_trigger_url
        __props__.__dict__["ingress_settings"] = ingress_settings
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_instances"] = max_instances
        __props__.__dict__["min_instances"] = min_instances
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["secret_environment_variables"] = secret_environment_variables
        __props__.__dict__["secret_volumes"] = secret_volumes
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["source_archive_bucket"] = source_archive_bucket
        __props__.__dict__["source_archive_object"] = source_archive_object
        __props__.__dict__["source_repository"] = source_repository
        __props__.__dict__["status"] = status
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["trigger_http"] = trigger_http
        __props__.__dict__["version_id"] = version_id
        __props__.__dict__["vpc_connector"] = vpc_connector
        __props__.__dict__["vpc_connector_egress_settings"] = vpc_connector_egress_settings
        return Function(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @_builtins.property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @_builtins.property
    @pulumi.getter(name="buildServiceAccount")
    def build_service_account(self) -> pulumi.Output[_builtins.str]:
        """
        If provided, the self-provided service account to use to build the function. The format of this field is `projects/{project}/serviceAccounts/{serviceAccountEmail}`
        """
        return pulumi.get(self, "build_service_account")

    @_builtins.property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "build_worker_pool")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dockerRegistry")
    def docker_registry(self) -> pulumi.Output[_builtins.str]:
        """
        Docker Registry to use for storing the function's Docker images. Allowed values are ARTIFACT_REGISTRY (default) and CONTAINER_REGISTRY.
        """
        return pulumi.get(self, "docker_registry")

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-managed repository created in Artifact Registry to which the function's Docker image will be pushed after it is built by Cloud Build. May optionally be encrypted with a customer-managed encryption key (CMEK). If unspecified and `docker_registry` is not explicitly set to `CONTAINER_REGISTRY`, GCF will create and use a default Artifact Registry repository named 'gcf-artifacts' in the region.
        """
        return pulumi.get(self, "docker_repository")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output['outputs.FunctionEventTrigger']:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @_builtins.property
    @pulumi.getter(name="httpsTriggerSecurityLevel")
    def https_trigger_security_level(self) -> pulumi.Output[_builtins.str]:
        """
        The security level for the function. The following options are available:

        * `SECURE_ALWAYS` Requests for a URL that match this handler that do not use HTTPS are automatically redirected to the HTTPS URL with the same path. Query parameters are reserved for the redirect.
        * `SECURE_OPTIONAL` Both HTTP and HTTPS requests with URLs that match the handler succeed without redirects. The application can examine the request to determine which protocol was used and respond accordingly.
        """
        return pulumi.get(self, "https_trigger_security_level")

    @_builtins.property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @_builtins.property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources. It must match the pattern `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
        If specified, you must also provide an artifact registry repository using the `docker_repository` field that was created with the same KMS crypto key. Before deploying, please complete all pre-requisites described in https://cloud.google.com/functions/docs/securing/cmek#granting_service_accounts_access_to_the_key
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Output[_builtins.int]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs20"`, `"python39"`, `"dotnet3"`, `"go116"`, `"java11"`, `"ruby30"`, `"php74"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.

        - - -
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionSecretEnvironmentVariable']]]:
        """
        Secret environment variables configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_environment_variables")

    @_builtins.property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionSecretVolume']]]:
        """
        Secret volumes configuration. Structure is documented below.
        """
        return pulumi.get(self, "secret_volumes")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @_builtins.property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @_builtins.property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> pulumi.Output[Optional['outputs.FunctionSourceRepository']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below. It must match the pattern `projects/{project}/locations/{location}/repositories/{repository}`.*
        """
        return pulumi.get(self, "source_repository")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the current stage of a deployment.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The version identifier of the Cloud Function. Each deployment attempt results in a new version of a function being
        created.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @_builtins.property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> pulumi.Output[_builtins.str]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

