# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 template: pulumi.Input['JobTemplateArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['JobBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 start_execution_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run job
        :param pulumi.Input['JobTemplateArgs'] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['JobBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] name: Name of the Job.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] run_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[_builtins.str] start_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
               The sum of job name and token length must be fewer than 63 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if run_execution_token is not None:
            pulumi.set(__self__, "run_execution_token", run_execution_token)
        if start_execution_token is not None:
            pulumi.set(__self__, "start_execution_token", start_execution_token)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Input['JobTemplateArgs']:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['JobTemplateArgs']):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['JobBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['JobBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @_builtins.property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="runExecutionToken")
    def run_execution_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "run_execution_token")

    @run_execution_token.setter
    def run_execution_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_execution_token", value)

    @_builtins.property
    @pulumi.getter(name="startExecutionToken")
    def start_execution_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "start_execution_token")

    @start_execution_token.setter
    def start_execution_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_execution_token", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['JobBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_count: Optional[pulumi.Input[_builtins.int]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_modifier: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_created_executions: Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 observed_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 run_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 start_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input['JobTemplateArgs']] = None,
                 terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['JobBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: (Output)
               Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[_builtins.str] delete_time: The deletion time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[_builtins.int] execution_count: Number of executions created for this job.
        :param pulumi.Input[_builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[_builtins.str] generation: A number that monotonically increases every time the user modifies the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]] latest_created_executions: Name of the last created execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run job
        :param pulumi.Input[_builtins.str] name: Name of the Job.
        :param pulumi.Input[_builtins.str] observed_generation: The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
               When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
               If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        :param pulumi.Input[_builtins.str] run_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[_builtins.str] start_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input['JobTemplateArgs'] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]] terminal_conditions: The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_count is not None:
            pulumi.set(__self__, "execution_count", execution_count)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modifier is not None:
            pulumi.set(__self__, "last_modifier", last_modifier)
        if latest_created_executions is not None:
            pulumi.set(__self__, "latest_created_executions", latest_created_executions)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if run_execution_token is not None:
            pulumi.set(__self__, "run_execution_token", run_execution_token)
        if start_execution_token is not None:
            pulumi.set(__self__, "start_execution_token", start_execution_token)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if terminal_conditions is not None:
            pulumi.set(__self__, "terminal_conditions", terminal_conditions)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['JobBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['JobBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @_builtins.property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @execution_count.setter
    def execution_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "execution_count", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A number that monotonically increases every time the user modifies the desired state.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @last_modifier.setter
    def last_modifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modifier", value)

    @_builtins.property
    @pulumi.getter(name="latestCreatedExecutions")
    def latest_created_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]]:
        """
        Name of the last created execution.
        Structure is documented below.
        """
        return pulumi.get(self, "latest_created_executions")

    @latest_created_executions.setter
    def latest_created_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLatestCreatedExecutionArgs']]]]):
        pulumi.set(self, "latest_created_executions", value)

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "observed_generation", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
        When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
        If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter(name="runExecutionToken")
    def run_execution_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "run_execution_token")

    @run_execution_token.setter
    def run_execution_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_execution_token", value)

    @_builtins.property
    @pulumi.getter(name="startExecutionToken")
    def start_execution_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "start_execution_token")

    @start_execution_token.setter
    def start_execution_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_execution_token", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['JobTemplateArgs']]:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['JobTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]]:
        """
        The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @terminal_conditions.setter
    def terminal_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTerminalConditionArgs']]]]):
        pulumi.set(self, "terminal_conditions", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:cloudrunv2/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['JobBinaryAuthorizationArgs', 'JobBinaryAuthorizationArgsDict']]] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 start_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
                 __props__=None):
        """
        A Cloud Run Job resource that references a container image which is run to completion.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.jobs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "resources": {
                            "limits": {
                                "cpu": "2",
                                "memory": "1024Mi",
                            },
                        },
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "volumes": [{
                        "name": "cloudsql",
                        "cloud_sql_instance": {
                            "instances": [instance.connection_name],
                        },
                    }],
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "envs": [
                            {
                                "name": "FOO",
                                "value": "bar",
                            },
                            {
                                "name": "latestdclsecret",
                                "value_source": {
                                    "secret_key_ref": {
                                        "secret": secret.secret_id,
                                        "version": "1",
                                    },
                                },
                            },
                        ],
                        "volume_mounts": [{
                            "name": "cloudsql",
                            "mount_path": "/cloudsql",
                        }],
                    }],
                },
            })
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("custom_test",
            name="run-network",
            auto_create_subnetworks=False)
        custom_test = gcp.compute.Subnetwork("custom_test",
            name="run-subnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            name="run-vpc",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "vpc_access": {
                        "connector": connector.id,
                        "egress": "ALL_TRAFFIC",
                    },
                },
            })
        ```
        ### Cloudrunv2 Job Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            launch_stage="GA",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "vpc_access": {
                        "network_interfaces": [{
                            "network": "default",
                            "subnetwork": "default",
                            "tags": [
                                "tag1",
                                "tag2",
                                "tag3",
                            ],
                        }],
                    },
                },
            })
        ```
        ### Cloudrunv2 Job Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "volumes": [{
                        "name": "a-volume",
                        "secret": {
                            "secret": secret.secret_id,
                            "default_mode": 292,
                            "items": [{
                                "version": "1",
                                "path": "my-secret",
                                "mode": 256,
                            }],
                        },
                    }],
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "volume_mounts": [{
                            "name": "a-volume",
                            "mount_path": "/secrets",
                        }],
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    secret_version_data,
                    secret_access,
                ]))
        ```
        ### Cloudrunv2 Job Emptydir

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    }],
                    "volumes": [{
                        "name": "empty-dir-volume",
                        "empty_dir": {
                            "medium": "MEMORY",
                            "size_limit": "128Mi",
                        },
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Run Job

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            start_execution_token="start-once-created",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [
                        {
                            "name": "job-1",
                            "image": "us-docker.pkg.dev/cloudrun/container/job",
                        },
                        {
                            "name": "job-2",
                            "image": "us-docker.pkg.dev/cloudrun/container/job",
                        },
                    ],
                },
            })
        ```
        ### Cloudrunv2 Job Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "node_selector": {
                        "accelerator": "nvidia-l4",
                    },
                },
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/jobs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default projects/{{project}}/locations/{{location}}/jobs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['JobBinaryAuthorizationArgs', 'JobBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run job
        :param pulumi.Input[_builtins.str] name: Name of the Job.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] run_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[_builtins.str] start_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']] template: The template used to create executions for this Job.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Run Job resource that references a container image which is run to completion.

        To get more information about Job, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.jobs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Job Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "resources": {
                            "limits": {
                                "cpu": "2",
                                "memory": "1024Mi",
                            },
                        },
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "volumes": [{
                        "name": "cloudsql",
                        "cloud_sql_instance": {
                            "instances": [instance.connection_name],
                        },
                    }],
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "envs": [
                            {
                                "name": "FOO",
                                "value": "bar",
                            },
                            {
                                "name": "latestdclsecret",
                                "value_source": {
                                    "secret_key_ref": {
                                        "secret": secret.secret_id,
                                        "version": "1",
                                    },
                                },
                            },
                        ],
                        "volume_mounts": [{
                            "name": "cloudsql",
                            "mount_path": "/cloudsql",
                        }],
                    }],
                },
            })
        project = gcp.organizations.get_project()
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Job Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("custom_test",
            name="run-network",
            auto_create_subnetworks=False)
        custom_test = gcp.compute.Subnetwork("custom_test",
            name="run-subnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            name="run-vpc",
            subnet={
                "name": custom_test.name,
            },
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "vpc_access": {
                        "connector": connector.id,
                        "egress": "ALL_TRAFFIC",
                    },
                },
            })
        ```
        ### Cloudrunv2 Job Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            launch_stage="GA",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "vpc_access": {
                        "network_interfaces": [{
                            "network": "default",
                            "subnetwork": "default",
                            "tags": [
                                "tag1",
                                "tag2",
                                "tag3",
                            ],
                        }],
                    },
                },
            })
        ```
        ### Cloudrunv2 Job Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "volumes": [{
                        "name": "a-volume",
                        "secret": {
                            "secret": secret.secret_id,
                            "default_mode": 292,
                            "items": [{
                                "version": "1",
                                "path": "my-secret",
                                "mode": 256,
                            }],
                        },
                    }],
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "volume_mounts": [{
                            "name": "a-volume",
                            "mount_path": "/secrets",
                        }],
                    }],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    secret_version_data,
                    secret_access,
                ]))
        ```
        ### Cloudrunv2 Job Emptydir

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    }],
                    "volumes": [{
                        "name": "empty-dir-volume",
                        "empty_dir": {
                            "medium": "MEMORY",
                            "size_limit": "128Mi",
                        },
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Run Job

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            start_execution_token="start-once-created",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                },
            })
        ```
        ### Cloudrunv2 Job Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            template={
                "template": {
                    "containers": [
                        {
                            "name": "job-1",
                            "image": "us-docker.pkg.dev/cloudrun/container/job",
                        },
                        {
                            "name": "job-2",
                            "image": "us-docker.pkg.dev/cloudrun/container/job",
                        },
                    ],
                },
            })
        ```
        ### Cloudrunv2 Job Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Job("default",
            name="cloudrun-job",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "template": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/job",
                    }],
                    "node_selector": {
                        "accelerator": "nvidia-l4",
                    },
                },
            })
        ```

        ## Import

        Job can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/jobs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Job can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default projects/{{project}}/locations/{{location}}/jobs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/job:Job default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['JobBinaryAuthorizationArgs', 'JobBinaryAuthorizationArgsDict']]] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 start_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["client"] = client
            __props__.__dict__["client_version"] = client_version
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["run_execution_token"] = run_execution_token
            __props__.__dict__["start_execution_token"] = start_execution_token
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["execution_count"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["generation"] = None
            __props__.__dict__["last_modifier"] = None
            __props__.__dict__["latest_created_executions"] = None
            __props__.__dict__["observed_generation"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["terminal_conditions"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Job, __self__).__init__(
            'gcp:cloudrunv2/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            binary_authorization: Optional[pulumi.Input[Union['JobBinaryAuthorizationArgs', 'JobBinaryAuthorizationArgsDict']]] = None,
            client: Optional[pulumi.Input[_builtins.str]] = None,
            client_version: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobConditionArgs', 'JobConditionArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            execution_count: Optional[pulumi.Input[_builtins.int]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            generation: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_modifier: Optional[pulumi.Input[_builtins.str]] = None,
            latest_created_executions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLatestCreatedExecutionArgs', 'JobLatestCreatedExecutionArgsDict']]]]] = None,
            launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            observed_generation: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            run_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
            start_execution_token: Optional[pulumi.Input[_builtins.str]] = None,
            template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
            terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobTerminalConditionArgs', 'JobTerminalConditionArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
               All system annotations in v1 now have a corresponding field in v2 Job.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['JobBinaryAuthorizationArgs', 'JobBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobConditionArgs', 'JobConditionArgsDict']]]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: (Output)
               Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[_builtins.str] delete_time: The deletion time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[_builtins.int] execution_count: Number of executions created for this job.
        :param pulumi.Input[_builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[_builtins.str] generation: A number that monotonically increases every time the user modifies the desired state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 Job.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobLatestCreatedExecutionArgs', 'JobLatestCreatedExecutionArgsDict']]]] latest_created_executions: Name of the last created execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run job
        :param pulumi.Input[_builtins.str] name: Name of the Job.
        :param pulumi.Input[_builtins.str] observed_generation: The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
               When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
               If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        :param pulumi.Input[_builtins.str] run_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[_builtins.str] start_execution_token: A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
               The sum of job name and token length must be fewer than 63 characters.
        :param pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']] template: The template used to create executions for this Job.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobTerminalConditionArgs', 'JobTerminalConditionArgsDict']]]] terminal_conditions: The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["client"] = client
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_count"] = execution_count
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["generation"] = generation
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modifier"] = last_modifier
        __props__.__dict__["latest_created_executions"] = latest_created_executions
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["observed_generation"] = observed_generation
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["run_execution_token"] = run_execution_token
        __props__.__dict__["start_execution_token"] = start_execution_token
        __props__.__dict__["template"] = template
        __props__.__dict__["terminal_conditions"] = terminal_conditions
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected on new resources.
        All system annotations in v1 now have a corresponding field in v2 Job.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.JobBinaryAuthorization']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @_builtins.property
    @pulumi.getter
    def client(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.JobCondition']]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Job does not reach its desired state. See comments in reconciling for additional information on `reconciliation` process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> pulumi.Output[_builtins.str]:
        """
        A number that monotonically increases every time the user modifies the desired state.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 Job.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @_builtins.property
    @pulumi.getter(name="latestCreatedExecutions")
    def latest_created_executions(self) -> pulumi.Output[Sequence['outputs.JobLatestCreatedExecution']]:
        """
        Name of the last created execution.
        Structure is documented below.
        """
        return pulumi.get(self, "latest_created_executions")

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[_builtins.str]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the cloud run job
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> pulumi.Output[_builtins.str]:
        """
        The generation of this Job. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Returns true if the Job is currently being acted upon by the system to bring it into the desired state.
        When a new Job is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Job to the desired state. This process is called reconciliation. While reconciliation is in process, observedGeneration and latest_succeeded_execution, will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the state matches the Job, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: observedGeneration and generation, latest_succeeded_execution and latestCreatedExecution.
        If reconciliation failed, observedGeneration and latest_succeeded_execution will have the state of the last succeeded execution or empty for newly created Job. Additional information on the failure can be found in terminalCondition and conditions
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter(name="runExecutionToken")
    def run_execution_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully completed.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "run_execution_token")

    @_builtins.property
    @pulumi.getter(name="startExecutionToken")
    def start_execution_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A unique string used as a suffix creating a new execution upon job create or update. The Job will become ready when the execution is successfully started.
        The sum of job name and token length must be fewer than 63 characters.
        """
        return pulumi.get(self, "start_execution_token")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.JobTemplate']:
        """
        The template used to create executions for this Job.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> pulumi.Output[Sequence['outputs.JobTerminalCondition']]:
        """
        The Condition of this Job, containing its readiness status, and detailed error information in case it did not reach the desired state
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server assigned unique identifier for the Execution. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

